import * as $protobuf from "protobufjs";
/** Namespace proto. */
export namespace proto {

    /** Properties of a ADVDeviceIdentity. */
    interface IADVDeviceIdentity {

        /** ADVDeviceIdentity rawId */
        rawId?: (number|null);

        /** ADVDeviceIdentity timestamp */
        timestamp?: (number|Long|null);

        /** ADVDeviceIdentity keyIndex */
        keyIndex?: (number|null);
    }

    /** Represents a ADVDeviceIdentity. */
    class ADVDeviceIdentity implements IADVDeviceIdentity {

        /**
         * Constructs a new ADVDeviceIdentity.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVDeviceIdentity);

        /** ADVDeviceIdentity rawId. */
        public rawId: number;

        /** ADVDeviceIdentity timestamp. */
        public timestamp: (number|Long);

        /** ADVDeviceIdentity keyIndex. */
        public keyIndex: number;

        /**
         * Creates a new ADVDeviceIdentity instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVDeviceIdentity instance
         */
        public static create(properties?: proto.IADVDeviceIdentity): proto.ADVDeviceIdentity;

        /**
         * Encodes the specified ADVDeviceIdentity message. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @param message ADVDeviceIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVDeviceIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @param message ADVDeviceIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVDeviceIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVDeviceIdentity;

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVDeviceIdentity;

        /**
         * Verifies a ADVDeviceIdentity message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVDeviceIdentity
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVDeviceIdentity;

        /**
         * Creates a plain object from a ADVDeviceIdentity message. Also converts values to other types if specified.
         * @param message ADVDeviceIdentity
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVDeviceIdentity, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVDeviceIdentity to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ADVKeyIndexList. */
    interface IADVKeyIndexList {

        /** ADVKeyIndexList rawId */
        rawId?: (number|null);

        /** ADVKeyIndexList timestamp */
        timestamp?: (number|Long|null);

        /** ADVKeyIndexList currentIndex */
        currentIndex?: (number|null);

        /** ADVKeyIndexList validIndexes */
        validIndexes?: (number[]|null);
    }

    /** Represents a ADVKeyIndexList. */
    class ADVKeyIndexList implements IADVKeyIndexList {

        /**
         * Constructs a new ADVKeyIndexList.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVKeyIndexList);

        /** ADVKeyIndexList rawId. */
        public rawId: number;

        /** ADVKeyIndexList timestamp. */
        public timestamp: (number|Long);

        /** ADVKeyIndexList currentIndex. */
        public currentIndex: number;

        /** ADVKeyIndexList validIndexes. */
        public validIndexes: number[];

        /**
         * Creates a new ADVKeyIndexList instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVKeyIndexList instance
         */
        public static create(properties?: proto.IADVKeyIndexList): proto.ADVKeyIndexList;

        /**
         * Encodes the specified ADVKeyIndexList message. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @param message ADVKeyIndexList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVKeyIndexList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @param message ADVKeyIndexList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVKeyIndexList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVKeyIndexList;

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVKeyIndexList;

        /**
         * Verifies a ADVKeyIndexList message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVKeyIndexList
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVKeyIndexList;

        /**
         * Creates a plain object from a ADVKeyIndexList message. Also converts values to other types if specified.
         * @param message ADVKeyIndexList
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVKeyIndexList, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVKeyIndexList to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ADVSignedDeviceIdentity. */
    interface IADVSignedDeviceIdentity {

        /** ADVSignedDeviceIdentity details */
        details?: (Uint8Array|null);

        /** ADVSignedDeviceIdentity accountSignatureKey */
        accountSignatureKey?: (Uint8Array|null);

        /** ADVSignedDeviceIdentity accountSignature */
        accountSignature?: (Uint8Array|null);

        /** ADVSignedDeviceIdentity deviceSignature */
        deviceSignature?: (Uint8Array|null);
    }

    /** Represents a ADVSignedDeviceIdentity. */
    class ADVSignedDeviceIdentity implements IADVSignedDeviceIdentity {

        /**
         * Constructs a new ADVSignedDeviceIdentity.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVSignedDeviceIdentity);

        /** ADVSignedDeviceIdentity details. */
        public details: Uint8Array;

        /** ADVSignedDeviceIdentity accountSignatureKey. */
        public accountSignatureKey: Uint8Array;

        /** ADVSignedDeviceIdentity accountSignature. */
        public accountSignature: Uint8Array;

        /** ADVSignedDeviceIdentity deviceSignature. */
        public deviceSignature: Uint8Array;

        /**
         * Creates a new ADVSignedDeviceIdentity instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVSignedDeviceIdentity instance
         */
        public static create(properties?: proto.IADVSignedDeviceIdentity): proto.ADVSignedDeviceIdentity;

        /**
         * Encodes the specified ADVSignedDeviceIdentity message. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @param message ADVSignedDeviceIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVSignedDeviceIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVSignedDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @param message ADVSignedDeviceIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVSignedDeviceIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVSignedDeviceIdentity;

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVSignedDeviceIdentity;

        /**
         * Verifies a ADVSignedDeviceIdentity message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVSignedDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVSignedDeviceIdentity
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVSignedDeviceIdentity;

        /**
         * Creates a plain object from a ADVSignedDeviceIdentity message. Also converts values to other types if specified.
         * @param message ADVSignedDeviceIdentity
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVSignedDeviceIdentity, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVSignedDeviceIdentity to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ADVSignedDeviceIdentityHMAC. */
    interface IADVSignedDeviceIdentityHMAC {

        /** ADVSignedDeviceIdentityHMAC details */
        details?: (Uint8Array|null);

        /** ADVSignedDeviceIdentityHMAC hmac */
        hmac?: (Uint8Array|null);
    }

    /** Represents a ADVSignedDeviceIdentityHMAC. */
    class ADVSignedDeviceIdentityHMAC implements IADVSignedDeviceIdentityHMAC {

        /**
         * Constructs a new ADVSignedDeviceIdentityHMAC.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVSignedDeviceIdentityHMAC);

        /** ADVSignedDeviceIdentityHMAC details. */
        public details: Uint8Array;

        /** ADVSignedDeviceIdentityHMAC hmac. */
        public hmac: Uint8Array;

        /**
         * Creates a new ADVSignedDeviceIdentityHMAC instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVSignedDeviceIdentityHMAC instance
         */
        public static create(properties?: proto.IADVSignedDeviceIdentityHMAC): proto.ADVSignedDeviceIdentityHMAC;

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @param message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVSignedDeviceIdentityHMAC, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @param message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVSignedDeviceIdentityHMAC, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVSignedDeviceIdentityHMAC;

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVSignedDeviceIdentityHMAC;

        /**
         * Verifies a ADVSignedDeviceIdentityHMAC message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVSignedDeviceIdentityHMAC message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVSignedDeviceIdentityHMAC
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVSignedDeviceIdentityHMAC;

        /**
         * Creates a plain object from a ADVSignedDeviceIdentityHMAC message. Also converts values to other types if specified.
         * @param message ADVSignedDeviceIdentityHMAC
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVSignedDeviceIdentityHMAC, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVSignedDeviceIdentityHMAC to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ADVSignedKeyIndexList. */
    interface IADVSignedKeyIndexList {

        /** ADVSignedKeyIndexList details */
        details?: (Uint8Array|null);

        /** ADVSignedKeyIndexList accountSignature */
        accountSignature?: (Uint8Array|null);
    }

    /** Represents a ADVSignedKeyIndexList. */
    class ADVSignedKeyIndexList implements IADVSignedKeyIndexList {

        /**
         * Constructs a new ADVSignedKeyIndexList.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVSignedKeyIndexList);

        /** ADVSignedKeyIndexList details. */
        public details: Uint8Array;

        /** ADVSignedKeyIndexList accountSignature. */
        public accountSignature: Uint8Array;

        /**
         * Creates a new ADVSignedKeyIndexList instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVSignedKeyIndexList instance
         */
        public static create(properties?: proto.IADVSignedKeyIndexList): proto.ADVSignedKeyIndexList;

        /**
         * Encodes the specified ADVSignedKeyIndexList message. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @param message ADVSignedKeyIndexList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVSignedKeyIndexList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVSignedKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @param message ADVSignedKeyIndexList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVSignedKeyIndexList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVSignedKeyIndexList;

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVSignedKeyIndexList;

        /**
         * Verifies a ADVSignedKeyIndexList message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVSignedKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVSignedKeyIndexList
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVSignedKeyIndexList;

        /**
         * Creates a plain object from a ADVSignedKeyIndexList message. Also converts values to other types if specified.
         * @param message ADVSignedKeyIndexList
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVSignedKeyIndexList, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVSignedKeyIndexList to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an ActionLink. */
    interface IActionLink {

        /** ActionLink url */
        url?: (string|null);

        /** ActionLink buttonTitle */
        buttonTitle?: (string|null);
    }

    /** Represents an ActionLink. */
    class ActionLink implements IActionLink {

        /**
         * Constructs a new ActionLink.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IActionLink);

        /** ActionLink url. */
        public url: string;

        /** ActionLink buttonTitle. */
        public buttonTitle: string;

        /**
         * Creates a new ActionLink instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ActionLink instance
         */
        public static create(properties?: proto.IActionLink): proto.ActionLink;

        /**
         * Encodes the specified ActionLink message. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @param message ActionLink message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IActionLink, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ActionLink message, length delimited. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @param message ActionLink message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IActionLink, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an ActionLink message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ActionLink;

        /**
         * Decodes an ActionLink message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ActionLink;

        /**
         * Verifies an ActionLink message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an ActionLink message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ActionLink
         */
        public static fromObject(object: { [k: string]: any }): proto.ActionLink;

        /**
         * Creates a plain object from an ActionLink message. Also converts values to other types if specified.
         * @param message ActionLink
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ActionLink, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ActionLink to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an AutoDownloadSettings. */
    interface IAutoDownloadSettings {

        /** AutoDownloadSettings downloadImages */
        downloadImages?: (boolean|null);

        /** AutoDownloadSettings downloadAudio */
        downloadAudio?: (boolean|null);

        /** AutoDownloadSettings downloadVideo */
        downloadVideo?: (boolean|null);

        /** AutoDownloadSettings downloadDocuments */
        downloadDocuments?: (boolean|null);
    }

    /** Represents an AutoDownloadSettings. */
    class AutoDownloadSettings implements IAutoDownloadSettings {

        /**
         * Constructs a new AutoDownloadSettings.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IAutoDownloadSettings);

        /** AutoDownloadSettings downloadImages. */
        public downloadImages: boolean;

        /** AutoDownloadSettings downloadAudio. */
        public downloadAudio: boolean;

        /** AutoDownloadSettings downloadVideo. */
        public downloadVideo: boolean;

        /** AutoDownloadSettings downloadDocuments. */
        public downloadDocuments: boolean;

        /**
         * Creates a new AutoDownloadSettings instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AutoDownloadSettings instance
         */
        public static create(properties?: proto.IAutoDownloadSettings): proto.AutoDownloadSettings;

        /**
         * Encodes the specified AutoDownloadSettings message. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @param message AutoDownloadSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IAutoDownloadSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified AutoDownloadSettings message, length delimited. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @param message AutoDownloadSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IAutoDownloadSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AutoDownloadSettings;

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AutoDownloadSettings;

        /**
         * Verifies an AutoDownloadSettings message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an AutoDownloadSettings message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AutoDownloadSettings
         */
        public static fromObject(object: { [k: string]: any }): proto.AutoDownloadSettings;

        /**
         * Creates a plain object from an AutoDownloadSettings message. Also converts values to other types if specified.
         * @param message AutoDownloadSettings
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.AutoDownloadSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AutoDownloadSettings to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an AvatarUserSettings. */
    interface IAvatarUserSettings {

        /** AvatarUserSettings fbid */
        fbid?: (string|null);

        /** AvatarUserSettings password */
        password?: (string|null);
    }

    /** Represents an AvatarUserSettings. */
    class AvatarUserSettings implements IAvatarUserSettings {

        /**
         * Constructs a new AvatarUserSettings.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IAvatarUserSettings);

        /** AvatarUserSettings fbid. */
        public fbid: string;

        /** AvatarUserSettings password. */
        public password: string;

        /**
         * Creates a new AvatarUserSettings instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AvatarUserSettings instance
         */
        public static create(properties?: proto.IAvatarUserSettings): proto.AvatarUserSettings;

        /**
         * Encodes the specified AvatarUserSettings message. Does not implicitly {@link proto.AvatarUserSettings.verify|verify} messages.
         * @param message AvatarUserSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IAvatarUserSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified AvatarUserSettings message, length delimited. Does not implicitly {@link proto.AvatarUserSettings.verify|verify} messages.
         * @param message AvatarUserSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IAvatarUserSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an AvatarUserSettings message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AvatarUserSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AvatarUserSettings;

        /**
         * Decodes an AvatarUserSettings message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AvatarUserSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AvatarUserSettings;

        /**
         * Verifies an AvatarUserSettings message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an AvatarUserSettings message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AvatarUserSettings
         */
        public static fromObject(object: { [k: string]: any }): proto.AvatarUserSettings;

        /**
         * Creates a plain object from an AvatarUserSettings message. Also converts values to other types if specified.
         * @param message AvatarUserSettings
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.AvatarUserSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AvatarUserSettings to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a BizAccountLinkInfo. */
    interface IBizAccountLinkInfo {

        /** BizAccountLinkInfo whatsappBizAcctFbid */
        whatsappBizAcctFbid?: (number|Long|null);

        /** BizAccountLinkInfo whatsappAcctNumber */
        whatsappAcctNumber?: (string|null);

        /** BizAccountLinkInfo issueTime */
        issueTime?: (number|Long|null);

        /** BizAccountLinkInfo hostStorage */
        hostStorage?: (proto.BizAccountLinkInfo.HostStorageType|null);

        /** BizAccountLinkInfo accountType */
        accountType?: (proto.BizAccountLinkInfo.AccountType|null);
    }

    /** Represents a BizAccountLinkInfo. */
    class BizAccountLinkInfo implements IBizAccountLinkInfo {

        /**
         * Constructs a new BizAccountLinkInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBizAccountLinkInfo);

        /** BizAccountLinkInfo whatsappBizAcctFbid. */
        public whatsappBizAcctFbid: (number|Long);

        /** BizAccountLinkInfo whatsappAcctNumber. */
        public whatsappAcctNumber: string;

        /** BizAccountLinkInfo issueTime. */
        public issueTime: (number|Long);

        /** BizAccountLinkInfo hostStorage. */
        public hostStorage: proto.BizAccountLinkInfo.HostStorageType;

        /** BizAccountLinkInfo accountType. */
        public accountType: proto.BizAccountLinkInfo.AccountType;

        /**
         * Creates a new BizAccountLinkInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BizAccountLinkInfo instance
         */
        public static create(properties?: proto.IBizAccountLinkInfo): proto.BizAccountLinkInfo;

        /**
         * Encodes the specified BizAccountLinkInfo message. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @param message BizAccountLinkInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBizAccountLinkInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BizAccountLinkInfo message, length delimited. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @param message BizAccountLinkInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBizAccountLinkInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BizAccountLinkInfo;

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BizAccountLinkInfo;

        /**
         * Verifies a BizAccountLinkInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BizAccountLinkInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BizAccountLinkInfo
         */
        public static fromObject(object: { [k: string]: any }): proto.BizAccountLinkInfo;

        /**
         * Creates a plain object from a BizAccountLinkInfo message. Also converts values to other types if specified.
         * @param message BizAccountLinkInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BizAccountLinkInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BizAccountLinkInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace BizAccountLinkInfo {

        /** AccountType enum. */
        enum AccountType {
            ENTERPRISE = 0
        }

        /** HostStorageType enum. */
        enum HostStorageType {
            ON_PREMISE = 0,
            FACEBOOK = 1
        }
    }

    /** Properties of a BizAccountPayload. */
    interface IBizAccountPayload {

        /** BizAccountPayload vnameCert */
        vnameCert?: (proto.IVerifiedNameCertificate|null);

        /** BizAccountPayload bizAcctLinkInfo */
        bizAcctLinkInfo?: (Uint8Array|null);
    }

    /** Represents a BizAccountPayload. */
    class BizAccountPayload implements IBizAccountPayload {

        /**
         * Constructs a new BizAccountPayload.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBizAccountPayload);

        /** BizAccountPayload vnameCert. */
        public vnameCert?: (proto.IVerifiedNameCertificate|null);

        /** BizAccountPayload bizAcctLinkInfo. */
        public bizAcctLinkInfo: Uint8Array;

        /**
         * Creates a new BizAccountPayload instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BizAccountPayload instance
         */
        public static create(properties?: proto.IBizAccountPayload): proto.BizAccountPayload;

        /**
         * Encodes the specified BizAccountPayload message. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @param message BizAccountPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBizAccountPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BizAccountPayload message, length delimited. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @param message BizAccountPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBizAccountPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BizAccountPayload;

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BizAccountPayload;

        /**
         * Verifies a BizAccountPayload message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BizAccountPayload message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BizAccountPayload
         */
        public static fromObject(object: { [k: string]: any }): proto.BizAccountPayload;

        /**
         * Creates a plain object from a BizAccountPayload message. Also converts values to other types if specified.
         * @param message BizAccountPayload
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BizAccountPayload, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BizAccountPayload to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a BizIdentityInfo. */
    interface IBizIdentityInfo {

        /** BizIdentityInfo vlevel */
        vlevel?: (proto.BizIdentityInfo.VerifiedLevelValue|null);

        /** BizIdentityInfo vnameCert */
        vnameCert?: (proto.IVerifiedNameCertificate|null);

        /** BizIdentityInfo signed */
        signed?: (boolean|null);

        /** BizIdentityInfo revoked */
        revoked?: (boolean|null);

        /** BizIdentityInfo hostStorage */
        hostStorage?: (proto.BizIdentityInfo.HostStorageType|null);

        /** BizIdentityInfo actualActors */
        actualActors?: (proto.BizIdentityInfo.ActualActorsType|null);

        /** BizIdentityInfo privacyModeTs */
        privacyModeTs?: (number|Long|null);

        /** BizIdentityInfo featureControls */
        featureControls?: (number|Long|null);
    }

    /** Represents a BizIdentityInfo. */
    class BizIdentityInfo implements IBizIdentityInfo {

        /**
         * Constructs a new BizIdentityInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBizIdentityInfo);

        /** BizIdentityInfo vlevel. */
        public vlevel: proto.BizIdentityInfo.VerifiedLevelValue;

        /** BizIdentityInfo vnameCert. */
        public vnameCert?: (proto.IVerifiedNameCertificate|null);

        /** BizIdentityInfo signed. */
        public signed: boolean;

        /** BizIdentityInfo revoked. */
        public revoked: boolean;

        /** BizIdentityInfo hostStorage. */
        public hostStorage: proto.BizIdentityInfo.HostStorageType;

        /** BizIdentityInfo actualActors. */
        public actualActors: proto.BizIdentityInfo.ActualActorsType;

        /** BizIdentityInfo privacyModeTs. */
        public privacyModeTs: (number|Long);

        /** BizIdentityInfo featureControls. */
        public featureControls: (number|Long);

        /**
         * Creates a new BizIdentityInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BizIdentityInfo instance
         */
        public static create(properties?: proto.IBizIdentityInfo): proto.BizIdentityInfo;

        /**
         * Encodes the specified BizIdentityInfo message. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @param message BizIdentityInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBizIdentityInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BizIdentityInfo message, length delimited. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @param message BizIdentityInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBizIdentityInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BizIdentityInfo;

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BizIdentityInfo;

        /**
         * Verifies a BizIdentityInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BizIdentityInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BizIdentityInfo
         */
        public static fromObject(object: { [k: string]: any }): proto.BizIdentityInfo;

        /**
         * Creates a plain object from a BizIdentityInfo message. Also converts values to other types if specified.
         * @param message BizIdentityInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BizIdentityInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BizIdentityInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace BizIdentityInfo {

        /** ActualActorsType enum. */
        enum ActualActorsType {
            SELF = 0,
            BSP = 1
        }

        /** HostStorageType enum. */
        enum HostStorageType {
            ON_PREMISE = 0,
            FACEBOOK = 1
        }

        /** VerifiedLevelValue enum. */
        enum VerifiedLevelValue {
            UNKNOWN = 0,
            LOW = 1,
            HIGH = 2
        }
    }

    /** Properties of a CertChain. */
    interface ICertChain {

        /** CertChain leaf */
        leaf?: (proto.CertChain.INoiseCertificate|null);

        /** CertChain intermediate */
        intermediate?: (proto.CertChain.INoiseCertificate|null);
    }

    /** Represents a CertChain. */
    class CertChain implements ICertChain {

        /**
         * Constructs a new CertChain.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ICertChain);

        /** CertChain leaf. */
        public leaf?: (proto.CertChain.INoiseCertificate|null);

        /** CertChain intermediate. */
        public intermediate?: (proto.CertChain.INoiseCertificate|null);

        /**
         * Creates a new CertChain instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CertChain instance
         */
        public static create(properties?: proto.ICertChain): proto.CertChain;

        /**
         * Encodes the specified CertChain message. Does not implicitly {@link proto.CertChain.verify|verify} messages.
         * @param message CertChain message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ICertChain, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CertChain message, length delimited. Does not implicitly {@link proto.CertChain.verify|verify} messages.
         * @param message CertChain message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ICertChain, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CertChain message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CertChain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CertChain;

        /**
         * Decodes a CertChain message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CertChain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CertChain;

        /**
         * Verifies a CertChain message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CertChain message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CertChain
         */
        public static fromObject(object: { [k: string]: any }): proto.CertChain;

        /**
         * Creates a plain object from a CertChain message. Also converts values to other types if specified.
         * @param message CertChain
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.CertChain, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CertChain to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace CertChain {

        /** Properties of a NoiseCertificate. */
        interface INoiseCertificate {

            /** NoiseCertificate details */
            details?: (Uint8Array|null);

            /** NoiseCertificate signature */
            signature?: (Uint8Array|null);
        }

        /** Represents a NoiseCertificate. */
        class NoiseCertificate implements INoiseCertificate {

            /**
             * Constructs a new NoiseCertificate.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.CertChain.INoiseCertificate);

            /** NoiseCertificate details. */
            public details: Uint8Array;

            /** NoiseCertificate signature. */
            public signature: Uint8Array;

            /**
             * Creates a new NoiseCertificate instance using the specified properties.
             * @param [properties] Properties to set
             * @returns NoiseCertificate instance
             */
            public static create(properties?: proto.CertChain.INoiseCertificate): proto.CertChain.NoiseCertificate;

            /**
             * Encodes the specified NoiseCertificate message. Does not implicitly {@link proto.CertChain.NoiseCertificate.verify|verify} messages.
             * @param message NoiseCertificate message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.CertChain.INoiseCertificate, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified NoiseCertificate message, length delimited. Does not implicitly {@link proto.CertChain.NoiseCertificate.verify|verify} messages.
             * @param message NoiseCertificate message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.CertChain.INoiseCertificate, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a NoiseCertificate message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns NoiseCertificate
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CertChain.NoiseCertificate;

            /**
             * Decodes a NoiseCertificate message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns NoiseCertificate
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CertChain.NoiseCertificate;

            /**
             * Verifies a NoiseCertificate message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a NoiseCertificate message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns NoiseCertificate
             */
            public static fromObject(object: { [k: string]: any }): proto.CertChain.NoiseCertificate;

            /**
             * Creates a plain object from a NoiseCertificate message. Also converts values to other types if specified.
             * @param message NoiseCertificate
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.CertChain.NoiseCertificate, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this NoiseCertificate to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace NoiseCertificate {

            /** Properties of a Details. */
            interface IDetails {

                /** Details serial */
                serial?: (number|null);

                /** Details issuerSerial */
                issuerSerial?: (number|null);

                /** Details key */
                key?: (Uint8Array|null);

                /** Details notBefore */
                notBefore?: (number|Long|null);

                /** Details notAfter */
                notAfter?: (number|Long|null);
            }

            /** Represents a Details. */
            class Details implements IDetails {

                /**
                 * Constructs a new Details.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.CertChain.NoiseCertificate.IDetails);

                /** Details serial. */
                public serial: number;

                /** Details issuerSerial. */
                public issuerSerial: number;

                /** Details key. */
                public key: Uint8Array;

                /** Details notBefore. */
                public notBefore: (number|Long);

                /** Details notAfter. */
                public notAfter: (number|Long);

                /**
                 * Creates a new Details instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Details instance
                 */
                public static create(properties?: proto.CertChain.NoiseCertificate.IDetails): proto.CertChain.NoiseCertificate.Details;

                /**
                 * Encodes the specified Details message. Does not implicitly {@link proto.CertChain.NoiseCertificate.Details.verify|verify} messages.
                 * @param message Details message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.CertChain.NoiseCertificate.IDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Details message, length delimited. Does not implicitly {@link proto.CertChain.NoiseCertificate.Details.verify|verify} messages.
                 * @param message Details message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.CertChain.NoiseCertificate.IDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Details message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Details
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CertChain.NoiseCertificate.Details;

                /**
                 * Decodes a Details message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Details
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CertChain.NoiseCertificate.Details;

                /**
                 * Verifies a Details message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Details message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Details
                 */
                public static fromObject(object: { [k: string]: any }): proto.CertChain.NoiseCertificate.Details;

                /**
                 * Creates a plain object from a Details message. Also converts values to other types if specified.
                 * @param message Details
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.CertChain.NoiseCertificate.Details, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Details to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }
    }

    /** Properties of a Chain. */
    interface IChain {

        /** Chain senderRatchetKey */
        senderRatchetKey?: (Uint8Array|null);

        /** Chain senderRatchetKeyPrivate */
        senderRatchetKeyPrivate?: (Uint8Array|null);

        /** Chain chainKey */
        chainKey?: (proto.IChainKey|null);

        /** Chain messageKeys */
        messageKeys?: (proto.IMessageKey[]|null);
    }

    /** Represents a Chain. */
    class Chain implements IChain {

        /**
         * Constructs a new Chain.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IChain);

        /** Chain senderRatchetKey. */
        public senderRatchetKey: Uint8Array;

        /** Chain senderRatchetKeyPrivate. */
        public senderRatchetKeyPrivate: Uint8Array;

        /** Chain chainKey. */
        public chainKey?: (proto.IChainKey|null);

        /** Chain messageKeys. */
        public messageKeys: proto.IMessageKey[];

        /**
         * Creates a new Chain instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Chain instance
         */
        public static create(properties?: proto.IChain): proto.Chain;

        /**
         * Encodes the specified Chain message. Does not implicitly {@link proto.Chain.verify|verify} messages.
         * @param message Chain message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IChain, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Chain message, length delimited. Does not implicitly {@link proto.Chain.verify|verify} messages.
         * @param message Chain message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IChain, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Chain message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Chain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Chain;

        /**
         * Decodes a Chain message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Chain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Chain;

        /**
         * Verifies a Chain message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Chain message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Chain
         */
        public static fromObject(object: { [k: string]: any }): proto.Chain;

        /**
         * Creates a plain object from a Chain message. Also converts values to other types if specified.
         * @param message Chain
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Chain, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Chain to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ChainKey. */
    interface IChainKey {

        /** ChainKey index */
        index?: (number|null);

        /** ChainKey key */
        key?: (Uint8Array|null);
    }

    /** Represents a ChainKey. */
    class ChainKey implements IChainKey {

        /**
         * Constructs a new ChainKey.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IChainKey);

        /** ChainKey index. */
        public index: number;

        /** ChainKey key. */
        public key: Uint8Array;

        /**
         * Creates a new ChainKey instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ChainKey instance
         */
        public static create(properties?: proto.IChainKey): proto.ChainKey;

        /**
         * Encodes the specified ChainKey message. Does not implicitly {@link proto.ChainKey.verify|verify} messages.
         * @param message ChainKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IChainKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ChainKey message, length delimited. Does not implicitly {@link proto.ChainKey.verify|verify} messages.
         * @param message ChainKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IChainKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ChainKey message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ChainKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ChainKey;

        /**
         * Decodes a ChainKey message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ChainKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ChainKey;

        /**
         * Verifies a ChainKey message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ChainKey message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ChainKey
         */
        public static fromObject(object: { [k: string]: any }): proto.ChainKey;

        /**
         * Creates a plain object from a ChainKey message. Also converts values to other types if specified.
         * @param message ChainKey
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ChainKey, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ChainKey to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ClientPayload. */
    interface IClientPayload {

        /** ClientPayload username */
        username?: (number|Long|null);

        /** ClientPayload passive */
        passive?: (boolean|null);

        /** ClientPayload userAgent */
        userAgent?: (proto.ClientPayload.IUserAgent|null);

        /** ClientPayload webInfo */
        webInfo?: (proto.ClientPayload.IWebInfo|null);

        /** ClientPayload pushName */
        pushName?: (string|null);

        /** ClientPayload sessionId */
        sessionId?: (number|null);

        /** ClientPayload shortConnect */
        shortConnect?: (boolean|null);

        /** ClientPayload connectType */
        connectType?: (proto.ClientPayload.ConnectType|null);

        /** ClientPayload connectReason */
        connectReason?: (proto.ClientPayload.ConnectReason|null);

        /** ClientPayload shards */
        shards?: (number[]|null);

        /** ClientPayload dnsSource */
        dnsSource?: (proto.ClientPayload.IDNSSource|null);

        /** ClientPayload connectAttemptCount */
        connectAttemptCount?: (number|null);

        /** ClientPayload device */
        device?: (number|null);

        /** ClientPayload devicePairingData */
        devicePairingData?: (proto.ClientPayload.IDevicePairingRegistrationData|null);

        /** ClientPayload product */
        product?: (proto.ClientPayload.Product|null);

        /** ClientPayload fbCat */
        fbCat?: (Uint8Array|null);

        /** ClientPayload fbUserAgent */
        fbUserAgent?: (Uint8Array|null);

        /** ClientPayload oc */
        oc?: (boolean|null);

        /** ClientPayload lc */
        lc?: (number|null);

        /** ClientPayload iosAppExtension */
        iosAppExtension?: (proto.ClientPayload.IOSAppExtension|null);

        /** ClientPayload fbAppId */
        fbAppId?: (number|Long|null);

        /** ClientPayload fbDeviceId */
        fbDeviceId?: (Uint8Array|null);

        /** ClientPayload pull */
        pull?: (boolean|null);

        /** ClientPayload paddingBytes */
        paddingBytes?: (Uint8Array|null);

        /** ClientPayload bizMarketSegment */
        bizMarketSegment?: (proto.ClientPayload.BizMarketSegment|null);

        /** ClientPayload yearClass */
        yearClass?: (number|null);

        /** ClientPayload memClass */
        memClass?: (number|null);
    }

    /** Represents a ClientPayload. */
    class ClientPayload implements IClientPayload {

        /**
         * Constructs a new ClientPayload.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IClientPayload);

        /** ClientPayload username. */
        public username: (number|Long);

        /** ClientPayload passive. */
        public passive: boolean;

        /** ClientPayload userAgent. */
        public userAgent?: (proto.ClientPayload.IUserAgent|null);

        /** ClientPayload webInfo. */
        public webInfo?: (proto.ClientPayload.IWebInfo|null);

        /** ClientPayload pushName. */
        public pushName: string;

        /** ClientPayload sessionId. */
        public sessionId: number;

        /** ClientPayload shortConnect. */
        public shortConnect: boolean;

        /** ClientPayload connectType. */
        public connectType: proto.ClientPayload.ConnectType;

        /** ClientPayload connectReason. */
        public connectReason: proto.ClientPayload.ConnectReason;

        /** ClientPayload shards. */
        public shards: number[];

        /** ClientPayload dnsSource. */
        public dnsSource?: (proto.ClientPayload.IDNSSource|null);

        /** ClientPayload connectAttemptCount. */
        public connectAttemptCount: number;

        /** ClientPayload device. */
        public device: number;

        /** ClientPayload devicePairingData. */
        public devicePairingData?: (proto.ClientPayload.IDevicePairingRegistrationData|null);

        /** ClientPayload product. */
        public product: proto.ClientPayload.Product;

        /** ClientPayload fbCat. */
        public fbCat: Uint8Array;

        /** ClientPayload fbUserAgent. */
        public fbUserAgent: Uint8Array;

        /** ClientPayload oc. */
        public oc: boolean;

        /** ClientPayload lc. */
        public lc: number;

        /** ClientPayload iosAppExtension. */
        public iosAppExtension: proto.ClientPayload.IOSAppExtension;

        /** ClientPayload fbAppId. */
        public fbAppId: (number|Long);

        /** ClientPayload fbDeviceId. */
        public fbDeviceId: Uint8Array;

        /** ClientPayload pull. */
        public pull: boolean;

        /** ClientPayload paddingBytes. */
        public paddingBytes: Uint8Array;

        /** ClientPayload bizMarketSegment. */
        public bizMarketSegment: proto.ClientPayload.BizMarketSegment;

        /** ClientPayload yearClass. */
        public yearClass: number;

        /** ClientPayload memClass. */
        public memClass: number;

        /**
         * Creates a new ClientPayload instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ClientPayload instance
         */
        public static create(properties?: proto.IClientPayload): proto.ClientPayload;

        /**
         * Encodes the specified ClientPayload message. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @param message ClientPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IClientPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ClientPayload message, length delimited. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @param message ClientPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IClientPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ClientPayload message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload;

        /**
         * Decodes a ClientPayload message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload;

        /**
         * Verifies a ClientPayload message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ClientPayload message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ClientPayload
         */
        public static fromObject(object: { [k: string]: any }): proto.ClientPayload;

        /**
         * Creates a plain object from a ClientPayload message. Also converts values to other types if specified.
         * @param message ClientPayload
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ClientPayload, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ClientPayload to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace ClientPayload {

        /** BizMarketSegment enum. */
        enum BizMarketSegment {
            DEFAULT = 0,
            DEVX = 1,
            INBOX = 2
        }

        /** ConnectReason enum. */
        enum ConnectReason {
            PUSH = 0,
            USER_ACTIVATED = 1,
            SCHEDULED = 2,
            ERROR_RECONNECT = 3,
            NETWORK_SWITCH = 4,
            PING_RECONNECT = 5
        }

        /** ConnectType enum. */
        enum ConnectType {
            CELLULAR_UNKNOWN = 0,
            WIFI_UNKNOWN = 1,
            CELLULAR_EDGE = 100,
            CELLULAR_IDEN = 101,
            CELLULAR_UMTS = 102,
            CELLULAR_EVDO = 103,
            CELLULAR_GPRS = 104,
            CELLULAR_HSDPA = 105,
            CELLULAR_HSUPA = 106,
            CELLULAR_HSPA = 107,
            CELLULAR_CDMA = 108,
            CELLULAR_1XRTT = 109,
            CELLULAR_EHRPD = 110,
            CELLULAR_LTE = 111,
            CELLULAR_HSPAP = 112
        }

        /** Properties of a DNSSource. */
        interface IDNSSource {

            /** DNSSource dnsMethod */
            dnsMethod?: (proto.ClientPayload.DNSSource.DNSResolutionMethod|null);

            /** DNSSource appCached */
            appCached?: (boolean|null);
        }

        /** Represents a DNSSource. */
        class DNSSource implements IDNSSource {

            /**
             * Constructs a new DNSSource.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ClientPayload.IDNSSource);

            /** DNSSource dnsMethod. */
            public dnsMethod: proto.ClientPayload.DNSSource.DNSResolutionMethod;

            /** DNSSource appCached. */
            public appCached: boolean;

            /**
             * Creates a new DNSSource instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DNSSource instance
             */
            public static create(properties?: proto.ClientPayload.IDNSSource): proto.ClientPayload.DNSSource;

            /**
             * Encodes the specified DNSSource message. Does not implicitly {@link proto.ClientPayload.DNSSource.verify|verify} messages.
             * @param message DNSSource message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ClientPayload.IDNSSource, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DNSSource message, length delimited. Does not implicitly {@link proto.ClientPayload.DNSSource.verify|verify} messages.
             * @param message DNSSource message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ClientPayload.IDNSSource, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DNSSource message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DNSSource
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.DNSSource;

            /**
             * Decodes a DNSSource message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DNSSource
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.DNSSource;

            /**
             * Verifies a DNSSource message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DNSSource message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DNSSource
             */
            public static fromObject(object: { [k: string]: any }): proto.ClientPayload.DNSSource;

            /**
             * Creates a plain object from a DNSSource message. Also converts values to other types if specified.
             * @param message DNSSource
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ClientPayload.DNSSource, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DNSSource to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace DNSSource {

            /** DNSResolutionMethod enum. */
            enum DNSResolutionMethod {
                SYSTEM = 0,
                GOOGLE = 1,
                HARDCODED = 2,
                OVERRIDE = 3,
                FALLBACK = 4
            }
        }

        /** Properties of a DevicePairingRegistrationData. */
        interface IDevicePairingRegistrationData {

            /** DevicePairingRegistrationData eRegid */
            eRegid?: (Uint8Array|null);

            /** DevicePairingRegistrationData eKeytype */
            eKeytype?: (Uint8Array|null);

            /** DevicePairingRegistrationData eIdent */
            eIdent?: (Uint8Array|null);

            /** DevicePairingRegistrationData eSkeyId */
            eSkeyId?: (Uint8Array|null);

            /** DevicePairingRegistrationData eSkeyVal */
            eSkeyVal?: (Uint8Array|null);

            /** DevicePairingRegistrationData eSkeySig */
            eSkeySig?: (Uint8Array|null);

            /** DevicePairingRegistrationData buildHash */
            buildHash?: (Uint8Array|null);

            /** DevicePairingRegistrationData deviceProps */
            deviceProps?: (Uint8Array|null);
        }

        /** Represents a DevicePairingRegistrationData. */
        class DevicePairingRegistrationData implements IDevicePairingRegistrationData {

            /**
             * Constructs a new DevicePairingRegistrationData.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ClientPayload.IDevicePairingRegistrationData);

            /** DevicePairingRegistrationData eRegid. */
            public eRegid: Uint8Array;

            /** DevicePairingRegistrationData eKeytype. */
            public eKeytype: Uint8Array;

            /** DevicePairingRegistrationData eIdent. */
            public eIdent: Uint8Array;

            /** DevicePairingRegistrationData eSkeyId. */
            public eSkeyId: Uint8Array;

            /** DevicePairingRegistrationData eSkeyVal. */
            public eSkeyVal: Uint8Array;

            /** DevicePairingRegistrationData eSkeySig. */
            public eSkeySig: Uint8Array;

            /** DevicePairingRegistrationData buildHash. */
            public buildHash: Uint8Array;

            /** DevicePairingRegistrationData deviceProps. */
            public deviceProps: Uint8Array;

            /**
             * Creates a new DevicePairingRegistrationData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DevicePairingRegistrationData instance
             */
            public static create(properties?: proto.ClientPayload.IDevicePairingRegistrationData): proto.ClientPayload.DevicePairingRegistrationData;

            /**
             * Encodes the specified DevicePairingRegistrationData message. Does not implicitly {@link proto.ClientPayload.DevicePairingRegistrationData.verify|verify} messages.
             * @param message DevicePairingRegistrationData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ClientPayload.IDevicePairingRegistrationData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DevicePairingRegistrationData message, length delimited. Does not implicitly {@link proto.ClientPayload.DevicePairingRegistrationData.verify|verify} messages.
             * @param message DevicePairingRegistrationData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ClientPayload.IDevicePairingRegistrationData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DevicePairingRegistrationData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DevicePairingRegistrationData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.DevicePairingRegistrationData;

            /**
             * Decodes a DevicePairingRegistrationData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DevicePairingRegistrationData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.DevicePairingRegistrationData;

            /**
             * Verifies a DevicePairingRegistrationData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DevicePairingRegistrationData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DevicePairingRegistrationData
             */
            public static fromObject(object: { [k: string]: any }): proto.ClientPayload.DevicePairingRegistrationData;

            /**
             * Creates a plain object from a DevicePairingRegistrationData message. Also converts values to other types if specified.
             * @param message DevicePairingRegistrationData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ClientPayload.DevicePairingRegistrationData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DevicePairingRegistrationData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** IOSAppExtension enum. */
        enum IOSAppExtension {
            SHARE_EXTENSION = 0,
            SERVICE_EXTENSION = 1,
            INTENTS_EXTENSION = 2
        }

        /** Product enum. */
        enum Product {
            WHATSAPP = 0,
            MESSENGER = 1
        }

        /** Properties of a UserAgent. */
        interface IUserAgent {

            /** UserAgent platform */
            platform?: (proto.ClientPayload.UserAgent.Platform|null);

            /** UserAgent appVersion */
            appVersion?: (proto.ClientPayload.UserAgent.IAppVersion|null);

            /** UserAgent mcc */
            mcc?: (string|null);

            /** UserAgent mnc */
            mnc?: (string|null);

            /** UserAgent osVersion */
            osVersion?: (string|null);

            /** UserAgent manufacturer */
            manufacturer?: (string|null);

            /** UserAgent device */
            device?: (string|null);

            /** UserAgent osBuildNumber */
            osBuildNumber?: (string|null);

            /** UserAgent phoneId */
            phoneId?: (string|null);

            /** UserAgent releaseChannel */
            releaseChannel?: (proto.ClientPayload.UserAgent.ReleaseChannel|null);

            /** UserAgent localeLanguageIso6391 */
            localeLanguageIso6391?: (string|null);

            /** UserAgent localeCountryIso31661Alpha2 */
            localeCountryIso31661Alpha2?: (string|null);

            /** UserAgent deviceBoard */
            deviceBoard?: (string|null);
        }

        /** Represents a UserAgent. */
        class UserAgent implements IUserAgent {

            /**
             * Constructs a new UserAgent.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ClientPayload.IUserAgent);

            /** UserAgent platform. */
            public platform: proto.ClientPayload.UserAgent.Platform;

            /** UserAgent appVersion. */
            public appVersion?: (proto.ClientPayload.UserAgent.IAppVersion|null);

            /** UserAgent mcc. */
            public mcc: string;

            /** UserAgent mnc. */
            public mnc: string;

            /** UserAgent osVersion. */
            public osVersion: string;

            /** UserAgent manufacturer. */
            public manufacturer: string;

            /** UserAgent device. */
            public device: string;

            /** UserAgent osBuildNumber. */
            public osBuildNumber: string;

            /** UserAgent phoneId. */
            public phoneId: string;

            /** UserAgent releaseChannel. */
            public releaseChannel: proto.ClientPayload.UserAgent.ReleaseChannel;

            /** UserAgent localeLanguageIso6391. */
            public localeLanguageIso6391: string;

            /** UserAgent localeCountryIso31661Alpha2. */
            public localeCountryIso31661Alpha2: string;

            /** UserAgent deviceBoard. */
            public deviceBoard: string;

            /**
             * Creates a new UserAgent instance using the specified properties.
             * @param [properties] Properties to set
             * @returns UserAgent instance
             */
            public static create(properties?: proto.ClientPayload.IUserAgent): proto.ClientPayload.UserAgent;

            /**
             * Encodes the specified UserAgent message. Does not implicitly {@link proto.ClientPayload.UserAgent.verify|verify} messages.
             * @param message UserAgent message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ClientPayload.IUserAgent, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified UserAgent message, length delimited. Does not implicitly {@link proto.ClientPayload.UserAgent.verify|verify} messages.
             * @param message UserAgent message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ClientPayload.IUserAgent, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a UserAgent message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns UserAgent
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.UserAgent;

            /**
             * Decodes a UserAgent message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns UserAgent
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.UserAgent;

            /**
             * Verifies a UserAgent message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a UserAgent message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns UserAgent
             */
            public static fromObject(object: { [k: string]: any }): proto.ClientPayload.UserAgent;

            /**
             * Creates a plain object from a UserAgent message. Also converts values to other types if specified.
             * @param message UserAgent
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ClientPayload.UserAgent, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this UserAgent to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace UserAgent {

            /** Properties of an AppVersion. */
            interface IAppVersion {

                /** AppVersion primary */
                primary?: (number|null);

                /** AppVersion secondary */
                secondary?: (number|null);

                /** AppVersion tertiary */
                tertiary?: (number|null);

                /** AppVersion quaternary */
                quaternary?: (number|null);

                /** AppVersion quinary */
                quinary?: (number|null);
            }

            /** Represents an AppVersion. */
            class AppVersion implements IAppVersion {

                /**
                 * Constructs a new AppVersion.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.ClientPayload.UserAgent.IAppVersion);

                /** AppVersion primary. */
                public primary: number;

                /** AppVersion secondary. */
                public secondary: number;

                /** AppVersion tertiary. */
                public tertiary: number;

                /** AppVersion quaternary. */
                public quaternary: number;

                /** AppVersion quinary. */
                public quinary: number;

                /**
                 * Creates a new AppVersion instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns AppVersion instance
                 */
                public static create(properties?: proto.ClientPayload.UserAgent.IAppVersion): proto.ClientPayload.UserAgent.AppVersion;

                /**
                 * Encodes the specified AppVersion message. Does not implicitly {@link proto.ClientPayload.UserAgent.AppVersion.verify|verify} messages.
                 * @param message AppVersion message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.ClientPayload.UserAgent.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link proto.ClientPayload.UserAgent.AppVersion.verify|verify} messages.
                 * @param message AppVersion message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.ClientPayload.UserAgent.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes an AppVersion message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns AppVersion
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.UserAgent.AppVersion;

                /**
                 * Decodes an AppVersion message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns AppVersion
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.UserAgent.AppVersion;

                /**
                 * Verifies an AppVersion message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns AppVersion
                 */
                public static fromObject(object: { [k: string]: any }): proto.ClientPayload.UserAgent.AppVersion;

                /**
                 * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
                 * @param message AppVersion
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.ClientPayload.UserAgent.AppVersion, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this AppVersion to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Platform enum. */
            enum Platform {
                ANDROID = 0,
                IOS = 1,
                WINDOWS_PHONE = 2,
                BLACKBERRY = 3,
                BLACKBERRYX = 4,
                S40 = 5,
                S60 = 6,
                PYTHON_CLIENT = 7,
                TIZEN = 8,
                ENTERPRISE = 9,
                SMB_ANDROID = 10,
                KAIOS = 11,
                SMB_IOS = 12,
                WINDOWS = 13,
                WEB = 14,
                PORTAL = 15,
                GREEN_ANDROID = 16,
                GREEN_IPHONE = 17,
                BLUE_ANDROID = 18,
                BLUE_IPHONE = 19,
                FBLITE_ANDROID = 20,
                MLITE_ANDROID = 21,
                IGLITE_ANDROID = 22,
                PAGE = 23,
                MACOS = 24,
                OCULUS_MSG = 25,
                OCULUS_CALL = 26,
                MILAN = 27,
                CAPI = 28,
                WEAROS = 29,
                ARDEVICE = 30,
                VRDEVICE = 31
            }

            /** ReleaseChannel enum. */
            enum ReleaseChannel {
                RELEASE = 0,
                BETA = 1,
                ALPHA = 2,
                DEBUG = 3
            }
        }

        /** Properties of a WebInfo. */
        interface IWebInfo {

            /** WebInfo refToken */
            refToken?: (string|null);

            /** WebInfo version */
            version?: (string|null);

            /** WebInfo webdPayload */
            webdPayload?: (proto.ClientPayload.WebInfo.IWebdPayload|null);

            /** WebInfo webSubPlatform */
            webSubPlatform?: (proto.ClientPayload.WebInfo.WebSubPlatform|null);
        }

        /** Represents a WebInfo. */
        class WebInfo implements IWebInfo {

            /**
             * Constructs a new WebInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ClientPayload.IWebInfo);

            /** WebInfo refToken. */
            public refToken: string;

            /** WebInfo version. */
            public version: string;

            /** WebInfo webdPayload. */
            public webdPayload?: (proto.ClientPayload.WebInfo.IWebdPayload|null);

            /** WebInfo webSubPlatform. */
            public webSubPlatform: proto.ClientPayload.WebInfo.WebSubPlatform;

            /**
             * Creates a new WebInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns WebInfo instance
             */
            public static create(properties?: proto.ClientPayload.IWebInfo): proto.ClientPayload.WebInfo;

            /**
             * Encodes the specified WebInfo message. Does not implicitly {@link proto.ClientPayload.WebInfo.verify|verify} messages.
             * @param message WebInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ClientPayload.IWebInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified WebInfo message, length delimited. Does not implicitly {@link proto.ClientPayload.WebInfo.verify|verify} messages.
             * @param message WebInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ClientPayload.IWebInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a WebInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns WebInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.WebInfo;

            /**
             * Decodes a WebInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns WebInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.WebInfo;

            /**
             * Verifies a WebInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a WebInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns WebInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ClientPayload.WebInfo;

            /**
             * Creates a plain object from a WebInfo message. Also converts values to other types if specified.
             * @param message WebInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ClientPayload.WebInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this WebInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace WebInfo {

            /** WebSubPlatform enum. */
            enum WebSubPlatform {
                WEB_BROWSER = 0,
                APP_STORE = 1,
                WIN_STORE = 2,
                DARWIN = 3,
                WIN32 = 4
            }

            /** Properties of a WebdPayload. */
            interface IWebdPayload {

                /** WebdPayload usesParticipantInKey */
                usesParticipantInKey?: (boolean|null);

                /** WebdPayload supportsStarredMessages */
                supportsStarredMessages?: (boolean|null);

                /** WebdPayload supportsDocumentMessages */
                supportsDocumentMessages?: (boolean|null);

                /** WebdPayload supportsUrlMessages */
                supportsUrlMessages?: (boolean|null);

                /** WebdPayload supportsMediaRetry */
                supportsMediaRetry?: (boolean|null);

                /** WebdPayload supportsE2EImage */
                supportsE2EImage?: (boolean|null);

                /** WebdPayload supportsE2EVideo */
                supportsE2EVideo?: (boolean|null);

                /** WebdPayload supportsE2EAudio */
                supportsE2EAudio?: (boolean|null);

                /** WebdPayload supportsE2EDocument */
                supportsE2EDocument?: (boolean|null);

                /** WebdPayload documentTypes */
                documentTypes?: (string|null);

                /** WebdPayload features */
                features?: (Uint8Array|null);
            }

            /** Represents a WebdPayload. */
            class WebdPayload implements IWebdPayload {

                /**
                 * Constructs a new WebdPayload.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.ClientPayload.WebInfo.IWebdPayload);

                /** WebdPayload usesParticipantInKey. */
                public usesParticipantInKey: boolean;

                /** WebdPayload supportsStarredMessages. */
                public supportsStarredMessages: boolean;

                /** WebdPayload supportsDocumentMessages. */
                public supportsDocumentMessages: boolean;

                /** WebdPayload supportsUrlMessages. */
                public supportsUrlMessages: boolean;

                /** WebdPayload supportsMediaRetry. */
                public supportsMediaRetry: boolean;

                /** WebdPayload supportsE2EImage. */
                public supportsE2EImage: boolean;

                /** WebdPayload supportsE2EVideo. */
                public supportsE2EVideo: boolean;

                /** WebdPayload supportsE2EAudio. */
                public supportsE2EAudio: boolean;

                /** WebdPayload supportsE2EDocument. */
                public supportsE2EDocument: boolean;

                /** WebdPayload documentTypes. */
                public documentTypes: string;

                /** WebdPayload features. */
                public features: Uint8Array;

                /**
                 * Creates a new WebdPayload instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns WebdPayload instance
                 */
                public static create(properties?: proto.ClientPayload.WebInfo.IWebdPayload): proto.ClientPayload.WebInfo.WebdPayload;

                /**
                 * Encodes the specified WebdPayload message. Does not implicitly {@link proto.ClientPayload.WebInfo.WebdPayload.verify|verify} messages.
                 * @param message WebdPayload message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.ClientPayload.WebInfo.IWebdPayload, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified WebdPayload message, length delimited. Does not implicitly {@link proto.ClientPayload.WebInfo.WebdPayload.verify|verify} messages.
                 * @param message WebdPayload message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.ClientPayload.WebInfo.IWebdPayload, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a WebdPayload message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns WebdPayload
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.WebInfo.WebdPayload;

                /**
                 * Decodes a WebdPayload message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns WebdPayload
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.WebInfo.WebdPayload;

                /**
                 * Verifies a WebdPayload message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a WebdPayload message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns WebdPayload
                 */
                public static fromObject(object: { [k: string]: any }): proto.ClientPayload.WebInfo.WebdPayload;

                /**
                 * Creates a plain object from a WebdPayload message. Also converts values to other types if specified.
                 * @param message WebdPayload
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.ClientPayload.WebInfo.WebdPayload, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this WebdPayload to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }
    }

    /** Properties of a ContextInfo. */
    interface IContextInfo {

        /** ContextInfo stanzaId */
        stanzaId?: (string|null);

        /** ContextInfo participant */
        participant?: (string|null);

        /** ContextInfo quotedMessage */
        quotedMessage?: (proto.IMessage|null);

        /** ContextInfo remoteJid */
        remoteJid?: (string|null);

        /** ContextInfo mentionedJid */
        mentionedJid?: (string[]|null);

        /** ContextInfo conversionSource */
        conversionSource?: (string|null);

        /** ContextInfo conversionData */
        conversionData?: (Uint8Array|null);

        /** ContextInfo conversionDelaySeconds */
        conversionDelaySeconds?: (number|null);

        /** ContextInfo forwardingScore */
        forwardingScore?: (number|null);

        /** ContextInfo isForwarded */
        isForwarded?: (boolean|null);

        /** ContextInfo quotedAd */
        quotedAd?: (proto.ContextInfo.IAdReplyInfo|null);

        /** ContextInfo placeholderKey */
        placeholderKey?: (proto.IMessageKey|null);

        /** ContextInfo expiration */
        expiration?: (number|null);

        /** ContextInfo ephemeralSettingTimestamp */
        ephemeralSettingTimestamp?: (number|Long|null);

        /** ContextInfo ephemeralSharedSecret */
        ephemeralSharedSecret?: (Uint8Array|null);

        /** ContextInfo externalAdReply */
        externalAdReply?: (proto.ContextInfo.IExternalAdReplyInfo|null);

        /** ContextInfo entryPointConversionSource */
        entryPointConversionSource?: (string|null);

        /** ContextInfo entryPointConversionApp */
        entryPointConversionApp?: (string|null);

        /** ContextInfo entryPointConversionDelaySeconds */
        entryPointConversionDelaySeconds?: (number|null);

        /** ContextInfo disappearingMode */
        disappearingMode?: (proto.IDisappearingMode|null);

        /** ContextInfo actionLink */
        actionLink?: (proto.IActionLink|null);

        /** ContextInfo groupSubject */
        groupSubject?: (string|null);

        /** ContextInfo parentGroupJid */
        parentGroupJid?: (string|null);

        /** ContextInfo trustBannerType */
        trustBannerType?: (string|null);

        /** ContextInfo trustBannerAction */
        trustBannerAction?: (number|null);
    }

    /** Represents a ContextInfo. */
    class ContextInfo implements IContextInfo {

        /**
         * Constructs a new ContextInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IContextInfo);

        /** ContextInfo stanzaId. */
        public stanzaId: string;

        /** ContextInfo participant. */
        public participant: string;

        /** ContextInfo quotedMessage. */
        public quotedMessage?: (proto.IMessage|null);

        /** ContextInfo remoteJid. */
        public remoteJid: string;

        /** ContextInfo mentionedJid. */
        public mentionedJid: string[];

        /** ContextInfo conversionSource. */
        public conversionSource: string;

        /** ContextInfo conversionData. */
        public conversionData: Uint8Array;

        /** ContextInfo conversionDelaySeconds. */
        public conversionDelaySeconds: number;

        /** ContextInfo forwardingScore. */
        public forwardingScore: number;

        /** ContextInfo isForwarded. */
        public isForwarded: boolean;

        /** ContextInfo quotedAd. */
        public quotedAd?: (proto.ContextInfo.IAdReplyInfo|null);

        /** ContextInfo placeholderKey. */
        public placeholderKey?: (proto.IMessageKey|null);

        /** ContextInfo expiration. */
        public expiration: number;

        /** ContextInfo ephemeralSettingTimestamp. */
        public ephemeralSettingTimestamp: (number|Long);

        /** ContextInfo ephemeralSharedSecret. */
        public ephemeralSharedSecret: Uint8Array;

        /** ContextInfo externalAdReply. */
        public externalAdReply?: (proto.ContextInfo.IExternalAdReplyInfo|null);

        /** ContextInfo entryPointConversionSource. */
        public entryPointConversionSource: string;

        /** ContextInfo entryPointConversionApp. */
        public entryPointConversionApp: string;

        /** ContextInfo entryPointConversionDelaySeconds. */
        public entryPointConversionDelaySeconds: number;

        /** ContextInfo disappearingMode. */
        public disappearingMode?: (proto.IDisappearingMode|null);

        /** ContextInfo actionLink. */
        public actionLink?: (proto.IActionLink|null);

        /** ContextInfo groupSubject. */
        public groupSubject: string;

        /** ContextInfo parentGroupJid. */
        public parentGroupJid: string;

        /** ContextInfo trustBannerType. */
        public trustBannerType: string;

        /** ContextInfo trustBannerAction. */
        public trustBannerAction: number;

        /**
         * Creates a new ContextInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ContextInfo instance
         */
        public static create(properties?: proto.IContextInfo): proto.ContextInfo;

        /**
         * Encodes the specified ContextInfo message. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @param message ContextInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IContextInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ContextInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @param message ContextInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IContextInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ContextInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo;

        /**
         * Decodes a ContextInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo;

        /**
         * Verifies a ContextInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ContextInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ContextInfo
         */
        public static fromObject(object: { [k: string]: any }): proto.ContextInfo;

        /**
         * Creates a plain object from a ContextInfo message. Also converts values to other types if specified.
         * @param message ContextInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ContextInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ContextInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace ContextInfo {

        /** Properties of an AdReplyInfo. */
        interface IAdReplyInfo {

            /** AdReplyInfo advertiserName */
            advertiserName?: (string|null);

            /** AdReplyInfo mediaType */
            mediaType?: (proto.ContextInfo.AdReplyInfo.MediaType|null);

            /** AdReplyInfo jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** AdReplyInfo caption */
            caption?: (string|null);
        }

        /** Represents an AdReplyInfo. */
        class AdReplyInfo implements IAdReplyInfo {

            /**
             * Constructs a new AdReplyInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IAdReplyInfo);

            /** AdReplyInfo advertiserName. */
            public advertiserName: string;

            /** AdReplyInfo mediaType. */
            public mediaType: proto.ContextInfo.AdReplyInfo.MediaType;

            /** AdReplyInfo jpegThumbnail. */
            public jpegThumbnail: Uint8Array;

            /** AdReplyInfo caption. */
            public caption: string;

            /**
             * Creates a new AdReplyInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AdReplyInfo instance
             */
            public static create(properties?: proto.ContextInfo.IAdReplyInfo): proto.ContextInfo.AdReplyInfo;

            /**
             * Encodes the specified AdReplyInfo message. Does not implicitly {@link proto.ContextInfo.AdReplyInfo.verify|verify} messages.
             * @param message AdReplyInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IAdReplyInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AdReplyInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.AdReplyInfo.verify|verify} messages.
             * @param message AdReplyInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IAdReplyInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AdReplyInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.AdReplyInfo;

            /**
             * Decodes an AdReplyInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.AdReplyInfo;

            /**
             * Verifies an AdReplyInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AdReplyInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AdReplyInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.AdReplyInfo;

            /**
             * Creates a plain object from an AdReplyInfo message. Also converts values to other types if specified.
             * @param message AdReplyInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.AdReplyInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AdReplyInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace AdReplyInfo {

            /** MediaType enum. */
            enum MediaType {
                NONE = 0,
                IMAGE = 1,
                VIDEO = 2
            }
        }

        /** Properties of an ExternalAdReplyInfo. */
        interface IExternalAdReplyInfo {

            /** ExternalAdReplyInfo title */
            title?: (string|null);

            /** ExternalAdReplyInfo body */
            body?: (string|null);

            /** ExternalAdReplyInfo mediaType */
            mediaType?: (proto.ContextInfo.ExternalAdReplyInfo.MediaType|null);

            /** ExternalAdReplyInfo thumbnailUrl */
            thumbnailUrl?: (string|null);

            /** ExternalAdReplyInfo mediaUrl */
            mediaUrl?: (string|null);

            /** ExternalAdReplyInfo thumbnail */
            thumbnail?: (Uint8Array|null);

            /** ExternalAdReplyInfo sourceType */
            sourceType?: (string|null);

            /** ExternalAdReplyInfo sourceId */
            sourceId?: (string|null);

            /** ExternalAdReplyInfo sourceUrl */
            sourceUrl?: (string|null);

            /** ExternalAdReplyInfo containsAutoReply */
            containsAutoReply?: (boolean|null);

            /** ExternalAdReplyInfo renderLargerThumbnail */
            renderLargerThumbnail?: (boolean|null);

            /** ExternalAdReplyInfo showAdAttribution */
            showAdAttribution?: (boolean|null);

            /** ExternalAdReplyInfo ctwaClid */
            ctwaClid?: (string|null);
        }

        /** Represents an ExternalAdReplyInfo. */
        class ExternalAdReplyInfo implements IExternalAdReplyInfo {

            /**
             * Constructs a new ExternalAdReplyInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IExternalAdReplyInfo);

            /** ExternalAdReplyInfo title. */
            public title: string;

            /** ExternalAdReplyInfo body. */
            public body: string;

            /** ExternalAdReplyInfo mediaType. */
            public mediaType: proto.ContextInfo.ExternalAdReplyInfo.MediaType;

            /** ExternalAdReplyInfo thumbnailUrl. */
            public thumbnailUrl: string;

            /** ExternalAdReplyInfo mediaUrl. */
            public mediaUrl: string;

            /** ExternalAdReplyInfo thumbnail. */
            public thumbnail: Uint8Array;

            /** ExternalAdReplyInfo sourceType. */
            public sourceType: string;

            /** ExternalAdReplyInfo sourceId. */
            public sourceId: string;

            /** ExternalAdReplyInfo sourceUrl. */
            public sourceUrl: string;

            /** ExternalAdReplyInfo containsAutoReply. */
            public containsAutoReply: boolean;

            /** ExternalAdReplyInfo renderLargerThumbnail. */
            public renderLargerThumbnail: boolean;

            /** ExternalAdReplyInfo showAdAttribution. */
            public showAdAttribution: boolean;

            /** ExternalAdReplyInfo ctwaClid. */
            public ctwaClid: string;

            /**
             * Creates a new ExternalAdReplyInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ExternalAdReplyInfo instance
             */
            public static create(properties?: proto.ContextInfo.IExternalAdReplyInfo): proto.ContextInfo.ExternalAdReplyInfo;

            /**
             * Encodes the specified ExternalAdReplyInfo message. Does not implicitly {@link proto.ContextInfo.ExternalAdReplyInfo.verify|verify} messages.
             * @param message ExternalAdReplyInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IExternalAdReplyInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ExternalAdReplyInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.ExternalAdReplyInfo.verify|verify} messages.
             * @param message ExternalAdReplyInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IExternalAdReplyInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an ExternalAdReplyInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ExternalAdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.ExternalAdReplyInfo;

            /**
             * Decodes an ExternalAdReplyInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ExternalAdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.ExternalAdReplyInfo;

            /**
             * Verifies an ExternalAdReplyInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an ExternalAdReplyInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ExternalAdReplyInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.ExternalAdReplyInfo;

            /**
             * Creates a plain object from an ExternalAdReplyInfo message. Also converts values to other types if specified.
             * @param message ExternalAdReplyInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.ExternalAdReplyInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ExternalAdReplyInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace ExternalAdReplyInfo {

            /** MediaType enum. */
            enum MediaType {
                NONE = 0,
                IMAGE = 1,
                VIDEO = 2
            }
        }
    }

    /** Properties of a Conversation. */
    interface IConversation {

        /** Conversation id */
        id: string;

        /** Conversation messages */
        messages?: (proto.IHistorySyncMsg[]|null);

        /** Conversation newJid */
        newJid?: (string|null);

        /** Conversation oldJid */
        oldJid?: (string|null);

        /** Conversation lastMsgTimestamp */
        lastMsgTimestamp?: (number|Long|null);

        /** Conversation unreadCount */
        unreadCount?: (number|null);

        /** Conversation readOnly */
        readOnly?: (boolean|null);

        /** Conversation endOfHistoryTransfer */
        endOfHistoryTransfer?: (boolean|null);

        /** Conversation ephemeralExpiration */
        ephemeralExpiration?: (number|null);

        /** Conversation ephemeralSettingTimestamp */
        ephemeralSettingTimestamp?: (number|Long|null);

        /** Conversation endOfHistoryTransferType */
        endOfHistoryTransferType?: (proto.Conversation.EndOfHistoryTransferType|null);

        /** Conversation conversationTimestamp */
        conversationTimestamp?: (number|Long|null);

        /** Conversation name */
        name?: (string|null);

        /** Conversation pHash */
        pHash?: (string|null);

        /** Conversation notSpam */
        notSpam?: (boolean|null);

        /** Conversation archived */
        archived?: (boolean|null);

        /** Conversation disappearingMode */
        disappearingMode?: (proto.IDisappearingMode|null);

        /** Conversation unreadMentionCount */
        unreadMentionCount?: (number|null);

        /** Conversation markedAsUnread */
        markedAsUnread?: (boolean|null);

        /** Conversation participant */
        participant?: (proto.IGroupParticipant[]|null);

        /** Conversation tcToken */
        tcToken?: (Uint8Array|null);

        /** Conversation tcTokenTimestamp */
        tcTokenTimestamp?: (number|Long|null);

        /** Conversation contactPrimaryIdentityKey */
        contactPrimaryIdentityKey?: (Uint8Array|null);

        /** Conversation pinned */
        pinned?: (number|null);

        /** Conversation muteEndTime */
        muteEndTime?: (number|Long|null);

        /** Conversation wallpaper */
        wallpaper?: (proto.IWallpaperSettings|null);

        /** Conversation mediaVisibility */
        mediaVisibility?: (proto.MediaVisibility|null);

        /** Conversation tcTokenSenderTimestamp */
        tcTokenSenderTimestamp?: (number|Long|null);

        /** Conversation suspended */
        suspended?: (boolean|null);

        /** Conversation terminated */
        terminated?: (boolean|null);

        /** Conversation createdAt */
        createdAt?: (number|Long|null);

        /** Conversation createdBy */
        createdBy?: (string|null);

        /** Conversation description */
        description?: (string|null);

        /** Conversation support */
        support?: (boolean|null);

        /** Conversation isParentGroup */
        isParentGroup?: (boolean|null);

        /** Conversation isDefaultSubgroup */
        isDefaultSubgroup?: (boolean|null);

        /** Conversation parentGroupId */
        parentGroupId?: (string|null);

        /** Conversation displayName */
        displayName?: (string|null);

        /** Conversation pnJid */
        pnJid?: (string|null);

        /** Conversation shareOwnPn */
        shareOwnPn?: (boolean|null);

        /** Conversation pnhDuplicateLidThread */
        pnhDuplicateLidThread?: (boolean|null);

        /** Conversation lidJid */
        lidJid?: (string|null);
    }

    /** Represents a Conversation. */
    class Conversation implements IConversation {

        /**
         * Constructs a new Conversation.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IConversation);

        /** Conversation id. */
        public id: string;

        /** Conversation messages. */
        public messages: proto.IHistorySyncMsg[];

        /** Conversation newJid. */
        public newJid: string;

        /** Conversation oldJid. */
        public oldJid: string;

        /** Conversation lastMsgTimestamp. */
        public lastMsgTimestamp: (number|Long);

        /** Conversation unreadCount. */
        public unreadCount: number;

        /** Conversation readOnly. */
        public readOnly: boolean;

        /** Conversation endOfHistoryTransfer. */
        public endOfHistoryTransfer: boolean;

        /** Conversation ephemeralExpiration. */
        public ephemeralExpiration: number;

        /** Conversation ephemeralSettingTimestamp. */
        public ephemeralSettingTimestamp: (number|Long);

        /** Conversation endOfHistoryTransferType. */
        public endOfHistoryTransferType: proto.Conversation.EndOfHistoryTransferType;

        /** Conversation conversationTimestamp. */
        public conversationTimestamp: (number|Long);

        /** Conversation name. */
        public name: string;

        /** Conversation pHash. */
        public pHash: string;

        /** Conversation notSpam. */
        public notSpam: boolean;

        /** Conversation archived. */
        public archived: boolean;

        /** Conversation disappearingMode. */
        public disappearingMode?: (proto.IDisappearingMode|null);

        /** Conversation unreadMentionCount. */
        public unreadMentionCount: number;

        /** Conversation markedAsUnread. */
        public markedAsUnread: boolean;

        /** Conversation participant. */
        public participant: proto.IGroupParticipant[];

        /** Conversation tcToken. */
        public tcToken: Uint8Array;

        /** Conversation tcTokenTimestamp. */
        public tcTokenTimestamp: (number|Long);

        /** Conversation contactPrimaryIdentityKey. */
        public contactPrimaryIdentityKey: Uint8Array;

        /** Conversation pinned. */
        public pinned: number;

        /** Conversation muteEndTime. */
        public muteEndTime: (number|Long);

        /** Conversation wallpaper. */
        public wallpaper?: (proto.IWallpaperSettings|null);

        /** Conversation mediaVisibility. */
        public mediaVisibility: proto.MediaVisibility;

        /** Conversation tcTokenSenderTimestamp. */
        public tcTokenSenderTimestamp: (number|Long);

        /** Conversation suspended. */
        public suspended: boolean;

        /** Conversation terminated. */
        public terminated: boolean;

        /** Conversation createdAt. */
        public createdAt: (number|Long);

        /** Conversation createdBy. */
        public createdBy: string;

        /** Conversation description. */
        public description: string;

        /** Conversation support. */
        public support: boolean;

        /** Conversation isParentGroup. */
        public isParentGroup: boolean;

        /** Conversation isDefaultSubgroup. */
        public isDefaultSubgroup: boolean;

        /** Conversation parentGroupId. */
        public parentGroupId: string;

        /** Conversation displayName. */
        public displayName: string;

        /** Conversation pnJid. */
        public pnJid: string;

        /** Conversation shareOwnPn. */
        public shareOwnPn: boolean;

        /** Conversation pnhDuplicateLidThread. */
        public pnhDuplicateLidThread: boolean;

        /** Conversation lidJid. */
        public lidJid: string;

        /**
         * Creates a new Conversation instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Conversation instance
         */
        public static create(properties?: proto.IConversation): proto.Conversation;

        /**
         * Encodes the specified Conversation message. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @param message Conversation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IConversation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Conversation message, length delimited. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @param message Conversation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IConversation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Conversation message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Conversation;

        /**
         * Decodes a Conversation message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Conversation;

        /**
         * Verifies a Conversation message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Conversation message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Conversation
         */
        public static fromObject(object: { [k: string]: any }): proto.Conversation;

        /**
         * Creates a plain object from a Conversation message. Also converts values to other types if specified.
         * @param message Conversation
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Conversation, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Conversation to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace Conversation {

        /** EndOfHistoryTransferType enum. */
        enum EndOfHistoryTransferType {
            COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY = 0,
            COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY = 1
        }
    }

    /** Properties of a DeviceListMetadata. */
    interface IDeviceListMetadata {

        /** DeviceListMetadata senderKeyHash */
        senderKeyHash?: (Uint8Array|null);

        /** DeviceListMetadata senderTimestamp */
        senderTimestamp?: (number|Long|null);

        /** DeviceListMetadata senderKeyIndexes */
        senderKeyIndexes?: (number[]|null);

        /** DeviceListMetadata recipientKeyHash */
        recipientKeyHash?: (Uint8Array|null);

        /** DeviceListMetadata recipientTimestamp */
        recipientTimestamp?: (number|Long|null);

        /** DeviceListMetadata recipientKeyIndexes */
        recipientKeyIndexes?: (number[]|null);
    }

    /** Represents a DeviceListMetadata. */
    class DeviceListMetadata implements IDeviceListMetadata {

        /**
         * Constructs a new DeviceListMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IDeviceListMetadata);

        /** DeviceListMetadata senderKeyHash. */
        public senderKeyHash: Uint8Array;

        /** DeviceListMetadata senderTimestamp. */
        public senderTimestamp: (number|Long);

        /** DeviceListMetadata senderKeyIndexes. */
        public senderKeyIndexes: number[];

        /** DeviceListMetadata recipientKeyHash. */
        public recipientKeyHash: Uint8Array;

        /** DeviceListMetadata recipientTimestamp. */
        public recipientTimestamp: (number|Long);

        /** DeviceListMetadata recipientKeyIndexes. */
        public recipientKeyIndexes: number[];

        /**
         * Creates a new DeviceListMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DeviceListMetadata instance
         */
        public static create(properties?: proto.IDeviceListMetadata): proto.DeviceListMetadata;

        /**
         * Encodes the specified DeviceListMetadata message. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @param message DeviceListMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IDeviceListMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DeviceListMetadata message, length delimited. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @param message DeviceListMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IDeviceListMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceListMetadata;

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceListMetadata;

        /**
         * Verifies a DeviceListMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DeviceListMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DeviceListMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.DeviceListMetadata;

        /**
         * Creates a plain object from a DeviceListMetadata message. Also converts values to other types if specified.
         * @param message DeviceListMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.DeviceListMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DeviceListMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DeviceProps. */
    interface IDeviceProps {

        /** DeviceProps os */
        os?: (string|null);

        /** DeviceProps version */
        version?: (proto.DeviceProps.IAppVersion|null);

        /** DeviceProps platformType */
        platformType?: (proto.DeviceProps.PlatformType|null);

        /** DeviceProps requireFullSync */
        requireFullSync?: (boolean|null);

        /** DeviceProps historySyncConfig */
        historySyncConfig?: (proto.DeviceProps.IHistorySyncConfig|null);
    }

    /** Represents a DeviceProps. */
    class DeviceProps implements IDeviceProps {

        /**
         * Constructs a new DeviceProps.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IDeviceProps);

        /** DeviceProps os. */
        public os: string;

        /** DeviceProps version. */
        public version?: (proto.DeviceProps.IAppVersion|null);

        /** DeviceProps platformType. */
        public platformType: proto.DeviceProps.PlatformType;

        /** DeviceProps requireFullSync. */
        public requireFullSync: boolean;

        /** DeviceProps historySyncConfig. */
        public historySyncConfig?: (proto.DeviceProps.IHistorySyncConfig|null);

        /**
         * Creates a new DeviceProps instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DeviceProps instance
         */
        public static create(properties?: proto.IDeviceProps): proto.DeviceProps;

        /**
         * Encodes the specified DeviceProps message. Does not implicitly {@link proto.DeviceProps.verify|verify} messages.
         * @param message DeviceProps message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IDeviceProps, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DeviceProps message, length delimited. Does not implicitly {@link proto.DeviceProps.verify|verify} messages.
         * @param message DeviceProps message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IDeviceProps, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DeviceProps message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DeviceProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceProps;

        /**
         * Decodes a DeviceProps message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DeviceProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceProps;

        /**
         * Verifies a DeviceProps message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DeviceProps message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DeviceProps
         */
        public static fromObject(object: { [k: string]: any }): proto.DeviceProps;

        /**
         * Creates a plain object from a DeviceProps message. Also converts values to other types if specified.
         * @param message DeviceProps
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.DeviceProps, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DeviceProps to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace DeviceProps {

        /** Properties of an AppVersion. */
        interface IAppVersion {

            /** AppVersion primary */
            primary?: (number|null);

            /** AppVersion secondary */
            secondary?: (number|null);

            /** AppVersion tertiary */
            tertiary?: (number|null);

            /** AppVersion quaternary */
            quaternary?: (number|null);

            /** AppVersion quinary */
            quinary?: (number|null);
        }

        /** Represents an AppVersion. */
        class AppVersion implements IAppVersion {

            /**
             * Constructs a new AppVersion.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.DeviceProps.IAppVersion);

            /** AppVersion primary. */
            public primary: number;

            /** AppVersion secondary. */
            public secondary: number;

            /** AppVersion tertiary. */
            public tertiary: number;

            /** AppVersion quaternary. */
            public quaternary: number;

            /** AppVersion quinary. */
            public quinary: number;

            /**
             * Creates a new AppVersion instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppVersion instance
             */
            public static create(properties?: proto.DeviceProps.IAppVersion): proto.DeviceProps.AppVersion;

            /**
             * Encodes the specified AppVersion message. Does not implicitly {@link proto.DeviceProps.AppVersion.verify|verify} messages.
             * @param message AppVersion message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.DeviceProps.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link proto.DeviceProps.AppVersion.verify|verify} messages.
             * @param message AppVersion message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.DeviceProps.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppVersion message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppVersion
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceProps.AppVersion;

            /**
             * Decodes an AppVersion message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppVersion
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceProps.AppVersion;

            /**
             * Verifies an AppVersion message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppVersion
             */
            public static fromObject(object: { [k: string]: any }): proto.DeviceProps.AppVersion;

            /**
             * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
             * @param message AppVersion
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.DeviceProps.AppVersion, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppVersion to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a HistorySyncConfig. */
        interface IHistorySyncConfig {

            /** HistorySyncConfig fullSyncDaysLimit */
            fullSyncDaysLimit?: (number|null);

            /** HistorySyncConfig fullSyncSizeMbLimit */
            fullSyncSizeMbLimit?: (number|null);

            /** HistorySyncConfig storageQuotaMb */
            storageQuotaMb?: (number|null);
        }

        /** Represents a HistorySyncConfig. */
        class HistorySyncConfig implements IHistorySyncConfig {

            /**
             * Constructs a new HistorySyncConfig.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.DeviceProps.IHistorySyncConfig);

            /** HistorySyncConfig fullSyncDaysLimit. */
            public fullSyncDaysLimit: number;

            /** HistorySyncConfig fullSyncSizeMbLimit. */
            public fullSyncSizeMbLimit: number;

            /** HistorySyncConfig storageQuotaMb. */
            public storageQuotaMb: number;

            /**
             * Creates a new HistorySyncConfig instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HistorySyncConfig instance
             */
            public static create(properties?: proto.DeviceProps.IHistorySyncConfig): proto.DeviceProps.HistorySyncConfig;

            /**
             * Encodes the specified HistorySyncConfig message. Does not implicitly {@link proto.DeviceProps.HistorySyncConfig.verify|verify} messages.
             * @param message HistorySyncConfig message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.DeviceProps.IHistorySyncConfig, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HistorySyncConfig message, length delimited. Does not implicitly {@link proto.DeviceProps.HistorySyncConfig.verify|verify} messages.
             * @param message HistorySyncConfig message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.DeviceProps.IHistorySyncConfig, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HistorySyncConfig message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HistorySyncConfig
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceProps.HistorySyncConfig;

            /**
             * Decodes a HistorySyncConfig message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HistorySyncConfig
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceProps.HistorySyncConfig;

            /**
             * Verifies a HistorySyncConfig message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HistorySyncConfig message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HistorySyncConfig
             */
            public static fromObject(object: { [k: string]: any }): proto.DeviceProps.HistorySyncConfig;

            /**
             * Creates a plain object from a HistorySyncConfig message. Also converts values to other types if specified.
             * @param message HistorySyncConfig
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.DeviceProps.HistorySyncConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HistorySyncConfig to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** PlatformType enum. */
        enum PlatformType {
            UNKNOWN = 0,
            CHROME = 1,
            FIREFOX = 2,
            IE = 3,
            OPERA = 4,
            SAFARI = 5,
            EDGE = 6,
            DESKTOP = 7,
            IPAD = 8,
            ANDROID_TABLET = 9,
            OHANA = 10,
            ALOHA = 11,
            CATALINA = 12,
            TCL_TV = 13
        }
    }

    /** Properties of a DisappearingMode. */
    interface IDisappearingMode {

        /** DisappearingMode initiator */
        initiator?: (proto.DisappearingMode.Initiator|null);
    }

    /** Represents a DisappearingMode. */
    class DisappearingMode implements IDisappearingMode {

        /**
         * Constructs a new DisappearingMode.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IDisappearingMode);

        /** DisappearingMode initiator. */
        public initiator: proto.DisappearingMode.Initiator;

        /**
         * Creates a new DisappearingMode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DisappearingMode instance
         */
        public static create(properties?: proto.IDisappearingMode): proto.DisappearingMode;

        /**
         * Encodes the specified DisappearingMode message. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @param message DisappearingMode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IDisappearingMode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DisappearingMode message, length delimited. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @param message DisappearingMode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IDisappearingMode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DisappearingMode;

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DisappearingMode;

        /**
         * Verifies a DisappearingMode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DisappearingMode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DisappearingMode
         */
        public static fromObject(object: { [k: string]: any }): proto.DisappearingMode;

        /**
         * Creates a plain object from a DisappearingMode message. Also converts values to other types if specified.
         * @param message DisappearingMode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.DisappearingMode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DisappearingMode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace DisappearingMode {

        /** Initiator enum. */
        enum Initiator {
            CHANGED_IN_CHAT = 0,
            INITIATED_BY_ME = 1,
            INITIATED_BY_OTHER = 2
        }
    }

    /** Properties of an EphemeralSetting. */
    interface IEphemeralSetting {

        /** EphemeralSetting duration */
        duration?: (number|null);

        /** EphemeralSetting timestamp */
        timestamp?: (number|Long|null);
    }

    /** Represents an EphemeralSetting. */
    class EphemeralSetting implements IEphemeralSetting {

        /**
         * Constructs a new EphemeralSetting.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IEphemeralSetting);

        /** EphemeralSetting duration. */
        public duration: number;

        /** EphemeralSetting timestamp. */
        public timestamp: (number|Long);

        /**
         * Creates a new EphemeralSetting instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EphemeralSetting instance
         */
        public static create(properties?: proto.IEphemeralSetting): proto.EphemeralSetting;

        /**
         * Encodes the specified EphemeralSetting message. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @param message EphemeralSetting message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IEphemeralSetting, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EphemeralSetting message, length delimited. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @param message EphemeralSetting message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IEphemeralSetting, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.EphemeralSetting;

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.EphemeralSetting;

        /**
         * Verifies an EphemeralSetting message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EphemeralSetting message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EphemeralSetting
         */
        public static fromObject(object: { [k: string]: any }): proto.EphemeralSetting;

        /**
         * Creates a plain object from an EphemeralSetting message. Also converts values to other types if specified.
         * @param message EphemeralSetting
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.EphemeralSetting, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EphemeralSetting to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an ExitCode. */
    interface IExitCode {

        /** ExitCode code */
        code?: (number|Long|null);

        /** ExitCode text */
        text?: (string|null);
    }

    /** Represents an ExitCode. */
    class ExitCode implements IExitCode {

        /**
         * Constructs a new ExitCode.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IExitCode);

        /** ExitCode code. */
        public code: (number|Long);

        /** ExitCode text. */
        public text: string;

        /**
         * Creates a new ExitCode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ExitCode instance
         */
        public static create(properties?: proto.IExitCode): proto.ExitCode;

        /**
         * Encodes the specified ExitCode message. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @param message ExitCode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IExitCode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ExitCode message, length delimited. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @param message ExitCode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IExitCode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an ExitCode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ExitCode;

        /**
         * Decodes an ExitCode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ExitCode;

        /**
         * Verifies an ExitCode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an ExitCode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ExitCode
         */
        public static fromObject(object: { [k: string]: any }): proto.ExitCode;

        /**
         * Creates a plain object from an ExitCode message. Also converts values to other types if specified.
         * @param message ExitCode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ExitCode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ExitCode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an ExternalBlobReference. */
    interface IExternalBlobReference {

        /** ExternalBlobReference mediaKey */
        mediaKey?: (Uint8Array|null);

        /** ExternalBlobReference directPath */
        directPath?: (string|null);

        /** ExternalBlobReference handle */
        handle?: (string|null);

        /** ExternalBlobReference fileSizeBytes */
        fileSizeBytes?: (number|Long|null);

        /** ExternalBlobReference fileSha256 */
        fileSha256?: (Uint8Array|null);

        /** ExternalBlobReference fileEncSha256 */
        fileEncSha256?: (Uint8Array|null);
    }

    /** Represents an ExternalBlobReference. */
    class ExternalBlobReference implements IExternalBlobReference {

        /**
         * Constructs a new ExternalBlobReference.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IExternalBlobReference);

        /** ExternalBlobReference mediaKey. */
        public mediaKey: Uint8Array;

        /** ExternalBlobReference directPath. */
        public directPath: string;

        /** ExternalBlobReference handle. */
        public handle: string;

        /** ExternalBlobReference fileSizeBytes. */
        public fileSizeBytes: (number|Long);

        /** ExternalBlobReference fileSha256. */
        public fileSha256: Uint8Array;

        /** ExternalBlobReference fileEncSha256. */
        public fileEncSha256: Uint8Array;

        /**
         * Creates a new ExternalBlobReference instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ExternalBlobReference instance
         */
        public static create(properties?: proto.IExternalBlobReference): proto.ExternalBlobReference;

        /**
         * Encodes the specified ExternalBlobReference message. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @param message ExternalBlobReference message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IExternalBlobReference, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ExternalBlobReference message, length delimited. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @param message ExternalBlobReference message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IExternalBlobReference, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ExternalBlobReference;

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ExternalBlobReference;

        /**
         * Verifies an ExternalBlobReference message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an ExternalBlobReference message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ExternalBlobReference
         */
        public static fromObject(object: { [k: string]: any }): proto.ExternalBlobReference;

        /**
         * Creates a plain object from an ExternalBlobReference message. Also converts values to other types if specified.
         * @param message ExternalBlobReference
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ExternalBlobReference, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ExternalBlobReference to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GlobalSettings. */
    interface IGlobalSettings {

        /** GlobalSettings lightThemeWallpaper */
        lightThemeWallpaper?: (proto.IWallpaperSettings|null);

        /** GlobalSettings mediaVisibility */
        mediaVisibility?: (proto.MediaVisibility|null);

        /** GlobalSettings darkThemeWallpaper */
        darkThemeWallpaper?: (proto.IWallpaperSettings|null);

        /** GlobalSettings autoDownloadWiFi */
        autoDownloadWiFi?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings autoDownloadCellular */
        autoDownloadCellular?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings autoDownloadRoaming */
        autoDownloadRoaming?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings showIndividualNotificationsPreview */
        showIndividualNotificationsPreview?: (boolean|null);

        /** GlobalSettings showGroupNotificationsPreview */
        showGroupNotificationsPreview?: (boolean|null);

        /** GlobalSettings disappearingModeDuration */
        disappearingModeDuration?: (number|null);

        /** GlobalSettings disappearingModeTimestamp */
        disappearingModeTimestamp?: (number|Long|null);

        /** GlobalSettings avatarUserSettings */
        avatarUserSettings?: (proto.IAvatarUserSettings|null);
    }

    /** Represents a GlobalSettings. */
    class GlobalSettings implements IGlobalSettings {

        /**
         * Constructs a new GlobalSettings.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IGlobalSettings);

        /** GlobalSettings lightThemeWallpaper. */
        public lightThemeWallpaper?: (proto.IWallpaperSettings|null);

        /** GlobalSettings mediaVisibility. */
        public mediaVisibility: proto.MediaVisibility;

        /** GlobalSettings darkThemeWallpaper. */
        public darkThemeWallpaper?: (proto.IWallpaperSettings|null);

        /** GlobalSettings autoDownloadWiFi. */
        public autoDownloadWiFi?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings autoDownloadCellular. */
        public autoDownloadCellular?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings autoDownloadRoaming. */
        public autoDownloadRoaming?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings showIndividualNotificationsPreview. */
        public showIndividualNotificationsPreview: boolean;

        /** GlobalSettings showGroupNotificationsPreview. */
        public showGroupNotificationsPreview: boolean;

        /** GlobalSettings disappearingModeDuration. */
        public disappearingModeDuration: number;

        /** GlobalSettings disappearingModeTimestamp. */
        public disappearingModeTimestamp: (number|Long);

        /** GlobalSettings avatarUserSettings. */
        public avatarUserSettings?: (proto.IAvatarUserSettings|null);

        /**
         * Creates a new GlobalSettings instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GlobalSettings instance
         */
        public static create(properties?: proto.IGlobalSettings): proto.GlobalSettings;

        /**
         * Encodes the specified GlobalSettings message. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @param message GlobalSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IGlobalSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GlobalSettings message, length delimited. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @param message GlobalSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IGlobalSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GlobalSettings message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GlobalSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.GlobalSettings;

        /**
         * Decodes a GlobalSettings message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GlobalSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.GlobalSettings;

        /**
         * Verifies a GlobalSettings message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GlobalSettings message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GlobalSettings
         */
        public static fromObject(object: { [k: string]: any }): proto.GlobalSettings;

        /**
         * Creates a plain object from a GlobalSettings message. Also converts values to other types if specified.
         * @param message GlobalSettings
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.GlobalSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GlobalSettings to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GroupParticipant. */
    interface IGroupParticipant {

        /** GroupParticipant userJid */
        userJid: string;

        /** GroupParticipant rank */
        rank?: (proto.GroupParticipant.Rank|null);
    }

    /** Represents a GroupParticipant. */
    class GroupParticipant implements IGroupParticipant {

        /**
         * Constructs a new GroupParticipant.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IGroupParticipant);

        /** GroupParticipant userJid. */
        public userJid: string;

        /** GroupParticipant rank. */
        public rank: proto.GroupParticipant.Rank;

        /**
         * Creates a new GroupParticipant instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GroupParticipant instance
         */
        public static create(properties?: proto.IGroupParticipant): proto.GroupParticipant;

        /**
         * Encodes the specified GroupParticipant message. Does not implicitly {@link proto.GroupParticipant.verify|verify} messages.
         * @param message GroupParticipant message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IGroupParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GroupParticipant message, length delimited. Does not implicitly {@link proto.GroupParticipant.verify|verify} messages.
         * @param message GroupParticipant message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IGroupParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GroupParticipant message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GroupParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.GroupParticipant;

        /**
         * Decodes a GroupParticipant message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GroupParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.GroupParticipant;

        /**
         * Verifies a GroupParticipant message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GroupParticipant message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GroupParticipant
         */
        public static fromObject(object: { [k: string]: any }): proto.GroupParticipant;

        /**
         * Creates a plain object from a GroupParticipant message. Also converts values to other types if specified.
         * @param message GroupParticipant
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.GroupParticipant, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GroupParticipant to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace GroupParticipant {

        /** Rank enum. */
        enum Rank {
            REGULAR = 0,
            ADMIN = 1,
            SUPERADMIN = 2
        }
    }

    /** Properties of a HandshakeMessage. */
    interface IHandshakeMessage {

        /** HandshakeMessage clientHello */
        clientHello?: (proto.HandshakeMessage.IClientHello|null);

        /** HandshakeMessage serverHello */
        serverHello?: (proto.HandshakeMessage.IServerHello|null);

        /** HandshakeMessage clientFinish */
        clientFinish?: (proto.HandshakeMessage.IClientFinish|null);
    }

    /** Represents a HandshakeMessage. */
    class HandshakeMessage implements IHandshakeMessage {

        /**
         * Constructs a new HandshakeMessage.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IHandshakeMessage);

        /** HandshakeMessage clientHello. */
        public clientHello?: (proto.HandshakeMessage.IClientHello|null);

        /** HandshakeMessage serverHello. */
        public serverHello?: (proto.HandshakeMessage.IServerHello|null);

        /** HandshakeMessage clientFinish. */
        public clientFinish?: (proto.HandshakeMessage.IClientFinish|null);

        /**
         * Creates a new HandshakeMessage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HandshakeMessage instance
         */
        public static create(properties?: proto.IHandshakeMessage): proto.HandshakeMessage;

        /**
         * Encodes the specified HandshakeMessage message. Does not implicitly {@link proto.HandshakeMessage.verify|verify} messages.
         * @param message HandshakeMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IHandshakeMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HandshakeMessage message, length delimited. Does not implicitly {@link proto.HandshakeMessage.verify|verify} messages.
         * @param message HandshakeMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IHandshakeMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a HandshakeMessage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HandshakeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HandshakeMessage;

        /**
         * Decodes a HandshakeMessage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HandshakeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HandshakeMessage;

        /**
         * Verifies a HandshakeMessage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HandshakeMessage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HandshakeMessage
         */
        public static fromObject(object: { [k: string]: any }): proto.HandshakeMessage;

        /**
         * Creates a plain object from a HandshakeMessage message. Also converts values to other types if specified.
         * @param message HandshakeMessage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.HandshakeMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HandshakeMessage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace HandshakeMessage {

        /** Properties of a ClientFinish. */
        interface IClientFinish {

            /** ClientFinish static */
            "static"?: (Uint8Array|null);

            /** ClientFinish payload */
            payload?: (Uint8Array|null);
        }

        /** Represents a ClientFinish. */
        class ClientFinish implements IClientFinish {

            /**
             * Constructs a new ClientFinish.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HandshakeMessage.IClientFinish);

            /** ClientFinish static. */
            public static: Uint8Array;

            /** ClientFinish payload. */
            public payload: Uint8Array;

            /**
             * Creates a new ClientFinish instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ClientFinish instance
             */
            public static create(properties?: proto.HandshakeMessage.IClientFinish): proto.HandshakeMessage.ClientFinish;

            /**
             * Encodes the specified ClientFinish message. Does not implicitly {@link proto.HandshakeMessage.ClientFinish.verify|verify} messages.
             * @param message ClientFinish message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HandshakeMessage.IClientFinish, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ClientFinish message, length delimited. Does not implicitly {@link proto.HandshakeMessage.ClientFinish.verify|verify} messages.
             * @param message ClientFinish message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HandshakeMessage.IClientFinish, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ClientFinish message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ClientFinish
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HandshakeMessage.ClientFinish;

            /**
             * Decodes a ClientFinish message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ClientFinish
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HandshakeMessage.ClientFinish;

            /**
             * Verifies a ClientFinish message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ClientFinish message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ClientFinish
             */
            public static fromObject(object: { [k: string]: any }): proto.HandshakeMessage.ClientFinish;

            /**
             * Creates a plain object from a ClientFinish message. Also converts values to other types if specified.
             * @param message ClientFinish
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HandshakeMessage.ClientFinish, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ClientFinish to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ClientHello. */
        interface IClientHello {

            /** ClientHello ephemeral */
            ephemeral?: (Uint8Array|null);

            /** ClientHello static */
            "static"?: (Uint8Array|null);

            /** ClientHello payload */
            payload?: (Uint8Array|null);
        }

        /** Represents a ClientHello. */
        class ClientHello implements IClientHello {

            /**
             * Constructs a new ClientHello.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HandshakeMessage.IClientHello);

            /** ClientHello ephemeral. */
            public ephemeral: Uint8Array;

            /** ClientHello static. */
            public static: Uint8Array;

            /** ClientHello payload. */
            public payload: Uint8Array;

            /**
             * Creates a new ClientHello instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ClientHello instance
             */
            public static create(properties?: proto.HandshakeMessage.IClientHello): proto.HandshakeMessage.ClientHello;

            /**
             * Encodes the specified ClientHello message. Does not implicitly {@link proto.HandshakeMessage.ClientHello.verify|verify} messages.
             * @param message ClientHello message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HandshakeMessage.IClientHello, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ClientHello message, length delimited. Does not implicitly {@link proto.HandshakeMessage.ClientHello.verify|verify} messages.
             * @param message ClientHello message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HandshakeMessage.IClientHello, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ClientHello message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ClientHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HandshakeMessage.ClientHello;

            /**
             * Decodes a ClientHello message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ClientHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HandshakeMessage.ClientHello;

            /**
             * Verifies a ClientHello message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ClientHello message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ClientHello
             */
            public static fromObject(object: { [k: string]: any }): proto.HandshakeMessage.ClientHello;

            /**
             * Creates a plain object from a ClientHello message. Also converts values to other types if specified.
             * @param message ClientHello
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HandshakeMessage.ClientHello, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ClientHello to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ServerHello. */
        interface IServerHello {

            /** ServerHello ephemeral */
            ephemeral?: (Uint8Array|null);

            /** ServerHello static */
            "static"?: (Uint8Array|null);

            /** ServerHello payload */
            payload?: (Uint8Array|null);
        }

        /** Represents a ServerHello. */
        class ServerHello implements IServerHello {

            /**
             * Constructs a new ServerHello.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HandshakeMessage.IServerHello);

            /** ServerHello ephemeral. */
            public ephemeral: Uint8Array;

            /** ServerHello static. */
            public static: Uint8Array;

            /** ServerHello payload. */
            public payload: Uint8Array;

            /**
             * Creates a new ServerHello instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ServerHello instance
             */
            public static create(properties?: proto.HandshakeMessage.IServerHello): proto.HandshakeMessage.ServerHello;

            /**
             * Encodes the specified ServerHello message. Does not implicitly {@link proto.HandshakeMessage.ServerHello.verify|verify} messages.
             * @param message ServerHello message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HandshakeMessage.IServerHello, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ServerHello message, length delimited. Does not implicitly {@link proto.HandshakeMessage.ServerHello.verify|verify} messages.
             * @param message ServerHello message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HandshakeMessage.IServerHello, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ServerHello message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ServerHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HandshakeMessage.ServerHello;

            /**
             * Decodes a ServerHello message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ServerHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HandshakeMessage.ServerHello;

            /**
             * Verifies a ServerHello message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ServerHello message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ServerHello
             */
            public static fromObject(object: { [k: string]: any }): proto.HandshakeMessage.ServerHello;

            /**
             * Creates a plain object from a ServerHello message. Also converts values to other types if specified.
             * @param message ServerHello
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HandshakeMessage.ServerHello, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ServerHello to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }
    }

    /** Properties of a HistorySync. */
    interface IHistorySync {

        /** HistorySync syncType */
        syncType: proto.HistorySync.HistorySyncType;

        /** HistorySync conversations */
        conversations?: (proto.IConversation[]|null);

        /** HistorySync statusV3Messages */
        statusV3Messages?: (proto.IWebMessageInfo[]|null);

        /** HistorySync chunkOrder */
        chunkOrder?: (number|null);

        /** HistorySync progress */
        progress?: (number|null);

        /** HistorySync pushnames */
        pushnames?: (proto.IPushname[]|null);

        /** HistorySync globalSettings */
        globalSettings?: (proto.IGlobalSettings|null);

        /** HistorySync threadIdUserSecret */
        threadIdUserSecret?: (Uint8Array|null);

        /** HistorySync threadDsTimeframeOffset */
        threadDsTimeframeOffset?: (number|null);

        /** HistorySync recentStickers */
        recentStickers?: (proto.IStickerMetadata[]|null);

        /** HistorySync pastParticipants */
        pastParticipants?: (proto.IPastParticipants[]|null);
    }

    /** Represents a HistorySync. */
    class HistorySync implements IHistorySync {

        /**
         * Constructs a new HistorySync.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IHistorySync);

        /** HistorySync syncType. */
        public syncType: proto.HistorySync.HistorySyncType;

        /** HistorySync conversations. */
        public conversations: proto.IConversation[];

        /** HistorySync statusV3Messages. */
        public statusV3Messages: proto.IWebMessageInfo[];

        /** HistorySync chunkOrder. */
        public chunkOrder: number;

        /** HistorySync progress. */
        public progress: number;

        /** HistorySync pushnames. */
        public pushnames: proto.IPushname[];

        /** HistorySync globalSettings. */
        public globalSettings?: (proto.IGlobalSettings|null);

        /** HistorySync threadIdUserSecret. */
        public threadIdUserSecret: Uint8Array;

        /** HistorySync threadDsTimeframeOffset. */
        public threadDsTimeframeOffset: number;

        /** HistorySync recentStickers. */
        public recentStickers: proto.IStickerMetadata[];

        /** HistorySync pastParticipants. */
        public pastParticipants: proto.IPastParticipants[];

        /**
         * Creates a new HistorySync instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HistorySync instance
         */
        public static create(properties?: proto.IHistorySync): proto.HistorySync;

        /**
         * Encodes the specified HistorySync message. Does not implicitly {@link proto.HistorySync.verify|verify} messages.
         * @param message HistorySync message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IHistorySync, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HistorySync message, length delimited. Does not implicitly {@link proto.HistorySync.verify|verify} messages.
         * @param message HistorySync message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IHistorySync, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a HistorySync message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HistorySync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HistorySync;

        /**
         * Decodes a HistorySync message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HistorySync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HistorySync;

        /**
         * Verifies a HistorySync message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HistorySync message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HistorySync
         */
        public static fromObject(object: { [k: string]: any }): proto.HistorySync;

        /**
         * Creates a plain object from a HistorySync message. Also converts values to other types if specified.
         * @param message HistorySync
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.HistorySync, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HistorySync to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace HistorySync {

        /** HistorySyncType enum. */
        enum HistorySyncType {
            INITIAL_BOOTSTRAP = 0,
            INITIAL_STATUS_V3 = 1,
            FULL = 2,
            RECENT = 3,
            PUSH_NAME = 4,
            NON_BLOCKING_DATA = 5
        }
    }

    /** Properties of a HistorySyncMsg. */
    interface IHistorySyncMsg {

        /** HistorySyncMsg message */
        message?: (proto.IWebMessageInfo|null);

        /** HistorySyncMsg msgOrderId */
        msgOrderId?: (number|Long|null);
    }

    /** Represents a HistorySyncMsg. */
    class HistorySyncMsg implements IHistorySyncMsg {

        /**
         * Constructs a new HistorySyncMsg.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IHistorySyncMsg);

        /** HistorySyncMsg message. */
        public message?: (proto.IWebMessageInfo|null);

        /** HistorySyncMsg msgOrderId. */
        public msgOrderId: (number|Long);

        /**
         * Creates a new HistorySyncMsg instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HistorySyncMsg instance
         */
        public static create(properties?: proto.IHistorySyncMsg): proto.HistorySyncMsg;

        /**
         * Encodes the specified HistorySyncMsg message. Does not implicitly {@link proto.HistorySyncMsg.verify|verify} messages.
         * @param message HistorySyncMsg message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IHistorySyncMsg, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HistorySyncMsg message, length delimited. Does not implicitly {@link proto.HistorySyncMsg.verify|verify} messages.
         * @param message HistorySyncMsg message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IHistorySyncMsg, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a HistorySyncMsg message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HistorySyncMsg
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HistorySyncMsg;

        /**
         * Decodes a HistorySyncMsg message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HistorySyncMsg
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HistorySyncMsg;

        /**
         * Verifies a HistorySyncMsg message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HistorySyncMsg message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HistorySyncMsg
         */
        public static fromObject(object: { [k: string]: any }): proto.HistorySyncMsg;

        /**
         * Creates a plain object from a HistorySyncMsg message. Also converts values to other types if specified.
         * @param message HistorySyncMsg
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.HistorySyncMsg, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HistorySyncMsg to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a HydratedTemplateButton. */
    interface IHydratedTemplateButton {

        /** HydratedTemplateButton index */
        index?: (number|null);

        /** HydratedTemplateButton quickReplyButton */
        quickReplyButton?: (proto.HydratedTemplateButton.IHydratedQuickReplyButton|null);

        /** HydratedTemplateButton urlButton */
        urlButton?: (proto.HydratedTemplateButton.IHydratedURLButton|null);

        /** HydratedTemplateButton callButton */
        callButton?: (proto.HydratedTemplateButton.IHydratedCallButton|null);
    }

    /** Represents a HydratedTemplateButton. */
    class HydratedTemplateButton implements IHydratedTemplateButton {

        /**
         * Constructs a new HydratedTemplateButton.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IHydratedTemplateButton);

        /** HydratedTemplateButton index. */
        public index: number;

        /** HydratedTemplateButton quickReplyButton. */
        public quickReplyButton?: (proto.HydratedTemplateButton.IHydratedQuickReplyButton|null);

        /** HydratedTemplateButton urlButton. */
        public urlButton?: (proto.HydratedTemplateButton.IHydratedURLButton|null);

        /** HydratedTemplateButton callButton. */
        public callButton?: (proto.HydratedTemplateButton.IHydratedCallButton|null);

        /** HydratedTemplateButton hydratedButton. */
        public hydratedButton?: ("quickReplyButton"|"urlButton"|"callButton");

        /**
         * Creates a new HydratedTemplateButton instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HydratedTemplateButton instance
         */
        public static create(properties?: proto.IHydratedTemplateButton): proto.HydratedTemplateButton;

        /**
         * Encodes the specified HydratedTemplateButton message. Does not implicitly {@link proto.HydratedTemplateButton.verify|verify} messages.
         * @param message HydratedTemplateButton message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IHydratedTemplateButton, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HydratedTemplateButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.verify|verify} messages.
         * @param message HydratedTemplateButton message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IHydratedTemplateButton, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a HydratedTemplateButton message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HydratedTemplateButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HydratedTemplateButton;

        /**
         * Decodes a HydratedTemplateButton message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HydratedTemplateButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HydratedTemplateButton;

        /**
         * Verifies a HydratedTemplateButton message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HydratedTemplateButton message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HydratedTemplateButton
         */
        public static fromObject(object: { [k: string]: any }): proto.HydratedTemplateButton;

        /**
         * Creates a plain object from a HydratedTemplateButton message. Also converts values to other types if specified.
         * @param message HydratedTemplateButton
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.HydratedTemplateButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HydratedTemplateButton to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace HydratedTemplateButton {

        /** Properties of a HydratedCallButton. */
        interface IHydratedCallButton {

            /** HydratedCallButton displayText */
            displayText?: (string|null);

            /** HydratedCallButton phoneNumber */
            phoneNumber?: (string|null);
        }

        /** Represents a HydratedCallButton. */
        class HydratedCallButton implements IHydratedCallButton {

            /**
             * Constructs a new HydratedCallButton.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HydratedTemplateButton.IHydratedCallButton);

            /** HydratedCallButton displayText. */
            public displayText: string;

            /** HydratedCallButton phoneNumber. */
            public phoneNumber: string;

            /**
             * Creates a new HydratedCallButton instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HydratedCallButton instance
             */
            public static create(properties?: proto.HydratedTemplateButton.IHydratedCallButton): proto.HydratedTemplateButton.HydratedCallButton;

            /**
             * Encodes the specified HydratedCallButton message. Does not implicitly {@link proto.HydratedTemplateButton.HydratedCallButton.verify|verify} messages.
             * @param message HydratedCallButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HydratedTemplateButton.IHydratedCallButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HydratedCallButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.HydratedCallButton.verify|verify} messages.
             * @param message HydratedCallButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HydratedTemplateButton.IHydratedCallButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HydratedCallButton message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HydratedCallButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HydratedTemplateButton.HydratedCallButton;

            /**
             * Decodes a HydratedCallButton message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HydratedCallButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HydratedTemplateButton.HydratedCallButton;

            /**
             * Verifies a HydratedCallButton message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HydratedCallButton message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HydratedCallButton
             */
            public static fromObject(object: { [k: string]: any }): proto.HydratedTemplateButton.HydratedCallButton;

            /**
             * Creates a plain object from a HydratedCallButton message. Also converts values to other types if specified.
             * @param message HydratedCallButton
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HydratedTemplateButton.HydratedCallButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HydratedCallButton to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a HydratedQuickReplyButton. */
        interface IHydratedQuickReplyButton {

            /** HydratedQuickReplyButton displayText */
            displayText?: (string|null);

            /** HydratedQuickReplyButton id */
            id?: (string|null);
        }

        /** Represents a HydratedQuickReplyButton. */
        class HydratedQuickReplyButton implements IHydratedQuickReplyButton {

            /**
             * Constructs a new HydratedQuickReplyButton.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HydratedTemplateButton.IHydratedQuickReplyButton);

            /** HydratedQuickReplyButton displayText. */
            public displayText: string;

            /** HydratedQuickReplyButton id. */
            public id: string;

            /**
             * Creates a new HydratedQuickReplyButton instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HydratedQuickReplyButton instance
             */
            public static create(properties?: proto.HydratedTemplateButton.IHydratedQuickReplyButton): proto.HydratedTemplateButton.HydratedQuickReplyButton;

            /**
             * Encodes the specified HydratedQuickReplyButton message. Does not implicitly {@link proto.HydratedTemplateButton.HydratedQuickReplyButton.verify|verify} messages.
             * @param message HydratedQuickReplyButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HydratedTemplateButton.IHydratedQuickReplyButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HydratedQuickReplyButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.HydratedQuickReplyButton.verify|verify} messages.
             * @param message HydratedQuickReplyButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HydratedTemplateButton.IHydratedQuickReplyButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HydratedQuickReplyButton message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HydratedQuickReplyButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HydratedTemplateButton.HydratedQuickReplyButton;

            /**
             * Decodes a HydratedQuickReplyButton message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HydratedQuickReplyButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HydratedTemplateButton.HydratedQuickReplyButton;

            /**
             * Verifies a HydratedQuickReplyButton message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HydratedQuickReplyButton message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HydratedQuickReplyButton
             */
            public static fromObject(object: { [k: string]: any }): proto.HydratedTemplateButton.HydratedQuickReplyButton;

            /**
             * Creates a plain object from a HydratedQuickReplyButton message. Also converts values to other types if specified.
             * @param message HydratedQuickReplyButton
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HydratedTemplateButton.HydratedQuickReplyButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HydratedQuickReplyButton to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a HydratedURLButton. */
        interface IHydratedURLButton {

            /** HydratedURLButton displayText */
            displayText?: (string|null);

            /** HydratedURLButton url */
            url?: (string|null);
        }

        /** Represents a HydratedURLButton. */
        class HydratedURLButton implements IHydratedURLButton {

            /**
             * Constructs a new HydratedURLButton.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HydratedTemplateButton.IHydratedURLButton);

            /** HydratedURLButton displayText. */
            public displayText: string;

            /** HydratedURLButton url. */
            public url: string;

            /**
             * Creates a new HydratedURLButton instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HydratedURLButton instance
             */
            public static create(properties?: proto.HydratedTemplateButton.IHydratedURLButton): proto.HydratedTemplateButton.HydratedURLButton;

            /**
             * Encodes the specified HydratedURLButton message. Does not implicitly {@link proto.HydratedTemplateButton.HydratedURLButton.verify|verify} messages.
             * @param message HydratedURLButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HydratedTemplateButton.IHydratedURLButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HydratedURLButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.HydratedURLButton.verify|verify} messages.
             * @param message HydratedURLButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HydratedTemplateButton.IHydratedURLButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HydratedURLButton message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HydratedURLButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HydratedTemplateButton.HydratedURLButton;

            /**
             * Decodes a HydratedURLButton message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HydratedURLButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HydratedTemplateButton.HydratedURLButton;

            /**
             * Verifies a HydratedURLButton message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HydratedURLButton message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HydratedURLButton
             */
            public static fromObject(object: { [k: string]: any }): proto.HydratedTemplateButton.HydratedURLButton;

            /**
             * Creates a plain object from a HydratedURLButton message. Also converts values to other types if specified.
             * @param message HydratedURLButton
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HydratedTemplateButton.HydratedURLButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HydratedURLButton to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }
    }

    /** Properties of an IdentityKeyPairStructure. */
    interface IIdentityKeyPairStructure {

        /** IdentityKeyPairStructure publicKey */
        publicKey?: (Uint8Array|null);

        /** IdentityKeyPairStructure privateKey */
        privateKey?: (Uint8Array|null);
    }

    /** Represents an IdentityKeyPairStructure. */
    class IdentityKeyPairStructure implements IIdentityKeyPairStructure {

        /**
         * Constructs a new IdentityKeyPairStructure.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IIdentityKeyPairStructure);

        /** IdentityKeyPairStructure publicKey. */
        public publicKey: Uint8Array;

        /** IdentityKeyPairStructure privateKey. */
        public privateKey: Uint8Array;

        /**
         * Creates a new IdentityKeyPairStructure instance using the specified properties.
         * @param [properties] Properties to set
         * @returns IdentityKeyPairStructure instance
         */
        public static create(properties?: proto.IIdentityKeyPairStructure): proto.IdentityKeyPairStructure;

        /**
         * Encodes the specified IdentityKeyPairStructure message. Does not implicitly {@link proto.IdentityKeyPairStructure.verify|verify} messages.
         * @param message IdentityKeyPairStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IIdentityKeyPairStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified IdentityKeyPairStructure message, length delimited. Does not implicitly {@link proto.IdentityKeyPairStructure.verify|verify} messages.
         * @param message IdentityKeyPairStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IIdentityKeyPairStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an IdentityKeyPairStructure message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns IdentityKeyPairStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.IdentityKeyPairStructure;

        /**
         * Decodes an IdentityKeyPairStructure message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns IdentityKeyPairStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.IdentityKeyPairStructure;

        /**
         * Verifies an IdentityKeyPairStructure message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an IdentityKeyPairStructure message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns IdentityKeyPairStructure
         */
        public static fromObject(object: { [k: string]: any }): proto.IdentityKeyPairStructure;

        /**
         * Creates a plain object from an IdentityKeyPairStructure message. Also converts values to other types if specified.
         * @param message IdentityKeyPairStructure
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.IdentityKeyPairStructure, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this IdentityKeyPairStructure to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an InteractiveAnnotation. */
    interface IInteractiveAnnotation {

        /** InteractiveAnnotation polygonVertices */
        polygonVertices?: (proto.IPoint[]|null);

        /** InteractiveAnnotation location */
        location?: (proto.ILocation|null);
    }

    /** Represents an InteractiveAnnotation. */
    class InteractiveAnnotation implements IInteractiveAnnotation {

        /**
         * Constructs a new InteractiveAnnotation.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IInteractiveAnnotation);

        /** InteractiveAnnotation polygonVertices. */
        public polygonVertices: proto.IPoint[];

        /** InteractiveAnnotation location. */
        public location?: (proto.ILocation|null);

        /** InteractiveAnnotation action. */
        public action?: "location";

        /**
         * Creates a new InteractiveAnnotation instance using the specified properties.
         * @param [properties] Properties to set
         * @returns InteractiveAnnotation instance
         */
        public static create(properties?: proto.IInteractiveAnnotation): proto.InteractiveAnnotation;

        /**
         * Encodes the specified InteractiveAnnotation message. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @param message InteractiveAnnotation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IInteractiveAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified InteractiveAnnotation message, length delimited. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @param message InteractiveAnnotation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IInteractiveAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.InteractiveAnnotation;

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.InteractiveAnnotation;

        /**
         * Verifies an InteractiveAnnotation message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an InteractiveAnnotation message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns InteractiveAnnotation
         */
        public static fromObject(object: { [k: string]: any }): proto.InteractiveAnnotation;

        /**
         * Creates a plain object from an InteractiveAnnotation message. Also converts values to other types if specified.
         * @param message InteractiveAnnotation
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.InteractiveAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this InteractiveAnnotation to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a KeepInChat. */
    interface IKeepInChat {

        /** KeepInChat keepType */
        keepType?: (proto.KeepType|null);

        /** KeepInChat serverTimestamp */
        serverTimestamp?: (number|Long|null);

        /** KeepInChat key */
        key?: (proto.IMessageKey|null);

        /** KeepInChat deviceJid */
        deviceJid?: (string|null);

        /** KeepInChat clientTimestampMs */
        clientTimestampMs?: (number|Long|null);

        /** KeepInChat serverTimestampMs */
        serverTimestampMs?: (number|Long|null);
    }

    /** Represents a KeepInChat. */
    class KeepInChat implements IKeepInChat {

        /**
         * Constructs a new KeepInChat.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IKeepInChat);

        /** KeepInChat keepType. */
        public keepType: proto.KeepType;

        /** KeepInChat serverTimestamp. */
        public serverTimestamp: (number|Long);

        /** KeepInChat key. */
        public key?: (proto.IMessageKey|null);

        /** KeepInChat deviceJid. */
        public deviceJid: string;

        /** KeepInChat clientTimestampMs. */
        public clientTimestampMs: (number|Long);

        /** KeepInChat serverTimestampMs. */
        public serverTimestampMs: (number|Long);

        /**
         * Creates a new KeepInChat instance using the specified properties.
         * @param [properties] Properties to set
         * @returns KeepInChat instance
         */
        public static create(properties?: proto.IKeepInChat): proto.KeepInChat;

        /**
         * Encodes the specified KeepInChat message. Does not implicitly {@link proto.KeepInChat.verify|verify} messages.
         * @param message KeepInChat message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IKeepInChat, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified KeepInChat message, length delimited. Does not implicitly {@link proto.KeepInChat.verify|verify} messages.
         * @param message KeepInChat message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IKeepInChat, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a KeepInChat message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns KeepInChat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.KeepInChat;

        /**
         * Decodes a KeepInChat message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns KeepInChat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.KeepInChat;

        /**
         * Verifies a KeepInChat message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a KeepInChat message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns KeepInChat
         */
        public static fromObject(object: { [k: string]: any }): proto.KeepInChat;

        /**
         * Creates a plain object from a KeepInChat message. Also converts values to other types if specified.
         * @param message KeepInChat
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.KeepInChat, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this KeepInChat to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** KeepType enum. */
    enum KeepType {
        UNKNOWN = 0,
        KEEP_FOR_ALL = 1,
        UNDO_KEEP_FOR_ALL = 2
    }

    /** Properties of a KeyId. */
    interface IKeyId {

        /** KeyId id */
        id?: (Uint8Array|null);
    }

    /** Represents a KeyId. */
    class KeyId implements IKeyId {

        /**
         * Constructs a new KeyId.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IKeyId);

        /** KeyId id. */
        public id: Uint8Array;

        /**
         * Creates a new KeyId instance using the specified properties.
         * @param [properties] Properties to set
         * @returns KeyId instance
         */
        public static create(properties?: proto.IKeyId): proto.KeyId;

        /**
         * Encodes the specified KeyId message. Does not implicitly {@link proto.KeyId.verify|verify} messages.
         * @param message KeyId message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IKeyId, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified KeyId message, length delimited. Does not implicitly {@link proto.KeyId.verify|verify} messages.
         * @param message KeyId message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IKeyId, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a KeyId message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns KeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.KeyId;

        /**
         * Decodes a KeyId message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns KeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.KeyId;

        /**
         * Verifies a KeyId message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a KeyId message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns KeyId
         */
        public static fromObject(object: { [k: string]: any }): proto.KeyId;

        /**
         * Creates a plain object from a KeyId message. Also converts values to other types if specified.
         * @param message KeyId
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.KeyId, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this KeyId to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a LocalizedName. */
    interface ILocalizedName {

        /** LocalizedName lg */
        lg?: (string|null);

        /** LocalizedName lc */
        lc?: (string|null);

        /** LocalizedName verifiedName */
        verifiedName?: (string|null);
    }

    /** Represents a LocalizedName. */
    class LocalizedName implements ILocalizedName {

        /**
         * Constructs a new LocalizedName.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ILocalizedName);

        /** LocalizedName lg. */
        public lg: string;

        /** LocalizedName lc. */
        public lc: string;

        /** LocalizedName verifiedName. */
        public verifiedName: string;

        /**
         * Creates a new LocalizedName instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LocalizedName instance
         */
        public static create(properties?: proto.ILocalizedName): proto.LocalizedName;

        /**
         * Encodes the specified LocalizedName message. Does not implicitly {@link proto.LocalizedName.verify|verify} messages.
         * @param message LocalizedName message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ILocalizedName, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LocalizedName message, length delimited. Does not implicitly {@link proto.LocalizedName.verify|verify} messages.
         * @param message LocalizedName message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ILocalizedName, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LocalizedName message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LocalizedName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.LocalizedName;

        /**
         * Decodes a LocalizedName message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LocalizedName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.LocalizedName;

        /**
         * Verifies a LocalizedName message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LocalizedName message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LocalizedName
         */
        public static fromObject(object: { [k: string]: any }): proto.LocalizedName;

        /**
         * Creates a plain object from a LocalizedName message. Also converts values to other types if specified.
         * @param message LocalizedName
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.LocalizedName, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LocalizedName to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Location. */
    interface ILocation {

        /** Location degreesLatitude */
        degreesLatitude?: (number|null);

        /** Location degreesLongitude */
        degreesLongitude?: (number|null);

        /** Location name */
        name?: (string|null);
    }

    /** Represents a Location. */
    class Location implements ILocation {

        /**
         * Constructs a new Location.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ILocation);

        /** Location degreesLatitude. */
        public degreesLatitude: number;

        /** Location degreesLongitude. */
        public degreesLongitude: number;

        /** Location name. */
        public name: string;

        /**
         * Creates a new Location instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Location instance
         */
        public static create(properties?: proto.ILocation): proto.Location;

        /**
         * Encodes the specified Location message. Does not implicitly {@link proto.Location.verify|verify} messages.
         * @param message Location message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ILocation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Location message, length delimited. Does not implicitly {@link proto.Location.verify|verify} messages.
         * @param message Location message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ILocation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Location message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Location
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Location;

        /**
         * Decodes a Location message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Location
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Location;

        /**
         * Verifies a Location message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Location message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Location
         */
        public static fromObject(object: { [k: string]: any }): proto.Location;

        /**
         * Creates a plain object from a Location message. Also converts values to other types if specified.
         * @param message Location
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Location, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Location to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MediaData. */
    interface IMediaData {

        /** MediaData localPath */
        localPath?: (string|null);
    }

    /** Represents a MediaData. */
    class MediaData implements IMediaData {

        /**
         * Constructs a new MediaData.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMediaData);

        /** MediaData localPath. */
        public localPath: string;

        /**
         * Creates a new MediaData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MediaData instance
         */
        public static create(properties?: proto.IMediaData): proto.MediaData;

        /**
         * Encodes the specified MediaData message. Does not implicitly {@link proto.MediaData.verify|verify} messages.
         * @param message MediaData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMediaData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MediaData message, length delimited. Does not implicitly {@link proto.MediaData.verify|verify} messages.
         * @param message MediaData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMediaData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MediaData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MediaData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MediaData;

        /**
         * Decodes a MediaData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MediaData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MediaData;

        /**
         * Verifies a MediaData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MediaData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MediaData
         */
        public static fromObject(object: { [k: string]: any }): proto.MediaData;

        /**
         * Creates a plain object from a MediaData message. Also converts values to other types if specified.
         * @param message MediaData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MediaData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MediaData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MediaRetryNotification. */
    interface IMediaRetryNotification {

        /** MediaRetryNotification stanzaId */
        stanzaId?: (string|null);

        /** MediaRetryNotification directPath */
        directPath?: (string|null);

        /** MediaRetryNotification result */
        result?: (proto.MediaRetryNotification.ResultType|null);
    }

    /** Represents a MediaRetryNotification. */
    class MediaRetryNotification implements IMediaRetryNotification {

        /**
         * Constructs a new MediaRetryNotification.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMediaRetryNotification);

        /** MediaRetryNotification stanzaId. */
        public stanzaId: string;

        /** MediaRetryNotification directPath. */
        public directPath: string;

        /** MediaRetryNotification result. */
        public result: proto.MediaRetryNotification.ResultType;

        /**
         * Creates a new MediaRetryNotification instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MediaRetryNotification instance
         */
        public static create(properties?: proto.IMediaRetryNotification): proto.MediaRetryNotification;

        /**
         * Encodes the specified MediaRetryNotification message. Does not implicitly {@link proto.MediaRetryNotification.verify|verify} messages.
         * @param message MediaRetryNotification message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMediaRetryNotification, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MediaRetryNotification message, length delimited. Does not implicitly {@link proto.MediaRetryNotification.verify|verify} messages.
         * @param message MediaRetryNotification message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMediaRetryNotification, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MediaRetryNotification message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MediaRetryNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MediaRetryNotification;

        /**
         * Decodes a MediaRetryNotification message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MediaRetryNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MediaRetryNotification;

        /**
         * Verifies a MediaRetryNotification message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MediaRetryNotification message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MediaRetryNotification
         */
        public static fromObject(object: { [k: string]: any }): proto.MediaRetryNotification;

        /**
         * Creates a plain object from a MediaRetryNotification message. Also converts values to other types if specified.
         * @param message MediaRetryNotification
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MediaRetryNotification, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MediaRetryNotification to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace MediaRetryNotification {

        /** ResultType enum. */
        enum ResultType {
            GENERAL_ERROR = 0,
            SUCCESS = 1,
            NOT_FOUND = 2,
            DECRYPTION_ERROR = 3
        }
    }

    /** MediaVisibility enum. */
    enum MediaVisibility {
        DEFAULT = 0,
        OFF = 1,
        ON = 2
    }

    /** Properties of a Message. */
    interface IMessage {

        /** Message conversation */
        conversation?: (string|null);

        /** Message senderKeyDistributionMessage */
        senderKeyDistributionMessage?: (proto.Message.ISenderKeyDistributionMessage|null);

        /** Message imageMessage */
        imageMessage?: (proto.Message.IImageMessage|null);

        /** Message contactMessage */
        contactMessage?: (proto.Message.IContactMessage|null);

        /** Message locationMessage */
        locationMessage?: (proto.Message.ILocationMessage|null);

        /** Message extendedTextMessage */
        extendedTextMessage?: (proto.Message.IExtendedTextMessage|null);

        /** Message documentMessage */
        documentMessage?: (proto.Message.IDocumentMessage|null);

        /** Message audioMessage */
        audioMessage?: (proto.Message.IAudioMessage|null);

        /** Message videoMessage */
        videoMessage?: (proto.Message.IVideoMessage|null);

        /** Message call */
        call?: (proto.Message.ICall|null);

        /** Message chat */
        chat?: (proto.Message.IChat|null);

        /** Message protocolMessage */
        protocolMessage?: (proto.Message.IProtocolMessage|null);

        /** Message contactsArrayMessage */
        contactsArrayMessage?: (proto.Message.IContactsArrayMessage|null);

        /** Message highlyStructuredMessage */
        highlyStructuredMessage?: (proto.Message.IHighlyStructuredMessage|null);

        /** Message fastRatchetKeySenderKeyDistributionMessage */
        fastRatchetKeySenderKeyDistributionMessage?: (proto.Message.ISenderKeyDistributionMessage|null);

        /** Message sendPaymentMessage */
        sendPaymentMessage?: (proto.Message.ISendPaymentMessage|null);

        /** Message liveLocationMessage */
        liveLocationMessage?: (proto.Message.ILiveLocationMessage|null);

        /** Message requestPaymentMessage */
        requestPaymentMessage?: (proto.Message.IRequestPaymentMessage|null);

        /** Message declinePaymentRequestMessage */
        declinePaymentRequestMessage?: (proto.Message.IDeclinePaymentRequestMessage|null);

        /** Message cancelPaymentRequestMessage */
        cancelPaymentRequestMessage?: (proto.Message.ICancelPaymentRequestMessage|null);

        /** Message templateMessage */
        templateMessage?: (proto.Message.ITemplateMessage|null);

        /** Message stickerMessage */
        stickerMessage?: (proto.Message.IStickerMessage|null);

        /** Message groupInviteMessage */
        groupInviteMessage?: (proto.Message.IGroupInviteMessage|null);

        /** Message templateButtonReplyMessage */
        templateButtonReplyMessage?: (proto.Message.ITemplateButtonReplyMessage|null);

        /** Message productMessage */
        productMessage?: (proto.Message.IProductMessage|null);

        /** Message deviceSentMessage */
        deviceSentMessage?: (proto.Message.IDeviceSentMessage|null);

        /** Message messageContextInfo */
        messageContextInfo?: (proto.IMessageContextInfo|null);

        /** Message listMessage */
        listMessage?: (proto.Message.IListMessage|null);

        /** Message viewOnceMessage */
        viewOnceMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message orderMessage */
        orderMessage?: (proto.Message.IOrderMessage|null);

        /** Message listResponseMessage */
        listResponseMessage?: (proto.Message.IListResponseMessage|null);

        /** Message ephemeralMessage */
        ephemeralMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message invoiceMessage */
        invoiceMessage?: (proto.Message.IInvoiceMessage|null);

        /** Message buttonsMessage */
        buttonsMessage?: (proto.Message.IButtonsMessage|null);

        /** Message buttonsResponseMessage */
        buttonsResponseMessage?: (proto.Message.IButtonsResponseMessage|null);

        /** Message paymentInviteMessage */
        paymentInviteMessage?: (proto.Message.IPaymentInviteMessage|null);

        /** Message interactiveMessage */
        interactiveMessage?: (proto.Message.IInteractiveMessage|null);

        /** Message reactionMessage */
        reactionMessage?: (proto.Message.IReactionMessage|null);

        /** Message stickerSyncRmrMessage */
        stickerSyncRmrMessage?: (proto.Message.IStickerSyncRMRMessage|null);

        /** Message interactiveResponseMessage */
        interactiveResponseMessage?: (proto.Message.IInteractiveResponseMessage|null);

        /** Message pollCreationMessage */
        pollCreationMessage?: (proto.Message.IPollCreationMessage|null);

        /** Message pollUpdateMessage */
        pollUpdateMessage?: (proto.Message.IPollUpdateMessage|null);

        /** Message keepInChatMessage */
        keepInChatMessage?: (proto.Message.IKeepInChatMessage|null);

        /** Message documentWithCaptionMessage */
        documentWithCaptionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message requestPhoneNumberMessage */
        requestPhoneNumberMessage?: (proto.Message.IRequestPhoneNumberMessage|null);

        /** Message viewOnceMessageV2 */
        viewOnceMessageV2?: (proto.Message.IFutureProofMessage|null);

        /** Message encReactionMessage */
        encReactionMessage?: (proto.Message.IEncReactionMessage|null);

        /** Message editedMessage */
        editedMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message viewOnceMessageV2Extension */
        viewOnceMessageV2Extension?: (proto.Message.IFutureProofMessage|null);
    }

    /** Represents a Message. */
    class Message implements IMessage {

        /**
         * Constructs a new Message.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMessage);

        /** Message conversation. */
        public conversation: string;

        /** Message senderKeyDistributionMessage. */
        public senderKeyDistributionMessage?: (proto.Message.ISenderKeyDistributionMessage|null);

        /** Message imageMessage. */
        public imageMessage?: (proto.Message.IImageMessage|null);

        /** Message contactMessage. */
        public contactMessage?: (proto.Message.IContactMessage|null);

        /** Message locationMessage. */
        public locationMessage?: (proto.Message.ILocationMessage|null);

        /** Message extendedTextMessage. */
        public extendedTextMessage?: (proto.Message.IExtendedTextMessage|null);

        /** Message documentMessage. */
        public documentMessage?: (proto.Message.IDocumentMessage|null);

        /** Message audioMessage. */
        public audioMessage?: (proto.Message.IAudioMessage|null);

        /** Message videoMessage. */
        public videoMessage?: (proto.Message.IVideoMessage|null);

        /** Message call. */
        public call?: (proto.Message.ICall|null);

        /** Message chat. */
        public chat?: (proto.Message.IChat|null);

        /** Message protocolMessage. */
        public protocolMessage?: (proto.Message.IProtocolMessage|null);

        /** Message contactsArrayMessage. */
        public contactsArrayMessage?: (proto.Message.IContactsArrayMessage|null);

        /** Message highlyStructuredMessage. */
        public highlyStructuredMessage?: (proto.Message.IHighlyStructuredMessage|null);

        /** Message fastRatchetKeySenderKeyDistributionMessage. */
        public fastRatchetKeySenderKeyDistributionMessage?: (proto.Message.ISenderKeyDistributionMessage|null);

        /** Message sendPaymentMessage. */
        public sendPaymentMessage?: (proto.Message.ISendPaymentMessage|null);

        /** Message liveLocationMessage. */
        public liveLocationMessage?: (proto.Message.ILiveLocationMessage|null);

        /** Message requestPaymentMessage. */
        public requestPaymentMessage?: (proto.Message.IRequestPaymentMessage|null);

        /** Message declinePaymentRequestMessage. */
        public declinePaymentRequestMessage?: (proto.Message.IDeclinePaymentRequestMessage|null);

        /** Message cancelPaymentRequestMessage. */
        public cancelPaymentRequestMessage?: (proto.Message.ICancelPaymentRequestMessage|null);

        /** Message templateMessage. */
        public templateMessage?: (proto.Message.ITemplateMessage|null);

        /** Message stickerMessage. */
        public stickerMessage?: (proto.Message.IStickerMessage|null);

        /** Message groupInviteMessage. */
        public groupInviteMessage?: (proto.Message.IGroupInviteMessage|null);

        /** Message templateButtonReplyMessage. */
        public templateButtonReplyMessage?: (proto.Message.ITemplateButtonReplyMessage|null);

        /** Message productMessage. */
        public productMessage?: (proto.Message.IProductMessage|null);

        /** Message deviceSentMessage. */
        public deviceSentMessage?: (proto.Message.IDeviceSentMessage|null);

        /** Message messageContextInfo. */
        public messageContextInfo?: (proto.IMessageContextInfo|null);

        /** Message listMessage. */
        public listMessage?: (proto.Message.IListMessage|null);

        /** Message viewOnceMessage. */
        public viewOnceMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message orderMessage. */
        public orderMessage?: (proto.Message.IOrderMessage|null);

        /** Message listResponseMessage. */
        public listResponseMessage?: (proto.Message.IListResponseMessage|null);

        /** Message ephemeralMessage. */
        public ephemeralMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message invoiceMessage. */
        public invoiceMessage?: (proto.Message.IInvoiceMessage|null);

        /** Message buttonsMessage. */
        public buttonsMessage?: (proto.Message.IButtonsMessage|null);

        /** Message buttonsResponseMessage. */
        public buttonsResponseMessage?: (proto.Message.IButtonsResponseMessage|null);

        /** Message paymentInviteMessage. */
        public paymentInviteMessage?: (proto.Message.IPaymentInviteMessage|null);

        /** Message interactiveMessage. */
        public interactiveMessage?: (proto.Message.IInteractiveMessage|null);

        /** Message reactionMessage. */
        public reactionMessage?: (proto.Message.IReactionMessage|null);

        /** Message stickerSyncRmrMessage. */
        public stickerSyncRmrMessage?: (proto.Message.IStickerSyncRMRMessage|null);

        /** Message interactiveResponseMessage. */
        public interactiveResponseMessage?: (proto.Message.IInteractiveResponseMessage|null);

        /** Message pollCreationMessage. */
        public pollCreationMessage?: (proto.Message.IPollCreationMessage|null);

        /** Message pollUpdateMessage. */
        public pollUpdateMessage?: (proto.Message.IPollUpdateMessage|null);

        /** Message keepInChatMessage. */
        public keepInChatMessage?: (proto.Message.IKeepInChatMessage|null);

        /** Message documentWithCaptionMessage. */
        public documentWithCaptionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message requestPhoneNumberMessage. */
        public requestPhoneNumberMessage?: (proto.Message.IRequestPhoneNumberMessage|null);

        /** Message viewOnceMessageV2. */
        public viewOnceMessageV2?: (proto.Message.IFutureProofMessage|null);

        /** Message encReactionMessage. */
        public encReactionMessage?: (proto.Message.IEncReactionMessage|null);

        /** Message editedMessage. */
        public editedMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message viewOnceMessageV2Extension. */
        public viewOnceMessageV2Extension?: (proto.Message.IFutureProofMessage|null);

        /**
         * Creates a new Message instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Message instance
         */
        public static create(properties?: proto.IMessage): proto.Message;

        /**
         * Encodes the specified Message message. Does not implicitly {@link proto.Message.verify|verify} messages.
         * @param message Message message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Message message, length delimited. Does not implicitly {@link proto.Message.verify|verify} messages.
         * @param message Message message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Message message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Message
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message;

        /**
         * Decodes a Message message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Message
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message;

        /**
         * Verifies a Message message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Message message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Message
         */
        public static fromObject(object: { [k: string]: any }): proto.Message;

        /**
         * Creates a plain object from a Message message. Also converts values to other types if specified.
         * @param message Message
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Message, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Message to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace Message {

        /** Properties of an AppStateFatalExceptionNotification. */
        interface IAppStateFatalExceptionNotification {

            /** AppStateFatalExceptionNotification collectionNames */
            collectionNames?: (string[]|null);

            /** AppStateFatalExceptionNotification timestamp */
            timestamp?: (number|Long|null);
        }

        /** Represents an AppStateFatalExceptionNotification. */
        class AppStateFatalExceptionNotification implements IAppStateFatalExceptionNotification {

            /**
             * Constructs a new AppStateFatalExceptionNotification.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateFatalExceptionNotification);

            /** AppStateFatalExceptionNotification collectionNames. */
            public collectionNames: string[];

            /** AppStateFatalExceptionNotification timestamp. */
            public timestamp: (number|Long);

            /**
             * Creates a new AppStateFatalExceptionNotification instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateFatalExceptionNotification instance
             */
            public static create(properties?: proto.Message.IAppStateFatalExceptionNotification): proto.Message.AppStateFatalExceptionNotification;

            /**
             * Encodes the specified AppStateFatalExceptionNotification message. Does not implicitly {@link proto.Message.AppStateFatalExceptionNotification.verify|verify} messages.
             * @param message AppStateFatalExceptionNotification message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateFatalExceptionNotification, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateFatalExceptionNotification message, length delimited. Does not implicitly {@link proto.Message.AppStateFatalExceptionNotification.verify|verify} messages.
             * @param message AppStateFatalExceptionNotification message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateFatalExceptionNotification, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateFatalExceptionNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateFatalExceptionNotification;

            /**
             * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateFatalExceptionNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateFatalExceptionNotification;

            /**
             * Verifies an AppStateFatalExceptionNotification message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateFatalExceptionNotification message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateFatalExceptionNotification
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateFatalExceptionNotification;

            /**
             * Creates a plain object from an AppStateFatalExceptionNotification message. Also converts values to other types if specified.
             * @param message AppStateFatalExceptionNotification
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateFatalExceptionNotification, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateFatalExceptionNotification to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an AppStateSyncKey. */
        interface IAppStateSyncKey {

            /** AppStateSyncKey keyId */
            keyId?: (proto.Message.IAppStateSyncKeyId|null);

            /** AppStateSyncKey keyData */
            keyData?: (proto.Message.IAppStateSyncKeyData|null);
        }

        /** Represents an AppStateSyncKey. */
        class AppStateSyncKey implements IAppStateSyncKey {

            /**
             * Constructs a new AppStateSyncKey.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKey);

            /** AppStateSyncKey keyId. */
            public keyId?: (proto.Message.IAppStateSyncKeyId|null);

            /** AppStateSyncKey keyData. */
            public keyData?: (proto.Message.IAppStateSyncKeyData|null);

            /**
             * Creates a new AppStateSyncKey instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKey instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKey): proto.Message.AppStateSyncKey;

            /**
             * Encodes the specified AppStateSyncKey message. Does not implicitly {@link proto.Message.AppStateSyncKey.verify|verify} messages.
             * @param message AppStateSyncKey message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKey, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKey message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKey.verify|verify} messages.
             * @param message AppStateSyncKey message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKey, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKey message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKey
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKey;

            /**
             * Decodes an AppStateSyncKey message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKey
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKey;

            /**
             * Verifies an AppStateSyncKey message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKey message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKey
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKey;

            /**
             * Creates a plain object from an AppStateSyncKey message. Also converts values to other types if specified.
             * @param message AppStateSyncKey
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKey, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKey to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an AppStateSyncKeyData. */
        interface IAppStateSyncKeyData {

            /** AppStateSyncKeyData keyData */
            keyData?: (Uint8Array|null);

            /** AppStateSyncKeyData fingerprint */
            fingerprint?: (proto.Message.IAppStateSyncKeyFingerprint|null);

            /** AppStateSyncKeyData timestamp */
            timestamp?: (number|Long|null);
        }

        /** Represents an AppStateSyncKeyData. */
        class AppStateSyncKeyData implements IAppStateSyncKeyData {

            /**
             * Constructs a new AppStateSyncKeyData.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyData);

            /** AppStateSyncKeyData keyData. */
            public keyData: Uint8Array;

            /** AppStateSyncKeyData fingerprint. */
            public fingerprint?: (proto.Message.IAppStateSyncKeyFingerprint|null);

            /** AppStateSyncKeyData timestamp. */
            public timestamp: (number|Long);

            /**
             * Creates a new AppStateSyncKeyData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyData instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyData): proto.Message.AppStateSyncKeyData;

            /**
             * Encodes the specified AppStateSyncKeyData message. Does not implicitly {@link proto.Message.AppStateSyncKeyData.verify|verify} messages.
             * @param message AppStateSyncKeyData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyData message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyData.verify|verify} messages.
             * @param message AppStateSyncKeyData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyData;

            /**
             * Decodes an AppStateSyncKeyData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyData;

            /**
             * Verifies an AppStateSyncKeyData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyData
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyData;

            /**
             * Creates a plain object from an AppStateSyncKeyData message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an AppStateSyncKeyFingerprint. */
        interface IAppStateSyncKeyFingerprint {

            /** AppStateSyncKeyFingerprint rawId */
            rawId?: (number|null);

            /** AppStateSyncKeyFingerprint currentIndex */
            currentIndex?: (number|null);

            /** AppStateSyncKeyFingerprint deviceIndexes */
            deviceIndexes?: (number[]|null);
        }

        /** Represents an AppStateSyncKeyFingerprint. */
        class AppStateSyncKeyFingerprint implements IAppStateSyncKeyFingerprint {

            /**
             * Constructs a new AppStateSyncKeyFingerprint.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyFingerprint);

            /** AppStateSyncKeyFingerprint rawId. */
            public rawId: number;

            /** AppStateSyncKeyFingerprint currentIndex. */
            public currentIndex: number;

            /** AppStateSyncKeyFingerprint deviceIndexes. */
            public deviceIndexes: number[];

            /**
             * Creates a new AppStateSyncKeyFingerprint instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyFingerprint instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyFingerprint): proto.Message.AppStateSyncKeyFingerprint;

            /**
             * Encodes the specified AppStateSyncKeyFingerprint message. Does not implicitly {@link proto.Message.AppStateSyncKeyFingerprint.verify|verify} messages.
             * @param message AppStateSyncKeyFingerprint message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyFingerprint, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyFingerprint message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyFingerprint.verify|verify} messages.
             * @param message AppStateSyncKeyFingerprint message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyFingerprint, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyFingerprint message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyFingerprint
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyFingerprint;

            /**
             * Decodes an AppStateSyncKeyFingerprint message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyFingerprint
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyFingerprint;

            /**
             * Verifies an AppStateSyncKeyFingerprint message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyFingerprint message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyFingerprint
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyFingerprint;

            /**
             * Creates a plain object from an AppStateSyncKeyFingerprint message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyFingerprint
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyFingerprint, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyFingerprint to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an AppStateSyncKeyId. */
        interface IAppStateSyncKeyId {

            /** AppStateSyncKeyId keyId */
            keyId?: (Uint8Array|null);
        }

        /** Represents an AppStateSyncKeyId. */
        class AppStateSyncKeyId implements IAppStateSyncKeyId {

            /**
             * Constructs a new AppStateSyncKeyId.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyId);

            /** AppStateSyncKeyId keyId. */
            public keyId: Uint8Array;

            /**
             * Creates a new AppStateSyncKeyId instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyId instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyId): proto.Message.AppStateSyncKeyId;

            /**
             * Encodes the specified AppStateSyncKeyId message. Does not implicitly {@link proto.Message.AppStateSyncKeyId.verify|verify} messages.
             * @param message AppStateSyncKeyId message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyId, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyId message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyId.verify|verify} messages.
             * @param message AppStateSyncKeyId message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyId, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyId message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyId
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyId;

            /**
             * Decodes an AppStateSyncKeyId message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyId
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyId;

            /**
             * Verifies an AppStateSyncKeyId message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyId message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyId
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyId;

            /**
             * Creates a plain object from an AppStateSyncKeyId message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyId
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyId, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyId to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an AppStateSyncKeyRequest. */
        interface IAppStateSyncKeyRequest {

            /** AppStateSyncKeyRequest keyIds */
            keyIds?: (proto.Message.IAppStateSyncKeyId[]|null);
        }

        /** Represents an AppStateSyncKeyRequest. */
        class AppStateSyncKeyRequest implements IAppStateSyncKeyRequest {

            /**
             * Constructs a new AppStateSyncKeyRequest.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyRequest);

            /** AppStateSyncKeyRequest keyIds. */
            public keyIds: proto.Message.IAppStateSyncKeyId[];

            /**
             * Creates a new AppStateSyncKeyRequest instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyRequest instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyRequest): proto.Message.AppStateSyncKeyRequest;

            /**
             * Encodes the specified AppStateSyncKeyRequest message. Does not implicitly {@link proto.Message.AppStateSyncKeyRequest.verify|verify} messages.
             * @param message AppStateSyncKeyRequest message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyRequest, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyRequest message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyRequest.verify|verify} messages.
             * @param message AppStateSyncKeyRequest message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyRequest, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyRequest message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyRequest
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyRequest;

            /**
             * Decodes an AppStateSyncKeyRequest message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyRequest
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyRequest;

            /**
             * Verifies an AppStateSyncKeyRequest message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyRequest message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyRequest
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyRequest;

            /**
             * Creates a plain object from an AppStateSyncKeyRequest message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyRequest
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyRequest to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an AppStateSyncKeyShare. */
        interface IAppStateSyncKeyShare {

            /** AppStateSyncKeyShare keys */
            keys?: (proto.Message.IAppStateSyncKey[]|null);
        }

        /** Represents an AppStateSyncKeyShare. */
        class AppStateSyncKeyShare implements IAppStateSyncKeyShare {

            /**
             * Constructs a new AppStateSyncKeyShare.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyShare);

            /** AppStateSyncKeyShare keys. */
            public keys: proto.Message.IAppStateSyncKey[];

            /**
             * Creates a new AppStateSyncKeyShare instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyShare instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyShare): proto.Message.AppStateSyncKeyShare;

            /**
             * Encodes the specified AppStateSyncKeyShare message. Does not implicitly {@link proto.Message.AppStateSyncKeyShare.verify|verify} messages.
             * @param message AppStateSyncKeyShare message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyShare, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyShare message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyShare.verify|verify} messages.
             * @param message AppStateSyncKeyShare message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyShare, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyShare message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyShare
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyShare;

            /**
             * Decodes an AppStateSyncKeyShare message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyShare
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyShare;

            /**
             * Verifies an AppStateSyncKeyShare message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyShare message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyShare
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyShare;

            /**
             * Creates a plain object from an AppStateSyncKeyShare message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyShare
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyShare, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyShare to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an AudioMessage. */
        interface IAudioMessage {

            /** AudioMessage url */
            url?: (string|null);

            /** AudioMessage mimetype */
            mimetype?: (string|null);

            /** AudioMessage fileSha256 */
            fileSha256?: (Uint8Array|null);

            /** AudioMessage fileLength */
            fileLength?: (number|Long|null);

            /** AudioMessage seconds */
            seconds?: (number|null);

            /** AudioMessage ptt */
            ptt?: (boolean|null);

            /** AudioMessage mediaKey */
            mediaKey?: (Uint8Array|null);

            /** AudioMessage fileEncSha256 */
            fileEncSha256?: (Uint8Array|null);

            /** AudioMessage directPath */
            directPath?: (string|null);

            /** AudioMessage mediaKeyTimestamp */
            mediaKeyTimestamp?: (number|Long|null);

            /** AudioMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** AudioMessage streamingSidecar */
            streamingSidecar?: (Uint8Array|null);

            /** AudioMessage waveform */
            waveform?: (Uint8Array|null);

            /** AudioMessage backgroundArgb */
            backgroundArgb?: (number|null);
        }

        /** Represents an AudioMessage. */
        class AudioMessage implements IAudioMessage {

            /**
             * Constructs a new AudioMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAudioMessage);

            /** AudioMessage url. */
            public url: string;

            /** AudioMessage mimetype. */
            public mimetype: string;

            /** AudioMessage fileSha256. */
            public fileSha256: Uint8Array;

            /** AudioMessage fileLength. */
            public fileLength: (number|Long);

            /** AudioMessage seconds. */
            public seconds: number;

            /** AudioMessage ptt. */
            public ptt: boolean;

            /** AudioMessage mediaKey. */
            public mediaKey: Uint8Array;

            /** AudioMessage fileEncSha256. */
            public fileEncSha256: Uint8Array;

            /** AudioMessage directPath. */
            public directPath: string;

            /** AudioMessage mediaKeyTimestamp. */
            public mediaKeyTimestamp: (number|Long);

            /** AudioMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** AudioMessage streamingSidecar. */
            public streamingSidecar: Uint8Array;

            /** AudioMessage waveform. */
            public waveform: Uint8Array;

            /** AudioMessage backgroundArgb. */
            public backgroundArgb: number;

            /**
             * Creates a new AudioMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AudioMessage instance
             */
            public static create(properties?: proto.Message.IAudioMessage): proto.Message.AudioMessage;

            /**
             * Encodes the specified AudioMessage message. Does not implicitly {@link proto.Message.AudioMessage.verify|verify} messages.
             * @param message AudioMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAudioMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AudioMessage message, length delimited. Does not implicitly {@link proto.Message.AudioMessage.verify|verify} messages.
             * @param message AudioMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAudioMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AudioMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AudioMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AudioMessage;

            /**
             * Decodes an AudioMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AudioMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AudioMessage;

            /**
             * Verifies an AudioMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AudioMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AudioMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AudioMessage;

            /**
             * Creates a plain object from an AudioMessage message. Also converts values to other types if specified.
             * @param message AudioMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AudioMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AudioMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ButtonsMessage. */
        interface IButtonsMessage {

            /** ButtonsMessage contentText */
            contentText?: (string|null);

            /** ButtonsMessage footerText */
            footerText?: (string|null);

            /** ButtonsMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** ButtonsMessage buttons */
            buttons?: (proto.Message.ButtonsMessage.IButton[]|null);

            /** ButtonsMessage headerType */
            headerType?: (proto.Message.ButtonsMessage.HeaderType|null);

            /** ButtonsMessage text */
            text?: (string|null);

            /** ButtonsMessage documentMessage */
            documentMessage?: (proto.Message.IDocumentMessage|null);

            /** ButtonsMessage imageMessage */
            imageMessage?: (proto.Message.IImageMessage|null);

            /** ButtonsMessage videoMessage */
            videoMessage?: (proto.Message.IVideoMessage|null);

            /** ButtonsMessage locationMessage */
            locationMessage?: (proto.Message.ILocationMessage|null);
        }

        /** Represents a ButtonsMessage. */
        class ButtonsMessage implements IButtonsMessage {

            /**
             * Constructs a new ButtonsMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IButtonsMessage);

            /** ButtonsMessage contentText. */
            public contentText: string;

            /** ButtonsMessage footerText. */
            public footerText: string;

            /** ButtonsMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** ButtonsMessage buttons. */
            public buttons: proto.Message.ButtonsMessage.IButton[];

            /** ButtonsMessage headerType. */
            public headerType: proto.Message.ButtonsMessage.HeaderType;

            /** ButtonsMessage text. */
            public text?: (string|null);

            /** ButtonsMessage documentMessage. */
            public documentMessage?: (proto.Message.IDocumentMessage|null);

            /** ButtonsMessage imageMessage. */
            public imageMessage?: (proto.Message.IImageMessage|null);

            /** ButtonsMessage videoMessage. */
            public videoMessage?: (proto.Message.IVideoMessage|null);

            /** ButtonsMessage locationMessage. */
            public locationMessage?: (proto.Message.ILocationMessage|null);

            /** ButtonsMessage header. */
            public header?: ("text"|"documentMessage"|"imageMessage"|"videoMessage"|"locationMessage");

            /**
             * Creates a new ButtonsMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ButtonsMessage instance
             */
            public static create(properties?: proto.Message.IButtonsMessage): proto.Message.ButtonsMessage;

            /**
             * Encodes the specified ButtonsMessage message. Does not implicitly {@link proto.Message.ButtonsMessage.verify|verify} messages.
             * @param message ButtonsMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IButtonsMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ButtonsMessage message, length delimited. Does not implicitly {@link proto.Message.ButtonsMessage.verify|verify} messages.
             * @param message ButtonsMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IButtonsMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ButtonsMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ButtonsMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsMessage;

            /**
             * Decodes a ButtonsMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ButtonsMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsMessage;

            /**
             * Verifies a ButtonsMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ButtonsMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ButtonsMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsMessage;

            /**
             * Creates a plain object from a ButtonsMessage message. Also converts values to other types if specified.
             * @param message ButtonsMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ButtonsMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ButtonsMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace ButtonsMessage {

            /** Properties of a Button. */
            interface IButton {

                /** Button buttonId */
                buttonId?: (string|null);

                /** Button buttonText */
                buttonText?: (proto.Message.ButtonsMessage.Button.IButtonText|null);

                /** Button type */
                type?: (proto.Message.ButtonsMessage.Button.Type|null);

                /** Button nativeFlowInfo */
                nativeFlowInfo?: (proto.Message.ButtonsMessage.Button.INativeFlowInfo|null);
            }

            /** Represents a Button. */
            class Button implements IButton {

                /**
                 * Constructs a new Button.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ButtonsMessage.IButton);

                /** Button buttonId. */
                public buttonId: string;

                /** Button buttonText. */
                public buttonText?: (proto.Message.ButtonsMessage.Button.IButtonText|null);

                /** Button type. */
                public type: proto.Message.ButtonsMessage.Button.Type;

                /** Button nativeFlowInfo. */
                public nativeFlowInfo?: (proto.Message.ButtonsMessage.Button.INativeFlowInfo|null);

                /**
                 * Creates a new Button instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Button instance
                 */
                public static create(properties?: proto.Message.ButtonsMessage.IButton): proto.Message.ButtonsMessage.Button;

                /**
                 * Encodes the specified Button message. Does not implicitly {@link proto.Message.ButtonsMessage.Button.verify|verify} messages.
                 * @param message Button message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ButtonsMessage.IButton, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Button message, length delimited. Does not implicitly {@link proto.Message.ButtonsMessage.Button.verify|verify} messages.
                 * @param message Button message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ButtonsMessage.IButton, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Button message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Button
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsMessage.Button;

                /**
                 * Decodes a Button message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Button
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsMessage.Button;

                /**
                 * Verifies a Button message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Button message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Button
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsMessage.Button;

                /**
                 * Creates a plain object from a Button message. Also converts values to other types if specified.
                 * @param message Button
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ButtonsMessage.Button, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Button to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace Button {

                /** Properties of a ButtonText. */
                interface IButtonText {

                    /** ButtonText displayText */
                    displayText?: (string|null);
                }

                /** Represents a ButtonText. */
                class ButtonText implements IButtonText {

                    /**
                     * Constructs a new ButtonText.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: proto.Message.ButtonsMessage.Button.IButtonText);

                    /** ButtonText displayText. */
                    public displayText: string;

                    /**
                     * Creates a new ButtonText instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ButtonText instance
                     */
                    public static create(properties?: proto.Message.ButtonsMessage.Button.IButtonText): proto.Message.ButtonsMessage.Button.ButtonText;

                    /**
                     * Encodes the specified ButtonText message. Does not implicitly {@link proto.Message.ButtonsMessage.Button.ButtonText.verify|verify} messages.
                     * @param message ButtonText message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: proto.Message.ButtonsMessage.Button.IButtonText, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ButtonText message, length delimited. Does not implicitly {@link proto.Message.ButtonsMessage.Button.ButtonText.verify|verify} messages.
                     * @param message ButtonText message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: proto.Message.ButtonsMessage.Button.IButtonText, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ButtonText message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ButtonText
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsMessage.Button.ButtonText;

                    /**
                     * Decodes a ButtonText message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ButtonText
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsMessage.Button.ButtonText;

                    /**
                     * Verifies a ButtonText message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ButtonText message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ButtonText
                     */
                    public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsMessage.Button.ButtonText;

                    /**
                     * Creates a plain object from a ButtonText message. Also converts values to other types if specified.
                     * @param message ButtonText
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: proto.Message.ButtonsMessage.Button.ButtonText, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ButtonText to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a NativeFlowInfo. */
                interface INativeFlowInfo {

                    /** NativeFlowInfo name */
                    name?: (string|null);

                    /** NativeFlowInfo paramsJson */
                    paramsJson?: (string|null);
                }

                /** Represents a NativeFlowInfo. */
                class NativeFlowInfo implements INativeFlowInfo {

                    /**
                     * Constructs a new NativeFlowInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: proto.Message.ButtonsMessage.Button.INativeFlowInfo);

                    /** NativeFlowInfo name. */
                    public name: string;

                    /** NativeFlowInfo paramsJson. */
                    public paramsJson: string;

                    /**
                     * Creates a new NativeFlowInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns NativeFlowInfo instance
                     */
                    public static create(properties?: proto.Message.ButtonsMessage.Button.INativeFlowInfo): proto.Message.ButtonsMessage.Button.NativeFlowInfo;

                    /**
                     * Encodes the specified NativeFlowInfo message. Does not implicitly {@link proto.Message.ButtonsMessage.Button.NativeFlowInfo.verify|verify} messages.
                     * @param message NativeFlowInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: proto.Message.ButtonsMessage.Button.INativeFlowInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified NativeFlowInfo message, length delimited. Does not implicitly {@link proto.Message.ButtonsMessage.Button.NativeFlowInfo.verify|verify} messages.
                     * @param message NativeFlowInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: proto.Message.ButtonsMessage.Button.INativeFlowInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a NativeFlowInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns NativeFlowInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsMessage.Button.NativeFlowInfo;

                    /**
                     * Decodes a NativeFlowInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns NativeFlowInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsMessage.Button.NativeFlowInfo;

                    /**
                     * Verifies a NativeFlowInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a NativeFlowInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns NativeFlowInfo
                     */
                    public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsMessage.Button.NativeFlowInfo;

                    /**
                     * Creates a plain object from a NativeFlowInfo message. Also converts values to other types if specified.
                     * @param message NativeFlowInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: proto.Message.ButtonsMessage.Button.NativeFlowInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this NativeFlowInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Type enum. */
                enum Type {
                    UNKNOWN = 0,
                    RESPONSE = 1,
                    NATIVE_FLOW = 2
                }
            }

            /** HeaderType enum. */
            enum HeaderType {
                UNKNOWN = 0,
                EMPTY = 1,
                TEXT = 2,
                DOCUMENT = 3,
                IMAGE = 4,
                VIDEO = 5,
                LOCATION = 6
            }
        }

        /** Properties of a ButtonsResponseMessage. */
        interface IButtonsResponseMessage {

            /** ButtonsResponseMessage selectedButtonId */
            selectedButtonId?: (string|null);

            /** ButtonsResponseMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** ButtonsResponseMessage type */
            type?: (proto.Message.ButtonsResponseMessage.Type|null);

            /** ButtonsResponseMessage selectedDisplayText */
            selectedDisplayText?: (string|null);
        }

        /** Represents a ButtonsResponseMessage. */
        class ButtonsResponseMessage implements IButtonsResponseMessage {

            /**
             * Constructs a new ButtonsResponseMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IButtonsResponseMessage);

            /** ButtonsResponseMessage selectedButtonId. */
            public selectedButtonId: string;

            /** ButtonsResponseMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** ButtonsResponseMessage type. */
            public type: proto.Message.ButtonsResponseMessage.Type;

            /** ButtonsResponseMessage selectedDisplayText. */
            public selectedDisplayText?: (string|null);

            /** ButtonsResponseMessage response. */
            public response?: "selectedDisplayText";

            /**
             * Creates a new ButtonsResponseMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ButtonsResponseMessage instance
             */
            public static create(properties?: proto.Message.IButtonsResponseMessage): proto.Message.ButtonsResponseMessage;

            /**
             * Encodes the specified ButtonsResponseMessage message. Does not implicitly {@link proto.Message.ButtonsResponseMessage.verify|verify} messages.
             * @param message ButtonsResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IButtonsResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ButtonsResponseMessage message, length delimited. Does not implicitly {@link proto.Message.ButtonsResponseMessage.verify|verify} messages.
             * @param message ButtonsResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IButtonsResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ButtonsResponseMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ButtonsResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsResponseMessage;

            /**
             * Decodes a ButtonsResponseMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ButtonsResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsResponseMessage;

            /**
             * Verifies a ButtonsResponseMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ButtonsResponseMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ButtonsResponseMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsResponseMessage;

            /**
             * Creates a plain object from a ButtonsResponseMessage message. Also converts values to other types if specified.
             * @param message ButtonsResponseMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ButtonsResponseMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ButtonsResponseMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace ButtonsResponseMessage {

            /** Type enum. */
            enum Type {
                UNKNOWN = 0,
                DISPLAY_TEXT = 1
            }
        }

        /** Properties of a Call. */
        interface ICall {

            /** Call callKey */
            callKey?: (Uint8Array|null);

            /** Call conversionSource */
            conversionSource?: (string|null);

            /** Call conversionData */
            conversionData?: (Uint8Array|null);

            /** Call conversionDelaySeconds */
            conversionDelaySeconds?: (number|null);
        }

        /** Represents a Call. */
        class Call implements ICall {

            /**
             * Constructs a new Call.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ICall);

            /** Call callKey. */
            public callKey: Uint8Array;

            /** Call conversionSource. */
            public conversionSource: string;

            /** Call conversionData. */
            public conversionData: Uint8Array;

            /** Call conversionDelaySeconds. */
            public conversionDelaySeconds: number;

            /**
             * Creates a new Call instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Call instance
             */
            public static create(properties?: proto.Message.ICall): proto.Message.Call;

            /**
             * Encodes the specified Call message. Does not implicitly {@link proto.Message.Call.verify|verify} messages.
             * @param message Call message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ICall, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Call message, length delimited. Does not implicitly {@link proto.Message.Call.verify|verify} messages.
             * @param message Call message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ICall, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a Call message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Call
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.Call;

            /**
             * Decodes a Call message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Call
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.Call;

            /**
             * Verifies a Call message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a Call message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Call
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.Call;

            /**
             * Creates a plain object from a Call message. Also converts values to other types if specified.
             * @param message Call
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.Call, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Call to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a CancelPaymentRequestMessage. */
        interface ICancelPaymentRequestMessage {

            /** CancelPaymentRequestMessage key */
            key?: (proto.IMessageKey|null);
        }

        /** Represents a CancelPaymentRequestMessage. */
        class CancelPaymentRequestMessage implements ICancelPaymentRequestMessage {

            /**
             * Constructs a new CancelPaymentRequestMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ICancelPaymentRequestMessage);

            /** CancelPaymentRequestMessage key. */
            public key?: (proto.IMessageKey|null);

            /**
             * Creates a new CancelPaymentRequestMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns CancelPaymentRequestMessage instance
             */
            public static create(properties?: proto.Message.ICancelPaymentRequestMessage): proto.Message.CancelPaymentRequestMessage;

            /**
             * Encodes the specified CancelPaymentRequestMessage message. Does not implicitly {@link proto.Message.CancelPaymentRequestMessage.verify|verify} messages.
             * @param message CancelPaymentRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ICancelPaymentRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified CancelPaymentRequestMessage message, length delimited. Does not implicitly {@link proto.Message.CancelPaymentRequestMessage.verify|verify} messages.
             * @param message CancelPaymentRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ICancelPaymentRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a CancelPaymentRequestMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns CancelPaymentRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.CancelPaymentRequestMessage;

            /**
             * Decodes a CancelPaymentRequestMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns CancelPaymentRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.CancelPaymentRequestMessage;

            /**
             * Verifies a CancelPaymentRequestMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a CancelPaymentRequestMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns CancelPaymentRequestMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.CancelPaymentRequestMessage;

            /**
             * Creates a plain object from a CancelPaymentRequestMessage message. Also converts values to other types if specified.
             * @param message CancelPaymentRequestMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.CancelPaymentRequestMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this CancelPaymentRequestMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a Chat. */
        interface IChat {

            /** Chat displayName */
            displayName?: (string|null);

            /** Chat id */
            id?: (string|null);
        }

        /** Represents a Chat. */
        class Chat implements IChat {

            /**
             * Constructs a new Chat.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IChat);

            /** Chat displayName. */
            public displayName: string;

            /** Chat id. */
            public id: string;

            /**
             * Creates a new Chat instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Chat instance
             */
            public static create(properties?: proto.Message.IChat): proto.Message.Chat;

            /**
             * Encodes the specified Chat message. Does not implicitly {@link proto.Message.Chat.verify|verify} messages.
             * @param message Chat message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IChat, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Chat message, length delimited. Does not implicitly {@link proto.Message.Chat.verify|verify} messages.
             * @param message Chat message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IChat, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a Chat message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Chat
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.Chat;

            /**
             * Decodes a Chat message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Chat
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.Chat;

            /**
             * Verifies a Chat message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a Chat message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Chat
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.Chat;

            /**
             * Creates a plain object from a Chat message. Also converts values to other types if specified.
             * @param message Chat
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.Chat, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Chat to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ContactMessage. */
        interface IContactMessage {

            /** ContactMessage displayName */
            displayName?: (string|null);

            /** ContactMessage vcard */
            vcard?: (string|null);

            /** ContactMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a ContactMessage. */
        class ContactMessage implements IContactMessage {

            /**
             * Constructs a new ContactMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IContactMessage);

            /** ContactMessage displayName. */
            public displayName: string;

            /** ContactMessage vcard. */
            public vcard: string;

            /** ContactMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new ContactMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ContactMessage instance
             */
            public static create(properties?: proto.Message.IContactMessage): proto.Message.ContactMessage;

            /**
             * Encodes the specified ContactMessage message. Does not implicitly {@link proto.Message.ContactMessage.verify|verify} messages.
             * @param message ContactMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IContactMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ContactMessage message, length delimited. Does not implicitly {@link proto.Message.ContactMessage.verify|verify} messages.
             * @param message ContactMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IContactMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ContactMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ContactMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ContactMessage;

            /**
             * Decodes a ContactMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ContactMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ContactMessage;

            /**
             * Verifies a ContactMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ContactMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ContactMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ContactMessage;

            /**
             * Creates a plain object from a ContactMessage message. Also converts values to other types if specified.
             * @param message ContactMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ContactMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ContactMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ContactsArrayMessage. */
        interface IContactsArrayMessage {

            /** ContactsArrayMessage displayName */
            displayName?: (string|null);

            /** ContactsArrayMessage contacts */
            contacts?: (proto.Message.IContactMessage[]|null);

            /** ContactsArrayMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a ContactsArrayMessage. */
        class ContactsArrayMessage implements IContactsArrayMessage {

            /**
             * Constructs a new ContactsArrayMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IContactsArrayMessage);

            /** ContactsArrayMessage displayName. */
            public displayName: string;

            /** ContactsArrayMessage contacts. */
            public contacts: proto.Message.IContactMessage[];

            /** ContactsArrayMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new ContactsArrayMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ContactsArrayMessage instance
             */
            public static create(properties?: proto.Message.IContactsArrayMessage): proto.Message.ContactsArrayMessage;

            /**
             * Encodes the specified ContactsArrayMessage message. Does not implicitly {@link proto.Message.ContactsArrayMessage.verify|verify} messages.
             * @param message ContactsArrayMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IContactsArrayMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ContactsArrayMessage message, length delimited. Does not implicitly {@link proto.Message.ContactsArrayMessage.verify|verify} messages.
             * @param message ContactsArrayMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IContactsArrayMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ContactsArrayMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ContactsArrayMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ContactsArrayMessage;

            /**
             * Decodes a ContactsArrayMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ContactsArrayMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ContactsArrayMessage;

            /**
             * Verifies a ContactsArrayMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ContactsArrayMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ContactsArrayMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ContactsArrayMessage;

            /**
             * Creates a plain object from a ContactsArrayMessage message. Also converts values to other types if specified.
             * @param message ContactsArrayMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ContactsArrayMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ContactsArrayMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a DeclinePaymentRequestMessage. */
        interface IDeclinePaymentRequestMessage {

            /** DeclinePaymentRequestMessage key */
            key?: (proto.IMessageKey|null);
        }

        /** Represents a DeclinePaymentRequestMessage. */
        class DeclinePaymentRequestMessage implements IDeclinePaymentRequestMessage {

            /**
             * Constructs a new DeclinePaymentRequestMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IDeclinePaymentRequestMessage);

            /** DeclinePaymentRequestMessage key. */
            public key?: (proto.IMessageKey|null);

            /**
             * Creates a new DeclinePaymentRequestMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DeclinePaymentRequestMessage instance
             */
            public static create(properties?: proto.Message.IDeclinePaymentRequestMessage): proto.Message.DeclinePaymentRequestMessage;

            /**
             * Encodes the specified DeclinePaymentRequestMessage message. Does not implicitly {@link proto.Message.DeclinePaymentRequestMessage.verify|verify} messages.
             * @param message DeclinePaymentRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IDeclinePaymentRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DeclinePaymentRequestMessage message, length delimited. Does not implicitly {@link proto.Message.DeclinePaymentRequestMessage.verify|verify} messages.
             * @param message DeclinePaymentRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IDeclinePaymentRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DeclinePaymentRequestMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DeclinePaymentRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.DeclinePaymentRequestMessage;

            /**
             * Decodes a DeclinePaymentRequestMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DeclinePaymentRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.DeclinePaymentRequestMessage;

            /**
             * Verifies a DeclinePaymentRequestMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DeclinePaymentRequestMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DeclinePaymentRequestMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.DeclinePaymentRequestMessage;

            /**
             * Creates a plain object from a DeclinePaymentRequestMessage message. Also converts values to other types if specified.
             * @param message DeclinePaymentRequestMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.DeclinePaymentRequestMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DeclinePaymentRequestMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a DeviceSentMessage. */
        interface IDeviceSentMessage {

            /** DeviceSentMessage destinationJid */
            destinationJid?: (string|null);

            /** DeviceSentMessage message */
            message?: (proto.IMessage|null);

            /** DeviceSentMessage phash */
            phash?: (string|null);
        }

        /** Represents a DeviceSentMessage. */
        class DeviceSentMessage implements IDeviceSentMessage {

            /**
             * Constructs a new DeviceSentMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IDeviceSentMessage);

            /** DeviceSentMessage destinationJid. */
            public destinationJid: string;

            /** DeviceSentMessage message. */
            public message?: (proto.IMessage|null);

            /** DeviceSentMessage phash. */
            public phash: string;

            /**
             * Creates a new DeviceSentMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DeviceSentMessage instance
             */
            public static create(properties?: proto.Message.IDeviceSentMessage): proto.Message.DeviceSentMessage;

            /**
             * Encodes the specified DeviceSentMessage message. Does not implicitly {@link proto.Message.DeviceSentMessage.verify|verify} messages.
             * @param message DeviceSentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IDeviceSentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DeviceSentMessage message, length delimited. Does not implicitly {@link proto.Message.DeviceSentMessage.verify|verify} messages.
             * @param message DeviceSentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IDeviceSentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DeviceSentMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DeviceSentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.DeviceSentMessage;

            /**
             * Decodes a DeviceSentMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DeviceSentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.DeviceSentMessage;

            /**
             * Verifies a DeviceSentMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DeviceSentMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DeviceSentMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.DeviceSentMessage;

            /**
             * Creates a plain object from a DeviceSentMessage message. Also converts values to other types if specified.
             * @param message DeviceSentMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.DeviceSentMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DeviceSentMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a DocumentMessage. */
        interface IDocumentMessage {

            /** DocumentMessage url */
            url?: (string|null);

            /** DocumentMessage mimetype */
            mimetype?: (string|null);

            /** DocumentMessage title */
            title?: (string|null);

            /** DocumentMessage fileSha256 */
            fileSha256?: (Uint8Array|null);

            /** DocumentMessage fileLength */
            fileLength?: (number|Long|null);

            /** DocumentMessage pageCount */
            pageCount?: (number|null);

            /** DocumentMessage mediaKey */
            mediaKey?: (Uint8Array|null);

            /** DocumentMessage fileName */
            fileName?: (string|null);

            /** DocumentMessage fileEncSha256 */
            fileEncSha256?: (Uint8Array|null);

            /** DocumentMessage directPath */
            directPath?: (string|null);

            /** DocumentMessage mediaKeyTimestamp */
            mediaKeyTimestamp?: (number|Long|null);

            /** DocumentMessage contactVcard */
            contactVcard?: (boolean|null);

            /** DocumentMessage thumbnailDirectPath */
            thumbnailDirectPath?: (string|null);

            /** DocumentMessage thumbnailSha256 */
            thumbnailSha256?: (Uint8Array|null);

            /** DocumentMessage thumbnailEncSha256 */
            thumbnailEncSha256?: (Uint8Array|null);

            /** DocumentMessage jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** DocumentMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** DocumentMessage thumbnailHeight */
            thumbnailHeight?: (number|null);

            /** DocumentMessage thumbnailWidth */
            thumbnailWidth?: (number|null);

            /** DocumentMessage caption */
            caption?: (string|null);
        }

        /** Represents a DocumentMessage. */
        class DocumentMessage implements IDocumentMessage {

            /**
             * Constructs a new DocumentMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IDocumentMessage);

            /** DocumentMessage url. */
            public url: string;

            /** DocumentMessage mimetype. */
            public mimetype: string;

            /** DocumentMessage title. */
            public title: string;

            /** DocumentMessage fileSha256. */
            public fileSha256: Uint8Array;

            /** DocumentMessage fileLength. */
            public fileLength: (number|Long);

            /** DocumentMessage pageCount. */
            public pageCount: number;

            /** DocumentMessage mediaKey. */
            public mediaKey: Uint8Array;

            /** DocumentMessage fileName. */
            public fileName: string;

            /** DocumentMessage fileEncSha256. */
            public fileEncSha256: Uint8Array;

            /** DocumentMessage directPath. */
            public directPath: string;

            /** DocumentMessage mediaKeyTimestamp. */
            public mediaKeyTimestamp: (number|Long);

            /** DocumentMessage contactVcard. */
            public contactVcard: boolean;

            /** DocumentMessage thumbnailDirectPath. */
            public thumbnailDirectPath: string;

            /** DocumentMessage thumbnailSha256. */
            public thumbnailSha256: Uint8Array;

            /** DocumentMessage thumbnailEncSha256. */
            public thumbnailEncSha256: Uint8Array;

            /** DocumentMessage jpegThumbnail. */
            public jpegThumbnail: Uint8Array;

            /** DocumentMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** DocumentMessage thumbnailHeight. */
            public thumbnailHeight: number;

            /** DocumentMessage thumbnailWidth. */
            public thumbnailWidth: number;

            /** DocumentMessage caption. */
            public caption: string;

            /**
             * Creates a new DocumentMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DocumentMessage instance
             */
            public static create(properties?: proto.Message.IDocumentMessage): proto.Message.DocumentMessage;

            /**
             * Encodes the specified DocumentMessage message. Does not implicitly {@link proto.Message.DocumentMessage.verify|verify} messages.
             * @param message DocumentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IDocumentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DocumentMessage message, length delimited. Does not implicitly {@link proto.Message.DocumentMessage.verify|verify} messages.
             * @param message DocumentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IDocumentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DocumentMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DocumentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.DocumentMessage;

            /**
             * Decodes a DocumentMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DocumentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.DocumentMessage;

            /**
             * Verifies a DocumentMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DocumentMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DocumentMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.DocumentMessage;

            /**
             * Creates a plain object from a DocumentMessage message. Also converts values to other types if specified.
             * @param message DocumentMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.DocumentMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DocumentMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an EncReactionMessage. */
        interface IEncReactionMessage {

            /** EncReactionMessage targetMessageKey */
            targetMessageKey?: (proto.IMessageKey|null);

            /** EncReactionMessage encPayload */
            encPayload?: (Uint8Array|null);

            /** EncReactionMessage encIv */
            encIv?: (Uint8Array|null);
        }

        /** Represents an EncReactionMessage. */
        class EncReactionMessage implements IEncReactionMessage {

            /**
             * Constructs a new EncReactionMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IEncReactionMessage);

            /** EncReactionMessage targetMessageKey. */
            public targetMessageKey?: (proto.IMessageKey|null);

            /** EncReactionMessage encPayload. */
            public encPayload: Uint8Array;

            /** EncReactionMessage encIv. */
            public encIv: Uint8Array;

            /**
             * Creates a new EncReactionMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EncReactionMessage instance
             */
            public static create(properties?: proto.Message.IEncReactionMessage): proto.Message.EncReactionMessage;

            /**
             * Encodes the specified EncReactionMessage message. Does not implicitly {@link proto.Message.EncReactionMessage.verify|verify} messages.
             * @param message EncReactionMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IEncReactionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EncReactionMessage message, length delimited. Does not implicitly {@link proto.Message.EncReactionMessage.verify|verify} messages.
             * @param message EncReactionMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IEncReactionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EncReactionMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EncReactionMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.EncReactionMessage;

            /**
             * Decodes an EncReactionMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EncReactionMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.EncReactionMessage;

            /**
             * Verifies an EncReactionMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EncReactionMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EncReactionMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.EncReactionMessage;

            /**
             * Creates a plain object from an EncReactionMessage message. Also converts values to other types if specified.
             * @param message EncReactionMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.EncReactionMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EncReactionMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an ExtendedTextMessage. */
        interface IExtendedTextMessage {

            /** ExtendedTextMessage text */
            text?: (string|null);

            /** ExtendedTextMessage matchedText */
            matchedText?: (string|null);

            /** ExtendedTextMessage canonicalUrl */
            canonicalUrl?: (string|null);

            /** ExtendedTextMessage description */
            description?: (string|null);

            /** ExtendedTextMessage title */
            title?: (string|null);

            /** ExtendedTextMessage textArgb */
            textArgb?: (number|null);

            /** ExtendedTextMessage backgroundArgb */
            backgroundArgb?: (number|null);

            /** ExtendedTextMessage font */
            font?: (proto.Message.ExtendedTextMessage.FontType|null);

            /** ExtendedTextMessage previewType */
            previewType?: (proto.Message.ExtendedTextMessage.PreviewType|null);

            /** ExtendedTextMessage jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** ExtendedTextMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** ExtendedTextMessage doNotPlayInline */
            doNotPlayInline?: (boolean|null);

            /** ExtendedTextMessage thumbnailDirectPath */
            thumbnailDirectPath?: (string|null);

            /** ExtendedTextMessage thumbnailSha256 */
            thumbnailSha256?: (Uint8Array|null);

            /** ExtendedTextMessage thumbnailEncSha256 */
            thumbnailEncSha256?: (Uint8Array|null);

            /** ExtendedTextMessage mediaKey */
            mediaKey?: (Uint8Array|null);

            /** ExtendedTextMessage mediaKeyTimestamp */
            mediaKeyTimestamp?: (number|Long|null);

            /** ExtendedTextMessage thumbnailHeight */
            thumbnailHeight?: (number|null);

            /** ExtendedTextMessage thumbnailWidth */
            thumbnailWidth?: (number|null);

            /** ExtendedTextMessage inviteLinkGroupType */
            inviteLinkGroupType?: (proto.Message.ExtendedTextMessage.InviteLinkGroupType|null);

            /** ExtendedTextMessage inviteLinkParentGroupSubjectV2 */
            inviteLinkParentGroupSubjectV2?: (string|null);

            /** ExtendedTextMessage inviteLinkParentGroupThumbnailV2 */
            inviteLinkParentGroupThumbnailV2?: (Uint8Array|null);

            /** ExtendedTextMessage inviteLinkGroupTypeV2 */
            inviteLinkGroupTypeV2?: (proto.Message.ExtendedTextMessage.InviteLinkGroupType|null);

            /** ExtendedTextMessage viewOnce */
            viewOnce?: (boolean|null);
        }

        /** Represents an ExtendedTextMessage. */
        class ExtendedTextMessage implements IExtendedTextMessage {

            /**
             * Constructs a new ExtendedTextMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IExtendedTextMessage);

            /** ExtendedTextMessage text. */
            public text: string;

            /** ExtendedTextMessage matchedText. */
            public matchedText: string;

            /** ExtendedTextMessage canonicalUrl. */
            public canonicalUrl: string;

            /** ExtendedTextMessage description. */
            public description: string;

            /** ExtendedTextMessage title. */
            public title: string;

            /** ExtendedTextMessage textArgb. */
            public textArgb: number;

            /** ExtendedTextMessage backgroundArgb. */
            public backgroundArgb: number;

            /** ExtendedTextMessage font. */
            public font: proto.Message.ExtendedTextMessage.FontType;

            /** ExtendedTextMessage previewType. */
            public previewType: proto.Message.ExtendedTextMessage.PreviewType;

            /** ExtendedTextMessage jpegThumbnail. */
            public jpegThumbnail: Uint8Array;

            /** ExtendedTextMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** ExtendedTextMessage doNotPlayInline. */
            public doNotPlayInline: boolean;

            /** ExtendedTextMessage thumbnailDirectPath. */
            public thumbnailDirectPath: string;

            /** ExtendedTextMessage thumbnailSha256. */
            public thumbnailSha256: Uint8Array;

            /** ExtendedTextMessage thumbnailEncSha256. */
            public thumbnailEncSha256: Uint8Array;

            /** ExtendedTextMessage mediaKey. */
            public mediaKey: Uint8Array;

            /** ExtendedTextMessage mediaKeyTimestamp. */
            public mediaKeyTimestamp: (number|Long);

            /** ExtendedTextMessage thumbnailHeight. */
            public thumbnailHeight: number;

            /** ExtendedTextMessage thumbnailWidth. */
            public thumbnailWidth: number;

            /** ExtendedTextMessage inviteLinkGroupType. */
            public inviteLinkGroupType: proto.Message.ExtendedTextMessage.InviteLinkGroupType;

            /** ExtendedTextMessage inviteLinkParentGroupSubjectV2. */
            public inviteLinkParentGroupSubjectV2: string;

            /** ExtendedTextMessage inviteLinkParentGroupThumbnailV2. */
            public inviteLinkParentGroupThumbnailV2: Uint8Array;

            /** ExtendedTextMessage inviteLinkGroupTypeV2. */
            public inviteLinkGroupTypeV2: proto.Message.ExtendedTextMessage.InviteLinkGroupType;

            /** ExtendedTextMessage viewOnce. */
            public viewOnce: boolean;

            /**
             * Creates a new ExtendedTextMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ExtendedTextMessage instance
             */
            public static create(properties?: proto.Message.IExtendedTextMessage): proto.Message.ExtendedTextMessage;

            /**
             * Encodes the specified ExtendedTextMessage message. Does not implicitly {@link proto.Message.ExtendedTextMessage.verify|verify} messages.
             * @param message ExtendedTextMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IExtendedTextMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ExtendedTextMessage message, length delimited. Does not implicitly {@link proto.Message.ExtendedTextMessage.verify|verify} messages.
             * @param message ExtendedTextMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IExtendedTextMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an ExtendedTextMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ExtendedTextMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ExtendedTextMessage;

            /**
             * Decodes an ExtendedTextMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ExtendedTextMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ExtendedTextMessage;

            /**
             * Verifies an ExtendedTextMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an ExtendedTextMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ExtendedTextMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ExtendedTextMessage;

            /**
             * Creates a plain object from an ExtendedTextMessage message. Also converts values to other types if specified.
             * @param message ExtendedTextMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ExtendedTextMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ExtendedTextMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace ExtendedTextMessage {

            /** FontType enum. */
            enum FontType {
                SANS_SERIF = 0,
                SERIF = 1,
                NORICAN_REGULAR = 2,
                BRYNDAN_WRITE = 3,
                BEBASNEUE_REGULAR = 4,
                OSWALD_HEAVY = 5
            }

            /** InviteLinkGroupType enum. */
            enum InviteLinkGroupType {
                DEFAULT = 0,
                PARENT = 1,
                SUB = 2,
                DEFAULT_SUB = 3
            }

            /** PreviewType enum. */
            enum PreviewType {
                NONE = 0,
                VIDEO = 1
            }
        }

        /** Properties of a FutureProofMessage. */
        interface IFutureProofMessage {

            /** FutureProofMessage message */
            message?: (proto.IMessage|null);
        }

        /** Represents a FutureProofMessage. */
        class FutureProofMessage implements IFutureProofMessage {

            /**
             * Constructs a new FutureProofMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IFutureProofMessage);

            /** FutureProofMessage message. */
            public message?: (proto.IMessage|null);

            /**
             * Creates a new FutureProofMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns FutureProofMessage instance
             */
            public static create(properties?: proto.Message.IFutureProofMessage): proto.Message.FutureProofMessage;

            /**
             * Encodes the specified FutureProofMessage message. Does not implicitly {@link proto.Message.FutureProofMessage.verify|verify} messages.
             * @param message FutureProofMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IFutureProofMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified FutureProofMessage message, length delimited. Does not implicitly {@link proto.Message.FutureProofMessage.verify|verify} messages.
             * @param message FutureProofMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IFutureProofMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a FutureProofMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns FutureProofMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.FutureProofMessage;

            /**
             * Decodes a FutureProofMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns FutureProofMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.FutureProofMessage;

            /**
             * Verifies a FutureProofMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a FutureProofMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns FutureProofMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.FutureProofMessage;

            /**
             * Creates a plain object from a FutureProofMessage message. Also converts values to other types if specified.
             * @param message FutureProofMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.FutureProofMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this FutureProofMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a GroupInviteMessage. */
        interface IGroupInviteMessage {

            /** GroupInviteMessage groupJid */
            groupJid?: (string|null);

            /** GroupInviteMessage inviteCode */
            inviteCode?: (string|null);

            /** GroupInviteMessage inviteExpiration */
            inviteExpiration?: (number|Long|null);

            /** GroupInviteMessage groupName */
            groupName?: (string|null);

            /** GroupInviteMessage jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** GroupInviteMessage caption */
            caption?: (string|null);

            /** GroupInviteMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** GroupInviteMessage groupType */
            groupType?: (proto.Message.GroupInviteMessage.GroupType|null);
        }

        /** Represents a GroupInviteMessage. */
        class GroupInviteMessage implements IGroupInviteMessage {

            /**
             * Constructs a new GroupInviteMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IGroupInviteMessage);

            /** GroupInviteMessage groupJid. */
            public groupJid: string;

            /** GroupInviteMessage inviteCode. */
            public inviteCode: string;

            /** GroupInviteMessage inviteExpiration. */
            public inviteExpiration: (number|Long);

            /** GroupInviteMessage groupName. */
            public groupName: string;

            /** GroupInviteMessage jpegThumbnail. */
            public jpegThumbnail: Uint8Array;

            /** GroupInviteMessage caption. */
            public caption: string;

            /** GroupInviteMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** GroupInviteMessage groupType. */
            public groupType: proto.Message.GroupInviteMessage.GroupType;

            /**
             * Creates a new GroupInviteMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns GroupInviteMessage instance
             */
            public static create(properties?: proto.Message.IGroupInviteMessage): proto.Message.GroupInviteMessage;

            /**
             * Encodes the specified GroupInviteMessage message. Does not implicitly {@link proto.Message.GroupInviteMessage.verify|verify} messages.
             * @param message GroupInviteMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IGroupInviteMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified GroupInviteMessage message, length delimited. Does not implicitly {@link proto.Message.GroupInviteMessage.verify|verify} messages.
             * @param message GroupInviteMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IGroupInviteMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a GroupInviteMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns GroupInviteMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.GroupInviteMessage;

            /**
             * Decodes a GroupInviteMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns GroupInviteMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.GroupInviteMessage;

            /**
             * Verifies a GroupInviteMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a GroupInviteMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns GroupInviteMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.GroupInviteMessage;

            /**
             * Creates a plain object from a GroupInviteMessage message. Also converts values to other types if specified.
             * @param message GroupInviteMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.GroupInviteMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this GroupInviteMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace GroupInviteMessage {

            /** GroupType enum. */
            enum GroupType {
                DEFAULT = 0,
                PARENT = 1
            }
        }

        /** Properties of a HighlyStructuredMessage. */
        interface IHighlyStructuredMessage {

            /** HighlyStructuredMessage namespace */
            namespace?: (string|null);

            /** HighlyStructuredMessage elementName */
            elementName?: (string|null);

            /** HighlyStructuredMessage params */
            params?: (string[]|null);

            /** HighlyStructuredMessage fallbackLg */
            fallbackLg?: (string|null);

            /** HighlyStructuredMessage fallbackLc */
            fallbackLc?: (string|null);

            /** HighlyStructuredMessage localizableParams */
            localizableParams?: (proto.Message.HighlyStructuredMessage.IHSMLocalizableParameter[]|null);

            /** HighlyStructuredMessage deterministicLg */
            deterministicLg?: (string|null);

            /** HighlyStructuredMessage deterministicLc */
            deterministicLc?: (string|null);

            /** HighlyStructuredMessage hydratedHsm */
            hydratedHsm?: (proto.Message.ITemplateMessage|null);
        }

        /** Represents a HighlyStructuredMessage. */
        class HighlyStructuredMessage implements IHighlyStructuredMessage {

            /**
             * Constructs a new HighlyStructuredMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IHighlyStructuredMessage);

            /** HighlyStructuredMessage namespace. */
            public namespace: string;

            /** HighlyStructuredMessage elementName. */
            public elementName: string;

            /** HighlyStructuredMessage params. */
            public params: string[];

            /** HighlyStructuredMessage fallbackLg. */
            public fallbackLg: string;

            /** HighlyStructuredMessage fallbackLc. */
            public fallbackLc: string;

            /** HighlyStructuredMessage localizableParams. */
            public localizableParams: proto.Message.HighlyStructuredMessage.IHSMLocalizableParameter[];

            /** HighlyStructuredMessage deterministicLg. */
            public deterministicLg: string;

            /** HighlyStructuredMessage deterministicLc. */
            public deterministicLc: string;

            /** HighlyStructuredMessage hydratedHsm. */
            public hydratedHsm?: (proto.Message.ITemplateMessage|null);

            /**
             * Creates a new HighlyStructuredMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HighlyStructuredMessage instance
             */
            public static create(properties?: proto.Message.IHighlyStructuredMessage): proto.Message.HighlyStructuredMessage;

            /**
             * Encodes the specified HighlyStructuredMessage message. Does not implicitly {@link proto.Message.HighlyStructuredMessage.verify|verify} messages.
             * @param message HighlyStructuredMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IHighlyStructuredMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HighlyStructuredMessage message, length delimited. Does not implicitly {@link proto.Message.HighlyStructuredMessage.verify|verify} messages.
             * @param message HighlyStructuredMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IHighlyStructuredMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HighlyStructuredMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HighlyStructuredMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.HighlyStructuredMessage;

            /**
             * Decodes a HighlyStructuredMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HighlyStructuredMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.HighlyStructuredMessage;

            /**
             * Verifies a HighlyStructuredMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HighlyStructuredMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HighlyStructuredMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.HighlyStructuredMessage;

            /**
             * Creates a plain object from a HighlyStructuredMessage message. Also converts values to other types if specified.
             * @param message HighlyStructuredMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.HighlyStructuredMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HighlyStructuredMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace HighlyStructuredMessage {

            /** Properties of a HSMLocalizableParameter. */
            interface IHSMLocalizableParameter {

                /** HSMLocalizableParameter default */
                "default"?: (string|null);

                /** HSMLocalizableParameter currency */
                currency?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMCurrency|null);

                /** HSMLocalizableParameter dateTime */
                dateTime?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMDateTime|null);
            }

            /** Represents a HSMLocalizableParameter. */
            class HSMLocalizableParameter implements IHSMLocalizableParameter {

                /**
                 * Constructs a new HSMLocalizableParameter.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.HighlyStructuredMessage.IHSMLocalizableParameter);

                /** HSMLocalizableParameter default. */
                public default: string;

                /** HSMLocalizableParameter currency. */
                public currency?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMCurrency|null);

                /** HSMLocalizableParameter dateTime. */
                public dateTime?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMDateTime|null);

                /** HSMLocalizableParameter paramOneof. */
                public paramOneof?: ("currency"|"dateTime");

                /**
                 * Creates a new HSMLocalizableParameter instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns HSMLocalizableParameter instance
                 */
                public static create(properties?: proto.Message.HighlyStructuredMessage.IHSMLocalizableParameter): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter;

                /**
                 * Encodes the specified HSMLocalizableParameter message. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.verify|verify} messages.
                 * @param message HSMLocalizableParameter message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.HighlyStructuredMessage.IHSMLocalizableParameter, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified HSMLocalizableParameter message, length delimited. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.verify|verify} messages.
                 * @param message HSMLocalizableParameter message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.HighlyStructuredMessage.IHSMLocalizableParameter, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a HSMLocalizableParameter message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns HSMLocalizableParameter
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter;

                /**
                 * Decodes a HSMLocalizableParameter message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns HSMLocalizableParameter
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter;

                /**
                 * Verifies a HSMLocalizableParameter message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a HSMLocalizableParameter message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns HSMLocalizableParameter
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter;

                /**
                 * Creates a plain object from a HSMLocalizableParameter message. Also converts values to other types if specified.
                 * @param message HSMLocalizableParameter
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this HSMLocalizableParameter to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace HSMLocalizableParameter {

                /** Properties of a HSMCurrency. */
                interface IHSMCurrency {

                    /** HSMCurrency currencyCode */
                    currencyCode?: (string|null);

                    /** HSMCurrency amount1000 */
                    amount1000?: (number|Long|null);
                }

                /** Represents a HSMCurrency. */
                class HSMCurrency implements IHSMCurrency {

                    /**
                     * Constructs a new HSMCurrency.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMCurrency);

                    /** HSMCurrency currencyCode. */
                    public currencyCode: string;

                    /** HSMCurrency amount1000. */
                    public amount1000: (number|Long);

                    /**
                     * Creates a new HSMCurrency instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns HSMCurrency instance
                     */
                    public static create(properties?: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMCurrency): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency;

                    /**
                     * Encodes the specified HSMCurrency message. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency.verify|verify} messages.
                     * @param message HSMCurrency message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMCurrency, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified HSMCurrency message, length delimited. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency.verify|verify} messages.
                     * @param message HSMCurrency message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMCurrency, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a HSMCurrency message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns HSMCurrency
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency;

                    /**
                     * Decodes a HSMCurrency message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns HSMCurrency
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency;

                    /**
                     * Verifies a HSMCurrency message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a HSMCurrency message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns HSMCurrency
                     */
                    public static fromObject(object: { [k: string]: any }): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency;

                    /**
                     * Creates a plain object from a HSMCurrency message. Also converts values to other types if specified.
                     * @param message HSMCurrency
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this HSMCurrency to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a HSMDateTime. */
                interface IHSMDateTime {

                    /** HSMDateTime component */
                    component?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeComponent|null);

                    /** HSMDateTime unixEpoch */
                    unixEpoch?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeUnixEpoch|null);
                }

                /** Represents a HSMDateTime. */
                class HSMDateTime implements IHSMDateTime {

                    /**
                     * Constructs a new HSMDateTime.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMDateTime);

                    /** HSMDateTime component. */
                    public component?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeComponent|null);

                    /** HSMDateTime unixEpoch. */
                    public unixEpoch?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeUnixEpoch|null);

                    /** HSMDateTime datetimeOneof. */
                    public datetimeOneof?: ("component"|"unixEpoch");

                    /**
                     * Creates a new HSMDateTime instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns HSMDateTime instance
                     */
                    public static create(properties?: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMDateTime): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime;

                    /**
                     * Encodes the specified HSMDateTime message. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.verify|verify} messages.
                     * @param message HSMDateTime message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMDateTime, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified HSMDateTime message, length delimited. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.verify|verify} messages.
                     * @param message HSMDateTime message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.IHSMDateTime, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a HSMDateTime message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns HSMDateTime
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime;

                    /**
                     * Decodes a HSMDateTime message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns HSMDateTime
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime;

                    /**
                     * Verifies a HSMDateTime message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a HSMDateTime message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns HSMDateTime
                     */
                    public static fromObject(object: { [k: string]: any }): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime;

                    /**
                     * Creates a plain object from a HSMDateTime message. Also converts values to other types if specified.
                     * @param message HSMDateTime
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this HSMDateTime to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace HSMDateTime {

                    /** Properties of a HSMDateTimeComponent. */
                    interface IHSMDateTimeComponent {

                        /** HSMDateTimeComponent dayOfWeek */
                        dayOfWeek?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent.DayOfWeekType|null);

                        /** HSMDateTimeComponent year */
                        year?: (number|null);

                        /** HSMDateTimeComponent month */
                        month?: (number|null);

                        /** HSMDateTimeComponent dayOfMonth */
                        dayOfMonth?: (number|null);

                        /** HSMDateTimeComponent hour */
                        hour?: (number|null);

                        /** HSMDateTimeComponent minute */
                        minute?: (number|null);

                        /** HSMDateTimeComponent calendar */
                        calendar?: (proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent.CalendarType|null);
                    }

                    /** Represents a HSMDateTimeComponent. */
                    class HSMDateTimeComponent implements IHSMDateTimeComponent {

                        /**
                         * Constructs a new HSMDateTimeComponent.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeComponent);

                        /** HSMDateTimeComponent dayOfWeek. */
                        public dayOfWeek: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent.DayOfWeekType;

                        /** HSMDateTimeComponent year. */
                        public year: number;

                        /** HSMDateTimeComponent month. */
                        public month: number;

                        /** HSMDateTimeComponent dayOfMonth. */
                        public dayOfMonth: number;

                        /** HSMDateTimeComponent hour. */
                        public hour: number;

                        /** HSMDateTimeComponent minute. */
                        public minute: number;

                        /** HSMDateTimeComponent calendar. */
                        public calendar: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent.CalendarType;

                        /**
                         * Creates a new HSMDateTimeComponent instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns HSMDateTimeComponent instance
                         */
                        public static create(properties?: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeComponent): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent;

                        /**
                         * Encodes the specified HSMDateTimeComponent message. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent.verify|verify} messages.
                         * @param message HSMDateTimeComponent message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeComponent, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified HSMDateTimeComponent message, length delimited. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent.verify|verify} messages.
                         * @param message HSMDateTimeComponent message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeComponent, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a HSMDateTimeComponent message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns HSMDateTimeComponent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent;

                        /**
                         * Decodes a HSMDateTimeComponent message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns HSMDateTimeComponent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent;

                        /**
                         * Verifies a HSMDateTimeComponent message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a HSMDateTimeComponent message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns HSMDateTimeComponent
                         */
                        public static fromObject(object: { [k: string]: any }): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent;

                        /**
                         * Creates a plain object from a HSMDateTimeComponent message. Also converts values to other types if specified.
                         * @param message HSMDateTimeComponent
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this HSMDateTimeComponent to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    namespace HSMDateTimeComponent {

                        /** CalendarType enum. */
                        enum CalendarType {
                            GREGORIAN = 1,
                            SOLAR_HIJRI = 2
                        }

                        /** DayOfWeekType enum. */
                        enum DayOfWeekType {
                            MONDAY = 1,
                            TUESDAY = 2,
                            WEDNESDAY = 3,
                            THURSDAY = 4,
                            FRIDAY = 5,
                            SATURDAY = 6,
                            SUNDAY = 7
                        }
                    }

                    /** Properties of a HSMDateTimeUnixEpoch. */
                    interface IHSMDateTimeUnixEpoch {

                        /** HSMDateTimeUnixEpoch timestamp */
                        timestamp?: (number|Long|null);
                    }

                    /** Represents a HSMDateTimeUnixEpoch. */
                    class HSMDateTimeUnixEpoch implements IHSMDateTimeUnixEpoch {

                        /**
                         * Constructs a new HSMDateTimeUnixEpoch.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeUnixEpoch);

                        /** HSMDateTimeUnixEpoch timestamp. */
                        public timestamp: (number|Long);

                        /**
                         * Creates a new HSMDateTimeUnixEpoch instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns HSMDateTimeUnixEpoch instance
                         */
                        public static create(properties?: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeUnixEpoch): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch;

                        /**
                         * Encodes the specified HSMDateTimeUnixEpoch message. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch.verify|verify} messages.
                         * @param message HSMDateTimeUnixEpoch message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeUnixEpoch, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified HSMDateTimeUnixEpoch message, length delimited. Does not implicitly {@link proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch.verify|verify} messages.
                         * @param message HSMDateTimeUnixEpoch message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.IHSMDateTimeUnixEpoch, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a HSMDateTimeUnixEpoch message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns HSMDateTimeUnixEpoch
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch;

                        /**
                         * Decodes a HSMDateTimeUnixEpoch message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns HSMDateTimeUnixEpoch
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch;

                        /**
                         * Verifies a HSMDateTimeUnixEpoch message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a HSMDateTimeUnixEpoch message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns HSMDateTimeUnixEpoch
                         */
                        public static fromObject(object: { [k: string]: any }): proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch;

                        /**
                         * Creates a plain object from a HSMDateTimeUnixEpoch message. Also converts values to other types if specified.
                         * @param message HSMDateTimeUnixEpoch
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this HSMDateTimeUnixEpoch to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }
                }
            }
        }

        /** Properties of a HistorySyncNotification. */
        interface IHistorySyncNotification {

            /** HistorySyncNotification fileSha256 */
            fileSha256?: (Uint8Array|null);

            /** HistorySyncNotification fileLength */
            fileLength?: (number|Long|null);

            /** HistorySyncNotification mediaKey */
            mediaKey?: (Uint8Array|null);

            /** HistorySyncNotification fileEncSha256 */
            fileEncSha256?: (Uint8Array|null);

            /** HistorySyncNotification directPath */
            directPath?: (string|null);

            /** HistorySyncNotification syncType */
            syncType?: (proto.Message.HistorySyncNotification.HistorySyncType|null);

            /** HistorySyncNotification chunkOrder */
            chunkOrder?: (number|null);

            /** HistorySyncNotification originalMessageId */
            originalMessageId?: (string|null);

            /** HistorySyncNotification progress */
            progress?: (number|null);

            /** HistorySyncNotification oldestMsgInChunkTimestampSec */
            oldestMsgInChunkTimestampSec?: (number|Long|null);
        }

        /** Represents a HistorySyncNotification. */
        class HistorySyncNotification implements IHistorySyncNotification {

            /**
             * Constructs a new HistorySyncNotification.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IHistorySyncNotification);

            /** HistorySyncNotification fileSha256. */
            public fileSha256: Uint8Array;

            /** HistorySyncNotification fileLength. */
            public fileLength: (number|Long);

            /** HistorySyncNotification mediaKey. */
            public mediaKey: Uint8Array;

            /** HistorySyncNotification fileEncSha256. */
            public fileEncSha256: Uint8Array;

            /** HistorySyncNotification directPath. */
            public directPath: string;

            /** HistorySyncNotification syncType. */
            public syncType: proto.Message.HistorySyncNotification.HistorySyncType;

            /** HistorySyncNotification chunkOrder. */
            public chunkOrder: number;

            /** HistorySyncNotification originalMessageId. */
            public originalMessageId: string;

            /** HistorySyncNotification progress. */
            public progress: number;

            /** HistorySyncNotification oldestMsgInChunkTimestampSec. */
            public oldestMsgInChunkTimestampSec: (number|Long);

            /**
             * Creates a new HistorySyncNotification instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HistorySyncNotification instance
             */
            public static create(properties?: proto.Message.IHistorySyncNotification): proto.Message.HistorySyncNotification;

            /**
             * Encodes the specified HistorySyncNotification message. Does not implicitly {@link proto.Message.HistorySyncNotification.verify|verify} messages.
             * @param message HistorySyncNotification message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IHistorySyncNotification, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HistorySyncNotification message, length delimited. Does not implicitly {@link proto.Message.HistorySyncNotification.verify|verify} messages.
             * @param message HistorySyncNotification message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IHistorySyncNotification, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HistorySyncNotification message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HistorySyncNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.HistorySyncNotification;

            /**
             * Decodes a HistorySyncNotification message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HistorySyncNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.HistorySyncNotification;

            /**
             * Verifies a HistorySyncNotification message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HistorySyncNotification message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HistorySyncNotification
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.HistorySyncNotification;

            /**
             * Creates a plain object from a HistorySyncNotification message. Also converts values to other types if specified.
             * @param message HistorySyncNotification
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.HistorySyncNotification, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HistorySyncNotification to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace HistorySyncNotification {

            /** HistorySyncType enum. */
            enum HistorySyncType {
                INITIAL_BOOTSTRAP = 0,
                INITIAL_STATUS_V3 = 1,
                FULL = 2,
                RECENT = 3,
                PUSH_NAME = 4,
                NON_BLOCKING_DATA = 5
            }
        }

        /** Properties of an ImageMessage. */
        interface IImageMessage {

            /** ImageMessage url */
            url?: (string|null);

            /** ImageMessage mimetype */
            mimetype?: (string|null);

            /** ImageMessage caption */
            caption?: (string|null);

            /** ImageMessage fileSha256 */
            fileSha256?: (Uint8Array|null);

            /** ImageMessage fileLength */
            fileLength?: (number|Long|null);

            /** ImageMessage height */
            height?: (number|null);

            /** ImageMessage width */
            width?: (number|null);

            /** ImageMessage mediaKey */
            mediaKey?: (Uint8Array|null);

            /** ImageMessage fileEncSha256 */
            fileEncSha256?: (Uint8Array|null);

            /** ImageMessage interactiveAnnotations */
            interactiveAnnotations?: (proto.IInteractiveAnnotation[]|null);

            /** ImageMessage directPath */
            directPath?: (string|null);

            /** ImageMessage mediaKeyTimestamp */
            mediaKeyTimestamp?: (number|Long|null);

            /** ImageMessage jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** ImageMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** ImageMessage firstScanSidecar */
            firstScanSidecar?: (Uint8Array|null);

            /** ImageMessage firstScanLength */
            firstScanLength?: (number|null);

            /** ImageMessage experimentGroupId */
            experimentGroupId?: (number|null);

            /** ImageMessage scansSidecar */
            scansSidecar?: (Uint8Array|null);

            /** ImageMessage scanLengths */
            scanLengths?: (number[]|null);

            /** ImageMessage midQualityFileSha256 */
            midQualityFileSha256?: (Uint8Array|null);

            /** ImageMessage midQualityFileEncSha256 */
            midQualityFileEncSha256?: (Uint8Array|null);

            /** ImageMessage viewOnce */
            viewOnce?: (boolean|null);

            /** ImageMessage thumbnailDirectPath */
            thumbnailDirectPath?: (string|null);

            /** ImageMessage thumbnailSha256 */
            thumbnailSha256?: (Uint8Array|null);

            /** ImageMessage thumbnailEncSha256 */
            thumbnailEncSha256?: (Uint8Array|null);

            /** ImageMessage staticUrl */
            staticUrl?: (string|null);
        }

        /** Represents an ImageMessage. */
        class ImageMessage implements IImageMessage {

            /**
             * Constructs a new ImageMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IImageMessage);

            /** ImageMessage url. */
            public url: string;

            /** ImageMessage mimetype. */
            public mimetype: string;

            /** ImageMessage caption. */
            public caption: string;

            /** ImageMessage fileSha256. */
            public fileSha256: Uint8Array;

            /** ImageMessage fileLength. */
            public fileLength: (number|Long);

            /** ImageMessage height. */
            public height: number;

            /** ImageMessage width. */
            public width: number;

            /** ImageMessage mediaKey. */
            public mediaKey: Uint8Array;

            /** ImageMessage fileEncSha256. */
            public fileEncSha256: Uint8Array;

            /** ImageMessage interactiveAnnotations. */
            public interactiveAnnotations: proto.IInteractiveAnnotation[];

            /** ImageMessage directPath. */
            public directPath: string;

            /** ImageMessage mediaKeyTimestamp. */
            public mediaKeyTimestamp: (number|Long);

            /** ImageMessage jpegThumbnail. */
            public jpegThumbnail: Uint8Array;

            /** ImageMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** ImageMessage firstScanSidecar. */
            public firstScanSidecar: Uint8Array;

            /** ImageMessage firstScanLength. */
            public firstScanLength: number;

            /** ImageMessage experimentGroupId. */
            public experimentGroupId: number;

            /** ImageMessage scansSidecar. */
            public scansSidecar: Uint8Array;

            /** ImageMessage scanLengths. */
            public scanLengths: number[];

            /** ImageMessage midQualityFileSha256. */
            public midQualityFileSha256: Uint8Array;

            /** ImageMessage midQualityFileEncSha256. */
            public midQualityFileEncSha256: Uint8Array;

            /** ImageMessage viewOnce. */
            public viewOnce: boolean;

            /** ImageMessage thumbnailDirectPath. */
            public thumbnailDirectPath: string;

            /** ImageMessage thumbnailSha256. */
            public thumbnailSha256: Uint8Array;

            /** ImageMessage thumbnailEncSha256. */
            public thumbnailEncSha256: Uint8Array;

            /** ImageMessage staticUrl. */
            public staticUrl: string;

            /**
             * Creates a new ImageMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ImageMessage instance
             */
            public static create(properties?: proto.Message.IImageMessage): proto.Message.ImageMessage;

            /**
             * Encodes the specified ImageMessage message. Does not implicitly {@link proto.Message.ImageMessage.verify|verify} messages.
             * @param message ImageMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IImageMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ImageMessage message, length delimited. Does not implicitly {@link proto.Message.ImageMessage.verify|verify} messages.
             * @param message ImageMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IImageMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an ImageMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ImageMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ImageMessage;

            /**
             * Decodes an ImageMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ImageMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ImageMessage;

            /**
             * Verifies an ImageMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an ImageMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ImageMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ImageMessage;

            /**
             * Creates a plain object from an ImageMessage message. Also converts values to other types if specified.
             * @param message ImageMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ImageMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ImageMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an InitialSecurityNotificationSettingSync. */
        interface IInitialSecurityNotificationSettingSync {

            /** InitialSecurityNotificationSettingSync securityNotificationEnabled */
            securityNotificationEnabled?: (boolean|null);
        }

        /** Represents an InitialSecurityNotificationSettingSync. */
        class InitialSecurityNotificationSettingSync implements IInitialSecurityNotificationSettingSync {

            /**
             * Constructs a new InitialSecurityNotificationSettingSync.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IInitialSecurityNotificationSettingSync);

            /** InitialSecurityNotificationSettingSync securityNotificationEnabled. */
            public securityNotificationEnabled: boolean;

            /**
             * Creates a new InitialSecurityNotificationSettingSync instance using the specified properties.
             * @param [properties] Properties to set
             * @returns InitialSecurityNotificationSettingSync instance
             */
            public static create(properties?: proto.Message.IInitialSecurityNotificationSettingSync): proto.Message.InitialSecurityNotificationSettingSync;

            /**
             * Encodes the specified InitialSecurityNotificationSettingSync message. Does not implicitly {@link proto.Message.InitialSecurityNotificationSettingSync.verify|verify} messages.
             * @param message InitialSecurityNotificationSettingSync message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IInitialSecurityNotificationSettingSync, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified InitialSecurityNotificationSettingSync message, length delimited. Does not implicitly {@link proto.Message.InitialSecurityNotificationSettingSync.verify|verify} messages.
             * @param message InitialSecurityNotificationSettingSync message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IInitialSecurityNotificationSettingSync, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an InitialSecurityNotificationSettingSync message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns InitialSecurityNotificationSettingSync
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InitialSecurityNotificationSettingSync;

            /**
             * Decodes an InitialSecurityNotificationSettingSync message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns InitialSecurityNotificationSettingSync
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InitialSecurityNotificationSettingSync;

            /**
             * Verifies an InitialSecurityNotificationSettingSync message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an InitialSecurityNotificationSettingSync message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns InitialSecurityNotificationSettingSync
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.InitialSecurityNotificationSettingSync;

            /**
             * Creates a plain object from an InitialSecurityNotificationSettingSync message. Also converts values to other types if specified.
             * @param message InitialSecurityNotificationSettingSync
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.InitialSecurityNotificationSettingSync, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this InitialSecurityNotificationSettingSync to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an InteractiveMessage. */
        interface IInteractiveMessage {

            /** InteractiveMessage header */
            header?: (proto.Message.InteractiveMessage.IHeader|null);

            /** InteractiveMessage body */
            body?: (proto.Message.InteractiveMessage.IBody|null);

            /** InteractiveMessage footer */
            footer?: (proto.Message.InteractiveMessage.IFooter|null);

            /** InteractiveMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** InteractiveMessage shopStorefrontMessage */
            shopStorefrontMessage?: (proto.Message.InteractiveMessage.IShopMessage|null);

            /** InteractiveMessage collectionMessage */
            collectionMessage?: (proto.Message.InteractiveMessage.ICollectionMessage|null);

            /** InteractiveMessage nativeFlowMessage */
            nativeFlowMessage?: (proto.Message.InteractiveMessage.INativeFlowMessage|null);
        }

        /** Represents an InteractiveMessage. */
        class InteractiveMessage implements IInteractiveMessage {

            /**
             * Constructs a new InteractiveMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IInteractiveMessage);

            /** InteractiveMessage header. */
            public header?: (proto.Message.InteractiveMessage.IHeader|null);

            /** InteractiveMessage body. */
            public body?: (proto.Message.InteractiveMessage.IBody|null);

            /** InteractiveMessage footer. */
            public footer?: (proto.Message.InteractiveMessage.IFooter|null);

            /** InteractiveMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** InteractiveMessage shopStorefrontMessage. */
            public shopStorefrontMessage?: (proto.Message.InteractiveMessage.IShopMessage|null);

            /** InteractiveMessage collectionMessage. */
            public collectionMessage?: (proto.Message.InteractiveMessage.ICollectionMessage|null);

            /** InteractiveMessage nativeFlowMessage. */
            public nativeFlowMessage?: (proto.Message.InteractiveMessage.INativeFlowMessage|null);

            /** InteractiveMessage interactiveMessage. */
            public interactiveMessage?: ("shopStorefrontMessage"|"collectionMessage"|"nativeFlowMessage");

            /**
             * Creates a new InteractiveMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns InteractiveMessage instance
             */
            public static create(properties?: proto.Message.IInteractiveMessage): proto.Message.InteractiveMessage;

            /**
             * Encodes the specified InteractiveMessage message. Does not implicitly {@link proto.Message.InteractiveMessage.verify|verify} messages.
             * @param message InteractiveMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IInteractiveMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified InteractiveMessage message, length delimited. Does not implicitly {@link proto.Message.InteractiveMessage.verify|verify} messages.
             * @param message InteractiveMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IInteractiveMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an InteractiveMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns InteractiveMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveMessage;

            /**
             * Decodes an InteractiveMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns InteractiveMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveMessage;

            /**
             * Verifies an InteractiveMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an InteractiveMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns InteractiveMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveMessage;

            /**
             * Creates a plain object from an InteractiveMessage message. Also converts values to other types if specified.
             * @param message InteractiveMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.InteractiveMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this InteractiveMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace InteractiveMessage {

            /** Properties of a Body. */
            interface IBody {

                /** Body text */
                text?: (string|null);
            }

            /** Represents a Body. */
            class Body implements IBody {

                /**
                 * Constructs a new Body.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.InteractiveMessage.IBody);

                /** Body text. */
                public text: string;

                /**
                 * Creates a new Body instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Body instance
                 */
                public static create(properties?: proto.Message.InteractiveMessage.IBody): proto.Message.InteractiveMessage.Body;

                /**
                 * Encodes the specified Body message. Does not implicitly {@link proto.Message.InteractiveMessage.Body.verify|verify} messages.
                 * @param message Body message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.InteractiveMessage.IBody, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Body message, length delimited. Does not implicitly {@link proto.Message.InteractiveMessage.Body.verify|verify} messages.
                 * @param message Body message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.InteractiveMessage.IBody, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Body message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Body
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveMessage.Body;

                /**
                 * Decodes a Body message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Body
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveMessage.Body;

                /**
                 * Verifies a Body message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Body message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Body
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveMessage.Body;

                /**
                 * Creates a plain object from a Body message. Also converts values to other types if specified.
                 * @param message Body
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.InteractiveMessage.Body, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Body to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a CollectionMessage. */
            interface ICollectionMessage {

                /** CollectionMessage bizJid */
                bizJid?: (string|null);

                /** CollectionMessage id */
                id?: (string|null);

                /** CollectionMessage messageVersion */
                messageVersion?: (number|null);
            }

            /** Represents a CollectionMessage. */
            class CollectionMessage implements ICollectionMessage {

                /**
                 * Constructs a new CollectionMessage.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.InteractiveMessage.ICollectionMessage);

                /** CollectionMessage bizJid. */
                public bizJid: string;

                /** CollectionMessage id. */
                public id: string;

                /** CollectionMessage messageVersion. */
                public messageVersion: number;

                /**
                 * Creates a new CollectionMessage instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns CollectionMessage instance
                 */
                public static create(properties?: proto.Message.InteractiveMessage.ICollectionMessage): proto.Message.InteractiveMessage.CollectionMessage;

                /**
                 * Encodes the specified CollectionMessage message. Does not implicitly {@link proto.Message.InteractiveMessage.CollectionMessage.verify|verify} messages.
                 * @param message CollectionMessage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.InteractiveMessage.ICollectionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified CollectionMessage message, length delimited. Does not implicitly {@link proto.Message.InteractiveMessage.CollectionMessage.verify|verify} messages.
                 * @param message CollectionMessage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.InteractiveMessage.ICollectionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a CollectionMessage message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns CollectionMessage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveMessage.CollectionMessage;

                /**
                 * Decodes a CollectionMessage message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns CollectionMessage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveMessage.CollectionMessage;

                /**
                 * Verifies a CollectionMessage message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a CollectionMessage message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns CollectionMessage
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveMessage.CollectionMessage;

                /**
                 * Creates a plain object from a CollectionMessage message. Also converts values to other types if specified.
                 * @param message CollectionMessage
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.InteractiveMessage.CollectionMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this CollectionMessage to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a Footer. */
            interface IFooter {

                /** Footer text */
                text?: (string|null);
            }

            /** Represents a Footer. */
            class Footer implements IFooter {

                /**
                 * Constructs a new Footer.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.InteractiveMessage.IFooter);

                /** Footer text. */
                public text: string;

                /**
                 * Creates a new Footer instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Footer instance
                 */
                public static create(properties?: proto.Message.InteractiveMessage.IFooter): proto.Message.InteractiveMessage.Footer;

                /**
                 * Encodes the specified Footer message. Does not implicitly {@link proto.Message.InteractiveMessage.Footer.verify|verify} messages.
                 * @param message Footer message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.InteractiveMessage.IFooter, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Footer message, length delimited. Does not implicitly {@link proto.Message.InteractiveMessage.Footer.verify|verify} messages.
                 * @param message Footer message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.InteractiveMessage.IFooter, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Footer message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Footer
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveMessage.Footer;

                /**
                 * Decodes a Footer message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Footer
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveMessage.Footer;

                /**
                 * Verifies a Footer message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Footer message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Footer
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveMessage.Footer;

                /**
                 * Creates a plain object from a Footer message. Also converts values to other types if specified.
                 * @param message Footer
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.InteractiveMessage.Footer, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Footer to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a Header. */
            interface IHeader {

                /** Header title */
                title?: (string|null);

                /** Header subtitle */
                subtitle?: (string|null);

                /** Header hasMediaAttachment */
                hasMediaAttachment?: (boolean|null);

                /** Header documentMessage */
                documentMessage?: (proto.Message.IDocumentMessage|null);

                /** Header imageMessage */
                imageMessage?: (proto.Message.IImageMessage|null);

                /** Header jpegThumbnail */
                jpegThumbnail?: (Uint8Array|null);

                /** Header videoMessage */
                videoMessage?: (proto.Message.IVideoMessage|null);
            }

            /** Represents a Header. */
            class Header implements IHeader {

                /**
                 * Constructs a new Header.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.InteractiveMessage.IHeader);

                /** Header title. */
                public title: string;

                /** Header subtitle. */
                public subtitle: string;

                /** Header hasMediaAttachment. */
                public hasMediaAttachment: boolean;

                /** Header documentMessage. */
                public documentMessage?: (proto.Message.IDocumentMessage|null);

                /** Header imageMessage. */
                public imageMessage?: (proto.Message.IImageMessage|null);

                /** Header jpegThumbnail. */
                public jpegThumbnail?: (Uint8Array|null);

                /** Header videoMessage. */
                public videoMessage?: (proto.Message.IVideoMessage|null);

                /** Header media. */
                public media?: ("documentMessage"|"imageMessage"|"jpegThumbnail"|"videoMessage");

                /**
                 * Creates a new Header instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Header instance
                 */
                public static create(properties?: proto.Message.InteractiveMessage.IHeader): proto.Message.InteractiveMessage.Header;

                /**
                 * Encodes the specified Header message. Does not implicitly {@link proto.Message.InteractiveMessage.Header.verify|verify} messages.
                 * @param message Header message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.InteractiveMessage.IHeader, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Header message, length delimited. Does not implicitly {@link proto.Message.InteractiveMessage.Header.verify|verify} messages.
                 * @param message Header message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.InteractiveMessage.IHeader, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Header message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Header
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveMessage.Header;

                /**
                 * Decodes a Header message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Header
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveMessage.Header;

                /**
                 * Verifies a Header message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Header message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Header
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveMessage.Header;

                /**
                 * Creates a plain object from a Header message. Also converts values to other types if specified.
                 * @param message Header
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.InteractiveMessage.Header, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Header to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a NativeFlowMessage. */
            interface INativeFlowMessage {

                /** NativeFlowMessage buttons */
                buttons?: (proto.Message.InteractiveMessage.NativeFlowMessage.INativeFlowButton[]|null);

                /** NativeFlowMessage messageParamsJson */
                messageParamsJson?: (string|null);

                /** NativeFlowMessage messageVersion */
                messageVersion?: (number|null);
            }

            /** Represents a NativeFlowMessage. */
            class NativeFlowMessage implements INativeFlowMessage {

                /**
                 * Constructs a new NativeFlowMessage.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.InteractiveMessage.INativeFlowMessage);

                /** NativeFlowMessage buttons. */
                public buttons: proto.Message.InteractiveMessage.NativeFlowMessage.INativeFlowButton[];

                /** NativeFlowMessage messageParamsJson. */
                public messageParamsJson: string;

                /** NativeFlowMessage messageVersion. */
                public messageVersion: number;

                /**
                 * Creates a new NativeFlowMessage instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns NativeFlowMessage instance
                 */
                public static create(properties?: proto.Message.InteractiveMessage.INativeFlowMessage): proto.Message.InteractiveMessage.NativeFlowMessage;

                /**
                 * Encodes the specified NativeFlowMessage message. Does not implicitly {@link proto.Message.InteractiveMessage.NativeFlowMessage.verify|verify} messages.
                 * @param message NativeFlowMessage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.InteractiveMessage.INativeFlowMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified NativeFlowMessage message, length delimited. Does not implicitly {@link proto.Message.InteractiveMessage.NativeFlowMessage.verify|verify} messages.
                 * @param message NativeFlowMessage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.InteractiveMessage.INativeFlowMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a NativeFlowMessage message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns NativeFlowMessage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveMessage.NativeFlowMessage;

                /**
                 * Decodes a NativeFlowMessage message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns NativeFlowMessage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveMessage.NativeFlowMessage;

                /**
                 * Verifies a NativeFlowMessage message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a NativeFlowMessage message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns NativeFlowMessage
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveMessage.NativeFlowMessage;

                /**
                 * Creates a plain object from a NativeFlowMessage message. Also converts values to other types if specified.
                 * @param message NativeFlowMessage
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.InteractiveMessage.NativeFlowMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this NativeFlowMessage to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace NativeFlowMessage {

                /** Properties of a NativeFlowButton. */
                interface INativeFlowButton {

                    /** NativeFlowButton name */
                    name?: (string|null);

                    /** NativeFlowButton buttonParamsJson */
                    buttonParamsJson?: (string|null);
                }

                /** Represents a NativeFlowButton. */
                class NativeFlowButton implements INativeFlowButton {

                    /**
                     * Constructs a new NativeFlowButton.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: proto.Message.InteractiveMessage.NativeFlowMessage.INativeFlowButton);

                    /** NativeFlowButton name. */
                    public name: string;

                    /** NativeFlowButton buttonParamsJson. */
                    public buttonParamsJson: string;

                    /**
                     * Creates a new NativeFlowButton instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns NativeFlowButton instance
                     */
                    public static create(properties?: proto.Message.InteractiveMessage.NativeFlowMessage.INativeFlowButton): proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton;

                    /**
                     * Encodes the specified NativeFlowButton message. Does not implicitly {@link proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton.verify|verify} messages.
                     * @param message NativeFlowButton message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: proto.Message.InteractiveMessage.NativeFlowMessage.INativeFlowButton, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified NativeFlowButton message, length delimited. Does not implicitly {@link proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton.verify|verify} messages.
                     * @param message NativeFlowButton message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: proto.Message.InteractiveMessage.NativeFlowMessage.INativeFlowButton, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a NativeFlowButton message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns NativeFlowButton
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton;

                    /**
                     * Decodes a NativeFlowButton message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns NativeFlowButton
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton;

                    /**
                     * Verifies a NativeFlowButton message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a NativeFlowButton message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns NativeFlowButton
                     */
                    public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton;

                    /**
                     * Creates a plain object from a NativeFlowButton message. Also converts values to other types if specified.
                     * @param message NativeFlowButton
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this NativeFlowButton to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }
            }

            /** Properties of a ShopMessage. */
            interface IShopMessage {

                /** ShopMessage id */
                id?: (string|null);

                /** ShopMessage surface */
                surface?: (proto.Message.InteractiveMessage.ShopMessage.Surface|null);

                /** ShopMessage messageVersion */
                messageVersion?: (number|null);
            }

            /** Represents a ShopMessage. */
            class ShopMessage implements IShopMessage {

                /**
                 * Constructs a new ShopMessage.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.InteractiveMessage.IShopMessage);

                /** ShopMessage id. */
                public id: string;

                /** ShopMessage surface. */
                public surface: proto.Message.InteractiveMessage.ShopMessage.Surface;

                /** ShopMessage messageVersion. */
                public messageVersion: number;

                /**
                 * Creates a new ShopMessage instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns ShopMessage instance
                 */
                public static create(properties?: proto.Message.InteractiveMessage.IShopMessage): proto.Message.InteractiveMessage.ShopMessage;

                /**
                 * Encodes the specified ShopMessage message. Does not implicitly {@link proto.Message.InteractiveMessage.ShopMessage.verify|verify} messages.
                 * @param message ShopMessage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.InteractiveMessage.IShopMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified ShopMessage message, length delimited. Does not implicitly {@link proto.Message.InteractiveMessage.ShopMessage.verify|verify} messages.
                 * @param message ShopMessage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.InteractiveMessage.IShopMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a ShopMessage message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns ShopMessage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveMessage.ShopMessage;

                /**
                 * Decodes a ShopMessage message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns ShopMessage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveMessage.ShopMessage;

                /**
                 * Verifies a ShopMessage message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a ShopMessage message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns ShopMessage
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveMessage.ShopMessage;

                /**
                 * Creates a plain object from a ShopMessage message. Also converts values to other types if specified.
                 * @param message ShopMessage
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.InteractiveMessage.ShopMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this ShopMessage to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace ShopMessage {

                /** Surface enum. */
                enum Surface {
                    UNKNOWN_SURFACE = 0,
                    FB = 1,
                    IG = 2,
                    WA = 3
                }
            }
        }

        /** Properties of an InteractiveResponseMessage. */
        interface IInteractiveResponseMessage {

            /** InteractiveResponseMessage body */
            body?: (proto.Message.InteractiveResponseMessage.IBody|null);

            /** InteractiveResponseMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** InteractiveResponseMessage nativeFlowResponseMessage */
            nativeFlowResponseMessage?: (proto.Message.InteractiveResponseMessage.INativeFlowResponseMessage|null);
        }

        /** Represents an InteractiveResponseMessage. */
        class InteractiveResponseMessage implements IInteractiveResponseMessage {

            /**
             * Constructs a new InteractiveResponseMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IInteractiveResponseMessage);

            /** InteractiveResponseMessage body. */
            public body?: (proto.Message.InteractiveResponseMessage.IBody|null);

            /** InteractiveResponseMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** InteractiveResponseMessage nativeFlowResponseMessage. */
            public nativeFlowResponseMessage?: (proto.Message.InteractiveResponseMessage.INativeFlowResponseMessage|null);

            /** InteractiveResponseMessage interactiveResponseMessage. */
            public interactiveResponseMessage?: "nativeFlowResponseMessage";

            /**
             * Creates a new InteractiveResponseMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns InteractiveResponseMessage instance
             */
            public static create(properties?: proto.Message.IInteractiveResponseMessage): proto.Message.InteractiveResponseMessage;

            /**
             * Encodes the specified InteractiveResponseMessage message. Does not implicitly {@link proto.Message.InteractiveResponseMessage.verify|verify} messages.
             * @param message InteractiveResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IInteractiveResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified InteractiveResponseMessage message, length delimited. Does not implicitly {@link proto.Message.InteractiveResponseMessage.verify|verify} messages.
             * @param message InteractiveResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IInteractiveResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an InteractiveResponseMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns InteractiveResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveResponseMessage;

            /**
             * Decodes an InteractiveResponseMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns InteractiveResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveResponseMessage;

            /**
             * Verifies an InteractiveResponseMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an InteractiveResponseMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns InteractiveResponseMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveResponseMessage;

            /**
             * Creates a plain object from an InteractiveResponseMessage message. Also converts values to other types if specified.
             * @param message InteractiveResponseMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.InteractiveResponseMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this InteractiveResponseMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace InteractiveResponseMessage {

            /** Properties of a Body. */
            interface IBody {

                /** Body text */
                text?: (string|null);
            }

            /** Represents a Body. */
            class Body implements IBody {

                /**
                 * Constructs a new Body.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.InteractiveResponseMessage.IBody);

                /** Body text. */
                public text: string;

                /**
                 * Creates a new Body instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Body instance
                 */
                public static create(properties?: proto.Message.InteractiveResponseMessage.IBody): proto.Message.InteractiveResponseMessage.Body;

                /**
                 * Encodes the specified Body message. Does not implicitly {@link proto.Message.InteractiveResponseMessage.Body.verify|verify} messages.
                 * @param message Body message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.InteractiveResponseMessage.IBody, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Body message, length delimited. Does not implicitly {@link proto.Message.InteractiveResponseMessage.Body.verify|verify} messages.
                 * @param message Body message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.InteractiveResponseMessage.IBody, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Body message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Body
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveResponseMessage.Body;

                /**
                 * Decodes a Body message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Body
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveResponseMessage.Body;

                /**
                 * Verifies a Body message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Body message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Body
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveResponseMessage.Body;

                /**
                 * Creates a plain object from a Body message. Also converts values to other types if specified.
                 * @param message Body
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.InteractiveResponseMessage.Body, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Body to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a NativeFlowResponseMessage. */
            interface INativeFlowResponseMessage {

                /** NativeFlowResponseMessage name */
                name?: (string|null);

                /** NativeFlowResponseMessage paramsJson */
                paramsJson?: (string|null);

                /** NativeFlowResponseMessage version */
                version?: (number|null);
            }

            /** Represents a NativeFlowResponseMessage. */
            class NativeFlowResponseMessage implements INativeFlowResponseMessage {

                /**
                 * Constructs a new NativeFlowResponseMessage.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.InteractiveResponseMessage.INativeFlowResponseMessage);

                /** NativeFlowResponseMessage name. */
                public name: string;

                /** NativeFlowResponseMessage paramsJson. */
                public paramsJson: string;

                /** NativeFlowResponseMessage version. */
                public version: number;

                /**
                 * Creates a new NativeFlowResponseMessage instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns NativeFlowResponseMessage instance
                 */
                public static create(properties?: proto.Message.InteractiveResponseMessage.INativeFlowResponseMessage): proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage;

                /**
                 * Encodes the specified NativeFlowResponseMessage message. Does not implicitly {@link proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage.verify|verify} messages.
                 * @param message NativeFlowResponseMessage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.InteractiveResponseMessage.INativeFlowResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified NativeFlowResponseMessage message, length delimited. Does not implicitly {@link proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage.verify|verify} messages.
                 * @param message NativeFlowResponseMessage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.InteractiveResponseMessage.INativeFlowResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a NativeFlowResponseMessage message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns NativeFlowResponseMessage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage;

                /**
                 * Decodes a NativeFlowResponseMessage message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns NativeFlowResponseMessage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage;

                /**
                 * Verifies a NativeFlowResponseMessage message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a NativeFlowResponseMessage message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns NativeFlowResponseMessage
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage;

                /**
                 * Creates a plain object from a NativeFlowResponseMessage message. Also converts values to other types if specified.
                 * @param message NativeFlowResponseMessage
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this NativeFlowResponseMessage to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of an InvoiceMessage. */
        interface IInvoiceMessage {

            /** InvoiceMessage note */
            note?: (string|null);

            /** InvoiceMessage token */
            token?: (string|null);

            /** InvoiceMessage attachmentType */
            attachmentType?: (proto.Message.InvoiceMessage.AttachmentType|null);

            /** InvoiceMessage attachmentMimetype */
            attachmentMimetype?: (string|null);

            /** InvoiceMessage attachmentMediaKey */
            attachmentMediaKey?: (Uint8Array|null);

            /** InvoiceMessage attachmentMediaKeyTimestamp */
            attachmentMediaKeyTimestamp?: (number|Long|null);

            /** InvoiceMessage attachmentFileSha256 */
            attachmentFileSha256?: (Uint8Array|null);

            /** InvoiceMessage attachmentFileEncSha256 */
            attachmentFileEncSha256?: (Uint8Array|null);

            /** InvoiceMessage attachmentDirectPath */
            attachmentDirectPath?: (string|null);

            /** InvoiceMessage attachmentJpegThumbnail */
            attachmentJpegThumbnail?: (Uint8Array|null);
        }

        /** Represents an InvoiceMessage. */
        class InvoiceMessage implements IInvoiceMessage {

            /**
             * Constructs a new InvoiceMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IInvoiceMessage);

            /** InvoiceMessage note. */
            public note: string;

            /** InvoiceMessage token. */
            public token: string;

            /** InvoiceMessage attachmentType. */
            public attachmentType: proto.Message.InvoiceMessage.AttachmentType;

            /** InvoiceMessage attachmentMimetype. */
            public attachmentMimetype: string;

            /** InvoiceMessage attachmentMediaKey. */
            public attachmentMediaKey: Uint8Array;

            /** InvoiceMessage attachmentMediaKeyTimestamp. */
            public attachmentMediaKeyTimestamp: (number|Long);

            /** InvoiceMessage attachmentFileSha256. */
            public attachmentFileSha256: Uint8Array;

            /** InvoiceMessage attachmentFileEncSha256. */
            public attachmentFileEncSha256: Uint8Array;

            /** InvoiceMessage attachmentDirectPath. */
            public attachmentDirectPath: string;

            /** InvoiceMessage attachmentJpegThumbnail. */
            public attachmentJpegThumbnail: Uint8Array;

            /**
             * Creates a new InvoiceMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns InvoiceMessage instance
             */
            public static create(properties?: proto.Message.IInvoiceMessage): proto.Message.InvoiceMessage;

            /**
             * Encodes the specified InvoiceMessage message. Does not implicitly {@link proto.Message.InvoiceMessage.verify|verify} messages.
             * @param message InvoiceMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IInvoiceMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified InvoiceMessage message, length delimited. Does not implicitly {@link proto.Message.InvoiceMessage.verify|verify} messages.
             * @param message InvoiceMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IInvoiceMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an InvoiceMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns InvoiceMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.InvoiceMessage;

            /**
             * Decodes an InvoiceMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns InvoiceMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.InvoiceMessage;

            /**
             * Verifies an InvoiceMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an InvoiceMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns InvoiceMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.InvoiceMessage;

            /**
             * Creates a plain object from an InvoiceMessage message. Also converts values to other types if specified.
             * @param message InvoiceMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.InvoiceMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this InvoiceMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace InvoiceMessage {

            /** AttachmentType enum. */
            enum AttachmentType {
                IMAGE = 0,
                PDF = 1
            }
        }

        /** Properties of a KeepInChatMessage. */
        interface IKeepInChatMessage {

            /** KeepInChatMessage key */
            key?: (proto.IMessageKey|null);

            /** KeepInChatMessage keepType */
            keepType?: (proto.KeepType|null);

            /** KeepInChatMessage timestampMs */
            timestampMs?: (number|Long|null);
        }

        /** Represents a KeepInChatMessage. */
        class KeepInChatMessage implements IKeepInChatMessage {

            /**
             * Constructs a new KeepInChatMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IKeepInChatMessage);

            /** KeepInChatMessage key. */
            public key?: (proto.IMessageKey|null);

            /** KeepInChatMessage keepType. */
            public keepType: proto.KeepType;

            /** KeepInChatMessage timestampMs. */
            public timestampMs: (number|Long);

            /**
             * Creates a new KeepInChatMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns KeepInChatMessage instance
             */
            public static create(properties?: proto.Message.IKeepInChatMessage): proto.Message.KeepInChatMessage;

            /**
             * Encodes the specified KeepInChatMessage message. Does not implicitly {@link proto.Message.KeepInChatMessage.verify|verify} messages.
             * @param message KeepInChatMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IKeepInChatMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified KeepInChatMessage message, length delimited. Does not implicitly {@link proto.Message.KeepInChatMessage.verify|verify} messages.
             * @param message KeepInChatMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IKeepInChatMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a KeepInChatMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns KeepInChatMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.KeepInChatMessage;

            /**
             * Decodes a KeepInChatMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns KeepInChatMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.KeepInChatMessage;

            /**
             * Verifies a KeepInChatMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a KeepInChatMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns KeepInChatMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.KeepInChatMessage;

            /**
             * Creates a plain object from a KeepInChatMessage message. Also converts values to other types if specified.
             * @param message KeepInChatMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.KeepInChatMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this KeepInChatMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ListMessage. */
        interface IListMessage {

            /** ListMessage title */
            title?: (string|null);

            /** ListMessage description */
            description?: (string|null);

            /** ListMessage buttonText */
            buttonText?: (string|null);

            /** ListMessage listType */
            listType?: (proto.Message.ListMessage.ListType|null);

            /** ListMessage sections */
            sections?: (proto.Message.ListMessage.ISection[]|null);

            /** ListMessage productListInfo */
            productListInfo?: (proto.Message.ListMessage.IProductListInfo|null);

            /** ListMessage footerText */
            footerText?: (string|null);

            /** ListMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a ListMessage. */
        class ListMessage implements IListMessage {

            /**
             * Constructs a new ListMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IListMessage);

            /** ListMessage title. */
            public title: string;

            /** ListMessage description. */
            public description: string;

            /** ListMessage buttonText. */
            public buttonText: string;

            /** ListMessage listType. */
            public listType: proto.Message.ListMessage.ListType;

            /** ListMessage sections. */
            public sections: proto.Message.ListMessage.ISection[];

            /** ListMessage productListInfo. */
            public productListInfo?: (proto.Message.ListMessage.IProductListInfo|null);

            /** ListMessage footerText. */
            public footerText: string;

            /** ListMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new ListMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ListMessage instance
             */
            public static create(properties?: proto.Message.IListMessage): proto.Message.ListMessage;

            /**
             * Encodes the specified ListMessage message. Does not implicitly {@link proto.Message.ListMessage.verify|verify} messages.
             * @param message ListMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IListMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ListMessage message, length delimited. Does not implicitly {@link proto.Message.ListMessage.verify|verify} messages.
             * @param message ListMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IListMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ListMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ListMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ListMessage;

            /**
             * Decodes a ListMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ListMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ListMessage;

            /**
             * Verifies a ListMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ListMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ListMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ListMessage;

            /**
             * Creates a plain object from a ListMessage message. Also converts values to other types if specified.
             * @param message ListMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ListMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ListMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace ListMessage {

            /** ListType enum. */
            enum ListType {
                UNKNOWN = 0,
                SINGLE_SELECT = 1,
                PRODUCT_LIST = 2
            }

            /** Properties of a Product. */
            interface IProduct {

                /** Product productId */
                productId?: (string|null);
            }

            /** Represents a Product. */
            class Product implements IProduct {

                /**
                 * Constructs a new Product.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ListMessage.IProduct);

                /** Product productId. */
                public productId: string;

                /**
                 * Creates a new Product instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Product instance
                 */
                public static create(properties?: proto.Message.ListMessage.IProduct): proto.Message.ListMessage.Product;

                /**
                 * Encodes the specified Product message. Does not implicitly {@link proto.Message.ListMessage.Product.verify|verify} messages.
                 * @param message Product message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ListMessage.IProduct, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Product message, length delimited. Does not implicitly {@link proto.Message.ListMessage.Product.verify|verify} messages.
                 * @param message Product message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ListMessage.IProduct, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Product message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Product
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ListMessage.Product;

                /**
                 * Decodes a Product message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Product
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ListMessage.Product;

                /**
                 * Verifies a Product message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Product message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Product
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ListMessage.Product;

                /**
                 * Creates a plain object from a Product message. Also converts values to other types if specified.
                 * @param message Product
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ListMessage.Product, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Product to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a ProductListHeaderImage. */
            interface IProductListHeaderImage {

                /** ProductListHeaderImage productId */
                productId?: (string|null);

                /** ProductListHeaderImage jpegThumbnail */
                jpegThumbnail?: (Uint8Array|null);
            }

            /** Represents a ProductListHeaderImage. */
            class ProductListHeaderImage implements IProductListHeaderImage {

                /**
                 * Constructs a new ProductListHeaderImage.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ListMessage.IProductListHeaderImage);

                /** ProductListHeaderImage productId. */
                public productId: string;

                /** ProductListHeaderImage jpegThumbnail. */
                public jpegThumbnail: Uint8Array;

                /**
                 * Creates a new ProductListHeaderImage instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns ProductListHeaderImage instance
                 */
                public static create(properties?: proto.Message.ListMessage.IProductListHeaderImage): proto.Message.ListMessage.ProductListHeaderImage;

                /**
                 * Encodes the specified ProductListHeaderImage message. Does not implicitly {@link proto.Message.ListMessage.ProductListHeaderImage.verify|verify} messages.
                 * @param message ProductListHeaderImage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ListMessage.IProductListHeaderImage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified ProductListHeaderImage message, length delimited. Does not implicitly {@link proto.Message.ListMessage.ProductListHeaderImage.verify|verify} messages.
                 * @param message ProductListHeaderImage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ListMessage.IProductListHeaderImage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a ProductListHeaderImage message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns ProductListHeaderImage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ListMessage.ProductListHeaderImage;

                /**
                 * Decodes a ProductListHeaderImage message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns ProductListHeaderImage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ListMessage.ProductListHeaderImage;

                /**
                 * Verifies a ProductListHeaderImage message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a ProductListHeaderImage message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns ProductListHeaderImage
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ListMessage.ProductListHeaderImage;

                /**
                 * Creates a plain object from a ProductListHeaderImage message. Also converts values to other types if specified.
                 * @param message ProductListHeaderImage
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ListMessage.ProductListHeaderImage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this ProductListHeaderImage to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a ProductListInfo. */
            interface IProductListInfo {

                /** ProductListInfo productSections */
                productSections?: (proto.Message.ListMessage.IProductSection[]|null);

                /** ProductListInfo headerImage */
                headerImage?: (proto.Message.ListMessage.IProductListHeaderImage|null);

                /** ProductListInfo businessOwnerJid */
                businessOwnerJid?: (string|null);
            }

            /** Represents a ProductListInfo. */
            class ProductListInfo implements IProductListInfo {

                /**
                 * Constructs a new ProductListInfo.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ListMessage.IProductListInfo);

                /** ProductListInfo productSections. */
                public productSections: proto.Message.ListMessage.IProductSection[];

                /** ProductListInfo headerImage. */
                public headerImage?: (proto.Message.ListMessage.IProductListHeaderImage|null);

                /** ProductListInfo businessOwnerJid. */
                public businessOwnerJid: string;

                /**
                 * Creates a new ProductListInfo instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns ProductListInfo instance
                 */
                public static create(properties?: proto.Message.ListMessage.IProductListInfo): proto.Message.ListMessage.ProductListInfo;

                /**
                 * Encodes the specified ProductListInfo message. Does not implicitly {@link proto.Message.ListMessage.ProductListInfo.verify|verify} messages.
                 * @param message ProductListInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ListMessage.IProductListInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified ProductListInfo message, length delimited. Does not implicitly {@link proto.Message.ListMessage.ProductListInfo.verify|verify} messages.
                 * @param message ProductListInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ListMessage.IProductListInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a ProductListInfo message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns ProductListInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ListMessage.ProductListInfo;

                /**
                 * Decodes a ProductListInfo message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns ProductListInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ListMessage.ProductListInfo;

                /**
                 * Verifies a ProductListInfo message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a ProductListInfo message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns ProductListInfo
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ListMessage.ProductListInfo;

                /**
                 * Creates a plain object from a ProductListInfo message. Also converts values to other types if specified.
                 * @param message ProductListInfo
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ListMessage.ProductListInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this ProductListInfo to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a ProductSection. */
            interface IProductSection {

                /** ProductSection title */
                title?: (string|null);

                /** ProductSection products */
                products?: (proto.Message.ListMessage.IProduct[]|null);
            }

            /** Represents a ProductSection. */
            class ProductSection implements IProductSection {

                /**
                 * Constructs a new ProductSection.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ListMessage.IProductSection);

                /** ProductSection title. */
                public title: string;

                /** ProductSection products. */
                public products: proto.Message.ListMessage.IProduct[];

                /**
                 * Creates a new ProductSection instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns ProductSection instance
                 */
                public static create(properties?: proto.Message.ListMessage.IProductSection): proto.Message.ListMessage.ProductSection;

                /**
                 * Encodes the specified ProductSection message. Does not implicitly {@link proto.Message.ListMessage.ProductSection.verify|verify} messages.
                 * @param message ProductSection message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ListMessage.IProductSection, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified ProductSection message, length delimited. Does not implicitly {@link proto.Message.ListMessage.ProductSection.verify|verify} messages.
                 * @param message ProductSection message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ListMessage.IProductSection, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a ProductSection message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns ProductSection
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ListMessage.ProductSection;

                /**
                 * Decodes a ProductSection message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns ProductSection
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ListMessage.ProductSection;

                /**
                 * Verifies a ProductSection message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a ProductSection message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns ProductSection
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ListMessage.ProductSection;

                /**
                 * Creates a plain object from a ProductSection message. Also converts values to other types if specified.
                 * @param message ProductSection
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ListMessage.ProductSection, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this ProductSection to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a Row. */
            interface IRow {

                /** Row title */
                title?: (string|null);

                /** Row description */
                description?: (string|null);

                /** Row rowId */
                rowId?: (string|null);
            }

            /** Represents a Row. */
            class Row implements IRow {

                /**
                 * Constructs a new Row.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ListMessage.IRow);

                /** Row title. */
                public title: string;

                /** Row description. */
                public description: string;

                /** Row rowId. */
                public rowId: string;

                /**
                 * Creates a new Row instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Row instance
                 */
                public static create(properties?: proto.Message.ListMessage.IRow): proto.Message.ListMessage.Row;

                /**
                 * Encodes the specified Row message. Does not implicitly {@link proto.Message.ListMessage.Row.verify|verify} messages.
                 * @param message Row message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ListMessage.IRow, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Row message, length delimited. Does not implicitly {@link proto.Message.ListMessage.Row.verify|verify} messages.
                 * @param message Row message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ListMessage.IRow, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Row message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Row
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ListMessage.Row;

                /**
                 * Decodes a Row message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Row
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ListMessage.Row;

                /**
                 * Verifies a Row message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Row message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Row
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ListMessage.Row;

                /**
                 * Creates a plain object from a Row message. Also converts values to other types if specified.
                 * @param message Row
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ListMessage.Row, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Row to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a Section. */
            interface ISection {

                /** Section title */
                title?: (string|null);

                /** Section rows */
                rows?: (proto.Message.ListMessage.IRow[]|null);
            }

            /** Represents a Section. */
            class Section implements ISection {

                /**
                 * Constructs a new Section.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ListMessage.ISection);

                /** Section title. */
                public title: string;

                /** Section rows. */
                public rows: proto.Message.ListMessage.IRow[];

                /**
                 * Creates a new Section instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Section instance
                 */
                public static create(properties?: proto.Message.ListMessage.ISection): proto.Message.ListMessage.Section;

                /**
                 * Encodes the specified Section message. Does not implicitly {@link proto.Message.ListMessage.Section.verify|verify} messages.
                 * @param message Section message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ListMessage.ISection, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Section message, length delimited. Does not implicitly {@link proto.Message.ListMessage.Section.verify|verify} messages.
                 * @param message Section message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ListMessage.ISection, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Section message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Section
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ListMessage.Section;

                /**
                 * Decodes a Section message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Section
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ListMessage.Section;

                /**
                 * Verifies a Section message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Section message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Section
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ListMessage.Section;

                /**
                 * Creates a plain object from a Section message. Also converts values to other types if specified.
                 * @param message Section
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ListMessage.Section, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Section to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a ListResponseMessage. */
        interface IListResponseMessage {

            /** ListResponseMessage title */
            title?: (string|null);

            /** ListResponseMessage listType */
            listType?: (proto.Message.ListResponseMessage.ListType|null);

            /** ListResponseMessage singleSelectReply */
            singleSelectReply?: (proto.Message.ListResponseMessage.ISingleSelectReply|null);

            /** ListResponseMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** ListResponseMessage description */
            description?: (string|null);
        }

        /** Represents a ListResponseMessage. */
        class ListResponseMessage implements IListResponseMessage {

            /**
             * Constructs a new ListResponseMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IListResponseMessage);

            /** ListResponseMessage title. */
            public title: string;

            /** ListResponseMessage listType. */
            public listType: proto.Message.ListResponseMessage.ListType;

            /** ListResponseMessage singleSelectReply. */
            public singleSelectReply?: (proto.Message.ListResponseMessage.ISingleSelectReply|null);

            /** ListResponseMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** ListResponseMessage description. */
            public description: string;

            /**
             * Creates a new ListResponseMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ListResponseMessage instance
             */
            public static create(properties?: proto.Message.IListResponseMessage): proto.Message.ListResponseMessage;

            /**
             * Encodes the specified ListResponseMessage message. Does not implicitly {@link proto.Message.ListResponseMessage.verify|verify} messages.
             * @param message ListResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IListResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ListResponseMessage message, length delimited. Does not implicitly {@link proto.Message.ListResponseMessage.verify|verify} messages.
             * @param message ListResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IListResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ListResponseMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ListResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ListResponseMessage;

            /**
             * Decodes a ListResponseMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ListResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ListResponseMessage;

            /**
             * Verifies a ListResponseMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ListResponseMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ListResponseMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ListResponseMessage;

            /**
             * Creates a plain object from a ListResponseMessage message. Also converts values to other types if specified.
             * @param message ListResponseMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ListResponseMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ListResponseMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace ListResponseMessage {

            /** ListType enum. */
            enum ListType {
                UNKNOWN = 0,
                SINGLE_SELECT = 1
            }

            /** Properties of a SingleSelectReply. */
            interface ISingleSelectReply {

                /** SingleSelectReply selectedRowId */
                selectedRowId?: (string|null);
            }

            /** Represents a SingleSelectReply. */
            class SingleSelectReply implements ISingleSelectReply {

                /**
                 * Constructs a new SingleSelectReply.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ListResponseMessage.ISingleSelectReply);

                /** SingleSelectReply selectedRowId. */
                public selectedRowId: string;

                /**
                 * Creates a new SingleSelectReply instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns SingleSelectReply instance
                 */
                public static create(properties?: proto.Message.ListResponseMessage.ISingleSelectReply): proto.Message.ListResponseMessage.SingleSelectReply;

                /**
                 * Encodes the specified SingleSelectReply message. Does not implicitly {@link proto.Message.ListResponseMessage.SingleSelectReply.verify|verify} messages.
                 * @param message SingleSelectReply message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ListResponseMessage.ISingleSelectReply, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified SingleSelectReply message, length delimited. Does not implicitly {@link proto.Message.ListResponseMessage.SingleSelectReply.verify|verify} messages.
                 * @param message SingleSelectReply message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ListResponseMessage.ISingleSelectReply, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a SingleSelectReply message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns SingleSelectReply
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ListResponseMessage.SingleSelectReply;

                /**
                 * Decodes a SingleSelectReply message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns SingleSelectReply
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ListResponseMessage.SingleSelectReply;

                /**
                 * Verifies a SingleSelectReply message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a SingleSelectReply message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns SingleSelectReply
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ListResponseMessage.SingleSelectReply;

                /**
                 * Creates a plain object from a SingleSelectReply message. Also converts values to other types if specified.
                 * @param message SingleSelectReply
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ListResponseMessage.SingleSelectReply, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this SingleSelectReply to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a LiveLocationMessage. */
        interface ILiveLocationMessage {

            /** LiveLocationMessage degreesLatitude */
            degreesLatitude?: (number|null);

            /** LiveLocationMessage degreesLongitude */
            degreesLongitude?: (number|null);

            /** LiveLocationMessage accuracyInMeters */
            accuracyInMeters?: (number|null);

            /** LiveLocationMessage speedInMps */
            speedInMps?: (number|null);

            /** LiveLocationMessage degreesClockwiseFromMagneticNorth */
            degreesClockwiseFromMagneticNorth?: (number|null);

            /** LiveLocationMessage caption */
            caption?: (string|null);

            /** LiveLocationMessage sequenceNumber */
            sequenceNumber?: (number|Long|null);

            /** LiveLocationMessage timeOffset */
            timeOffset?: (number|null);

            /** LiveLocationMessage jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** LiveLocationMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a LiveLocationMessage. */
        class LiveLocationMessage implements ILiveLocationMessage {

            /**
             * Constructs a new LiveLocationMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ILiveLocationMessage);

            /** LiveLocationMessage degreesLatitude. */
            public degreesLatitude: number;

            /** LiveLocationMessage degreesLongitude. */
            public degreesLongitude: number;

            /** LiveLocationMessage accuracyInMeters. */
            public accuracyInMeters: number;

            /** LiveLocationMessage speedInMps. */
            public speedInMps: number;

            /** LiveLocationMessage degreesClockwiseFromMagneticNorth. */
            public degreesClockwiseFromMagneticNorth: number;

            /** LiveLocationMessage caption. */
            public caption: string;

            /** LiveLocationMessage sequenceNumber. */
            public sequenceNumber: (number|Long);

            /** LiveLocationMessage timeOffset. */
            public timeOffset: number;

            /** LiveLocationMessage jpegThumbnail. */
            public jpegThumbnail: Uint8Array;

            /** LiveLocationMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new LiveLocationMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns LiveLocationMessage instance
             */
            public static create(properties?: proto.Message.ILiveLocationMessage): proto.Message.LiveLocationMessage;

            /**
             * Encodes the specified LiveLocationMessage message. Does not implicitly {@link proto.Message.LiveLocationMessage.verify|verify} messages.
             * @param message LiveLocationMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ILiveLocationMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified LiveLocationMessage message, length delimited. Does not implicitly {@link proto.Message.LiveLocationMessage.verify|verify} messages.
             * @param message LiveLocationMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ILiveLocationMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a LiveLocationMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns LiveLocationMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.LiveLocationMessage;

            /**
             * Decodes a LiveLocationMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns LiveLocationMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.LiveLocationMessage;

            /**
             * Verifies a LiveLocationMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a LiveLocationMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns LiveLocationMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.LiveLocationMessage;

            /**
             * Creates a plain object from a LiveLocationMessage message. Also converts values to other types if specified.
             * @param message LiveLocationMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.LiveLocationMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this LiveLocationMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a LocationMessage. */
        interface ILocationMessage {

            /** LocationMessage degreesLatitude */
            degreesLatitude?: (number|null);

            /** LocationMessage degreesLongitude */
            degreesLongitude?: (number|null);

            /** LocationMessage name */
            name?: (string|null);

            /** LocationMessage address */
            address?: (string|null);

            /** LocationMessage url */
            url?: (string|null);

            /** LocationMessage isLive */
            isLive?: (boolean|null);

            /** LocationMessage accuracyInMeters */
            accuracyInMeters?: (number|null);

            /** LocationMessage speedInMps */
            speedInMps?: (number|null);

            /** LocationMessage degreesClockwiseFromMagneticNorth */
            degreesClockwiseFromMagneticNorth?: (number|null);

            /** LocationMessage comment */
            comment?: (string|null);

            /** LocationMessage jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** LocationMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a LocationMessage. */
        class LocationMessage implements ILocationMessage {

            /**
             * Constructs a new LocationMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ILocationMessage);

            /** LocationMessage degreesLatitude. */
            public degreesLatitude: number;

            /** LocationMessage degreesLongitude. */
            public degreesLongitude: number;

            /** LocationMessage name. */
            public name: string;

            /** LocationMessage address. */
            public address: string;

            /** LocationMessage url. */
            public url: string;

            /** LocationMessage isLive. */
            public isLive: boolean;

            /** LocationMessage accuracyInMeters. */
            public accuracyInMeters: number;

            /** LocationMessage speedInMps. */
            public speedInMps: number;

            /** LocationMessage degreesClockwiseFromMagneticNorth. */
            public degreesClockwiseFromMagneticNorth: number;

            /** LocationMessage comment. */
            public comment: string;

            /** LocationMessage jpegThumbnail. */
            public jpegThumbnail: Uint8Array;

            /** LocationMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new LocationMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns LocationMessage instance
             */
            public static create(properties?: proto.Message.ILocationMessage): proto.Message.LocationMessage;

            /**
             * Encodes the specified LocationMessage message. Does not implicitly {@link proto.Message.LocationMessage.verify|verify} messages.
             * @param message LocationMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ILocationMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified LocationMessage message, length delimited. Does not implicitly {@link proto.Message.LocationMessage.verify|verify} messages.
             * @param message LocationMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ILocationMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a LocationMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns LocationMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.LocationMessage;

            /**
             * Decodes a LocationMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns LocationMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.LocationMessage;

            /**
             * Verifies a LocationMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a LocationMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns LocationMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.LocationMessage;

            /**
             * Creates a plain object from a LocationMessage message. Also converts values to other types if specified.
             * @param message LocationMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.LocationMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this LocationMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an OrderMessage. */
        interface IOrderMessage {

            /** OrderMessage orderId */
            orderId?: (string|null);

            /** OrderMessage thumbnail */
            thumbnail?: (Uint8Array|null);

            /** OrderMessage itemCount */
            itemCount?: (number|null);

            /** OrderMessage status */
            status?: (proto.Message.OrderMessage.OrderStatus|null);

            /** OrderMessage surface */
            surface?: (proto.Message.OrderMessage.OrderSurface|null);

            /** OrderMessage message */
            message?: (string|null);

            /** OrderMessage orderTitle */
            orderTitle?: (string|null);

            /** OrderMessage sellerJid */
            sellerJid?: (string|null);

            /** OrderMessage token */
            token?: (string|null);

            /** OrderMessage totalAmount1000 */
            totalAmount1000?: (number|Long|null);

            /** OrderMessage totalCurrencyCode */
            totalCurrencyCode?: (string|null);

            /** OrderMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents an OrderMessage. */
        class OrderMessage implements IOrderMessage {

            /**
             * Constructs a new OrderMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IOrderMessage);

            /** OrderMessage orderId. */
            public orderId: string;

            /** OrderMessage thumbnail. */
            public thumbnail: Uint8Array;

            /** OrderMessage itemCount. */
            public itemCount: number;

            /** OrderMessage status. */
            public status: proto.Message.OrderMessage.OrderStatus;

            /** OrderMessage surface. */
            public surface: proto.Message.OrderMessage.OrderSurface;

            /** OrderMessage message. */
            public message: string;

            /** OrderMessage orderTitle. */
            public orderTitle: string;

            /** OrderMessage sellerJid. */
            public sellerJid: string;

            /** OrderMessage token. */
            public token: string;

            /** OrderMessage totalAmount1000. */
            public totalAmount1000: (number|Long);

            /** OrderMessage totalCurrencyCode. */
            public totalCurrencyCode: string;

            /** OrderMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new OrderMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns OrderMessage instance
             */
            public static create(properties?: proto.Message.IOrderMessage): proto.Message.OrderMessage;

            /**
             * Encodes the specified OrderMessage message. Does not implicitly {@link proto.Message.OrderMessage.verify|verify} messages.
             * @param message OrderMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IOrderMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified OrderMessage message, length delimited. Does not implicitly {@link proto.Message.OrderMessage.verify|verify} messages.
             * @param message OrderMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IOrderMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an OrderMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns OrderMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.OrderMessage;

            /**
             * Decodes an OrderMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns OrderMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.OrderMessage;

            /**
             * Verifies an OrderMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an OrderMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns OrderMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.OrderMessage;

            /**
             * Creates a plain object from an OrderMessage message. Also converts values to other types if specified.
             * @param message OrderMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.OrderMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this OrderMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace OrderMessage {

            /** OrderStatus enum. */
            enum OrderStatus {
                INQUIRY = 1
            }

            /** OrderSurface enum. */
            enum OrderSurface {
                CATALOG = 1
            }
        }

        /** Properties of a PaymentInviteMessage. */
        interface IPaymentInviteMessage {

            /** PaymentInviteMessage serviceType */
            serviceType?: (proto.Message.PaymentInviteMessage.ServiceType|null);

            /** PaymentInviteMessage expiryTimestamp */
            expiryTimestamp?: (number|Long|null);
        }

        /** Represents a PaymentInviteMessage. */
        class PaymentInviteMessage implements IPaymentInviteMessage {

            /**
             * Constructs a new PaymentInviteMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IPaymentInviteMessage);

            /** PaymentInviteMessage serviceType. */
            public serviceType: proto.Message.PaymentInviteMessage.ServiceType;

            /** PaymentInviteMessage expiryTimestamp. */
            public expiryTimestamp: (number|Long);

            /**
             * Creates a new PaymentInviteMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns PaymentInviteMessage instance
             */
            public static create(properties?: proto.Message.IPaymentInviteMessage): proto.Message.PaymentInviteMessage;

            /**
             * Encodes the specified PaymentInviteMessage message. Does not implicitly {@link proto.Message.PaymentInviteMessage.verify|verify} messages.
             * @param message PaymentInviteMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IPaymentInviteMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified PaymentInviteMessage message, length delimited. Does not implicitly {@link proto.Message.PaymentInviteMessage.verify|verify} messages.
             * @param message PaymentInviteMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IPaymentInviteMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a PaymentInviteMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns PaymentInviteMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PaymentInviteMessage;

            /**
             * Decodes a PaymentInviteMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns PaymentInviteMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PaymentInviteMessage;

            /**
             * Verifies a PaymentInviteMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a PaymentInviteMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns PaymentInviteMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.PaymentInviteMessage;

            /**
             * Creates a plain object from a PaymentInviteMessage message. Also converts values to other types if specified.
             * @param message PaymentInviteMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.PaymentInviteMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this PaymentInviteMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace PaymentInviteMessage {

            /** ServiceType enum. */
            enum ServiceType {
                UNKNOWN = 0,
                FBPAY = 1,
                NOVI = 2,
                UPI = 3
            }
        }

        /** Properties of a PeerDataOperationRequestMessage. */
        interface IPeerDataOperationRequestMessage {

            /** PeerDataOperationRequestMessage peerDataOperationRequestType */
            peerDataOperationRequestType?: (proto.Message.PeerDataOperationRequestType|null);

            /** PeerDataOperationRequestMessage requestStickerReupload */
            requestStickerReupload?: (proto.Message.PeerDataOperationRequestMessage.IRequestStickerReupload[]|null);

            /** PeerDataOperationRequestMessage requestUrlPreview */
            requestUrlPreview?: (proto.Message.PeerDataOperationRequestMessage.IRequestUrlPreview[]|null);
        }

        /** Represents a PeerDataOperationRequestMessage. */
        class PeerDataOperationRequestMessage implements IPeerDataOperationRequestMessage {

            /**
             * Constructs a new PeerDataOperationRequestMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IPeerDataOperationRequestMessage);

            /** PeerDataOperationRequestMessage peerDataOperationRequestType. */
            public peerDataOperationRequestType: proto.Message.PeerDataOperationRequestType;

            /** PeerDataOperationRequestMessage requestStickerReupload. */
            public requestStickerReupload: proto.Message.PeerDataOperationRequestMessage.IRequestStickerReupload[];

            /** PeerDataOperationRequestMessage requestUrlPreview. */
            public requestUrlPreview: proto.Message.PeerDataOperationRequestMessage.IRequestUrlPreview[];

            /**
             * Creates a new PeerDataOperationRequestMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns PeerDataOperationRequestMessage instance
             */
            public static create(properties?: proto.Message.IPeerDataOperationRequestMessage): proto.Message.PeerDataOperationRequestMessage;

            /**
             * Encodes the specified PeerDataOperationRequestMessage message. Does not implicitly {@link proto.Message.PeerDataOperationRequestMessage.verify|verify} messages.
             * @param message PeerDataOperationRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IPeerDataOperationRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified PeerDataOperationRequestMessage message, length delimited. Does not implicitly {@link proto.Message.PeerDataOperationRequestMessage.verify|verify} messages.
             * @param message PeerDataOperationRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IPeerDataOperationRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a PeerDataOperationRequestMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns PeerDataOperationRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PeerDataOperationRequestMessage;

            /**
             * Decodes a PeerDataOperationRequestMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns PeerDataOperationRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PeerDataOperationRequestMessage;

            /**
             * Verifies a PeerDataOperationRequestMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a PeerDataOperationRequestMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns PeerDataOperationRequestMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.PeerDataOperationRequestMessage;

            /**
             * Creates a plain object from a PeerDataOperationRequestMessage message. Also converts values to other types if specified.
             * @param message PeerDataOperationRequestMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.PeerDataOperationRequestMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this PeerDataOperationRequestMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace PeerDataOperationRequestMessage {

            /** Properties of a RequestStickerReupload. */
            interface IRequestStickerReupload {

                /** RequestStickerReupload fileSha256 */
                fileSha256?: (string|null);
            }

            /** Represents a RequestStickerReupload. */
            class RequestStickerReupload implements IRequestStickerReupload {

                /**
                 * Constructs a new RequestStickerReupload.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.PeerDataOperationRequestMessage.IRequestStickerReupload);

                /** RequestStickerReupload fileSha256. */
                public fileSha256: string;

                /**
                 * Creates a new RequestStickerReupload instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns RequestStickerReupload instance
                 */
                public static create(properties?: proto.Message.PeerDataOperationRequestMessage.IRequestStickerReupload): proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload;

                /**
                 * Encodes the specified RequestStickerReupload message. Does not implicitly {@link proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload.verify|verify} messages.
                 * @param message RequestStickerReupload message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.PeerDataOperationRequestMessage.IRequestStickerReupload, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified RequestStickerReupload message, length delimited. Does not implicitly {@link proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload.verify|verify} messages.
                 * @param message RequestStickerReupload message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.PeerDataOperationRequestMessage.IRequestStickerReupload, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a RequestStickerReupload message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns RequestStickerReupload
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload;

                /**
                 * Decodes a RequestStickerReupload message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns RequestStickerReupload
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload;

                /**
                 * Verifies a RequestStickerReupload message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a RequestStickerReupload message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns RequestStickerReupload
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload;

                /**
                 * Creates a plain object from a RequestStickerReupload message. Also converts values to other types if specified.
                 * @param message RequestStickerReupload
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this RequestStickerReupload to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a RequestUrlPreview. */
            interface IRequestUrlPreview {

                /** RequestUrlPreview url */
                url?: (string|null);
            }

            /** Represents a RequestUrlPreview. */
            class RequestUrlPreview implements IRequestUrlPreview {

                /**
                 * Constructs a new RequestUrlPreview.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.PeerDataOperationRequestMessage.IRequestUrlPreview);

                /** RequestUrlPreview url. */
                public url: string;

                /**
                 * Creates a new RequestUrlPreview instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns RequestUrlPreview instance
                 */
                public static create(properties?: proto.Message.PeerDataOperationRequestMessage.IRequestUrlPreview): proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview;

                /**
                 * Encodes the specified RequestUrlPreview message. Does not implicitly {@link proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview.verify|verify} messages.
                 * @param message RequestUrlPreview message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.PeerDataOperationRequestMessage.IRequestUrlPreview, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified RequestUrlPreview message, length delimited. Does not implicitly {@link proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview.verify|verify} messages.
                 * @param message RequestUrlPreview message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.PeerDataOperationRequestMessage.IRequestUrlPreview, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a RequestUrlPreview message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns RequestUrlPreview
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview;

                /**
                 * Decodes a RequestUrlPreview message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns RequestUrlPreview
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview;

                /**
                 * Verifies a RequestUrlPreview message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a RequestUrlPreview message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns RequestUrlPreview
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview;

                /**
                 * Creates a plain object from a RequestUrlPreview message. Also converts values to other types if specified.
                 * @param message RequestUrlPreview
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this RequestUrlPreview to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a PeerDataOperationRequestResponseMessage. */
        interface IPeerDataOperationRequestResponseMessage {

            /** PeerDataOperationRequestResponseMessage peerDataOperationRequestType */
            peerDataOperationRequestType?: (proto.Message.PeerDataOperationRequestType|null);

            /** PeerDataOperationRequestResponseMessage stanzaId */
            stanzaId?: (string|null);

            /** PeerDataOperationRequestResponseMessage peerDataOperationResult */
            peerDataOperationResult?: (proto.Message.PeerDataOperationRequestResponseMessage.IPeerDataOperationResult[]|null);
        }

        /** Represents a PeerDataOperationRequestResponseMessage. */
        class PeerDataOperationRequestResponseMessage implements IPeerDataOperationRequestResponseMessage {

            /**
             * Constructs a new PeerDataOperationRequestResponseMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IPeerDataOperationRequestResponseMessage);

            /** PeerDataOperationRequestResponseMessage peerDataOperationRequestType. */
            public peerDataOperationRequestType: proto.Message.PeerDataOperationRequestType;

            /** PeerDataOperationRequestResponseMessage stanzaId. */
            public stanzaId: string;

            /** PeerDataOperationRequestResponseMessage peerDataOperationResult. */
            public peerDataOperationResult: proto.Message.PeerDataOperationRequestResponseMessage.IPeerDataOperationResult[];

            /**
             * Creates a new PeerDataOperationRequestResponseMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns PeerDataOperationRequestResponseMessage instance
             */
            public static create(properties?: proto.Message.IPeerDataOperationRequestResponseMessage): proto.Message.PeerDataOperationRequestResponseMessage;

            /**
             * Encodes the specified PeerDataOperationRequestResponseMessage message. Does not implicitly {@link proto.Message.PeerDataOperationRequestResponseMessage.verify|verify} messages.
             * @param message PeerDataOperationRequestResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IPeerDataOperationRequestResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified PeerDataOperationRequestResponseMessage message, length delimited. Does not implicitly {@link proto.Message.PeerDataOperationRequestResponseMessage.verify|verify} messages.
             * @param message PeerDataOperationRequestResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IPeerDataOperationRequestResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a PeerDataOperationRequestResponseMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns PeerDataOperationRequestResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PeerDataOperationRequestResponseMessage;

            /**
             * Decodes a PeerDataOperationRequestResponseMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns PeerDataOperationRequestResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PeerDataOperationRequestResponseMessage;

            /**
             * Verifies a PeerDataOperationRequestResponseMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a PeerDataOperationRequestResponseMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns PeerDataOperationRequestResponseMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.PeerDataOperationRequestResponseMessage;

            /**
             * Creates a plain object from a PeerDataOperationRequestResponseMessage message. Also converts values to other types if specified.
             * @param message PeerDataOperationRequestResponseMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.PeerDataOperationRequestResponseMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this PeerDataOperationRequestResponseMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace PeerDataOperationRequestResponseMessage {

            /** Properties of a PeerDataOperationResult. */
            interface IPeerDataOperationResult {

                /** PeerDataOperationResult mediaUploadResult */
                mediaUploadResult?: (proto.MediaRetryNotification.ResultType|null);

                /** PeerDataOperationResult stickerMessage */
                stickerMessage?: (proto.Message.IStickerMessage|null);

                /** PeerDataOperationResult linkPreviewResponse */
                linkPreviewResponse?: (proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.ILinkPreviewResponse|null);
            }

            /** Represents a PeerDataOperationResult. */
            class PeerDataOperationResult implements IPeerDataOperationResult {

                /**
                 * Constructs a new PeerDataOperationResult.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.PeerDataOperationRequestResponseMessage.IPeerDataOperationResult);

                /** PeerDataOperationResult mediaUploadResult. */
                public mediaUploadResult: proto.MediaRetryNotification.ResultType;

                /** PeerDataOperationResult stickerMessage. */
                public stickerMessage?: (proto.Message.IStickerMessage|null);

                /** PeerDataOperationResult linkPreviewResponse. */
                public linkPreviewResponse?: (proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.ILinkPreviewResponse|null);

                /**
                 * Creates a new PeerDataOperationResult instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns PeerDataOperationResult instance
                 */
                public static create(properties?: proto.Message.PeerDataOperationRequestResponseMessage.IPeerDataOperationResult): proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult;

                /**
                 * Encodes the specified PeerDataOperationResult message. Does not implicitly {@link proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.verify|verify} messages.
                 * @param message PeerDataOperationResult message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.PeerDataOperationRequestResponseMessage.IPeerDataOperationResult, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified PeerDataOperationResult message, length delimited. Does not implicitly {@link proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.verify|verify} messages.
                 * @param message PeerDataOperationResult message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.PeerDataOperationRequestResponseMessage.IPeerDataOperationResult, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a PeerDataOperationResult message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns PeerDataOperationResult
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult;

                /**
                 * Decodes a PeerDataOperationResult message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns PeerDataOperationResult
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult;

                /**
                 * Verifies a PeerDataOperationResult message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a PeerDataOperationResult message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns PeerDataOperationResult
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult;

                /**
                 * Creates a plain object from a PeerDataOperationResult message. Also converts values to other types if specified.
                 * @param message PeerDataOperationResult
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this PeerDataOperationResult to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace PeerDataOperationResult {

                /** Properties of a LinkPreviewResponse. */
                interface ILinkPreviewResponse {

                    /** LinkPreviewResponse url */
                    url?: (string|null);

                    /** LinkPreviewResponse title */
                    title?: (string|null);

                    /** LinkPreviewResponse description */
                    description?: (string|null);

                    /** LinkPreviewResponse thumbData */
                    thumbData?: (Uint8Array|null);

                    /** LinkPreviewResponse canonicalUrl */
                    canonicalUrl?: (string|null);

                    /** LinkPreviewResponse matchText */
                    matchText?: (string|null);

                    /** LinkPreviewResponse previewType */
                    previewType?: (string|null);
                }

                /** Represents a LinkPreviewResponse. */
                class LinkPreviewResponse implements ILinkPreviewResponse {

                    /**
                     * Constructs a new LinkPreviewResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.ILinkPreviewResponse);

                    /** LinkPreviewResponse url. */
                    public url: string;

                    /** LinkPreviewResponse title. */
                    public title: string;

                    /** LinkPreviewResponse description. */
                    public description: string;

                    /** LinkPreviewResponse thumbData. */
                    public thumbData: Uint8Array;

                    /** LinkPreviewResponse canonicalUrl. */
                    public canonicalUrl: string;

                    /** LinkPreviewResponse matchText. */
                    public matchText: string;

                    /** LinkPreviewResponse previewType. */
                    public previewType: string;

                    /**
                     * Creates a new LinkPreviewResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns LinkPreviewResponse instance
                     */
                    public static create(properties?: proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.ILinkPreviewResponse): proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse;

                    /**
                     * Encodes the specified LinkPreviewResponse message. Does not implicitly {@link proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse.verify|verify} messages.
                     * @param message LinkPreviewResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.ILinkPreviewResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified LinkPreviewResponse message, length delimited. Does not implicitly {@link proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse.verify|verify} messages.
                     * @param message LinkPreviewResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.ILinkPreviewResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a LinkPreviewResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns LinkPreviewResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse;

                    /**
                     * Decodes a LinkPreviewResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns LinkPreviewResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse;

                    /**
                     * Verifies a LinkPreviewResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a LinkPreviewResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns LinkPreviewResponse
                     */
                    public static fromObject(object: { [k: string]: any }): proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse;

                    /**
                     * Creates a plain object from a LinkPreviewResponse message. Also converts values to other types if specified.
                     * @param message LinkPreviewResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this LinkPreviewResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }
            }
        }

        /** PeerDataOperationRequestType enum. */
        enum PeerDataOperationRequestType {
            UPLOAD_STICKER = 0,
            SEND_RECENT_STICKER_BOOTSTRAP = 1,
            GENERATE_LINK_PREVIEW = 2
        }

        /** Properties of a PollCreationMessage. */
        interface IPollCreationMessage {

            /** PollCreationMessage encKey */
            encKey?: (Uint8Array|null);

            /** PollCreationMessage name */
            name?: (string|null);

            /** PollCreationMessage options */
            options?: (proto.Message.PollCreationMessage.IOption[]|null);

            /** PollCreationMessage selectableOptionsCount */
            selectableOptionsCount?: (number|null);

            /** PollCreationMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a PollCreationMessage. */
        class PollCreationMessage implements IPollCreationMessage {

            /**
             * Constructs a new PollCreationMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IPollCreationMessage);

            /** PollCreationMessage encKey. */
            public encKey: Uint8Array;

            /** PollCreationMessage name. */
            public name: string;

            /** PollCreationMessage options. */
            public options: proto.Message.PollCreationMessage.IOption[];

            /** PollCreationMessage selectableOptionsCount. */
            public selectableOptionsCount: number;

            /** PollCreationMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new PollCreationMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns PollCreationMessage instance
             */
            public static create(properties?: proto.Message.IPollCreationMessage): proto.Message.PollCreationMessage;

            /**
             * Encodes the specified PollCreationMessage message. Does not implicitly {@link proto.Message.PollCreationMessage.verify|verify} messages.
             * @param message PollCreationMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IPollCreationMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified PollCreationMessage message, length delimited. Does not implicitly {@link proto.Message.PollCreationMessage.verify|verify} messages.
             * @param message PollCreationMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IPollCreationMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a PollCreationMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns PollCreationMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PollCreationMessage;

            /**
             * Decodes a PollCreationMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns PollCreationMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PollCreationMessage;

            /**
             * Verifies a PollCreationMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a PollCreationMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns PollCreationMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.PollCreationMessage;

            /**
             * Creates a plain object from a PollCreationMessage message. Also converts values to other types if specified.
             * @param message PollCreationMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.PollCreationMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this PollCreationMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace PollCreationMessage {

            /** Properties of an Option. */
            interface IOption {

                /** Option optionName */
                optionName?: (string|null);
            }

            /** Represents an Option. */
            class Option implements IOption {

                /**
                 * Constructs a new Option.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.PollCreationMessage.IOption);

                /** Option optionName. */
                public optionName: string;

                /**
                 * Creates a new Option instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Option instance
                 */
                public static create(properties?: proto.Message.PollCreationMessage.IOption): proto.Message.PollCreationMessage.Option;

                /**
                 * Encodes the specified Option message. Does not implicitly {@link proto.Message.PollCreationMessage.Option.verify|verify} messages.
                 * @param message Option message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.PollCreationMessage.IOption, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Option message, length delimited. Does not implicitly {@link proto.Message.PollCreationMessage.Option.verify|verify} messages.
                 * @param message Option message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.PollCreationMessage.IOption, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes an Option message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Option
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PollCreationMessage.Option;

                /**
                 * Decodes an Option message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Option
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PollCreationMessage.Option;

                /**
                 * Verifies an Option message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates an Option message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Option
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.PollCreationMessage.Option;

                /**
                 * Creates a plain object from an Option message. Also converts values to other types if specified.
                 * @param message Option
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.PollCreationMessage.Option, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Option to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a PollEncValue. */
        interface IPollEncValue {

            /** PollEncValue encPayload */
            encPayload?: (Uint8Array|null);

            /** PollEncValue encIv */
            encIv?: (Uint8Array|null);
        }

        /** Represents a PollEncValue. */
        class PollEncValue implements IPollEncValue {

            /**
             * Constructs a new PollEncValue.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IPollEncValue);

            /** PollEncValue encPayload. */
            public encPayload: Uint8Array;

            /** PollEncValue encIv. */
            public encIv: Uint8Array;

            /**
             * Creates a new PollEncValue instance using the specified properties.
             * @param [properties] Properties to set
             * @returns PollEncValue instance
             */
            public static create(properties?: proto.Message.IPollEncValue): proto.Message.PollEncValue;

            /**
             * Encodes the specified PollEncValue message. Does not implicitly {@link proto.Message.PollEncValue.verify|verify} messages.
             * @param message PollEncValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IPollEncValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified PollEncValue message, length delimited. Does not implicitly {@link proto.Message.PollEncValue.verify|verify} messages.
             * @param message PollEncValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IPollEncValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a PollEncValue message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns PollEncValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PollEncValue;

            /**
             * Decodes a PollEncValue message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns PollEncValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PollEncValue;

            /**
             * Verifies a PollEncValue message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a PollEncValue message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns PollEncValue
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.PollEncValue;

            /**
             * Creates a plain object from a PollEncValue message. Also converts values to other types if specified.
             * @param message PollEncValue
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.PollEncValue, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this PollEncValue to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a PollUpdateMessage. */
        interface IPollUpdateMessage {

            /** PollUpdateMessage pollCreationMessageKey */
            pollCreationMessageKey?: (proto.IMessageKey|null);

            /** PollUpdateMessage vote */
            vote?: (proto.Message.IPollEncValue|null);

            /** PollUpdateMessage metadata */
            metadata?: (proto.Message.IPollUpdateMessageMetadata|null);

            /** PollUpdateMessage senderTimestampMs */
            senderTimestampMs?: (number|Long|null);
        }

        /** Represents a PollUpdateMessage. */
        class PollUpdateMessage implements IPollUpdateMessage {

            /**
             * Constructs a new PollUpdateMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IPollUpdateMessage);

            /** PollUpdateMessage pollCreationMessageKey. */
            public pollCreationMessageKey?: (proto.IMessageKey|null);

            /** PollUpdateMessage vote. */
            public vote?: (proto.Message.IPollEncValue|null);

            /** PollUpdateMessage metadata. */
            public metadata?: (proto.Message.IPollUpdateMessageMetadata|null);

            /** PollUpdateMessage senderTimestampMs. */
            public senderTimestampMs: (number|Long);

            /**
             * Creates a new PollUpdateMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns PollUpdateMessage instance
             */
            public static create(properties?: proto.Message.IPollUpdateMessage): proto.Message.PollUpdateMessage;

            /**
             * Encodes the specified PollUpdateMessage message. Does not implicitly {@link proto.Message.PollUpdateMessage.verify|verify} messages.
             * @param message PollUpdateMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IPollUpdateMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified PollUpdateMessage message, length delimited. Does not implicitly {@link proto.Message.PollUpdateMessage.verify|verify} messages.
             * @param message PollUpdateMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IPollUpdateMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a PollUpdateMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns PollUpdateMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PollUpdateMessage;

            /**
             * Decodes a PollUpdateMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns PollUpdateMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PollUpdateMessage;

            /**
             * Verifies a PollUpdateMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a PollUpdateMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns PollUpdateMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.PollUpdateMessage;

            /**
             * Creates a plain object from a PollUpdateMessage message. Also converts values to other types if specified.
             * @param message PollUpdateMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.PollUpdateMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this PollUpdateMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a PollUpdateMessageMetadata. */
        interface IPollUpdateMessageMetadata {
        }

        /** Represents a PollUpdateMessageMetadata. */
        class PollUpdateMessageMetadata implements IPollUpdateMessageMetadata {

            /**
             * Constructs a new PollUpdateMessageMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IPollUpdateMessageMetadata);

            /**
             * Creates a new PollUpdateMessageMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns PollUpdateMessageMetadata instance
             */
            public static create(properties?: proto.Message.IPollUpdateMessageMetadata): proto.Message.PollUpdateMessageMetadata;

            /**
             * Encodes the specified PollUpdateMessageMetadata message. Does not implicitly {@link proto.Message.PollUpdateMessageMetadata.verify|verify} messages.
             * @param message PollUpdateMessageMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IPollUpdateMessageMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified PollUpdateMessageMetadata message, length delimited. Does not implicitly {@link proto.Message.PollUpdateMessageMetadata.verify|verify} messages.
             * @param message PollUpdateMessageMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IPollUpdateMessageMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a PollUpdateMessageMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns PollUpdateMessageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PollUpdateMessageMetadata;

            /**
             * Decodes a PollUpdateMessageMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns PollUpdateMessageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PollUpdateMessageMetadata;

            /**
             * Verifies a PollUpdateMessageMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a PollUpdateMessageMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns PollUpdateMessageMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.PollUpdateMessageMetadata;

            /**
             * Creates a plain object from a PollUpdateMessageMetadata message. Also converts values to other types if specified.
             * @param message PollUpdateMessageMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.PollUpdateMessageMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this PollUpdateMessageMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a PollVoteMessage. */
        interface IPollVoteMessage {

            /** PollVoteMessage selectedOptions */
            selectedOptions?: (Uint8Array[]|null);
        }

        /** Represents a PollVoteMessage. */
        class PollVoteMessage implements IPollVoteMessage {

            /**
             * Constructs a new PollVoteMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IPollVoteMessage);

            /** PollVoteMessage selectedOptions. */
            public selectedOptions: Uint8Array[];

            /**
             * Creates a new PollVoteMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns PollVoteMessage instance
             */
            public static create(properties?: proto.Message.IPollVoteMessage): proto.Message.PollVoteMessage;

            /**
             * Encodes the specified PollVoteMessage message. Does not implicitly {@link proto.Message.PollVoteMessage.verify|verify} messages.
             * @param message PollVoteMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IPollVoteMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified PollVoteMessage message, length delimited. Does not implicitly {@link proto.Message.PollVoteMessage.verify|verify} messages.
             * @param message PollVoteMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IPollVoteMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a PollVoteMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns PollVoteMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.PollVoteMessage;

            /**
             * Decodes a PollVoteMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns PollVoteMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.PollVoteMessage;

            /**
             * Verifies a PollVoteMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a PollVoteMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns PollVoteMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.PollVoteMessage;

            /**
             * Creates a plain object from a PollVoteMessage message. Also converts values to other types if specified.
             * @param message PollVoteMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.PollVoteMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this PollVoteMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ProductMessage. */
        interface IProductMessage {

            /** ProductMessage product */
            product?: (proto.Message.ProductMessage.IProductSnapshot|null);

            /** ProductMessage businessOwnerJid */
            businessOwnerJid?: (string|null);

            /** ProductMessage catalog */
            catalog?: (proto.Message.ProductMessage.ICatalogSnapshot|null);

            /** ProductMessage body */
            body?: (string|null);

            /** ProductMessage footer */
            footer?: (string|null);

            /** ProductMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a ProductMessage. */
        class ProductMessage implements IProductMessage {

            /**
             * Constructs a new ProductMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IProductMessage);

            /** ProductMessage product. */
            public product?: (proto.Message.ProductMessage.IProductSnapshot|null);

            /** ProductMessage businessOwnerJid. */
            public businessOwnerJid: string;

            /** ProductMessage catalog. */
            public catalog?: (proto.Message.ProductMessage.ICatalogSnapshot|null);

            /** ProductMessage body. */
            public body: string;

            /** ProductMessage footer. */
            public footer: string;

            /** ProductMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new ProductMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ProductMessage instance
             */
            public static create(properties?: proto.Message.IProductMessage): proto.Message.ProductMessage;

            /**
             * Encodes the specified ProductMessage message. Does not implicitly {@link proto.Message.ProductMessage.verify|verify} messages.
             * @param message ProductMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IProductMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ProductMessage message, length delimited. Does not implicitly {@link proto.Message.ProductMessage.verify|verify} messages.
             * @param message ProductMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IProductMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ProductMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ProductMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ProductMessage;

            /**
             * Decodes a ProductMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ProductMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ProductMessage;

            /**
             * Verifies a ProductMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ProductMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ProductMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ProductMessage;

            /**
             * Creates a plain object from a ProductMessage message. Also converts values to other types if specified.
             * @param message ProductMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ProductMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ProductMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace ProductMessage {

            /** Properties of a CatalogSnapshot. */
            interface ICatalogSnapshot {

                /** CatalogSnapshot catalogImage */
                catalogImage?: (proto.Message.IImageMessage|null);

                /** CatalogSnapshot title */
                title?: (string|null);

                /** CatalogSnapshot description */
                description?: (string|null);
            }

            /** Represents a CatalogSnapshot. */
            class CatalogSnapshot implements ICatalogSnapshot {

                /**
                 * Constructs a new CatalogSnapshot.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ProductMessage.ICatalogSnapshot);

                /** CatalogSnapshot catalogImage. */
                public catalogImage?: (proto.Message.IImageMessage|null);

                /** CatalogSnapshot title. */
                public title: string;

                /** CatalogSnapshot description. */
                public description: string;

                /**
                 * Creates a new CatalogSnapshot instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns CatalogSnapshot instance
                 */
                public static create(properties?: proto.Message.ProductMessage.ICatalogSnapshot): proto.Message.ProductMessage.CatalogSnapshot;

                /**
                 * Encodes the specified CatalogSnapshot message. Does not implicitly {@link proto.Message.ProductMessage.CatalogSnapshot.verify|verify} messages.
                 * @param message CatalogSnapshot message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ProductMessage.ICatalogSnapshot, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified CatalogSnapshot message, length delimited. Does not implicitly {@link proto.Message.ProductMessage.CatalogSnapshot.verify|verify} messages.
                 * @param message CatalogSnapshot message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ProductMessage.ICatalogSnapshot, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a CatalogSnapshot message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns CatalogSnapshot
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ProductMessage.CatalogSnapshot;

                /**
                 * Decodes a CatalogSnapshot message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns CatalogSnapshot
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ProductMessage.CatalogSnapshot;

                /**
                 * Verifies a CatalogSnapshot message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a CatalogSnapshot message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns CatalogSnapshot
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ProductMessage.CatalogSnapshot;

                /**
                 * Creates a plain object from a CatalogSnapshot message. Also converts values to other types if specified.
                 * @param message CatalogSnapshot
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ProductMessage.CatalogSnapshot, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this CatalogSnapshot to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a ProductSnapshot. */
            interface IProductSnapshot {

                /** ProductSnapshot productImage */
                productImage?: (proto.Message.IImageMessage|null);

                /** ProductSnapshot productId */
                productId?: (string|null);

                /** ProductSnapshot title */
                title?: (string|null);

                /** ProductSnapshot description */
                description?: (string|null);

                /** ProductSnapshot currencyCode */
                currencyCode?: (string|null);

                /** ProductSnapshot priceAmount1000 */
                priceAmount1000?: (number|Long|null);

                /** ProductSnapshot retailerId */
                retailerId?: (string|null);

                /** ProductSnapshot url */
                url?: (string|null);

                /** ProductSnapshot productImageCount */
                productImageCount?: (number|null);

                /** ProductSnapshot firstImageId */
                firstImageId?: (string|null);

                /** ProductSnapshot salePriceAmount1000 */
                salePriceAmount1000?: (number|Long|null);
            }

            /** Represents a ProductSnapshot. */
            class ProductSnapshot implements IProductSnapshot {

                /**
                 * Constructs a new ProductSnapshot.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ProductMessage.IProductSnapshot);

                /** ProductSnapshot productImage. */
                public productImage?: (proto.Message.IImageMessage|null);

                /** ProductSnapshot productId. */
                public productId: string;

                /** ProductSnapshot title. */
                public title: string;

                /** ProductSnapshot description. */
                public description: string;

                /** ProductSnapshot currencyCode. */
                public currencyCode: string;

                /** ProductSnapshot priceAmount1000. */
                public priceAmount1000: (number|Long);

                /** ProductSnapshot retailerId. */
                public retailerId: string;

                /** ProductSnapshot url. */
                public url: string;

                /** ProductSnapshot productImageCount. */
                public productImageCount: number;

                /** ProductSnapshot firstImageId. */
                public firstImageId: string;

                /** ProductSnapshot salePriceAmount1000. */
                public salePriceAmount1000: (number|Long);

                /**
                 * Creates a new ProductSnapshot instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns ProductSnapshot instance
                 */
                public static create(properties?: proto.Message.ProductMessage.IProductSnapshot): proto.Message.ProductMessage.ProductSnapshot;

                /**
                 * Encodes the specified ProductSnapshot message. Does not implicitly {@link proto.Message.ProductMessage.ProductSnapshot.verify|verify} messages.
                 * @param message ProductSnapshot message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ProductMessage.IProductSnapshot, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified ProductSnapshot message, length delimited. Does not implicitly {@link proto.Message.ProductMessage.ProductSnapshot.verify|verify} messages.
                 * @param message ProductSnapshot message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ProductMessage.IProductSnapshot, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a ProductSnapshot message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns ProductSnapshot
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ProductMessage.ProductSnapshot;

                /**
                 * Decodes a ProductSnapshot message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns ProductSnapshot
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ProductMessage.ProductSnapshot;

                /**
                 * Verifies a ProductSnapshot message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a ProductSnapshot message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns ProductSnapshot
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ProductMessage.ProductSnapshot;

                /**
                 * Creates a plain object from a ProductSnapshot message. Also converts values to other types if specified.
                 * @param message ProductSnapshot
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ProductMessage.ProductSnapshot, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this ProductSnapshot to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a ProtocolMessage. */
        interface IProtocolMessage {

            /** ProtocolMessage key */
            key?: (proto.IMessageKey|null);

            /** ProtocolMessage type */
            type?: (proto.Message.ProtocolMessage.Type|null);

            /** ProtocolMessage ephemeralExpiration */
            ephemeralExpiration?: (number|null);

            /** ProtocolMessage ephemeralSettingTimestamp */
            ephemeralSettingTimestamp?: (number|Long|null);

            /** ProtocolMessage historySyncNotification */
            historySyncNotification?: (proto.Message.IHistorySyncNotification|null);

            /** ProtocolMessage appStateSyncKeyShare */
            appStateSyncKeyShare?: (proto.Message.IAppStateSyncKeyShare|null);

            /** ProtocolMessage appStateSyncKeyRequest */
            appStateSyncKeyRequest?: (proto.Message.IAppStateSyncKeyRequest|null);

            /** ProtocolMessage initialSecurityNotificationSettingSync */
            initialSecurityNotificationSettingSync?: (proto.Message.IInitialSecurityNotificationSettingSync|null);

            /** ProtocolMessage appStateFatalExceptionNotification */
            appStateFatalExceptionNotification?: (proto.Message.IAppStateFatalExceptionNotification|null);

            /** ProtocolMessage disappearingMode */
            disappearingMode?: (proto.IDisappearingMode|null);

            /** ProtocolMessage editedMessage */
            editedMessage?: (proto.IMessage|null);

            /** ProtocolMessage timestampMs */
            timestampMs?: (number|Long|null);

            /** ProtocolMessage peerDataOperationRequestMessage */
            peerDataOperationRequestMessage?: (proto.Message.IPeerDataOperationRequestMessage|null);

            /** ProtocolMessage peerDataOperationRequestResponseMessage */
            peerDataOperationRequestResponseMessage?: (proto.Message.IPeerDataOperationRequestResponseMessage|null);
        }

        /** Represents a ProtocolMessage. */
        class ProtocolMessage implements IProtocolMessage {

            /**
             * Constructs a new ProtocolMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IProtocolMessage);

            /** ProtocolMessage key. */
            public key?: (proto.IMessageKey|null);

            /** ProtocolMessage type. */
            public type: proto.Message.ProtocolMessage.Type;

            /** ProtocolMessage ephemeralExpiration. */
            public ephemeralExpiration: number;

            /** ProtocolMessage ephemeralSettingTimestamp. */
            public ephemeralSettingTimestamp: (number|Long);

            /** ProtocolMessage historySyncNotification. */
            public historySyncNotification?: (proto.Message.IHistorySyncNotification|null);

            /** ProtocolMessage appStateSyncKeyShare. */
            public appStateSyncKeyShare?: (proto.Message.IAppStateSyncKeyShare|null);

            /** ProtocolMessage appStateSyncKeyRequest. */
            public appStateSyncKeyRequest?: (proto.Message.IAppStateSyncKeyRequest|null);

            /** ProtocolMessage initialSecurityNotificationSettingSync. */
            public initialSecurityNotificationSettingSync?: (proto.Message.IInitialSecurityNotificationSettingSync|null);

            /** ProtocolMessage appStateFatalExceptionNotification. */
            public appStateFatalExceptionNotification?: (proto.Message.IAppStateFatalExceptionNotification|null);

            /** ProtocolMessage disappearingMode. */
            public disappearingMode?: (proto.IDisappearingMode|null);

            /** ProtocolMessage editedMessage. */
            public editedMessage?: (proto.IMessage|null);

            /** ProtocolMessage timestampMs. */
            public timestampMs: (number|Long);

            /** ProtocolMessage peerDataOperationRequestMessage. */
            public peerDataOperationRequestMessage?: (proto.Message.IPeerDataOperationRequestMessage|null);

            /** ProtocolMessage peerDataOperationRequestResponseMessage. */
            public peerDataOperationRequestResponseMessage?: (proto.Message.IPeerDataOperationRequestResponseMessage|null);

            /**
             * Creates a new ProtocolMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ProtocolMessage instance
             */
            public static create(properties?: proto.Message.IProtocolMessage): proto.Message.ProtocolMessage;

            /**
             * Encodes the specified ProtocolMessage message. Does not implicitly {@link proto.Message.ProtocolMessage.verify|verify} messages.
             * @param message ProtocolMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IProtocolMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ProtocolMessage message, length delimited. Does not implicitly {@link proto.Message.ProtocolMessage.verify|verify} messages.
             * @param message ProtocolMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IProtocolMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ProtocolMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ProtocolMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ProtocolMessage;

            /**
             * Decodes a ProtocolMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ProtocolMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ProtocolMessage;

            /**
             * Verifies a ProtocolMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ProtocolMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ProtocolMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ProtocolMessage;

            /**
             * Creates a plain object from a ProtocolMessage message. Also converts values to other types if specified.
             * @param message ProtocolMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ProtocolMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ProtocolMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace ProtocolMessage {

            /** Type enum. */
            enum Type {
                REVOKE = 0,
                EPHEMERAL_SETTING = 3,
                EPHEMERAL_SYNC_RESPONSE = 4,
                HISTORY_SYNC_NOTIFICATION = 5,
                APP_STATE_SYNC_KEY_SHARE = 6,
                APP_STATE_SYNC_KEY_REQUEST = 7,
                MSG_FANOUT_BACKFILL_REQUEST = 8,
                INITIAL_SECURITY_NOTIFICATION_SETTING_SYNC = 9,
                APP_STATE_FATAL_EXCEPTION_NOTIFICATION = 10,
                SHARE_PHONE_NUMBER = 11,
                MESSAGE_EDIT = 14,
                PEER_DATA_OPERATION_REQUEST_MESSAGE = 16,
                PEER_DATA_OPERATION_REQUEST_RESPONSE_MESSAGE = 17
            }
        }

        /** Properties of a ReactionMessage. */
        interface IReactionMessage {

            /** ReactionMessage key */
            key?: (proto.IMessageKey|null);

            /** ReactionMessage text */
            text?: (string|null);

            /** ReactionMessage groupingKey */
            groupingKey?: (string|null);

            /** ReactionMessage senderTimestampMs */
            senderTimestampMs?: (number|Long|null);
        }

        /** Represents a ReactionMessage. */
        class ReactionMessage implements IReactionMessage {

            /**
             * Constructs a new ReactionMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IReactionMessage);

            /** ReactionMessage key. */
            public key?: (proto.IMessageKey|null);

            /** ReactionMessage text. */
            public text: string;

            /** ReactionMessage groupingKey. */
            public groupingKey: string;

            /** ReactionMessage senderTimestampMs. */
            public senderTimestampMs: (number|Long);

            /**
             * Creates a new ReactionMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ReactionMessage instance
             */
            public static create(properties?: proto.Message.IReactionMessage): proto.Message.ReactionMessage;

            /**
             * Encodes the specified ReactionMessage message. Does not implicitly {@link proto.Message.ReactionMessage.verify|verify} messages.
             * @param message ReactionMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IReactionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ReactionMessage message, length delimited. Does not implicitly {@link proto.Message.ReactionMessage.verify|verify} messages.
             * @param message ReactionMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IReactionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ReactionMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ReactionMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ReactionMessage;

            /**
             * Decodes a ReactionMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ReactionMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ReactionMessage;

            /**
             * Verifies a ReactionMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ReactionMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ReactionMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ReactionMessage;

            /**
             * Creates a plain object from a ReactionMessage message. Also converts values to other types if specified.
             * @param message ReactionMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ReactionMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ReactionMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a RequestPaymentMessage. */
        interface IRequestPaymentMessage {

            /** RequestPaymentMessage noteMessage */
            noteMessage?: (proto.IMessage|null);

            /** RequestPaymentMessage currencyCodeIso4217 */
            currencyCodeIso4217?: (string|null);

            /** RequestPaymentMessage amount1000 */
            amount1000?: (number|Long|null);

            /** RequestPaymentMessage requestFrom */
            requestFrom?: (string|null);

            /** RequestPaymentMessage expiryTimestamp */
            expiryTimestamp?: (number|Long|null);

            /** RequestPaymentMessage amount */
            amount?: (proto.IMoney|null);

            /** RequestPaymentMessage background */
            background?: (proto.IPaymentBackground|null);
        }

        /** Represents a RequestPaymentMessage. */
        class RequestPaymentMessage implements IRequestPaymentMessage {

            /**
             * Constructs a new RequestPaymentMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IRequestPaymentMessage);

            /** RequestPaymentMessage noteMessage. */
            public noteMessage?: (proto.IMessage|null);

            /** RequestPaymentMessage currencyCodeIso4217. */
            public currencyCodeIso4217: string;

            /** RequestPaymentMessage amount1000. */
            public amount1000: (number|Long);

            /** RequestPaymentMessage requestFrom. */
            public requestFrom: string;

            /** RequestPaymentMessage expiryTimestamp. */
            public expiryTimestamp: (number|Long);

            /** RequestPaymentMessage amount. */
            public amount?: (proto.IMoney|null);

            /** RequestPaymentMessage background. */
            public background?: (proto.IPaymentBackground|null);

            /**
             * Creates a new RequestPaymentMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns RequestPaymentMessage instance
             */
            public static create(properties?: proto.Message.IRequestPaymentMessage): proto.Message.RequestPaymentMessage;

            /**
             * Encodes the specified RequestPaymentMessage message. Does not implicitly {@link proto.Message.RequestPaymentMessage.verify|verify} messages.
             * @param message RequestPaymentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IRequestPaymentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified RequestPaymentMessage message, length delimited. Does not implicitly {@link proto.Message.RequestPaymentMessage.verify|verify} messages.
             * @param message RequestPaymentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IRequestPaymentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a RequestPaymentMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns RequestPaymentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.RequestPaymentMessage;

            /**
             * Decodes a RequestPaymentMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns RequestPaymentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.RequestPaymentMessage;

            /**
             * Verifies a RequestPaymentMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a RequestPaymentMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns RequestPaymentMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.RequestPaymentMessage;

            /**
             * Creates a plain object from a RequestPaymentMessage message. Also converts values to other types if specified.
             * @param message RequestPaymentMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.RequestPaymentMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this RequestPaymentMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a RequestPhoneNumberMessage. */
        interface IRequestPhoneNumberMessage {

            /** RequestPhoneNumberMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a RequestPhoneNumberMessage. */
        class RequestPhoneNumberMessage implements IRequestPhoneNumberMessage {

            /**
             * Constructs a new RequestPhoneNumberMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IRequestPhoneNumberMessage);

            /** RequestPhoneNumberMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new RequestPhoneNumberMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns RequestPhoneNumberMessage instance
             */
            public static create(properties?: proto.Message.IRequestPhoneNumberMessage): proto.Message.RequestPhoneNumberMessage;

            /**
             * Encodes the specified RequestPhoneNumberMessage message. Does not implicitly {@link proto.Message.RequestPhoneNumberMessage.verify|verify} messages.
             * @param message RequestPhoneNumberMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IRequestPhoneNumberMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified RequestPhoneNumberMessage message, length delimited. Does not implicitly {@link proto.Message.RequestPhoneNumberMessage.verify|verify} messages.
             * @param message RequestPhoneNumberMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IRequestPhoneNumberMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a RequestPhoneNumberMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns RequestPhoneNumberMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.RequestPhoneNumberMessage;

            /**
             * Decodes a RequestPhoneNumberMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns RequestPhoneNumberMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.RequestPhoneNumberMessage;

            /**
             * Verifies a RequestPhoneNumberMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a RequestPhoneNumberMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns RequestPhoneNumberMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.RequestPhoneNumberMessage;

            /**
             * Creates a plain object from a RequestPhoneNumberMessage message. Also converts values to other types if specified.
             * @param message RequestPhoneNumberMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.RequestPhoneNumberMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this RequestPhoneNumberMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a SendPaymentMessage. */
        interface ISendPaymentMessage {

            /** SendPaymentMessage noteMessage */
            noteMessage?: (proto.IMessage|null);

            /** SendPaymentMessage requestMessageKey */
            requestMessageKey?: (proto.IMessageKey|null);

            /** SendPaymentMessage background */
            background?: (proto.IPaymentBackground|null);
        }

        /** Represents a SendPaymentMessage. */
        class SendPaymentMessage implements ISendPaymentMessage {

            /**
             * Constructs a new SendPaymentMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ISendPaymentMessage);

            /** SendPaymentMessage noteMessage. */
            public noteMessage?: (proto.IMessage|null);

            /** SendPaymentMessage requestMessageKey. */
            public requestMessageKey?: (proto.IMessageKey|null);

            /** SendPaymentMessage background. */
            public background?: (proto.IPaymentBackground|null);

            /**
             * Creates a new SendPaymentMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns SendPaymentMessage instance
             */
            public static create(properties?: proto.Message.ISendPaymentMessage): proto.Message.SendPaymentMessage;

            /**
             * Encodes the specified SendPaymentMessage message. Does not implicitly {@link proto.Message.SendPaymentMessage.verify|verify} messages.
             * @param message SendPaymentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ISendPaymentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified SendPaymentMessage message, length delimited. Does not implicitly {@link proto.Message.SendPaymentMessage.verify|verify} messages.
             * @param message SendPaymentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ISendPaymentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a SendPaymentMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns SendPaymentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.SendPaymentMessage;

            /**
             * Decodes a SendPaymentMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns SendPaymentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.SendPaymentMessage;

            /**
             * Verifies a SendPaymentMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a SendPaymentMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns SendPaymentMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.SendPaymentMessage;

            /**
             * Creates a plain object from a SendPaymentMessage message. Also converts values to other types if specified.
             * @param message SendPaymentMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.SendPaymentMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this SendPaymentMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a SenderKeyDistributionMessage. */
        interface ISenderKeyDistributionMessage {

            /** SenderKeyDistributionMessage groupId */
            groupId?: (string|null);

            /** SenderKeyDistributionMessage axolotlSenderKeyDistributionMessage */
            axolotlSenderKeyDistributionMessage?: (Uint8Array|null);
        }

        /** Represents a SenderKeyDistributionMessage. */
        class SenderKeyDistributionMessage implements ISenderKeyDistributionMessage {

            /**
             * Constructs a new SenderKeyDistributionMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ISenderKeyDistributionMessage);

            /** SenderKeyDistributionMessage groupId. */
            public groupId: string;

            /** SenderKeyDistributionMessage axolotlSenderKeyDistributionMessage. */
            public axolotlSenderKeyDistributionMessage: Uint8Array;

            /**
             * Creates a new SenderKeyDistributionMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns SenderKeyDistributionMessage instance
             */
            public static create(properties?: proto.Message.ISenderKeyDistributionMessage): proto.Message.SenderKeyDistributionMessage;

            /**
             * Encodes the specified SenderKeyDistributionMessage message. Does not implicitly {@link proto.Message.SenderKeyDistributionMessage.verify|verify} messages.
             * @param message SenderKeyDistributionMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ISenderKeyDistributionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified SenderKeyDistributionMessage message, length delimited. Does not implicitly {@link proto.Message.SenderKeyDistributionMessage.verify|verify} messages.
             * @param message SenderKeyDistributionMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ISenderKeyDistributionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a SenderKeyDistributionMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns SenderKeyDistributionMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.SenderKeyDistributionMessage;

            /**
             * Decodes a SenderKeyDistributionMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns SenderKeyDistributionMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.SenderKeyDistributionMessage;

            /**
             * Verifies a SenderKeyDistributionMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a SenderKeyDistributionMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns SenderKeyDistributionMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.SenderKeyDistributionMessage;

            /**
             * Creates a plain object from a SenderKeyDistributionMessage message. Also converts values to other types if specified.
             * @param message SenderKeyDistributionMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.SenderKeyDistributionMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this SenderKeyDistributionMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a StickerMessage. */
        interface IStickerMessage {

            /** StickerMessage url */
            url?: (string|null);

            /** StickerMessage fileSha256 */
            fileSha256?: (Uint8Array|null);

            /** StickerMessage fileEncSha256 */
            fileEncSha256?: (Uint8Array|null);

            /** StickerMessage mediaKey */
            mediaKey?: (Uint8Array|null);

            /** StickerMessage mimetype */
            mimetype?: (string|null);

            /** StickerMessage height */
            height?: (number|null);

            /** StickerMessage width */
            width?: (number|null);

            /** StickerMessage directPath */
            directPath?: (string|null);

            /** StickerMessage fileLength */
            fileLength?: (number|Long|null);

            /** StickerMessage mediaKeyTimestamp */
            mediaKeyTimestamp?: (number|Long|null);

            /** StickerMessage firstFrameLength */
            firstFrameLength?: (number|null);

            /** StickerMessage firstFrameSidecar */
            firstFrameSidecar?: (Uint8Array|null);

            /** StickerMessage isAnimated */
            isAnimated?: (boolean|null);

            /** StickerMessage pngThumbnail */
            pngThumbnail?: (Uint8Array|null);

            /** StickerMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** StickerMessage stickerSentTs */
            stickerSentTs?: (number|Long|null);

            /** StickerMessage isAvatar */
            isAvatar?: (boolean|null);
        }

        /** Represents a StickerMessage. */
        class StickerMessage implements IStickerMessage {

            /**
             * Constructs a new StickerMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IStickerMessage);

            /** StickerMessage url. */
            public url: string;

            /** StickerMessage fileSha256. */
            public fileSha256: Uint8Array;

            /** StickerMessage fileEncSha256. */
            public fileEncSha256: Uint8Array;

            /** StickerMessage mediaKey. */
            public mediaKey: Uint8Array;

            /** StickerMessage mimetype. */
            public mimetype: string;

            /** StickerMessage height. */
            public height: number;

            /** StickerMessage width. */
            public width: number;

            /** StickerMessage directPath. */
            public directPath: string;

            /** StickerMessage fileLength. */
            public fileLength: (number|Long);

            /** StickerMessage mediaKeyTimestamp. */
            public mediaKeyTimestamp: (number|Long);

            /** StickerMessage firstFrameLength. */
            public firstFrameLength: number;

            /** StickerMessage firstFrameSidecar. */
            public firstFrameSidecar: Uint8Array;

            /** StickerMessage isAnimated. */
            public isAnimated: boolean;

            /** StickerMessage pngThumbnail. */
            public pngThumbnail: Uint8Array;

            /** StickerMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** StickerMessage stickerSentTs. */
            public stickerSentTs: (number|Long);

            /** StickerMessage isAvatar. */
            public isAvatar: boolean;

            /**
             * Creates a new StickerMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns StickerMessage instance
             */
            public static create(properties?: proto.Message.IStickerMessage): proto.Message.StickerMessage;

            /**
             * Encodes the specified StickerMessage message. Does not implicitly {@link proto.Message.StickerMessage.verify|verify} messages.
             * @param message StickerMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IStickerMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified StickerMessage message, length delimited. Does not implicitly {@link proto.Message.StickerMessage.verify|verify} messages.
             * @param message StickerMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IStickerMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a StickerMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns StickerMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.StickerMessage;

            /**
             * Decodes a StickerMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns StickerMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.StickerMessage;

            /**
             * Verifies a StickerMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a StickerMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns StickerMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.StickerMessage;

            /**
             * Creates a plain object from a StickerMessage message. Also converts values to other types if specified.
             * @param message StickerMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.StickerMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this StickerMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a StickerSyncRMRMessage. */
        interface IStickerSyncRMRMessage {

            /** StickerSyncRMRMessage filehash */
            filehash?: (string[]|null);

            /** StickerSyncRMRMessage rmrSource */
            rmrSource?: (string|null);

            /** StickerSyncRMRMessage requestTimestamp */
            requestTimestamp?: (number|Long|null);
        }

        /** Represents a StickerSyncRMRMessage. */
        class StickerSyncRMRMessage implements IStickerSyncRMRMessage {

            /**
             * Constructs a new StickerSyncRMRMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IStickerSyncRMRMessage);

            /** StickerSyncRMRMessage filehash. */
            public filehash: string[];

            /** StickerSyncRMRMessage rmrSource. */
            public rmrSource: string;

            /** StickerSyncRMRMessage requestTimestamp. */
            public requestTimestamp: (number|Long);

            /**
             * Creates a new StickerSyncRMRMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns StickerSyncRMRMessage instance
             */
            public static create(properties?: proto.Message.IStickerSyncRMRMessage): proto.Message.StickerSyncRMRMessage;

            /**
             * Encodes the specified StickerSyncRMRMessage message. Does not implicitly {@link proto.Message.StickerSyncRMRMessage.verify|verify} messages.
             * @param message StickerSyncRMRMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IStickerSyncRMRMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified StickerSyncRMRMessage message, length delimited. Does not implicitly {@link proto.Message.StickerSyncRMRMessage.verify|verify} messages.
             * @param message StickerSyncRMRMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IStickerSyncRMRMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a StickerSyncRMRMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns StickerSyncRMRMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.StickerSyncRMRMessage;

            /**
             * Decodes a StickerSyncRMRMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns StickerSyncRMRMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.StickerSyncRMRMessage;

            /**
             * Verifies a StickerSyncRMRMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a StickerSyncRMRMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns StickerSyncRMRMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.StickerSyncRMRMessage;

            /**
             * Creates a plain object from a StickerSyncRMRMessage message. Also converts values to other types if specified.
             * @param message StickerSyncRMRMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.StickerSyncRMRMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this StickerSyncRMRMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TemplateButtonReplyMessage. */
        interface ITemplateButtonReplyMessage {

            /** TemplateButtonReplyMessage selectedId */
            selectedId?: (string|null);

            /** TemplateButtonReplyMessage selectedDisplayText */
            selectedDisplayText?: (string|null);

            /** TemplateButtonReplyMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** TemplateButtonReplyMessage selectedIndex */
            selectedIndex?: (number|null);
        }

        /** Represents a TemplateButtonReplyMessage. */
        class TemplateButtonReplyMessage implements ITemplateButtonReplyMessage {

            /**
             * Constructs a new TemplateButtonReplyMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ITemplateButtonReplyMessage);

            /** TemplateButtonReplyMessage selectedId. */
            public selectedId: string;

            /** TemplateButtonReplyMessage selectedDisplayText. */
            public selectedDisplayText: string;

            /** TemplateButtonReplyMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** TemplateButtonReplyMessage selectedIndex. */
            public selectedIndex: number;

            /**
             * Creates a new TemplateButtonReplyMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TemplateButtonReplyMessage instance
             */
            public static create(properties?: proto.Message.ITemplateButtonReplyMessage): proto.Message.TemplateButtonReplyMessage;

            /**
             * Encodes the specified TemplateButtonReplyMessage message. Does not implicitly {@link proto.Message.TemplateButtonReplyMessage.verify|verify} messages.
             * @param message TemplateButtonReplyMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ITemplateButtonReplyMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TemplateButtonReplyMessage message, length delimited. Does not implicitly {@link proto.Message.TemplateButtonReplyMessage.verify|verify} messages.
             * @param message TemplateButtonReplyMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ITemplateButtonReplyMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TemplateButtonReplyMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TemplateButtonReplyMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.TemplateButtonReplyMessage;

            /**
             * Decodes a TemplateButtonReplyMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TemplateButtonReplyMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.TemplateButtonReplyMessage;

            /**
             * Verifies a TemplateButtonReplyMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TemplateButtonReplyMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TemplateButtonReplyMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.TemplateButtonReplyMessage;

            /**
             * Creates a plain object from a TemplateButtonReplyMessage message. Also converts values to other types if specified.
             * @param message TemplateButtonReplyMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.TemplateButtonReplyMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TemplateButtonReplyMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TemplateMessage. */
        interface ITemplateMessage {

            /** TemplateMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** TemplateMessage hydratedTemplate */
            hydratedTemplate?: (proto.Message.TemplateMessage.IHydratedFourRowTemplate|null);

            /** TemplateMessage templateId */
            templateId?: (string|null);

            /** TemplateMessage fourRowTemplate */
            fourRowTemplate?: (proto.Message.TemplateMessage.IFourRowTemplate|null);

            /** TemplateMessage hydratedFourRowTemplate */
            hydratedFourRowTemplate?: (proto.Message.TemplateMessage.IHydratedFourRowTemplate|null);

            /** TemplateMessage interactiveMessageTemplate */
            interactiveMessageTemplate?: (proto.Message.IInteractiveMessage|null);
        }

        /** Represents a TemplateMessage. */
        class TemplateMessage implements ITemplateMessage {

            /**
             * Constructs a new TemplateMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ITemplateMessage);

            /** TemplateMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** TemplateMessage hydratedTemplate. */
            public hydratedTemplate?: (proto.Message.TemplateMessage.IHydratedFourRowTemplate|null);

            /** TemplateMessage templateId. */
            public templateId: string;

            /** TemplateMessage fourRowTemplate. */
            public fourRowTemplate?: (proto.Message.TemplateMessage.IFourRowTemplate|null);

            /** TemplateMessage hydratedFourRowTemplate. */
            public hydratedFourRowTemplate?: (proto.Message.TemplateMessage.IHydratedFourRowTemplate|null);

            /** TemplateMessage interactiveMessageTemplate. */
            public interactiveMessageTemplate?: (proto.Message.IInteractiveMessage|null);

            /** TemplateMessage format. */
            public format?: ("fourRowTemplate"|"hydratedFourRowTemplate"|"interactiveMessageTemplate");

            /**
             * Creates a new TemplateMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TemplateMessage instance
             */
            public static create(properties?: proto.Message.ITemplateMessage): proto.Message.TemplateMessage;

            /**
             * Encodes the specified TemplateMessage message. Does not implicitly {@link proto.Message.TemplateMessage.verify|verify} messages.
             * @param message TemplateMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ITemplateMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TemplateMessage message, length delimited. Does not implicitly {@link proto.Message.TemplateMessage.verify|verify} messages.
             * @param message TemplateMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ITemplateMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TemplateMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TemplateMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.TemplateMessage;

            /**
             * Decodes a TemplateMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TemplateMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.TemplateMessage;

            /**
             * Verifies a TemplateMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TemplateMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TemplateMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.TemplateMessage;

            /**
             * Creates a plain object from a TemplateMessage message. Also converts values to other types if specified.
             * @param message TemplateMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.TemplateMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TemplateMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TemplateMessage {

            /** Properties of a FourRowTemplate. */
            interface IFourRowTemplate {

                /** FourRowTemplate content */
                content?: (proto.Message.IHighlyStructuredMessage|null);

                /** FourRowTemplate footer */
                footer?: (proto.Message.IHighlyStructuredMessage|null);

                /** FourRowTemplate buttons */
                buttons?: (proto.ITemplateButton[]|null);

                /** FourRowTemplate documentMessage */
                documentMessage?: (proto.Message.IDocumentMessage|null);

                /** FourRowTemplate highlyStructuredMessage */
                highlyStructuredMessage?: (proto.Message.IHighlyStructuredMessage|null);

                /** FourRowTemplate imageMessage */
                imageMessage?: (proto.Message.IImageMessage|null);

                /** FourRowTemplate videoMessage */
                videoMessage?: (proto.Message.IVideoMessage|null);

                /** FourRowTemplate locationMessage */
                locationMessage?: (proto.Message.ILocationMessage|null);
            }

            /** Represents a FourRowTemplate. */
            class FourRowTemplate implements IFourRowTemplate {

                /**
                 * Constructs a new FourRowTemplate.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.TemplateMessage.IFourRowTemplate);

                /** FourRowTemplate content. */
                public content?: (proto.Message.IHighlyStructuredMessage|null);

                /** FourRowTemplate footer. */
                public footer?: (proto.Message.IHighlyStructuredMessage|null);

                /** FourRowTemplate buttons. */
                public buttons: proto.ITemplateButton[];

                /** FourRowTemplate documentMessage. */
                public documentMessage?: (proto.Message.IDocumentMessage|null);

                /** FourRowTemplate highlyStructuredMessage. */
                public highlyStructuredMessage?: (proto.Message.IHighlyStructuredMessage|null);

                /** FourRowTemplate imageMessage. */
                public imageMessage?: (proto.Message.IImageMessage|null);

                /** FourRowTemplate videoMessage. */
                public videoMessage?: (proto.Message.IVideoMessage|null);

                /** FourRowTemplate locationMessage. */
                public locationMessage?: (proto.Message.ILocationMessage|null);

                /** FourRowTemplate title. */
                public title?: ("documentMessage"|"highlyStructuredMessage"|"imageMessage"|"videoMessage"|"locationMessage");

                /**
                 * Creates a new FourRowTemplate instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns FourRowTemplate instance
                 */
                public static create(properties?: proto.Message.TemplateMessage.IFourRowTemplate): proto.Message.TemplateMessage.FourRowTemplate;

                /**
                 * Encodes the specified FourRowTemplate message. Does not implicitly {@link proto.Message.TemplateMessage.FourRowTemplate.verify|verify} messages.
                 * @param message FourRowTemplate message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.TemplateMessage.IFourRowTemplate, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified FourRowTemplate message, length delimited. Does not implicitly {@link proto.Message.TemplateMessage.FourRowTemplate.verify|verify} messages.
                 * @param message FourRowTemplate message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.TemplateMessage.IFourRowTemplate, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a FourRowTemplate message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns FourRowTemplate
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.TemplateMessage.FourRowTemplate;

                /**
                 * Decodes a FourRowTemplate message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns FourRowTemplate
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.TemplateMessage.FourRowTemplate;

                /**
                 * Verifies a FourRowTemplate message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a FourRowTemplate message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns FourRowTemplate
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.TemplateMessage.FourRowTemplate;

                /**
                 * Creates a plain object from a FourRowTemplate message. Also converts values to other types if specified.
                 * @param message FourRowTemplate
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.TemplateMessage.FourRowTemplate, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this FourRowTemplate to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a HydratedFourRowTemplate. */
            interface IHydratedFourRowTemplate {

                /** HydratedFourRowTemplate hydratedContentText */
                hydratedContentText?: (string|null);

                /** HydratedFourRowTemplate hydratedFooterText */
                hydratedFooterText?: (string|null);

                /** HydratedFourRowTemplate hydratedButtons */
                hydratedButtons?: (proto.IHydratedTemplateButton[]|null);

                /** HydratedFourRowTemplate templateId */
                templateId?: (string|null);

                /** HydratedFourRowTemplate documentMessage */
                documentMessage?: (proto.Message.IDocumentMessage|null);

                /** HydratedFourRowTemplate hydratedTitleText */
                hydratedTitleText?: (string|null);

                /** HydratedFourRowTemplate imageMessage */
                imageMessage?: (proto.Message.IImageMessage|null);

                /** HydratedFourRowTemplate videoMessage */
                videoMessage?: (proto.Message.IVideoMessage|null);

                /** HydratedFourRowTemplate locationMessage */
                locationMessage?: (proto.Message.ILocationMessage|null);
            }

            /** Represents a HydratedFourRowTemplate. */
            class HydratedFourRowTemplate implements IHydratedFourRowTemplate {

                /**
                 * Constructs a new HydratedFourRowTemplate.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.TemplateMessage.IHydratedFourRowTemplate);

                /** HydratedFourRowTemplate hydratedContentText. */
                public hydratedContentText: string;

                /** HydratedFourRowTemplate hydratedFooterText. */
                public hydratedFooterText: string;

                /** HydratedFourRowTemplate hydratedButtons. */
                public hydratedButtons: proto.IHydratedTemplateButton[];

                /** HydratedFourRowTemplate templateId. */
                public templateId: string;

                /** HydratedFourRowTemplate documentMessage. */
                public documentMessage?: (proto.Message.IDocumentMessage|null);

                /** HydratedFourRowTemplate hydratedTitleText. */
                public hydratedTitleText?: (string|null);

                /** HydratedFourRowTemplate imageMessage. */
                public imageMessage?: (proto.Message.IImageMessage|null);

                /** HydratedFourRowTemplate videoMessage. */
                public videoMessage?: (proto.Message.IVideoMessage|null);

                /** HydratedFourRowTemplate locationMessage. */
                public locationMessage?: (proto.Message.ILocationMessage|null);

                /** HydratedFourRowTemplate title. */
                public title?: ("documentMessage"|"hydratedTitleText"|"imageMessage"|"videoMessage"|"locationMessage");

                /**
                 * Creates a new HydratedFourRowTemplate instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns HydratedFourRowTemplate instance
                 */
                public static create(properties?: proto.Message.TemplateMessage.IHydratedFourRowTemplate): proto.Message.TemplateMessage.HydratedFourRowTemplate;

                /**
                 * Encodes the specified HydratedFourRowTemplate message. Does not implicitly {@link proto.Message.TemplateMessage.HydratedFourRowTemplate.verify|verify} messages.
                 * @param message HydratedFourRowTemplate message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.TemplateMessage.IHydratedFourRowTemplate, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified HydratedFourRowTemplate message, length delimited. Does not implicitly {@link proto.Message.TemplateMessage.HydratedFourRowTemplate.verify|verify} messages.
                 * @param message HydratedFourRowTemplate message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.TemplateMessage.IHydratedFourRowTemplate, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a HydratedFourRowTemplate message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns HydratedFourRowTemplate
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.TemplateMessage.HydratedFourRowTemplate;

                /**
                 * Decodes a HydratedFourRowTemplate message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns HydratedFourRowTemplate
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.TemplateMessage.HydratedFourRowTemplate;

                /**
                 * Verifies a HydratedFourRowTemplate message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a HydratedFourRowTemplate message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns HydratedFourRowTemplate
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.TemplateMessage.HydratedFourRowTemplate;

                /**
                 * Creates a plain object from a HydratedFourRowTemplate message. Also converts values to other types if specified.
                 * @param message HydratedFourRowTemplate
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.TemplateMessage.HydratedFourRowTemplate, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this HydratedFourRowTemplate to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a VideoMessage. */
        interface IVideoMessage {

            /** VideoMessage url */
            url?: (string|null);

            /** VideoMessage mimetype */
            mimetype?: (string|null);

            /** VideoMessage fileSha256 */
            fileSha256?: (Uint8Array|null);

            /** VideoMessage fileLength */
            fileLength?: (number|Long|null);

            /** VideoMessage seconds */
            seconds?: (number|null);

            /** VideoMessage mediaKey */
            mediaKey?: (Uint8Array|null);

            /** VideoMessage caption */
            caption?: (string|null);

            /** VideoMessage gifPlayback */
            gifPlayback?: (boolean|null);

            /** VideoMessage height */
            height?: (number|null);

            /** VideoMessage width */
            width?: (number|null);

            /** VideoMessage fileEncSha256 */
            fileEncSha256?: (Uint8Array|null);

            /** VideoMessage interactiveAnnotations */
            interactiveAnnotations?: (proto.IInteractiveAnnotation[]|null);

            /** VideoMessage directPath */
            directPath?: (string|null);

            /** VideoMessage mediaKeyTimestamp */
            mediaKeyTimestamp?: (number|Long|null);

            /** VideoMessage jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** VideoMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** VideoMessage streamingSidecar */
            streamingSidecar?: (Uint8Array|null);

            /** VideoMessage gifAttribution */
            gifAttribution?: (proto.Message.VideoMessage.Attribution|null);

            /** VideoMessage viewOnce */
            viewOnce?: (boolean|null);

            /** VideoMessage thumbnailDirectPath */
            thumbnailDirectPath?: (string|null);

            /** VideoMessage thumbnailSha256 */
            thumbnailSha256?: (Uint8Array|null);

            /** VideoMessage thumbnailEncSha256 */
            thumbnailEncSha256?: (Uint8Array|null);

            /** VideoMessage staticUrl */
            staticUrl?: (string|null);
        }

        /** Represents a VideoMessage. */
        class VideoMessage implements IVideoMessage {

            /**
             * Constructs a new VideoMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IVideoMessage);

            /** VideoMessage url. */
            public url: string;

            /** VideoMessage mimetype. */
            public mimetype: string;

            /** VideoMessage fileSha256. */
            public fileSha256: Uint8Array;

            /** VideoMessage fileLength. */
            public fileLength: (number|Long);

            /** VideoMessage seconds. */
            public seconds: number;

            /** VideoMessage mediaKey. */
            public mediaKey: Uint8Array;

            /** VideoMessage caption. */
            public caption: string;

            /** VideoMessage gifPlayback. */
            public gifPlayback: boolean;

            /** VideoMessage height. */
            public height: number;

            /** VideoMessage width. */
            public width: number;

            /** VideoMessage fileEncSha256. */
            public fileEncSha256: Uint8Array;

            /** VideoMessage interactiveAnnotations. */
            public interactiveAnnotations: proto.IInteractiveAnnotation[];

            /** VideoMessage directPath. */
            public directPath: string;

            /** VideoMessage mediaKeyTimestamp. */
            public mediaKeyTimestamp: (number|Long);

            /** VideoMessage jpegThumbnail. */
            public jpegThumbnail: Uint8Array;

            /** VideoMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** VideoMessage streamingSidecar. */
            public streamingSidecar: Uint8Array;

            /** VideoMessage gifAttribution. */
            public gifAttribution: proto.Message.VideoMessage.Attribution;

            /** VideoMessage viewOnce. */
            public viewOnce: boolean;

            /** VideoMessage thumbnailDirectPath. */
            public thumbnailDirectPath: string;

            /** VideoMessage thumbnailSha256. */
            public thumbnailSha256: Uint8Array;

            /** VideoMessage thumbnailEncSha256. */
            public thumbnailEncSha256: Uint8Array;

            /** VideoMessage staticUrl. */
            public staticUrl: string;

            /**
             * Creates a new VideoMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns VideoMessage instance
             */
            public static create(properties?: proto.Message.IVideoMessage): proto.Message.VideoMessage;

            /**
             * Encodes the specified VideoMessage message. Does not implicitly {@link proto.Message.VideoMessage.verify|verify} messages.
             * @param message VideoMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IVideoMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified VideoMessage message, length delimited. Does not implicitly {@link proto.Message.VideoMessage.verify|verify} messages.
             * @param message VideoMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IVideoMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a VideoMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns VideoMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.VideoMessage;

            /**
             * Decodes a VideoMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns VideoMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.VideoMessage;

            /**
             * Verifies a VideoMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a VideoMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns VideoMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.VideoMessage;

            /**
             * Creates a plain object from a VideoMessage message. Also converts values to other types if specified.
             * @param message VideoMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.VideoMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this VideoMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace VideoMessage {

            /** Attribution enum. */
            enum Attribution {
                NONE = 0,
                GIPHY = 1,
                TENOR = 2
            }
        }
    }

    /** Properties of a MessageContextInfo. */
    interface IMessageContextInfo {

        /** MessageContextInfo deviceListMetadata */
        deviceListMetadata?: (proto.IDeviceListMetadata|null);

        /** MessageContextInfo deviceListMetadataVersion */
        deviceListMetadataVersion?: (number|null);

        /** MessageContextInfo messageSecret */
        messageSecret?: (Uint8Array|null);

        /** MessageContextInfo paddingBytes */
        paddingBytes?: (Uint8Array|null);
    }

    /** Represents a MessageContextInfo. */
    class MessageContextInfo implements IMessageContextInfo {

        /**
         * Constructs a new MessageContextInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMessageContextInfo);

        /** MessageContextInfo deviceListMetadata. */
        public deviceListMetadata?: (proto.IDeviceListMetadata|null);

        /** MessageContextInfo deviceListMetadataVersion. */
        public deviceListMetadataVersion: number;

        /** MessageContextInfo messageSecret. */
        public messageSecret: Uint8Array;

        /** MessageContextInfo paddingBytes. */
        public paddingBytes: Uint8Array;

        /**
         * Creates a new MessageContextInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MessageContextInfo instance
         */
        public static create(properties?: proto.IMessageContextInfo): proto.MessageContextInfo;

        /**
         * Encodes the specified MessageContextInfo message. Does not implicitly {@link proto.MessageContextInfo.verify|verify} messages.
         * @param message MessageContextInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMessageContextInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MessageContextInfo message, length delimited. Does not implicitly {@link proto.MessageContextInfo.verify|verify} messages.
         * @param message MessageContextInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMessageContextInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MessageContextInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MessageContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MessageContextInfo;

        /**
         * Decodes a MessageContextInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MessageContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MessageContextInfo;

        /**
         * Verifies a MessageContextInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MessageContextInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MessageContextInfo
         */
        public static fromObject(object: { [k: string]: any }): proto.MessageContextInfo;

        /**
         * Creates a plain object from a MessageContextInfo message. Also converts values to other types if specified.
         * @param message MessageContextInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MessageContextInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MessageContextInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MessageKey. */
    interface IMessageKey {

        /** MessageKey remoteJid */
        remoteJid?: (string|null);

        /** MessageKey fromMe */
        fromMe?: (boolean|null);

        /** MessageKey id */
        id?: (string|null);

        /** MessageKey participant */
        participant?: (string|null);
    }

    /** Represents a MessageKey. */
    class MessageKey implements IMessageKey {

        /**
         * Constructs a new MessageKey.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMessageKey);

        /** MessageKey remoteJid. */
        public remoteJid: string;

        /** MessageKey fromMe. */
        public fromMe: boolean;

        /** MessageKey id. */
        public id: string;

        /** MessageKey participant. */
        public participant: string;

        /**
         * Creates a new MessageKey instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MessageKey instance
         */
        public static create(properties?: proto.IMessageKey): proto.MessageKey;

        /**
         * Encodes the specified MessageKey message. Does not implicitly {@link proto.MessageKey.verify|verify} messages.
         * @param message MessageKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMessageKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MessageKey message, length delimited. Does not implicitly {@link proto.MessageKey.verify|verify} messages.
         * @param message MessageKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMessageKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MessageKey message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MessageKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MessageKey;

        /**
         * Decodes a MessageKey message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MessageKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MessageKey;

        /**
         * Verifies a MessageKey message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MessageKey message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MessageKey
         */
        public static fromObject(object: { [k: string]: any }): proto.MessageKey;

        /**
         * Creates a plain object from a MessageKey message. Also converts values to other types if specified.
         * @param message MessageKey
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MessageKey, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MessageKey to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Money. */
    interface IMoney {

        /** Money value */
        value?: (number|Long|null);

        /** Money offset */
        offset?: (number|null);

        /** Money currencyCode */
        currencyCode?: (string|null);
    }

    /** Represents a Money. */
    class Money implements IMoney {

        /**
         * Constructs a new Money.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMoney);

        /** Money value. */
        public value: (number|Long);

        /** Money offset. */
        public offset: number;

        /** Money currencyCode. */
        public currencyCode: string;

        /**
         * Creates a new Money instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Money instance
         */
        public static create(properties?: proto.IMoney): proto.Money;

        /**
         * Encodes the specified Money message. Does not implicitly {@link proto.Money.verify|verify} messages.
         * @param message Money message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMoney, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Money message, length delimited. Does not implicitly {@link proto.Money.verify|verify} messages.
         * @param message Money message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMoney, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Money message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Money
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Money;

        /**
         * Decodes a Money message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Money
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Money;

        /**
         * Verifies a Money message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Money message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Money
         */
        public static fromObject(object: { [k: string]: any }): proto.Money;

        /**
         * Creates a plain object from a Money message. Also converts values to other types if specified.
         * @param message Money
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Money, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Money to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MsgOpaqueData. */
    interface IMsgOpaqueData {

        /** MsgOpaqueData body */
        body?: (string|null);

        /** MsgOpaqueData caption */
        caption?: (string|null);

        /** MsgOpaqueData lng */
        lng?: (number|null);

        /** MsgOpaqueData isLive */
        isLive?: (boolean|null);

        /** MsgOpaqueData lat */
        lat?: (number|null);

        /** MsgOpaqueData paymentAmount1000 */
        paymentAmount1000?: (number|null);

        /** MsgOpaqueData paymentNoteMsgBody */
        paymentNoteMsgBody?: (string|null);

        /** MsgOpaqueData canonicalUrl */
        canonicalUrl?: (string|null);

        /** MsgOpaqueData matchedText */
        matchedText?: (string|null);

        /** MsgOpaqueData title */
        title?: (string|null);

        /** MsgOpaqueData description */
        description?: (string|null);

        /** MsgOpaqueData futureproofBuffer */
        futureproofBuffer?: (Uint8Array|null);

        /** MsgOpaqueData clientUrl */
        clientUrl?: (string|null);

        /** MsgOpaqueData loc */
        loc?: (string|null);

        /** MsgOpaqueData pollName */
        pollName?: (string|null);

        /** MsgOpaqueData pollOptions */
        pollOptions?: (proto.MsgOpaqueData.IPollOption[]|null);

        /** MsgOpaqueData pollSelectableOptionsCount */
        pollSelectableOptionsCount?: (number|null);

        /** MsgOpaqueData messageSecret */
        messageSecret?: (Uint8Array|null);

        /** MsgOpaqueData originalSelfAuthor */
        originalSelfAuthor?: (string|null);

        /** MsgOpaqueData senderTimestampMs */
        senderTimestampMs?: (number|Long|null);

        /** MsgOpaqueData pollUpdateParentKey */
        pollUpdateParentKey?: (string|null);

        /** MsgOpaqueData encPollVote */
        encPollVote?: (proto.IPollEncValue|null);
    }

    /** Represents a MsgOpaqueData. */
    class MsgOpaqueData implements IMsgOpaqueData {

        /**
         * Constructs a new MsgOpaqueData.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMsgOpaqueData);

        /** MsgOpaqueData body. */
        public body: string;

        /** MsgOpaqueData caption. */
        public caption: string;

        /** MsgOpaqueData lng. */
        public lng: number;

        /** MsgOpaqueData isLive. */
        public isLive: boolean;

        /** MsgOpaqueData lat. */
        public lat: number;

        /** MsgOpaqueData paymentAmount1000. */
        public paymentAmount1000: number;

        /** MsgOpaqueData paymentNoteMsgBody. */
        public paymentNoteMsgBody: string;

        /** MsgOpaqueData canonicalUrl. */
        public canonicalUrl: string;

        /** MsgOpaqueData matchedText. */
        public matchedText: string;

        /** MsgOpaqueData title. */
        public title: string;

        /** MsgOpaqueData description. */
        public description: string;

        /** MsgOpaqueData futureproofBuffer. */
        public futureproofBuffer: Uint8Array;

        /** MsgOpaqueData clientUrl. */
        public clientUrl: string;

        /** MsgOpaqueData loc. */
        public loc: string;

        /** MsgOpaqueData pollName. */
        public pollName: string;

        /** MsgOpaqueData pollOptions. */
        public pollOptions: proto.MsgOpaqueData.IPollOption[];

        /** MsgOpaqueData pollSelectableOptionsCount. */
        public pollSelectableOptionsCount: number;

        /** MsgOpaqueData messageSecret. */
        public messageSecret: Uint8Array;

        /** MsgOpaqueData originalSelfAuthor. */
        public originalSelfAuthor: string;

        /** MsgOpaqueData senderTimestampMs. */
        public senderTimestampMs: (number|Long);

        /** MsgOpaqueData pollUpdateParentKey. */
        public pollUpdateParentKey: string;

        /** MsgOpaqueData encPollVote. */
        public encPollVote?: (proto.IPollEncValue|null);

        /**
         * Creates a new MsgOpaqueData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MsgOpaqueData instance
         */
        public static create(properties?: proto.IMsgOpaqueData): proto.MsgOpaqueData;

        /**
         * Encodes the specified MsgOpaqueData message. Does not implicitly {@link proto.MsgOpaqueData.verify|verify} messages.
         * @param message MsgOpaqueData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMsgOpaqueData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MsgOpaqueData message, length delimited. Does not implicitly {@link proto.MsgOpaqueData.verify|verify} messages.
         * @param message MsgOpaqueData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMsgOpaqueData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MsgOpaqueData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MsgOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MsgOpaqueData;

        /**
         * Decodes a MsgOpaqueData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MsgOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MsgOpaqueData;

        /**
         * Verifies a MsgOpaqueData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MsgOpaqueData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MsgOpaqueData
         */
        public static fromObject(object: { [k: string]: any }): proto.MsgOpaqueData;

        /**
         * Creates a plain object from a MsgOpaqueData message. Also converts values to other types if specified.
         * @param message MsgOpaqueData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MsgOpaqueData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MsgOpaqueData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace MsgOpaqueData {

        /** Properties of a PollOption. */
        interface IPollOption {

            /** PollOption name */
            name?: (string|null);
        }

        /** Represents a PollOption. */
        class PollOption implements IPollOption {

            /**
             * Constructs a new PollOption.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.MsgOpaqueData.IPollOption);

            /** PollOption name. */
            public name: string;

            /**
             * Creates a new PollOption instance using the specified properties.
             * @param [properties] Properties to set
             * @returns PollOption instance
             */
            public static create(properties?: proto.MsgOpaqueData.IPollOption): proto.MsgOpaqueData.PollOption;

            /**
             * Encodes the specified PollOption message. Does not implicitly {@link proto.MsgOpaqueData.PollOption.verify|verify} messages.
             * @param message PollOption message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.MsgOpaqueData.IPollOption, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified PollOption message, length delimited. Does not implicitly {@link proto.MsgOpaqueData.PollOption.verify|verify} messages.
             * @param message PollOption message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.MsgOpaqueData.IPollOption, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a PollOption message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns PollOption
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MsgOpaqueData.PollOption;

            /**
             * Decodes a PollOption message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns PollOption
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MsgOpaqueData.PollOption;

            /**
             * Verifies a PollOption message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a PollOption message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns PollOption
             */
            public static fromObject(object: { [k: string]: any }): proto.MsgOpaqueData.PollOption;

            /**
             * Creates a plain object from a PollOption message. Also converts values to other types if specified.
             * @param message PollOption
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.MsgOpaqueData.PollOption, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this PollOption to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }
    }

    /** Properties of a MsgRowOpaqueData. */
    interface IMsgRowOpaqueData {

        /** MsgRowOpaqueData currentMsg */
        currentMsg?: (proto.IMsgOpaqueData|null);

        /** MsgRowOpaqueData quotedMsg */
        quotedMsg?: (proto.IMsgOpaqueData|null);
    }

    /** Represents a MsgRowOpaqueData. */
    class MsgRowOpaqueData implements IMsgRowOpaqueData {

        /**
         * Constructs a new MsgRowOpaqueData.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMsgRowOpaqueData);

        /** MsgRowOpaqueData currentMsg. */
        public currentMsg?: (proto.IMsgOpaqueData|null);

        /** MsgRowOpaqueData quotedMsg. */
        public quotedMsg?: (proto.IMsgOpaqueData|null);

        /**
         * Creates a new MsgRowOpaqueData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MsgRowOpaqueData instance
         */
        public static create(properties?: proto.IMsgRowOpaqueData): proto.MsgRowOpaqueData;

        /**
         * Encodes the specified MsgRowOpaqueData message. Does not implicitly {@link proto.MsgRowOpaqueData.verify|verify} messages.
         * @param message MsgRowOpaqueData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMsgRowOpaqueData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MsgRowOpaqueData message, length delimited. Does not implicitly {@link proto.MsgRowOpaqueData.verify|verify} messages.
         * @param message MsgRowOpaqueData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMsgRowOpaqueData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MsgRowOpaqueData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MsgRowOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MsgRowOpaqueData;

        /**
         * Decodes a MsgRowOpaqueData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MsgRowOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MsgRowOpaqueData;

        /**
         * Verifies a MsgRowOpaqueData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MsgRowOpaqueData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MsgRowOpaqueData
         */
        public static fromObject(object: { [k: string]: any }): proto.MsgRowOpaqueData;

        /**
         * Creates a plain object from a MsgRowOpaqueData message. Also converts values to other types if specified.
         * @param message MsgRowOpaqueData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MsgRowOpaqueData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MsgRowOpaqueData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a NoiseCertificate. */
    interface INoiseCertificate {

        /** NoiseCertificate details */
        details?: (Uint8Array|null);

        /** NoiseCertificate signature */
        signature?: (Uint8Array|null);
    }

    /** Represents a NoiseCertificate. */
    class NoiseCertificate implements INoiseCertificate {

        /**
         * Constructs a new NoiseCertificate.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.INoiseCertificate);

        /** NoiseCertificate details. */
        public details: Uint8Array;

        /** NoiseCertificate signature. */
        public signature: Uint8Array;

        /**
         * Creates a new NoiseCertificate instance using the specified properties.
         * @param [properties] Properties to set
         * @returns NoiseCertificate instance
         */
        public static create(properties?: proto.INoiseCertificate): proto.NoiseCertificate;

        /**
         * Encodes the specified NoiseCertificate message. Does not implicitly {@link proto.NoiseCertificate.verify|verify} messages.
         * @param message NoiseCertificate message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.INoiseCertificate, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified NoiseCertificate message, length delimited. Does not implicitly {@link proto.NoiseCertificate.verify|verify} messages.
         * @param message NoiseCertificate message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.INoiseCertificate, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a NoiseCertificate message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns NoiseCertificate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.NoiseCertificate;

        /**
         * Decodes a NoiseCertificate message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns NoiseCertificate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.NoiseCertificate;

        /**
         * Verifies a NoiseCertificate message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a NoiseCertificate message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns NoiseCertificate
         */
        public static fromObject(object: { [k: string]: any }): proto.NoiseCertificate;

        /**
         * Creates a plain object from a NoiseCertificate message. Also converts values to other types if specified.
         * @param message NoiseCertificate
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.NoiseCertificate, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this NoiseCertificate to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace NoiseCertificate {

        /** Properties of a Details. */
        interface IDetails {

            /** Details serial */
            serial?: (number|null);

            /** Details issuer */
            issuer?: (string|null);

            /** Details expires */
            expires?: (number|Long|null);

            /** Details subject */
            subject?: (string|null);

            /** Details key */
            key?: (Uint8Array|null);
        }

        /** Represents a Details. */
        class Details implements IDetails {

            /**
             * Constructs a new Details.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.NoiseCertificate.IDetails);

            /** Details serial. */
            public serial: number;

            /** Details issuer. */
            public issuer: string;

            /** Details expires. */
            public expires: (number|Long);

            /** Details subject. */
            public subject: string;

            /** Details key. */
            public key: Uint8Array;

            /**
             * Creates a new Details instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Details instance
             */
            public static create(properties?: proto.NoiseCertificate.IDetails): proto.NoiseCertificate.Details;

            /**
             * Encodes the specified Details message. Does not implicitly {@link proto.NoiseCertificate.Details.verify|verify} messages.
             * @param message Details message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.NoiseCertificate.IDetails, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Details message, length delimited. Does not implicitly {@link proto.NoiseCertificate.Details.verify|verify} messages.
             * @param message Details message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.NoiseCertificate.IDetails, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a Details message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Details
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.NoiseCertificate.Details;

            /**
             * Decodes a Details message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Details
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.NoiseCertificate.Details;

            /**
             * Verifies a Details message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a Details message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Details
             */
            public static fromObject(object: { [k: string]: any }): proto.NoiseCertificate.Details;

            /**
             * Creates a plain object from a Details message. Also converts values to other types if specified.
             * @param message Details
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.NoiseCertificate.Details, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Details to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }
    }

    /** Properties of a NotificationMessageInfo. */
    interface INotificationMessageInfo {

        /** NotificationMessageInfo key */
        key?: (proto.IMessageKey|null);

        /** NotificationMessageInfo message */
        message?: (proto.IMessage|null);

        /** NotificationMessageInfo messageTimestamp */
        messageTimestamp?: (number|Long|null);

        /** NotificationMessageInfo participant */
        participant?: (string|null);
    }

    /** Represents a NotificationMessageInfo. */
    class NotificationMessageInfo implements INotificationMessageInfo {

        /**
         * Constructs a new NotificationMessageInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.INotificationMessageInfo);

        /** NotificationMessageInfo key. */
        public key?: (proto.IMessageKey|null);

        /** NotificationMessageInfo message. */
        public message?: (proto.IMessage|null);

        /** NotificationMessageInfo messageTimestamp. */
        public messageTimestamp: (number|Long);

        /** NotificationMessageInfo participant. */
        public participant: string;

        /**
         * Creates a new NotificationMessageInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns NotificationMessageInfo instance
         */
        public static create(properties?: proto.INotificationMessageInfo): proto.NotificationMessageInfo;

        /**
         * Encodes the specified NotificationMessageInfo message. Does not implicitly {@link proto.NotificationMessageInfo.verify|verify} messages.
         * @param message NotificationMessageInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.INotificationMessageInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified NotificationMessageInfo message, length delimited. Does not implicitly {@link proto.NotificationMessageInfo.verify|verify} messages.
         * @param message NotificationMessageInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.INotificationMessageInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a NotificationMessageInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns NotificationMessageInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.NotificationMessageInfo;

        /**
         * Decodes a NotificationMessageInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns NotificationMessageInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.NotificationMessageInfo;

        /**
         * Verifies a NotificationMessageInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a NotificationMessageInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns NotificationMessageInfo
         */
        public static fromObject(object: { [k: string]: any }): proto.NotificationMessageInfo;

        /**
         * Creates a plain object from a NotificationMessageInfo message. Also converts values to other types if specified.
         * @param message NotificationMessageInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.NotificationMessageInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this NotificationMessageInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PastParticipant. */
    interface IPastParticipant {

        /** PastParticipant userJid */
        userJid?: (string|null);

        /** PastParticipant leaveReason */
        leaveReason?: (proto.PastParticipant.LeaveReason|null);

        /** PastParticipant leaveTs */
        leaveTs?: (number|Long|null);
    }

    /** Represents a PastParticipant. */
    class PastParticipant implements IPastParticipant {

        /**
         * Constructs a new PastParticipant.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPastParticipant);

        /** PastParticipant userJid. */
        public userJid: string;

        /** PastParticipant leaveReason. */
        public leaveReason: proto.PastParticipant.LeaveReason;

        /** PastParticipant leaveTs. */
        public leaveTs: (number|Long);

        /**
         * Creates a new PastParticipant instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PastParticipant instance
         */
        public static create(properties?: proto.IPastParticipant): proto.PastParticipant;

        /**
         * Encodes the specified PastParticipant message. Does not implicitly {@link proto.PastParticipant.verify|verify} messages.
         * @param message PastParticipant message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPastParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PastParticipant message, length delimited. Does not implicitly {@link proto.PastParticipant.verify|verify} messages.
         * @param message PastParticipant message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPastParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PastParticipant message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PastParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PastParticipant;

        /**
         * Decodes a PastParticipant message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PastParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PastParticipant;

        /**
         * Verifies a PastParticipant message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PastParticipant message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PastParticipant
         */
        public static fromObject(object: { [k: string]: any }): proto.PastParticipant;

        /**
         * Creates a plain object from a PastParticipant message. Also converts values to other types if specified.
         * @param message PastParticipant
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PastParticipant, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PastParticipant to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace PastParticipant {

        /** LeaveReason enum. */
        enum LeaveReason {
            LEFT = 0,
            REMOVED = 1
        }
    }

    /** Properties of a PastParticipants. */
    interface IPastParticipants {

        /** PastParticipants groupJid */
        groupJid?: (string|null);

        /** PastParticipants pastParticipants */
        pastParticipants?: (proto.IPastParticipant[]|null);
    }

    /** Represents a PastParticipants. */
    class PastParticipants implements IPastParticipants {

        /**
         * Constructs a new PastParticipants.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPastParticipants);

        /** PastParticipants groupJid. */
        public groupJid: string;

        /** PastParticipants pastParticipants. */
        public pastParticipants: proto.IPastParticipant[];

        /**
         * Creates a new PastParticipants instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PastParticipants instance
         */
        public static create(properties?: proto.IPastParticipants): proto.PastParticipants;

        /**
         * Encodes the specified PastParticipants message. Does not implicitly {@link proto.PastParticipants.verify|verify} messages.
         * @param message PastParticipants message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPastParticipants, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PastParticipants message, length delimited. Does not implicitly {@link proto.PastParticipants.verify|verify} messages.
         * @param message PastParticipants message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPastParticipants, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PastParticipants message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PastParticipants
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PastParticipants;

        /**
         * Decodes a PastParticipants message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PastParticipants
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PastParticipants;

        /**
         * Verifies a PastParticipants message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PastParticipants message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PastParticipants
         */
        public static fromObject(object: { [k: string]: any }): proto.PastParticipants;

        /**
         * Creates a plain object from a PastParticipants message. Also converts values to other types if specified.
         * @param message PastParticipants
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PastParticipants, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PastParticipants to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PaymentBackground. */
    interface IPaymentBackground {

        /** PaymentBackground id */
        id?: (string|null);

        /** PaymentBackground fileLength */
        fileLength?: (number|Long|null);

        /** PaymentBackground width */
        width?: (number|null);

        /** PaymentBackground height */
        height?: (number|null);

        /** PaymentBackground mimetype */
        mimetype?: (string|null);

        /** PaymentBackground placeholderArgb */
        placeholderArgb?: (number|null);

        /** PaymentBackground textArgb */
        textArgb?: (number|null);

        /** PaymentBackground subtextArgb */
        subtextArgb?: (number|null);

        /** PaymentBackground mediaData */
        mediaData?: (proto.PaymentBackground.IMediaData|null);

        /** PaymentBackground type */
        type?: (proto.PaymentBackground.Type|null);
    }

    /** Represents a PaymentBackground. */
    class PaymentBackground implements IPaymentBackground {

        /**
         * Constructs a new PaymentBackground.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPaymentBackground);

        /** PaymentBackground id. */
        public id: string;

        /** PaymentBackground fileLength. */
        public fileLength: (number|Long);

        /** PaymentBackground width. */
        public width: number;

        /** PaymentBackground height. */
        public height: number;

        /** PaymentBackground mimetype. */
        public mimetype: string;

        /** PaymentBackground placeholderArgb. */
        public placeholderArgb: number;

        /** PaymentBackground textArgb. */
        public textArgb: number;

        /** PaymentBackground subtextArgb. */
        public subtextArgb: number;

        /** PaymentBackground mediaData. */
        public mediaData?: (proto.PaymentBackground.IMediaData|null);

        /** PaymentBackground type. */
        public type: proto.PaymentBackground.Type;

        /**
         * Creates a new PaymentBackground instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PaymentBackground instance
         */
        public static create(properties?: proto.IPaymentBackground): proto.PaymentBackground;

        /**
         * Encodes the specified PaymentBackground message. Does not implicitly {@link proto.PaymentBackground.verify|verify} messages.
         * @param message PaymentBackground message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPaymentBackground, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PaymentBackground message, length delimited. Does not implicitly {@link proto.PaymentBackground.verify|verify} messages.
         * @param message PaymentBackground message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPaymentBackground, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PaymentBackground message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PaymentBackground
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PaymentBackground;

        /**
         * Decodes a PaymentBackground message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PaymentBackground
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PaymentBackground;

        /**
         * Verifies a PaymentBackground message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PaymentBackground message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PaymentBackground
         */
        public static fromObject(object: { [k: string]: any }): proto.PaymentBackground;

        /**
         * Creates a plain object from a PaymentBackground message. Also converts values to other types if specified.
         * @param message PaymentBackground
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PaymentBackground, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PaymentBackground to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace PaymentBackground {

        /** Properties of a MediaData. */
        interface IMediaData {

            /** MediaData mediaKey */
            mediaKey?: (Uint8Array|null);

            /** MediaData mediaKeyTimestamp */
            mediaKeyTimestamp?: (number|Long|null);

            /** MediaData fileSha256 */
            fileSha256?: (Uint8Array|null);

            /** MediaData fileEncSha256 */
            fileEncSha256?: (Uint8Array|null);

            /** MediaData directPath */
            directPath?: (string|null);
        }

        /** Represents a MediaData. */
        class MediaData implements IMediaData {

            /**
             * Constructs a new MediaData.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.PaymentBackground.IMediaData);

            /** MediaData mediaKey. */
            public mediaKey: Uint8Array;

            /** MediaData mediaKeyTimestamp. */
            public mediaKeyTimestamp: (number|Long);

            /** MediaData fileSha256. */
            public fileSha256: Uint8Array;

            /** MediaData fileEncSha256. */
            public fileEncSha256: Uint8Array;

            /** MediaData directPath. */
            public directPath: string;

            /**
             * Creates a new MediaData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns MediaData instance
             */
            public static create(properties?: proto.PaymentBackground.IMediaData): proto.PaymentBackground.MediaData;

            /**
             * Encodes the specified MediaData message. Does not implicitly {@link proto.PaymentBackground.MediaData.verify|verify} messages.
             * @param message MediaData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.PaymentBackground.IMediaData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified MediaData message, length delimited. Does not implicitly {@link proto.PaymentBackground.MediaData.verify|verify} messages.
             * @param message MediaData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.PaymentBackground.IMediaData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a MediaData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns MediaData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PaymentBackground.MediaData;

            /**
             * Decodes a MediaData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns MediaData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PaymentBackground.MediaData;

            /**
             * Verifies a MediaData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a MediaData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns MediaData
             */
            public static fromObject(object: { [k: string]: any }): proto.PaymentBackground.MediaData;

            /**
             * Creates a plain object from a MediaData message. Also converts values to other types if specified.
             * @param message MediaData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.PaymentBackground.MediaData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this MediaData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Type enum. */
        enum Type {
            UNKNOWN = 0,
            DEFAULT = 1
        }
    }

    /** Properties of a PaymentInfo. */
    interface IPaymentInfo {

        /** PaymentInfo currencyDeprecated */
        currencyDeprecated?: (proto.PaymentInfo.Currency|null);

        /** PaymentInfo amount1000 */
        amount1000?: (number|Long|null);

        /** PaymentInfo receiverJid */
        receiverJid?: (string|null);

        /** PaymentInfo status */
        status?: (proto.PaymentInfo.Status|null);

        /** PaymentInfo transactionTimestamp */
        transactionTimestamp?: (number|Long|null);

        /** PaymentInfo requestMessageKey */
        requestMessageKey?: (proto.IMessageKey|null);

        /** PaymentInfo expiryTimestamp */
        expiryTimestamp?: (number|Long|null);

        /** PaymentInfo futureproofed */
        futureproofed?: (boolean|null);

        /** PaymentInfo currency */
        currency?: (string|null);

        /** PaymentInfo txnStatus */
        txnStatus?: (proto.PaymentInfo.TxnStatus|null);

        /** PaymentInfo useNoviFiatFormat */
        useNoviFiatFormat?: (boolean|null);

        /** PaymentInfo primaryAmount */
        primaryAmount?: (proto.IMoney|null);

        /** PaymentInfo exchangeAmount */
        exchangeAmount?: (proto.IMoney|null);
    }

    /** Represents a PaymentInfo. */
    class PaymentInfo implements IPaymentInfo {

        /**
         * Constructs a new PaymentInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPaymentInfo);

        /** PaymentInfo currencyDeprecated. */
        public currencyDeprecated: proto.PaymentInfo.Currency;

        /** PaymentInfo amount1000. */
        public amount1000: (number|Long);

        /** PaymentInfo receiverJid. */
        public receiverJid: string;

        /** PaymentInfo status. */
        public status: proto.PaymentInfo.Status;

        /** PaymentInfo transactionTimestamp. */
        public transactionTimestamp: (number|Long);

        /** PaymentInfo requestMessageKey. */
        public requestMessageKey?: (proto.IMessageKey|null);

        /** PaymentInfo expiryTimestamp. */
        public expiryTimestamp: (number|Long);

        /** PaymentInfo futureproofed. */
        public futureproofed: boolean;

        /** PaymentInfo currency. */
        public currency: string;

        /** PaymentInfo txnStatus. */
        public txnStatus: proto.PaymentInfo.TxnStatus;

        /** PaymentInfo useNoviFiatFormat. */
        public useNoviFiatFormat: boolean;

        /** PaymentInfo primaryAmount. */
        public primaryAmount?: (proto.IMoney|null);

        /** PaymentInfo exchangeAmount. */
        public exchangeAmount?: (proto.IMoney|null);

        /**
         * Creates a new PaymentInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PaymentInfo instance
         */
        public static create(properties?: proto.IPaymentInfo): proto.PaymentInfo;

        /**
         * Encodes the specified PaymentInfo message. Does not implicitly {@link proto.PaymentInfo.verify|verify} messages.
         * @param message PaymentInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPaymentInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PaymentInfo message, length delimited. Does not implicitly {@link proto.PaymentInfo.verify|verify} messages.
         * @param message PaymentInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPaymentInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PaymentInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PaymentInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PaymentInfo;

        /**
         * Decodes a PaymentInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PaymentInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PaymentInfo;

        /**
         * Verifies a PaymentInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PaymentInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PaymentInfo
         */
        public static fromObject(object: { [k: string]: any }): proto.PaymentInfo;

        /**
         * Creates a plain object from a PaymentInfo message. Also converts values to other types if specified.
         * @param message PaymentInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PaymentInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PaymentInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace PaymentInfo {

        /** Currency enum. */
        enum Currency {
            UNKNOWN_CURRENCY = 0,
            INR = 1
        }

        /** Status enum. */
        enum Status {
            UNKNOWN_STATUS = 0,
            PROCESSING = 1,
            SENT = 2,
            NEED_TO_ACCEPT = 3,
            COMPLETE = 4,
            COULD_NOT_COMPLETE = 5,
            REFUNDED = 6,
            EXPIRED = 7,
            REJECTED = 8,
            CANCELLED = 9,
            WAITING_FOR_PAYER = 10,
            WAITING = 11
        }

        /** TxnStatus enum. */
        enum TxnStatus {
            UNKNOWN = 0,
            PENDING_SETUP = 1,
            PENDING_RECEIVER_SETUP = 2,
            INIT = 3,
            SUCCESS = 4,
            COMPLETED = 5,
            FAILED = 6,
            FAILED_RISK = 7,
            FAILED_PROCESSING = 8,
            FAILED_RECEIVER_PROCESSING = 9,
            FAILED_DA = 10,
            FAILED_DA_FINAL = 11,
            REFUNDED_TXN = 12,
            REFUND_FAILED = 13,
            REFUND_FAILED_PROCESSING = 14,
            REFUND_FAILED_DA = 15,
            EXPIRED_TXN = 16,
            AUTH_CANCELED = 17,
            AUTH_CANCEL_FAILED_PROCESSING = 18,
            AUTH_CANCEL_FAILED = 19,
            COLLECT_INIT = 20,
            COLLECT_SUCCESS = 21,
            COLLECT_FAILED = 22,
            COLLECT_FAILED_RISK = 23,
            COLLECT_REJECTED = 24,
            COLLECT_EXPIRED = 25,
            COLLECT_CANCELED = 26,
            COLLECT_CANCELLING = 27,
            IN_REVIEW = 28,
            REVERSAL_SUCCESS = 29,
            REVERSAL_PENDING = 30,
            REFUND_PENDING = 31
        }
    }

    /** Properties of a PendingKeyExchange. */
    interface IPendingKeyExchange {

        /** PendingKeyExchange sequence */
        sequence?: (number|null);

        /** PendingKeyExchange localBaseKey */
        localBaseKey?: (Uint8Array|null);

        /** PendingKeyExchange localBaseKeyPrivate */
        localBaseKeyPrivate?: (Uint8Array|null);

        /** PendingKeyExchange localRatchetKey */
        localRatchetKey?: (Uint8Array|null);

        /** PendingKeyExchange localRatchetKeyPrivate */
        localRatchetKeyPrivate?: (Uint8Array|null);

        /** PendingKeyExchange localIdentityKey */
        localIdentityKey?: (Uint8Array|null);

        /** PendingKeyExchange localIdentityKeyPrivate */
        localIdentityKeyPrivate?: (Uint8Array|null);
    }

    /** Represents a PendingKeyExchange. */
    class PendingKeyExchange implements IPendingKeyExchange {

        /**
         * Constructs a new PendingKeyExchange.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPendingKeyExchange);

        /** PendingKeyExchange sequence. */
        public sequence: number;

        /** PendingKeyExchange localBaseKey. */
        public localBaseKey: Uint8Array;

        /** PendingKeyExchange localBaseKeyPrivate. */
        public localBaseKeyPrivate: Uint8Array;

        /** PendingKeyExchange localRatchetKey. */
        public localRatchetKey: Uint8Array;

        /** PendingKeyExchange localRatchetKeyPrivate. */
        public localRatchetKeyPrivate: Uint8Array;

        /** PendingKeyExchange localIdentityKey. */
        public localIdentityKey: Uint8Array;

        /** PendingKeyExchange localIdentityKeyPrivate. */
        public localIdentityKeyPrivate: Uint8Array;

        /**
         * Creates a new PendingKeyExchange instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PendingKeyExchange instance
         */
        public static create(properties?: proto.IPendingKeyExchange): proto.PendingKeyExchange;

        /**
         * Encodes the specified PendingKeyExchange message. Does not implicitly {@link proto.PendingKeyExchange.verify|verify} messages.
         * @param message PendingKeyExchange message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPendingKeyExchange, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PendingKeyExchange message, length delimited. Does not implicitly {@link proto.PendingKeyExchange.verify|verify} messages.
         * @param message PendingKeyExchange message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPendingKeyExchange, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PendingKeyExchange message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PendingKeyExchange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PendingKeyExchange;

        /**
         * Decodes a PendingKeyExchange message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PendingKeyExchange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PendingKeyExchange;

        /**
         * Verifies a PendingKeyExchange message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PendingKeyExchange message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PendingKeyExchange
         */
        public static fromObject(object: { [k: string]: any }): proto.PendingKeyExchange;

        /**
         * Creates a plain object from a PendingKeyExchange message. Also converts values to other types if specified.
         * @param message PendingKeyExchange
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PendingKeyExchange, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PendingKeyExchange to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PendingPreKey. */
    interface IPendingPreKey {

        /** PendingPreKey preKeyId */
        preKeyId?: (number|null);

        /** PendingPreKey signedPreKeyId */
        signedPreKeyId?: (number|null);

        /** PendingPreKey baseKey */
        baseKey?: (Uint8Array|null);
    }

    /** Represents a PendingPreKey. */
    class PendingPreKey implements IPendingPreKey {

        /**
         * Constructs a new PendingPreKey.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPendingPreKey);

        /** PendingPreKey preKeyId. */
        public preKeyId: number;

        /** PendingPreKey signedPreKeyId. */
        public signedPreKeyId: number;

        /** PendingPreKey baseKey. */
        public baseKey: Uint8Array;

        /**
         * Creates a new PendingPreKey instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PendingPreKey instance
         */
        public static create(properties?: proto.IPendingPreKey): proto.PendingPreKey;

        /**
         * Encodes the specified PendingPreKey message. Does not implicitly {@link proto.PendingPreKey.verify|verify} messages.
         * @param message PendingPreKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPendingPreKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PendingPreKey message, length delimited. Does not implicitly {@link proto.PendingPreKey.verify|verify} messages.
         * @param message PendingPreKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPendingPreKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PendingPreKey message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PendingPreKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PendingPreKey;

        /**
         * Decodes a PendingPreKey message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PendingPreKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PendingPreKey;

        /**
         * Verifies a PendingPreKey message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PendingPreKey message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PendingPreKey
         */
        public static fromObject(object: { [k: string]: any }): proto.PendingPreKey;

        /**
         * Creates a plain object from a PendingPreKey message. Also converts values to other types if specified.
         * @param message PendingPreKey
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PendingPreKey, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PendingPreKey to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PhotoChange. */
    interface IPhotoChange {

        /** PhotoChange oldPhoto */
        oldPhoto?: (Uint8Array|null);

        /** PhotoChange newPhoto */
        newPhoto?: (Uint8Array|null);

        /** PhotoChange newPhotoId */
        newPhotoId?: (number|null);
    }

    /** Represents a PhotoChange. */
    class PhotoChange implements IPhotoChange {

        /**
         * Constructs a new PhotoChange.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPhotoChange);

        /** PhotoChange oldPhoto. */
        public oldPhoto: Uint8Array;

        /** PhotoChange newPhoto. */
        public newPhoto: Uint8Array;

        /** PhotoChange newPhotoId. */
        public newPhotoId: number;

        /**
         * Creates a new PhotoChange instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PhotoChange instance
         */
        public static create(properties?: proto.IPhotoChange): proto.PhotoChange;

        /**
         * Encodes the specified PhotoChange message. Does not implicitly {@link proto.PhotoChange.verify|verify} messages.
         * @param message PhotoChange message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPhotoChange, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PhotoChange message, length delimited. Does not implicitly {@link proto.PhotoChange.verify|verify} messages.
         * @param message PhotoChange message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPhotoChange, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PhotoChange message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PhotoChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PhotoChange;

        /**
         * Decodes a PhotoChange message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PhotoChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PhotoChange;

        /**
         * Verifies a PhotoChange message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PhotoChange message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PhotoChange
         */
        public static fromObject(object: { [k: string]: any }): proto.PhotoChange;

        /**
         * Creates a plain object from a PhotoChange message. Also converts values to other types if specified.
         * @param message PhotoChange
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PhotoChange, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PhotoChange to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Point. */
    interface IPoint {

        /** Point xDeprecated */
        xDeprecated?: (number|null);

        /** Point yDeprecated */
        yDeprecated?: (number|null);

        /** Point x */
        x?: (number|null);

        /** Point y */
        y?: (number|null);
    }

    /** Represents a Point. */
    class Point implements IPoint {

        /**
         * Constructs a new Point.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPoint);

        /** Point xDeprecated. */
        public xDeprecated: number;

        /** Point yDeprecated. */
        public yDeprecated: number;

        /** Point x. */
        public x: number;

        /** Point y. */
        public y: number;

        /**
         * Creates a new Point instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Point instance
         */
        public static create(properties?: proto.IPoint): proto.Point;

        /**
         * Encodes the specified Point message. Does not implicitly {@link proto.Point.verify|verify} messages.
         * @param message Point message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPoint, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Point message, length delimited. Does not implicitly {@link proto.Point.verify|verify} messages.
         * @param message Point message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPoint, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Point message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Point
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Point;

        /**
         * Decodes a Point message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Point
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Point;

        /**
         * Verifies a Point message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Point message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Point
         */
        public static fromObject(object: { [k: string]: any }): proto.Point;

        /**
         * Creates a plain object from a Point message. Also converts values to other types if specified.
         * @param message Point
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Point, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Point to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PollAdditionalMetadata. */
    interface IPollAdditionalMetadata {

        /** PollAdditionalMetadata pollInvalidated */
        pollInvalidated?: (boolean|null);
    }

    /** Represents a PollAdditionalMetadata. */
    class PollAdditionalMetadata implements IPollAdditionalMetadata {

        /**
         * Constructs a new PollAdditionalMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPollAdditionalMetadata);

        /** PollAdditionalMetadata pollInvalidated. */
        public pollInvalidated: boolean;

        /**
         * Creates a new PollAdditionalMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PollAdditionalMetadata instance
         */
        public static create(properties?: proto.IPollAdditionalMetadata): proto.PollAdditionalMetadata;

        /**
         * Encodes the specified PollAdditionalMetadata message. Does not implicitly {@link proto.PollAdditionalMetadata.verify|verify} messages.
         * @param message PollAdditionalMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPollAdditionalMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PollAdditionalMetadata message, length delimited. Does not implicitly {@link proto.PollAdditionalMetadata.verify|verify} messages.
         * @param message PollAdditionalMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPollAdditionalMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PollAdditionalMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PollAdditionalMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PollAdditionalMetadata;

        /**
         * Decodes a PollAdditionalMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PollAdditionalMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PollAdditionalMetadata;

        /**
         * Verifies a PollAdditionalMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PollAdditionalMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PollAdditionalMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.PollAdditionalMetadata;

        /**
         * Creates a plain object from a PollAdditionalMetadata message. Also converts values to other types if specified.
         * @param message PollAdditionalMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PollAdditionalMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PollAdditionalMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PollEncValue. */
    interface IPollEncValue {

        /** PollEncValue encPayload */
        encPayload?: (Uint8Array|null);

        /** PollEncValue encIv */
        encIv?: (Uint8Array|null);
    }

    /** Represents a PollEncValue. */
    class PollEncValue implements IPollEncValue {

        /**
         * Constructs a new PollEncValue.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPollEncValue);

        /** PollEncValue encPayload. */
        public encPayload: Uint8Array;

        /** PollEncValue encIv. */
        public encIv: Uint8Array;

        /**
         * Creates a new PollEncValue instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PollEncValue instance
         */
        public static create(properties?: proto.IPollEncValue): proto.PollEncValue;

        /**
         * Encodes the specified PollEncValue message. Does not implicitly {@link proto.PollEncValue.verify|verify} messages.
         * @param message PollEncValue message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPollEncValue, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PollEncValue message, length delimited. Does not implicitly {@link proto.PollEncValue.verify|verify} messages.
         * @param message PollEncValue message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPollEncValue, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PollEncValue message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PollEncValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PollEncValue;

        /**
         * Decodes a PollEncValue message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PollEncValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PollEncValue;

        /**
         * Verifies a PollEncValue message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PollEncValue message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PollEncValue
         */
        public static fromObject(object: { [k: string]: any }): proto.PollEncValue;

        /**
         * Creates a plain object from a PollEncValue message. Also converts values to other types if specified.
         * @param message PollEncValue
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PollEncValue, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PollEncValue to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PollUpdate. */
    interface IPollUpdate {

        /** PollUpdate pollUpdateMessageKey */
        pollUpdateMessageKey?: (proto.IMessageKey|null);

        /** PollUpdate vote */
        vote?: (proto.Message.IPollVoteMessage|null);

        /** PollUpdate senderTimestampMs */
        senderTimestampMs?: (number|Long|null);
    }

    /** Represents a PollUpdate. */
    class PollUpdate implements IPollUpdate {

        /**
         * Constructs a new PollUpdate.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPollUpdate);

        /** PollUpdate pollUpdateMessageKey. */
        public pollUpdateMessageKey?: (proto.IMessageKey|null);

        /** PollUpdate vote. */
        public vote?: (proto.Message.IPollVoteMessage|null);

        /** PollUpdate senderTimestampMs. */
        public senderTimestampMs: (number|Long);

        /**
         * Creates a new PollUpdate instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PollUpdate instance
         */
        public static create(properties?: proto.IPollUpdate): proto.PollUpdate;

        /**
         * Encodes the specified PollUpdate message. Does not implicitly {@link proto.PollUpdate.verify|verify} messages.
         * @param message PollUpdate message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPollUpdate, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PollUpdate message, length delimited. Does not implicitly {@link proto.PollUpdate.verify|verify} messages.
         * @param message PollUpdate message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPollUpdate, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PollUpdate message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PollUpdate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PollUpdate;

        /**
         * Decodes a PollUpdate message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PollUpdate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PollUpdate;

        /**
         * Verifies a PollUpdate message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PollUpdate message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PollUpdate
         */
        public static fromObject(object: { [k: string]: any }): proto.PollUpdate;

        /**
         * Creates a plain object from a PollUpdate message. Also converts values to other types if specified.
         * @param message PollUpdate
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PollUpdate, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PollUpdate to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PreKeyRecordStructure. */
    interface IPreKeyRecordStructure {

        /** PreKeyRecordStructure id */
        id?: (number|null);

        /** PreKeyRecordStructure publicKey */
        publicKey?: (Uint8Array|null);

        /** PreKeyRecordStructure privateKey */
        privateKey?: (Uint8Array|null);
    }

    /** Represents a PreKeyRecordStructure. */
    class PreKeyRecordStructure implements IPreKeyRecordStructure {

        /**
         * Constructs a new PreKeyRecordStructure.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPreKeyRecordStructure);

        /** PreKeyRecordStructure id. */
        public id: number;

        /** PreKeyRecordStructure publicKey. */
        public publicKey: Uint8Array;

        /** PreKeyRecordStructure privateKey. */
        public privateKey: Uint8Array;

        /**
         * Creates a new PreKeyRecordStructure instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PreKeyRecordStructure instance
         */
        public static create(properties?: proto.IPreKeyRecordStructure): proto.PreKeyRecordStructure;

        /**
         * Encodes the specified PreKeyRecordStructure message. Does not implicitly {@link proto.PreKeyRecordStructure.verify|verify} messages.
         * @param message PreKeyRecordStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPreKeyRecordStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PreKeyRecordStructure message, length delimited. Does not implicitly {@link proto.PreKeyRecordStructure.verify|verify} messages.
         * @param message PreKeyRecordStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPreKeyRecordStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PreKeyRecordStructure message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PreKeyRecordStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.PreKeyRecordStructure;

        /**
         * Decodes a PreKeyRecordStructure message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PreKeyRecordStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.PreKeyRecordStructure;

        /**
         * Verifies a PreKeyRecordStructure message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PreKeyRecordStructure message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PreKeyRecordStructure
         */
        public static fromObject(object: { [k: string]: any }): proto.PreKeyRecordStructure;

        /**
         * Creates a plain object from a PreKeyRecordStructure message. Also converts values to other types if specified.
         * @param message PreKeyRecordStructure
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.PreKeyRecordStructure, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PreKeyRecordStructure to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Pushname. */
    interface IPushname {

        /** Pushname id */
        id?: (string|null);

        /** Pushname pushname */
        pushname?: (string|null);
    }

    /** Represents a Pushname. */
    class Pushname implements IPushname {

        /**
         * Constructs a new Pushname.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IPushname);

        /** Pushname id. */
        public id: string;

        /** Pushname pushname. */
        public pushname: string;

        /**
         * Creates a new Pushname instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Pushname instance
         */
        public static create(properties?: proto.IPushname): proto.Pushname;

        /**
         * Encodes the specified Pushname message. Does not implicitly {@link proto.Pushname.verify|verify} messages.
         * @param message Pushname message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IPushname, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Pushname message, length delimited. Does not implicitly {@link proto.Pushname.verify|verify} messages.
         * @param message Pushname message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IPushname, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Pushname message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Pushname
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Pushname;

        /**
         * Decodes a Pushname message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Pushname
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Pushname;

        /**
         * Verifies a Pushname message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Pushname message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Pushname
         */
        public static fromObject(object: { [k: string]: any }): proto.Pushname;

        /**
         * Creates a plain object from a Pushname message. Also converts values to other types if specified.
         * @param message Pushname
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Pushname, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Pushname to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Reaction. */
    interface IReaction {

        /** Reaction key */
        key?: (proto.IMessageKey|null);

        /** Reaction text */
        text?: (string|null);

        /** Reaction groupingKey */
        groupingKey?: (string|null);

        /** Reaction senderTimestampMs */
        senderTimestampMs?: (number|Long|null);

        /** Reaction unread */
        unread?: (boolean|null);
    }

    /** Represents a Reaction. */
    class Reaction implements IReaction {

        /**
         * Constructs a new Reaction.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IReaction);

        /** Reaction key. */
        public key?: (proto.IMessageKey|null);

        /** Reaction text. */
        public text: string;

        /** Reaction groupingKey. */
        public groupingKey: string;

        /** Reaction senderTimestampMs. */
        public senderTimestampMs: (number|Long);

        /** Reaction unread. */
        public unread: boolean;

        /**
         * Creates a new Reaction instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Reaction instance
         */
        public static create(properties?: proto.IReaction): proto.Reaction;

        /**
         * Encodes the specified Reaction message. Does not implicitly {@link proto.Reaction.verify|verify} messages.
         * @param message Reaction message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IReaction, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Reaction message, length delimited. Does not implicitly {@link proto.Reaction.verify|verify} messages.
         * @param message Reaction message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IReaction, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Reaction message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Reaction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Reaction;

        /**
         * Decodes a Reaction message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Reaction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Reaction;

        /**
         * Verifies a Reaction message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Reaction message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Reaction
         */
        public static fromObject(object: { [k: string]: any }): proto.Reaction;

        /**
         * Creates a plain object from a Reaction message. Also converts values to other types if specified.
         * @param message Reaction
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Reaction, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Reaction to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RecentEmojiWeight. */
    interface IRecentEmojiWeight {

        /** RecentEmojiWeight emoji */
        emoji?: (string|null);

        /** RecentEmojiWeight weight */
        weight?: (number|null);
    }

    /** Represents a RecentEmojiWeight. */
    class RecentEmojiWeight implements IRecentEmojiWeight {

        /**
         * Constructs a new RecentEmojiWeight.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IRecentEmojiWeight);

        /** RecentEmojiWeight emoji. */
        public emoji: string;

        /** RecentEmojiWeight weight. */
        public weight: number;

        /**
         * Creates a new RecentEmojiWeight instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RecentEmojiWeight instance
         */
        public static create(properties?: proto.IRecentEmojiWeight): proto.RecentEmojiWeight;

        /**
         * Encodes the specified RecentEmojiWeight message. Does not implicitly {@link proto.RecentEmojiWeight.verify|verify} messages.
         * @param message RecentEmojiWeight message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IRecentEmojiWeight, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified RecentEmojiWeight message, length delimited. Does not implicitly {@link proto.RecentEmojiWeight.verify|verify} messages.
         * @param message RecentEmojiWeight message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IRecentEmojiWeight, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a RecentEmojiWeight message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RecentEmojiWeight
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.RecentEmojiWeight;

        /**
         * Decodes a RecentEmojiWeight message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RecentEmojiWeight
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.RecentEmojiWeight;

        /**
         * Verifies a RecentEmojiWeight message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RecentEmojiWeight message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RecentEmojiWeight
         */
        public static fromObject(object: { [k: string]: any }): proto.RecentEmojiWeight;

        /**
         * Creates a plain object from a RecentEmojiWeight message. Also converts values to other types if specified.
         * @param message RecentEmojiWeight
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.RecentEmojiWeight, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RecentEmojiWeight to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RecordStructure. */
    interface IRecordStructure {

        /** RecordStructure currentSession */
        currentSession?: (proto.ISessionStructure|null);

        /** RecordStructure previousSessions */
        previousSessions?: (proto.ISessionStructure[]|null);
    }

    /** Represents a RecordStructure. */
    class RecordStructure implements IRecordStructure {

        /**
         * Constructs a new RecordStructure.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IRecordStructure);

        /** RecordStructure currentSession. */
        public currentSession?: (proto.ISessionStructure|null);

        /** RecordStructure previousSessions. */
        public previousSessions: proto.ISessionStructure[];

        /**
         * Creates a new RecordStructure instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RecordStructure instance
         */
        public static create(properties?: proto.IRecordStructure): proto.RecordStructure;

        /**
         * Encodes the specified RecordStructure message. Does not implicitly {@link proto.RecordStructure.verify|verify} messages.
         * @param message RecordStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IRecordStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified RecordStructure message, length delimited. Does not implicitly {@link proto.RecordStructure.verify|verify} messages.
         * @param message RecordStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IRecordStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a RecordStructure message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RecordStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.RecordStructure;

        /**
         * Decodes a RecordStructure message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RecordStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.RecordStructure;

        /**
         * Verifies a RecordStructure message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RecordStructure message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RecordStructure
         */
        public static fromObject(object: { [k: string]: any }): proto.RecordStructure;

        /**
         * Creates a plain object from a RecordStructure message. Also converts values to other types if specified.
         * @param message RecordStructure
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.RecordStructure, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RecordStructure to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SenderChainKey. */
    interface ISenderChainKey {

        /** SenderChainKey iteration */
        iteration?: (number|null);

        /** SenderChainKey seed */
        seed?: (Uint8Array|null);
    }

    /** Represents a SenderChainKey. */
    class SenderChainKey implements ISenderChainKey {

        /**
         * Constructs a new SenderChainKey.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ISenderChainKey);

        /** SenderChainKey iteration. */
        public iteration: number;

        /** SenderChainKey seed. */
        public seed: Uint8Array;

        /**
         * Creates a new SenderChainKey instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SenderChainKey instance
         */
        public static create(properties?: proto.ISenderChainKey): proto.SenderChainKey;

        /**
         * Encodes the specified SenderChainKey message. Does not implicitly {@link proto.SenderChainKey.verify|verify} messages.
         * @param message SenderChainKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ISenderChainKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SenderChainKey message, length delimited. Does not implicitly {@link proto.SenderChainKey.verify|verify} messages.
         * @param message SenderChainKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ISenderChainKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SenderChainKey message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SenderChainKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SenderChainKey;

        /**
         * Decodes a SenderChainKey message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SenderChainKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SenderChainKey;

        /**
         * Verifies a SenderChainKey message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SenderChainKey message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SenderChainKey
         */
        public static fromObject(object: { [k: string]: any }): proto.SenderChainKey;

        /**
         * Creates a plain object from a SenderChainKey message. Also converts values to other types if specified.
         * @param message SenderChainKey
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.SenderChainKey, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SenderChainKey to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SenderKeyRecordStructure. */
    interface ISenderKeyRecordStructure {

        /** SenderKeyRecordStructure senderKeyStates */
        senderKeyStates?: (proto.ISenderKeyStateStructure[]|null);
    }

    /** Represents a SenderKeyRecordStructure. */
    class SenderKeyRecordStructure implements ISenderKeyRecordStructure {

        /**
         * Constructs a new SenderKeyRecordStructure.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ISenderKeyRecordStructure);

        /** SenderKeyRecordStructure senderKeyStates. */
        public senderKeyStates: proto.ISenderKeyStateStructure[];

        /**
         * Creates a new SenderKeyRecordStructure instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SenderKeyRecordStructure instance
         */
        public static create(properties?: proto.ISenderKeyRecordStructure): proto.SenderKeyRecordStructure;

        /**
         * Encodes the specified SenderKeyRecordStructure message. Does not implicitly {@link proto.SenderKeyRecordStructure.verify|verify} messages.
         * @param message SenderKeyRecordStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ISenderKeyRecordStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SenderKeyRecordStructure message, length delimited. Does not implicitly {@link proto.SenderKeyRecordStructure.verify|verify} messages.
         * @param message SenderKeyRecordStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ISenderKeyRecordStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SenderKeyRecordStructure message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SenderKeyRecordStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SenderKeyRecordStructure;

        /**
         * Decodes a SenderKeyRecordStructure message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SenderKeyRecordStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SenderKeyRecordStructure;

        /**
         * Verifies a SenderKeyRecordStructure message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SenderKeyRecordStructure message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SenderKeyRecordStructure
         */
        public static fromObject(object: { [k: string]: any }): proto.SenderKeyRecordStructure;

        /**
         * Creates a plain object from a SenderKeyRecordStructure message. Also converts values to other types if specified.
         * @param message SenderKeyRecordStructure
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.SenderKeyRecordStructure, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SenderKeyRecordStructure to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SenderKeyStateStructure. */
    interface ISenderKeyStateStructure {

        /** SenderKeyStateStructure senderKeyId */
        senderKeyId?: (number|null);

        /** SenderKeyStateStructure senderChainKey */
        senderChainKey?: (proto.ISenderChainKey|null);

        /** SenderKeyStateStructure senderSigningKey */
        senderSigningKey?: (proto.ISenderSigningKey|null);

        /** SenderKeyStateStructure senderMessageKeys */
        senderMessageKeys?: (proto.ISenderMessageKey[]|null);
    }

    /** Represents a SenderKeyStateStructure. */
    class SenderKeyStateStructure implements ISenderKeyStateStructure {

        /**
         * Constructs a new SenderKeyStateStructure.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ISenderKeyStateStructure);

        /** SenderKeyStateStructure senderKeyId. */
        public senderKeyId: number;

        /** SenderKeyStateStructure senderChainKey. */
        public senderChainKey?: (proto.ISenderChainKey|null);

        /** SenderKeyStateStructure senderSigningKey. */
        public senderSigningKey?: (proto.ISenderSigningKey|null);

        /** SenderKeyStateStructure senderMessageKeys. */
        public senderMessageKeys: proto.ISenderMessageKey[];

        /**
         * Creates a new SenderKeyStateStructure instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SenderKeyStateStructure instance
         */
        public static create(properties?: proto.ISenderKeyStateStructure): proto.SenderKeyStateStructure;

        /**
         * Encodes the specified SenderKeyStateStructure message. Does not implicitly {@link proto.SenderKeyStateStructure.verify|verify} messages.
         * @param message SenderKeyStateStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ISenderKeyStateStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SenderKeyStateStructure message, length delimited. Does not implicitly {@link proto.SenderKeyStateStructure.verify|verify} messages.
         * @param message SenderKeyStateStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ISenderKeyStateStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SenderKeyStateStructure message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SenderKeyStateStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SenderKeyStateStructure;

        /**
         * Decodes a SenderKeyStateStructure message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SenderKeyStateStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SenderKeyStateStructure;

        /**
         * Verifies a SenderKeyStateStructure message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SenderKeyStateStructure message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SenderKeyStateStructure
         */
        public static fromObject(object: { [k: string]: any }): proto.SenderKeyStateStructure;

        /**
         * Creates a plain object from a SenderKeyStateStructure message. Also converts values to other types if specified.
         * @param message SenderKeyStateStructure
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.SenderKeyStateStructure, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SenderKeyStateStructure to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SenderMessageKey. */
    interface ISenderMessageKey {

        /** SenderMessageKey iteration */
        iteration?: (number|null);

        /** SenderMessageKey seed */
        seed?: (Uint8Array|null);
    }

    /** Represents a SenderMessageKey. */
    class SenderMessageKey implements ISenderMessageKey {

        /**
         * Constructs a new SenderMessageKey.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ISenderMessageKey);

        /** SenderMessageKey iteration. */
        public iteration: number;

        /** SenderMessageKey seed. */
        public seed: Uint8Array;

        /**
         * Creates a new SenderMessageKey instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SenderMessageKey instance
         */
        public static create(properties?: proto.ISenderMessageKey): proto.SenderMessageKey;

        /**
         * Encodes the specified SenderMessageKey message. Does not implicitly {@link proto.SenderMessageKey.verify|verify} messages.
         * @param message SenderMessageKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ISenderMessageKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SenderMessageKey message, length delimited. Does not implicitly {@link proto.SenderMessageKey.verify|verify} messages.
         * @param message SenderMessageKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ISenderMessageKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SenderMessageKey message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SenderMessageKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SenderMessageKey;

        /**
         * Decodes a SenderMessageKey message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SenderMessageKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SenderMessageKey;

        /**
         * Verifies a SenderMessageKey message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SenderMessageKey message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SenderMessageKey
         */
        public static fromObject(object: { [k: string]: any }): proto.SenderMessageKey;

        /**
         * Creates a plain object from a SenderMessageKey message. Also converts values to other types if specified.
         * @param message SenderMessageKey
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.SenderMessageKey, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SenderMessageKey to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SenderSigningKey. */
    interface ISenderSigningKey {

        /** SenderSigningKey public */
        "public"?: (Uint8Array|null);

        /** SenderSigningKey private */
        "private"?: (Uint8Array|null);
    }

    /** Represents a SenderSigningKey. */
    class SenderSigningKey implements ISenderSigningKey {

        /**
         * Constructs a new SenderSigningKey.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ISenderSigningKey);

        /** SenderSigningKey public. */
        public public: Uint8Array;

        /** SenderSigningKey private. */
        public private: Uint8Array;

        /**
         * Creates a new SenderSigningKey instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SenderSigningKey instance
         */
        public static create(properties?: proto.ISenderSigningKey): proto.SenderSigningKey;

        /**
         * Encodes the specified SenderSigningKey message. Does not implicitly {@link proto.SenderSigningKey.verify|verify} messages.
         * @param message SenderSigningKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ISenderSigningKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SenderSigningKey message, length delimited. Does not implicitly {@link proto.SenderSigningKey.verify|verify} messages.
         * @param message SenderSigningKey message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ISenderSigningKey, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SenderSigningKey message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SenderSigningKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SenderSigningKey;

        /**
         * Decodes a SenderSigningKey message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SenderSigningKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SenderSigningKey;

        /**
         * Verifies a SenderSigningKey message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SenderSigningKey message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SenderSigningKey
         */
        public static fromObject(object: { [k: string]: any }): proto.SenderSigningKey;

        /**
         * Creates a plain object from a SenderSigningKey message. Also converts values to other types if specified.
         * @param message SenderSigningKey
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.SenderSigningKey, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SenderSigningKey to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ServerErrorReceipt. */
    interface IServerErrorReceipt {

        /** ServerErrorReceipt stanzaId */
        stanzaId?: (string|null);
    }

    /** Represents a ServerErrorReceipt. */
    class ServerErrorReceipt implements IServerErrorReceipt {

        /**
         * Constructs a new ServerErrorReceipt.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IServerErrorReceipt);

        /** ServerErrorReceipt stanzaId. */
        public stanzaId: string;

        /**
         * Creates a new ServerErrorReceipt instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ServerErrorReceipt instance
         */
        public static create(properties?: proto.IServerErrorReceipt): proto.ServerErrorReceipt;

        /**
         * Encodes the specified ServerErrorReceipt message. Does not implicitly {@link proto.ServerErrorReceipt.verify|verify} messages.
         * @param message ServerErrorReceipt message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IServerErrorReceipt, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ServerErrorReceipt message, length delimited. Does not implicitly {@link proto.ServerErrorReceipt.verify|verify} messages.
         * @param message ServerErrorReceipt message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IServerErrorReceipt, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ServerErrorReceipt message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ServerErrorReceipt
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ServerErrorReceipt;

        /**
         * Decodes a ServerErrorReceipt message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ServerErrorReceipt
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ServerErrorReceipt;

        /**
         * Verifies a ServerErrorReceipt message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ServerErrorReceipt message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ServerErrorReceipt
         */
        public static fromObject(object: { [k: string]: any }): proto.ServerErrorReceipt;

        /**
         * Creates a plain object from a ServerErrorReceipt message. Also converts values to other types if specified.
         * @param message ServerErrorReceipt
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ServerErrorReceipt, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ServerErrorReceipt to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SessionStructure. */
    interface ISessionStructure {

        /** SessionStructure sessionVersion */
        sessionVersion?: (number|null);

        /** SessionStructure localIdentityPublic */
        localIdentityPublic?: (Uint8Array|null);

        /** SessionStructure remoteIdentityPublic */
        remoteIdentityPublic?: (Uint8Array|null);

        /** SessionStructure rootKey */
        rootKey?: (Uint8Array|null);

        /** SessionStructure previousCounter */
        previousCounter?: (number|null);

        /** SessionStructure senderChain */
        senderChain?: (proto.IChain|null);

        /** SessionStructure receiverChains */
        receiverChains?: (proto.IChain[]|null);

        /** SessionStructure pendingKeyExchange */
        pendingKeyExchange?: (proto.IPendingKeyExchange|null);

        /** SessionStructure pendingPreKey */
        pendingPreKey?: (proto.IPendingPreKey|null);

        /** SessionStructure remoteRegistrationId */
        remoteRegistrationId?: (number|null);

        /** SessionStructure localRegistrationId */
        localRegistrationId?: (number|null);

        /** SessionStructure needsRefresh */
        needsRefresh?: (boolean|null);

        /** SessionStructure aliceBaseKey */
        aliceBaseKey?: (Uint8Array|null);
    }

    /** Represents a SessionStructure. */
    class SessionStructure implements ISessionStructure {

        /**
         * Constructs a new SessionStructure.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ISessionStructure);

        /** SessionStructure sessionVersion. */
        public sessionVersion: number;

        /** SessionStructure localIdentityPublic. */
        public localIdentityPublic: Uint8Array;

        /** SessionStructure remoteIdentityPublic. */
        public remoteIdentityPublic: Uint8Array;

        /** SessionStructure rootKey. */
        public rootKey: Uint8Array;

        /** SessionStructure previousCounter. */
        public previousCounter: number;

        /** SessionStructure senderChain. */
        public senderChain?: (proto.IChain|null);

        /** SessionStructure receiverChains. */
        public receiverChains: proto.IChain[];

        /** SessionStructure pendingKeyExchange. */
        public pendingKeyExchange?: (proto.IPendingKeyExchange|null);

        /** SessionStructure pendingPreKey. */
        public pendingPreKey?: (proto.IPendingPreKey|null);

        /** SessionStructure remoteRegistrationId. */
        public remoteRegistrationId: number;

        /** SessionStructure localRegistrationId. */
        public localRegistrationId: number;

        /** SessionStructure needsRefresh. */
        public needsRefresh: boolean;

        /** SessionStructure aliceBaseKey. */
        public aliceBaseKey: Uint8Array;

        /**
         * Creates a new SessionStructure instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SessionStructure instance
         */
        public static create(properties?: proto.ISessionStructure): proto.SessionStructure;

        /**
         * Encodes the specified SessionStructure message. Does not implicitly {@link proto.SessionStructure.verify|verify} messages.
         * @param message SessionStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ISessionStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SessionStructure message, length delimited. Does not implicitly {@link proto.SessionStructure.verify|verify} messages.
         * @param message SessionStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ISessionStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SessionStructure message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SessionStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SessionStructure;

        /**
         * Decodes a SessionStructure message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SessionStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SessionStructure;

        /**
         * Verifies a SessionStructure message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SessionStructure message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SessionStructure
         */
        public static fromObject(object: { [k: string]: any }): proto.SessionStructure;

        /**
         * Creates a plain object from a SessionStructure message. Also converts values to other types if specified.
         * @param message SessionStructure
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.SessionStructure, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SessionStructure to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SignedPreKeyRecordStructure. */
    interface ISignedPreKeyRecordStructure {

        /** SignedPreKeyRecordStructure id */
        id?: (number|null);

        /** SignedPreKeyRecordStructure publicKey */
        publicKey?: (Uint8Array|null);

        /** SignedPreKeyRecordStructure privateKey */
        privateKey?: (Uint8Array|null);

        /** SignedPreKeyRecordStructure signature */
        signature?: (Uint8Array|null);

        /** SignedPreKeyRecordStructure timestamp */
        timestamp?: (number|Long|null);
    }

    /** Represents a SignedPreKeyRecordStructure. */
    class SignedPreKeyRecordStructure implements ISignedPreKeyRecordStructure {

        /**
         * Constructs a new SignedPreKeyRecordStructure.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ISignedPreKeyRecordStructure);

        /** SignedPreKeyRecordStructure id. */
        public id: number;

        /** SignedPreKeyRecordStructure publicKey. */
        public publicKey: Uint8Array;

        /** SignedPreKeyRecordStructure privateKey. */
        public privateKey: Uint8Array;

        /** SignedPreKeyRecordStructure signature. */
        public signature: Uint8Array;

        /** SignedPreKeyRecordStructure timestamp. */
        public timestamp: (number|Long);

        /**
         * Creates a new SignedPreKeyRecordStructure instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SignedPreKeyRecordStructure instance
         */
        public static create(properties?: proto.ISignedPreKeyRecordStructure): proto.SignedPreKeyRecordStructure;

        /**
         * Encodes the specified SignedPreKeyRecordStructure message. Does not implicitly {@link proto.SignedPreKeyRecordStructure.verify|verify} messages.
         * @param message SignedPreKeyRecordStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ISignedPreKeyRecordStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SignedPreKeyRecordStructure message, length delimited. Does not implicitly {@link proto.SignedPreKeyRecordStructure.verify|verify} messages.
         * @param message SignedPreKeyRecordStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ISignedPreKeyRecordStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SignedPreKeyRecordStructure message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SignedPreKeyRecordStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SignedPreKeyRecordStructure;

        /**
         * Decodes a SignedPreKeyRecordStructure message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SignedPreKeyRecordStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SignedPreKeyRecordStructure;

        /**
         * Verifies a SignedPreKeyRecordStructure message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SignedPreKeyRecordStructure message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SignedPreKeyRecordStructure
         */
        public static fromObject(object: { [k: string]: any }): proto.SignedPreKeyRecordStructure;

        /**
         * Creates a plain object from a SignedPreKeyRecordStructure message. Also converts values to other types if specified.
         * @param message SignedPreKeyRecordStructure
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.SignedPreKeyRecordStructure, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SignedPreKeyRecordStructure to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a StatusPSA. */
    interface IStatusPSA {

        /** StatusPSA campaignId */
        campaignId: (number|Long);

        /** StatusPSA campaignExpirationTimestamp */
        campaignExpirationTimestamp?: (number|Long|null);
    }

    /** Represents a StatusPSA. */
    class StatusPSA implements IStatusPSA {

        /**
         * Constructs a new StatusPSA.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IStatusPSA);

        /** StatusPSA campaignId. */
        public campaignId: (number|Long);

        /** StatusPSA campaignExpirationTimestamp. */
        public campaignExpirationTimestamp: (number|Long);

        /**
         * Creates a new StatusPSA instance using the specified properties.
         * @param [properties] Properties to set
         * @returns StatusPSA instance
         */
        public static create(properties?: proto.IStatusPSA): proto.StatusPSA;

        /**
         * Encodes the specified StatusPSA message. Does not implicitly {@link proto.StatusPSA.verify|verify} messages.
         * @param message StatusPSA message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IStatusPSA, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified StatusPSA message, length delimited. Does not implicitly {@link proto.StatusPSA.verify|verify} messages.
         * @param message StatusPSA message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IStatusPSA, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a StatusPSA message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns StatusPSA
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.StatusPSA;

        /**
         * Decodes a StatusPSA message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns StatusPSA
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.StatusPSA;

        /**
         * Verifies a StatusPSA message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a StatusPSA message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns StatusPSA
         */
        public static fromObject(object: { [k: string]: any }): proto.StatusPSA;

        /**
         * Creates a plain object from a StatusPSA message. Also converts values to other types if specified.
         * @param message StatusPSA
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.StatusPSA, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this StatusPSA to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a StickerMetadata. */
    interface IStickerMetadata {

        /** StickerMetadata url */
        url?: (string|null);

        /** StickerMetadata fileSha256 */
        fileSha256?: (Uint8Array|null);

        /** StickerMetadata fileEncSha256 */
        fileEncSha256?: (Uint8Array|null);

        /** StickerMetadata mediaKey */
        mediaKey?: (Uint8Array|null);

        /** StickerMetadata mimetype */
        mimetype?: (string|null);

        /** StickerMetadata height */
        height?: (number|null);

        /** StickerMetadata width */
        width?: (number|null);

        /** StickerMetadata directPath */
        directPath?: (string|null);

        /** StickerMetadata fileLength */
        fileLength?: (number|Long|null);

        /** StickerMetadata weight */
        weight?: (number|null);

        /** StickerMetadata lastStickerSentTs */
        lastStickerSentTs?: (number|Long|null);
    }

    /** Represents a StickerMetadata. */
    class StickerMetadata implements IStickerMetadata {

        /**
         * Constructs a new StickerMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IStickerMetadata);

        /** StickerMetadata url. */
        public url: string;

        /** StickerMetadata fileSha256. */
        public fileSha256: Uint8Array;

        /** StickerMetadata fileEncSha256. */
        public fileEncSha256: Uint8Array;

        /** StickerMetadata mediaKey. */
        public mediaKey: Uint8Array;

        /** StickerMetadata mimetype. */
        public mimetype: string;

        /** StickerMetadata height. */
        public height: number;

        /** StickerMetadata width. */
        public width: number;

        /** StickerMetadata directPath. */
        public directPath: string;

        /** StickerMetadata fileLength. */
        public fileLength: (number|Long);

        /** StickerMetadata weight. */
        public weight: number;

        /** StickerMetadata lastStickerSentTs. */
        public lastStickerSentTs: (number|Long);

        /**
         * Creates a new StickerMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns StickerMetadata instance
         */
        public static create(properties?: proto.IStickerMetadata): proto.StickerMetadata;

        /**
         * Encodes the specified StickerMetadata message. Does not implicitly {@link proto.StickerMetadata.verify|verify} messages.
         * @param message StickerMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IStickerMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified StickerMetadata message, length delimited. Does not implicitly {@link proto.StickerMetadata.verify|verify} messages.
         * @param message StickerMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IStickerMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a StickerMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns StickerMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.StickerMetadata;

        /**
         * Decodes a StickerMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns StickerMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.StickerMetadata;

        /**
         * Verifies a StickerMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a StickerMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns StickerMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.StickerMetadata;

        /**
         * Creates a plain object from a StickerMetadata message. Also converts values to other types if specified.
         * @param message StickerMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.StickerMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this StickerMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SyncActionData. */
    interface ISyncActionData {

        /** SyncActionData index */
        index?: (Uint8Array|null);

        /** SyncActionData value */
        value?: (proto.ISyncActionValue|null);

        /** SyncActionData padding */
        padding?: (Uint8Array|null);

        /** SyncActionData version */
        version?: (number|null);
    }

    /** Represents a SyncActionData. */
    class SyncActionData implements ISyncActionData {

        /**
         * Constructs a new SyncActionData.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ISyncActionData);

        /** SyncActionData index. */
        public index: Uint8Array;

        /** SyncActionData value. */
        public value?: (proto.ISyncActionValue|null);

        /** SyncActionData padding. */
        public padding: Uint8Array;

        /** SyncActionData version. */
        public version: number;

        /**
         * Creates a new SyncActionData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SyncActionData instance
         */
        public static create(properties?: proto.ISyncActionData): proto.SyncActionData;

        /**
         * Encodes the specified SyncActionData message. Does not implicitly {@link proto.SyncActionData.verify|verify} messages.
         * @param message SyncActionData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ISyncActionData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SyncActionData message, length delimited. Does not implicitly {@link proto.SyncActionData.verify|verify} messages.
         * @param message SyncActionData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ISyncActionData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SyncActionData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SyncActionData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionData;

        /**
         * Decodes a SyncActionData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SyncActionData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionData;

        /**
         * Verifies a SyncActionData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SyncActionData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SyncActionData
         */
        public static fromObject(object: { [k: string]: any }): proto.SyncActionData;

        /**
         * Creates a plain object from a SyncActionData message. Also converts values to other types if specified.
         * @param message SyncActionData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.SyncActionData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SyncActionData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SyncActionValue. */
    interface ISyncActionValue {

        /** SyncActionValue timestamp */
        timestamp?: (number|Long|null);

        /** SyncActionValue starAction */
        starAction?: (proto.SyncActionValue.IStarAction|null);

        /** SyncActionValue contactAction */
        contactAction?: (proto.SyncActionValue.IContactAction|null);

        /** SyncActionValue muteAction */
        muteAction?: (proto.SyncActionValue.IMuteAction|null);

        /** SyncActionValue pinAction */
        pinAction?: (proto.SyncActionValue.IPinAction|null);

        /** SyncActionValue securityNotificationSetting */
        securityNotificationSetting?: (proto.SyncActionValue.ISecurityNotificationSetting|null);

        /** SyncActionValue pushNameSetting */
        pushNameSetting?: (proto.SyncActionValue.IPushNameSetting|null);

        /** SyncActionValue quickReplyAction */
        quickReplyAction?: (proto.SyncActionValue.IQuickReplyAction|null);

        /** SyncActionValue recentEmojiWeightsAction */
        recentEmojiWeightsAction?: (proto.SyncActionValue.IRecentEmojiWeightsAction|null);

        /** SyncActionValue labelEditAction */
        labelEditAction?: (proto.SyncActionValue.ILabelEditAction|null);

        /** SyncActionValue labelAssociationAction */
        labelAssociationAction?: (proto.SyncActionValue.ILabelAssociationAction|null);

        /** SyncActionValue localeSetting */
        localeSetting?: (proto.SyncActionValue.ILocaleSetting|null);

        /** SyncActionValue archiveChatAction */
        archiveChatAction?: (proto.SyncActionValue.IArchiveChatAction|null);

        /** SyncActionValue deleteMessageForMeAction */
        deleteMessageForMeAction?: (proto.SyncActionValue.IDeleteMessageForMeAction|null);

        /** SyncActionValue keyExpiration */
        keyExpiration?: (proto.SyncActionValue.IKeyExpiration|null);

        /** SyncActionValue markChatAsReadAction */
        markChatAsReadAction?: (proto.SyncActionValue.IMarkChatAsReadAction|null);

        /** SyncActionValue clearChatAction */
        clearChatAction?: (proto.SyncActionValue.IClearChatAction|null);

        /** SyncActionValue deleteChatAction */
        deleteChatAction?: (proto.SyncActionValue.IDeleteChatAction|null);

        /** SyncActionValue unarchiveChatsSetting */
        unarchiveChatsSetting?: (proto.SyncActionValue.IUnarchiveChatsSetting|null);

        /** SyncActionValue primaryFeature */
        primaryFeature?: (proto.SyncActionValue.IPrimaryFeature|null);

        /** SyncActionValue androidUnsupportedActions */
        androidUnsupportedActions?: (proto.SyncActionValue.IAndroidUnsupportedActions|null);

        /** SyncActionValue agentAction */
        agentAction?: (proto.SyncActionValue.IAgentAction|null);

        /** SyncActionValue subscriptionAction */
        subscriptionAction?: (proto.SyncActionValue.ISubscriptionAction|null);

        /** SyncActionValue userStatusMuteAction */
        userStatusMuteAction?: (proto.SyncActionValue.IUserStatusMuteAction|null);

        /** SyncActionValue timeFormatAction */
        timeFormatAction?: (proto.SyncActionValue.ITimeFormatAction|null);

        /** SyncActionValue nuxAction */
        nuxAction?: (proto.SyncActionValue.INuxAction|null);

        /** SyncActionValue primaryVersionAction */
        primaryVersionAction?: (proto.SyncActionValue.IPrimaryVersionAction|null);

        /** SyncActionValue stickerAction */
        stickerAction?: (proto.SyncActionValue.IStickerAction|null);

        /** SyncActionValue removeRecentStickerAction */
        removeRecentStickerAction?: (proto.SyncActionValue.IRemoveRecentStickerAction|null);

        /** SyncActionValue chatAssignment */
        chatAssignment?: (proto.SyncActionValue.IChatAssignmentAction|null);

        /** SyncActionValue chatAssignmentOpenedStatus */
        chatAssignmentOpenedStatus?: (proto.SyncActionValue.IChatAssignmentOpenedStatusAction|null);
    }

    /** Represents a SyncActionValue. */
    class SyncActionValue implements ISyncActionValue {

        /**
         * Constructs a new SyncActionValue.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ISyncActionValue);

        /** SyncActionValue timestamp. */
        public timestamp: (number|Long);

        /** SyncActionValue starAction. */
        public starAction?: (proto.SyncActionValue.IStarAction|null);

        /** SyncActionValue contactAction. */
        public contactAction?: (proto.SyncActionValue.IContactAction|null);

        /** SyncActionValue muteAction. */
        public muteAction?: (proto.SyncActionValue.IMuteAction|null);

        /** SyncActionValue pinAction. */
        public pinAction?: (proto.SyncActionValue.IPinAction|null);

        /** SyncActionValue securityNotificationSetting. */
        public securityNotificationSetting?: (proto.SyncActionValue.ISecurityNotificationSetting|null);

        /** SyncActionValue pushNameSetting. */
        public pushNameSetting?: (proto.SyncActionValue.IPushNameSetting|null);

        /** SyncActionValue quickReplyAction. */
        public quickReplyAction?: (proto.SyncActionValue.IQuickReplyAction|null);

        /** SyncActionValue recentEmojiWeightsAction. */
        public recentEmojiWeightsAction?: (proto.SyncActionValue.IRecentEmojiWeightsAction|null);

        /** SyncActionValue labelEditAction. */
        public labelEditAction?: (proto.SyncActionValue.ILabelEditAction|null);

        /** SyncActionValue labelAssociationAction. */
        public labelAssociationAction?: (proto.SyncActionValue.ILabelAssociationAction|null);

        /** SyncActionValue localeSetting. */
        public localeSetting?: (proto.SyncActionValue.ILocaleSetting|null);

        /** SyncActionValue archiveChatAction. */
        public archiveChatAction?: (proto.SyncActionValue.IArchiveChatAction|null);

        /** SyncActionValue deleteMessageForMeAction. */
        public deleteMessageForMeAction?: (proto.SyncActionValue.IDeleteMessageForMeAction|null);

        /** SyncActionValue keyExpiration. */
        public keyExpiration?: (proto.SyncActionValue.IKeyExpiration|null);

        /** SyncActionValue markChatAsReadAction. */
        public markChatAsReadAction?: (proto.SyncActionValue.IMarkChatAsReadAction|null);

        /** SyncActionValue clearChatAction. */
        public clearChatAction?: (proto.SyncActionValue.IClearChatAction|null);

        /** SyncActionValue deleteChatAction. */
        public deleteChatAction?: (proto.SyncActionValue.IDeleteChatAction|null);

        /** SyncActionValue unarchiveChatsSetting. */
        public unarchiveChatsSetting?: (proto.SyncActionValue.IUnarchiveChatsSetting|null);

        /** SyncActionValue primaryFeature. */
        public primaryFeature?: (proto.SyncActionValue.IPrimaryFeature|null);

        /** SyncActionValue androidUnsupportedActions. */
        public androidUnsupportedActions?: (proto.SyncActionValue.IAndroidUnsupportedActions|null);

        /** SyncActionValue agentAction. */
        public agentAction?: (proto.SyncActionValue.IAgentAction|null);

        /** SyncActionValue subscriptionAction. */
        public subscriptionAction?: (proto.SyncActionValue.ISubscriptionAction|null);

        /** SyncActionValue userStatusMuteAction. */
        public userStatusMuteAction?: (proto.SyncActionValue.IUserStatusMuteAction|null);

        /** SyncActionValue timeFormatAction. */
        public timeFormatAction?: (proto.SyncActionValue.ITimeFormatAction|null);

        /** SyncActionValue nuxAction. */
        public nuxAction?: (proto.SyncActionValue.INuxAction|null);

        /** SyncActionValue primaryVersionAction. */
        public primaryVersionAction?: (proto.SyncActionValue.IPrimaryVersionAction|null);

        /** SyncActionValue stickerAction. */
        public stickerAction?: (proto.SyncActionValue.IStickerAction|null);

        /** SyncActionValue removeRecentStickerAction. */
        public removeRecentStickerAction?: (proto.SyncActionValue.IRemoveRecentStickerAction|null);

        /** SyncActionValue chatAssignment. */
        public chatAssignment?: (proto.SyncActionValue.IChatAssignmentAction|null);

        /** SyncActionValue chatAssignmentOpenedStatus. */
        public chatAssignmentOpenedStatus?: (proto.SyncActionValue.IChatAssignmentOpenedStatusAction|null);

        /**
         * Creates a new SyncActionValue instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SyncActionValue instance
         */
        public static create(properties?: proto.ISyncActionValue): proto.SyncActionValue;

        /**
         * Encodes the specified SyncActionValue message. Does not implicitly {@link proto.SyncActionValue.verify|verify} messages.
         * @param message SyncActionValue message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ISyncActionValue, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SyncActionValue message, length delimited. Does not implicitly {@link proto.SyncActionValue.verify|verify} messages.
         * @param message SyncActionValue message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ISyncActionValue, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SyncActionValue message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SyncActionValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue;

        /**
         * Decodes a SyncActionValue message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SyncActionValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue;

        /**
         * Verifies a SyncActionValue message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SyncActionValue message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SyncActionValue
         */
        public static fromObject(object: { [k: string]: any }): proto.SyncActionValue;

        /**
         * Creates a plain object from a SyncActionValue message. Also converts values to other types if specified.
         * @param message SyncActionValue
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.SyncActionValue, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SyncActionValue to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace SyncActionValue {

        /** Properties of an AgentAction. */
        interface IAgentAction {

            /** AgentAction name */
            name?: (string|null);

            /** AgentAction deviceID */
            deviceID?: (number|null);

            /** AgentAction isDeleted */
            isDeleted?: (boolean|null);
        }

        /** Represents an AgentAction. */
        class AgentAction implements IAgentAction {

            /**
             * Constructs a new AgentAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IAgentAction);

            /** AgentAction name. */
            public name: string;

            /** AgentAction deviceID. */
            public deviceID: number;

            /** AgentAction isDeleted. */
            public isDeleted: boolean;

            /**
             * Creates a new AgentAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AgentAction instance
             */
            public static create(properties?: proto.SyncActionValue.IAgentAction): proto.SyncActionValue.AgentAction;

            /**
             * Encodes the specified AgentAction message. Does not implicitly {@link proto.SyncActionValue.AgentAction.verify|verify} messages.
             * @param message AgentAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IAgentAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AgentAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.AgentAction.verify|verify} messages.
             * @param message AgentAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IAgentAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AgentAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AgentAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.AgentAction;

            /**
             * Decodes an AgentAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AgentAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.AgentAction;

            /**
             * Verifies an AgentAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AgentAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AgentAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.AgentAction;

            /**
             * Creates a plain object from an AgentAction message. Also converts values to other types if specified.
             * @param message AgentAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.AgentAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AgentAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an AndroidUnsupportedActions. */
        interface IAndroidUnsupportedActions {

            /** AndroidUnsupportedActions allowed */
            allowed?: (boolean|null);
        }

        /** Represents an AndroidUnsupportedActions. */
        class AndroidUnsupportedActions implements IAndroidUnsupportedActions {

            /**
             * Constructs a new AndroidUnsupportedActions.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IAndroidUnsupportedActions);

            /** AndroidUnsupportedActions allowed. */
            public allowed: boolean;

            /**
             * Creates a new AndroidUnsupportedActions instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AndroidUnsupportedActions instance
             */
            public static create(properties?: proto.SyncActionValue.IAndroidUnsupportedActions): proto.SyncActionValue.AndroidUnsupportedActions;

            /**
             * Encodes the specified AndroidUnsupportedActions message. Does not implicitly {@link proto.SyncActionValue.AndroidUnsupportedActions.verify|verify} messages.
             * @param message AndroidUnsupportedActions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IAndroidUnsupportedActions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AndroidUnsupportedActions message, length delimited. Does not implicitly {@link proto.SyncActionValue.AndroidUnsupportedActions.verify|verify} messages.
             * @param message AndroidUnsupportedActions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IAndroidUnsupportedActions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AndroidUnsupportedActions message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AndroidUnsupportedActions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.AndroidUnsupportedActions;

            /**
             * Decodes an AndroidUnsupportedActions message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AndroidUnsupportedActions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.AndroidUnsupportedActions;

            /**
             * Verifies an AndroidUnsupportedActions message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AndroidUnsupportedActions message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AndroidUnsupportedActions
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.AndroidUnsupportedActions;

            /**
             * Creates a plain object from an AndroidUnsupportedActions message. Also converts values to other types if specified.
             * @param message AndroidUnsupportedActions
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.AndroidUnsupportedActions, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AndroidUnsupportedActions to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an ArchiveChatAction. */
        interface IArchiveChatAction {

            /** ArchiveChatAction archived */
            archived?: (boolean|null);

            /** ArchiveChatAction messageRange */
            messageRange?: (proto.SyncActionValue.ISyncActionMessageRange|null);
        }

        /** Represents an ArchiveChatAction. */
        class ArchiveChatAction implements IArchiveChatAction {

            /**
             * Constructs a new ArchiveChatAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IArchiveChatAction);

            /** ArchiveChatAction archived. */
            public archived: boolean;

            /** ArchiveChatAction messageRange. */
            public messageRange?: (proto.SyncActionValue.ISyncActionMessageRange|null);

            /**
             * Creates a new ArchiveChatAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ArchiveChatAction instance
             */
            public static create(properties?: proto.SyncActionValue.IArchiveChatAction): proto.SyncActionValue.ArchiveChatAction;

            /**
             * Encodes the specified ArchiveChatAction message. Does not implicitly {@link proto.SyncActionValue.ArchiveChatAction.verify|verify} messages.
             * @param message ArchiveChatAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IArchiveChatAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ArchiveChatAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.ArchiveChatAction.verify|verify} messages.
             * @param message ArchiveChatAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IArchiveChatAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an ArchiveChatAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ArchiveChatAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.ArchiveChatAction;

            /**
             * Decodes an ArchiveChatAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ArchiveChatAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.ArchiveChatAction;

            /**
             * Verifies an ArchiveChatAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an ArchiveChatAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ArchiveChatAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.ArchiveChatAction;

            /**
             * Creates a plain object from an ArchiveChatAction message. Also converts values to other types if specified.
             * @param message ArchiveChatAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.ArchiveChatAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ArchiveChatAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ChatAssignmentAction. */
        interface IChatAssignmentAction {

            /** ChatAssignmentAction deviceAgentID */
            deviceAgentID?: (string|null);
        }

        /** Represents a ChatAssignmentAction. */
        class ChatAssignmentAction implements IChatAssignmentAction {

            /**
             * Constructs a new ChatAssignmentAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IChatAssignmentAction);

            /** ChatAssignmentAction deviceAgentID. */
            public deviceAgentID: string;

            /**
             * Creates a new ChatAssignmentAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ChatAssignmentAction instance
             */
            public static create(properties?: proto.SyncActionValue.IChatAssignmentAction): proto.SyncActionValue.ChatAssignmentAction;

            /**
             * Encodes the specified ChatAssignmentAction message. Does not implicitly {@link proto.SyncActionValue.ChatAssignmentAction.verify|verify} messages.
             * @param message ChatAssignmentAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IChatAssignmentAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ChatAssignmentAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.ChatAssignmentAction.verify|verify} messages.
             * @param message ChatAssignmentAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IChatAssignmentAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ChatAssignmentAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ChatAssignmentAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.ChatAssignmentAction;

            /**
             * Decodes a ChatAssignmentAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ChatAssignmentAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.ChatAssignmentAction;

            /**
             * Verifies a ChatAssignmentAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ChatAssignmentAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ChatAssignmentAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.ChatAssignmentAction;

            /**
             * Creates a plain object from a ChatAssignmentAction message. Also converts values to other types if specified.
             * @param message ChatAssignmentAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.ChatAssignmentAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ChatAssignmentAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ChatAssignmentOpenedStatusAction. */
        interface IChatAssignmentOpenedStatusAction {

            /** ChatAssignmentOpenedStatusAction chatOpened */
            chatOpened?: (boolean|null);
        }

        /** Represents a ChatAssignmentOpenedStatusAction. */
        class ChatAssignmentOpenedStatusAction implements IChatAssignmentOpenedStatusAction {

            /**
             * Constructs a new ChatAssignmentOpenedStatusAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IChatAssignmentOpenedStatusAction);

            /** ChatAssignmentOpenedStatusAction chatOpened. */
            public chatOpened: boolean;

            /**
             * Creates a new ChatAssignmentOpenedStatusAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ChatAssignmentOpenedStatusAction instance
             */
            public static create(properties?: proto.SyncActionValue.IChatAssignmentOpenedStatusAction): proto.SyncActionValue.ChatAssignmentOpenedStatusAction;

            /**
             * Encodes the specified ChatAssignmentOpenedStatusAction message. Does not implicitly {@link proto.SyncActionValue.ChatAssignmentOpenedStatusAction.verify|verify} messages.
             * @param message ChatAssignmentOpenedStatusAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IChatAssignmentOpenedStatusAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ChatAssignmentOpenedStatusAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.ChatAssignmentOpenedStatusAction.verify|verify} messages.
             * @param message ChatAssignmentOpenedStatusAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IChatAssignmentOpenedStatusAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ChatAssignmentOpenedStatusAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ChatAssignmentOpenedStatusAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.ChatAssignmentOpenedStatusAction;

            /**
             * Decodes a ChatAssignmentOpenedStatusAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ChatAssignmentOpenedStatusAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.ChatAssignmentOpenedStatusAction;

            /**
             * Verifies a ChatAssignmentOpenedStatusAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ChatAssignmentOpenedStatusAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ChatAssignmentOpenedStatusAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.ChatAssignmentOpenedStatusAction;

            /**
             * Creates a plain object from a ChatAssignmentOpenedStatusAction message. Also converts values to other types if specified.
             * @param message ChatAssignmentOpenedStatusAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.ChatAssignmentOpenedStatusAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ChatAssignmentOpenedStatusAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ClearChatAction. */
        interface IClearChatAction {

            /** ClearChatAction messageRange */
            messageRange?: (proto.SyncActionValue.ISyncActionMessageRange|null);
        }

        /** Represents a ClearChatAction. */
        class ClearChatAction implements IClearChatAction {

            /**
             * Constructs a new ClearChatAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IClearChatAction);

            /** ClearChatAction messageRange. */
            public messageRange?: (proto.SyncActionValue.ISyncActionMessageRange|null);

            /**
             * Creates a new ClearChatAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ClearChatAction instance
             */
            public static create(properties?: proto.SyncActionValue.IClearChatAction): proto.SyncActionValue.ClearChatAction;

            /**
             * Encodes the specified ClearChatAction message. Does not implicitly {@link proto.SyncActionValue.ClearChatAction.verify|verify} messages.
             * @param message ClearChatAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IClearChatAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ClearChatAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.ClearChatAction.verify|verify} messages.
             * @param message ClearChatAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IClearChatAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ClearChatAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ClearChatAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.ClearChatAction;

            /**
             * Decodes a ClearChatAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ClearChatAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.ClearChatAction;

            /**
             * Verifies a ClearChatAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ClearChatAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ClearChatAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.ClearChatAction;

            /**
             * Creates a plain object from a ClearChatAction message. Also converts values to other types if specified.
             * @param message ClearChatAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.ClearChatAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ClearChatAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ContactAction. */
        interface IContactAction {

            /** ContactAction fullName */
            fullName?: (string|null);

            /** ContactAction firstName */
            firstName?: (string|null);

            /** ContactAction lidJid */
            lidJid?: (string|null);
        }

        /** Represents a ContactAction. */
        class ContactAction implements IContactAction {

            /**
             * Constructs a new ContactAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IContactAction);

            /** ContactAction fullName. */
            public fullName: string;

            /** ContactAction firstName. */
            public firstName: string;

            /** ContactAction lidJid. */
            public lidJid: string;

            /**
             * Creates a new ContactAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ContactAction instance
             */
            public static create(properties?: proto.SyncActionValue.IContactAction): proto.SyncActionValue.ContactAction;

            /**
             * Encodes the specified ContactAction message. Does not implicitly {@link proto.SyncActionValue.ContactAction.verify|verify} messages.
             * @param message ContactAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IContactAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ContactAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.ContactAction.verify|verify} messages.
             * @param message ContactAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IContactAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ContactAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ContactAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.ContactAction;

            /**
             * Decodes a ContactAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ContactAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.ContactAction;

            /**
             * Verifies a ContactAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ContactAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ContactAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.ContactAction;

            /**
             * Creates a plain object from a ContactAction message. Also converts values to other types if specified.
             * @param message ContactAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.ContactAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ContactAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a DeleteChatAction. */
        interface IDeleteChatAction {

            /** DeleteChatAction messageRange */
            messageRange?: (proto.SyncActionValue.ISyncActionMessageRange|null);
        }

        /** Represents a DeleteChatAction. */
        class DeleteChatAction implements IDeleteChatAction {

            /**
             * Constructs a new DeleteChatAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IDeleteChatAction);

            /** DeleteChatAction messageRange. */
            public messageRange?: (proto.SyncActionValue.ISyncActionMessageRange|null);

            /**
             * Creates a new DeleteChatAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DeleteChatAction instance
             */
            public static create(properties?: proto.SyncActionValue.IDeleteChatAction): proto.SyncActionValue.DeleteChatAction;

            /**
             * Encodes the specified DeleteChatAction message. Does not implicitly {@link proto.SyncActionValue.DeleteChatAction.verify|verify} messages.
             * @param message DeleteChatAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IDeleteChatAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DeleteChatAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.DeleteChatAction.verify|verify} messages.
             * @param message DeleteChatAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IDeleteChatAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DeleteChatAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DeleteChatAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.DeleteChatAction;

            /**
             * Decodes a DeleteChatAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DeleteChatAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.DeleteChatAction;

            /**
             * Verifies a DeleteChatAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DeleteChatAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DeleteChatAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.DeleteChatAction;

            /**
             * Creates a plain object from a DeleteChatAction message. Also converts values to other types if specified.
             * @param message DeleteChatAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.DeleteChatAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DeleteChatAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a DeleteMessageForMeAction. */
        interface IDeleteMessageForMeAction {

            /** DeleteMessageForMeAction deleteMedia */
            deleteMedia?: (boolean|null);

            /** DeleteMessageForMeAction messageTimestamp */
            messageTimestamp?: (number|Long|null);
        }

        /** Represents a DeleteMessageForMeAction. */
        class DeleteMessageForMeAction implements IDeleteMessageForMeAction {

            /**
             * Constructs a new DeleteMessageForMeAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IDeleteMessageForMeAction);

            /** DeleteMessageForMeAction deleteMedia. */
            public deleteMedia: boolean;

            /** DeleteMessageForMeAction messageTimestamp. */
            public messageTimestamp: (number|Long);

            /**
             * Creates a new DeleteMessageForMeAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DeleteMessageForMeAction instance
             */
            public static create(properties?: proto.SyncActionValue.IDeleteMessageForMeAction): proto.SyncActionValue.DeleteMessageForMeAction;

            /**
             * Encodes the specified DeleteMessageForMeAction message. Does not implicitly {@link proto.SyncActionValue.DeleteMessageForMeAction.verify|verify} messages.
             * @param message DeleteMessageForMeAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IDeleteMessageForMeAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DeleteMessageForMeAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.DeleteMessageForMeAction.verify|verify} messages.
             * @param message DeleteMessageForMeAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IDeleteMessageForMeAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DeleteMessageForMeAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DeleteMessageForMeAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.DeleteMessageForMeAction;

            /**
             * Decodes a DeleteMessageForMeAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DeleteMessageForMeAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.DeleteMessageForMeAction;

            /**
             * Verifies a DeleteMessageForMeAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DeleteMessageForMeAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DeleteMessageForMeAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.DeleteMessageForMeAction;

            /**
             * Creates a plain object from a DeleteMessageForMeAction message. Also converts values to other types if specified.
             * @param message DeleteMessageForMeAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.DeleteMessageForMeAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DeleteMessageForMeAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a KeyExpiration. */
        interface IKeyExpiration {

            /** KeyExpiration expiredKeyEpoch */
            expiredKeyEpoch?: (number|null);
        }

        /** Represents a KeyExpiration. */
        class KeyExpiration implements IKeyExpiration {

            /**
             * Constructs a new KeyExpiration.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.IKeyExpiration);

            /** KeyExpiration expiredKeyEpoch. */
            public expiredKeyEpoch: number;

            /**
             * Creates a new KeyExpiration instance using the specified properties.
             * @param [properties] Properties to set
             * @returns KeyExpiration instance
             */
            public static create(properties?: proto.SyncActionValue.IKeyExpiration): proto.SyncActionValue.KeyExpiration;

            /**
             * Encodes the specified KeyExpiration message. Does not implicitly {@link proto.SyncActionValue.KeyExpiration.verify|verify} messages.
             * @param message KeyExpiration message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.IKeyExpiration, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified KeyExpiration message, length delimited. Does not implicitly {@link proto.SyncActionValue.KeyExpiration.verify|verify} messages.
             * @param message KeyExpiration message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.IKeyExpiration, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a KeyExpiration message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns KeyExpiration
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.KeyExpiration;

            /**
             * Decodes a KeyExpiration message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns KeyExpiration
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.KeyExpiration;

            /**
             * Verifies a KeyExpiration message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a KeyExpiration message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns KeyExpiration
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.KeyExpiration;

            /**
             * Creates a plain object from a KeyExpiration message. Also converts values to other types if specified.
             * @param message KeyExpiration
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.KeyExpiration, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this KeyExpiration to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a LabelAssociationAction. */
        interface ILabelAssociationAction {

            /** LabelAssociationAction labeled */
            labeled?: (boolean|null);
        }

        /** Represents a LabelAssociationAction. */
        class LabelAssociationAction implements ILabelAssociationAction {

            /**
             * Constructs a new LabelAssociationAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.ILabelAssociationAction);

            /** LabelAssociationAction labeled. */
            public labeled: boolean;

            /**
             * Creates a new LabelAssociationAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns LabelAssociationAction instance
             */
            public static create(properties?: proto.SyncActionValue.ILabelAssociationAction): proto.SyncActionValue.LabelAssociationAction;

            /**
             * Encodes the specified LabelAssociationAction message. Does not implicitly {@link proto.SyncActionValue.LabelAssociationAction.verify|verify} messages.
             * @param message LabelAssociationAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.ILabelAssociationAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified LabelAssociationAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.LabelAssociationAction.verify|verify} messages.
             * @param message LabelAssociationAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.ILabelAssociationAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a LabelAssociationAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns LabelAssociationAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.LabelAssociationAction;

            /**
             * Decodes a LabelAssociationAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns LabelAssociationAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.LabelAssociationAction;

            /**
             * Verifies a LabelAssociationAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a LabelAssociationAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns LabelAssociationAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.LabelAssociationAction;

            /**
             * Creates a plain object from a LabelAssociationAction message. Also converts values to other types if specified.
             * @param message LabelAssociationAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.LabelAssociationAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this LabelAssociationAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a LabelEditAction. */
        interface ILabelEditAction {

            /** LabelEditAction name */
            name?: (string|null);

            /** LabelEditAction color */
            color?: (number|null);

            /** LabelEditAction predefinedId */
            predefinedId?: (number|null);

            /** LabelEditAction deleted */
            deleted?: (boolean|null);
        }

        /** Represents a LabelEditAction. */
        class LabelEditAction implements ILabelEditAction {

            /**
             * Constructs a new LabelEditAction.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.ILabelEditAction);

            /** LabelEditAction name. */
            public name: string;

            /** LabelEditAction color. */
            public color: number;

            /** LabelEditAction predefinedId. */
            public predefinedId: number;

            /** LabelEditAction deleted. */
            public deleted: boolean;

            /**
             * Creates a new LabelEditAction instance using the specified properties.
             * @param [properties] Properties to set
             * @returns LabelEditAction instance
             */
            public static create(properties?: proto.SyncActionValue.ILabelEditAction): proto.SyncActionValue.LabelEditAction;

            /**
             * Encodes the specified LabelEditAction message. Does not implicitly {@link proto.SyncActionValue.LabelEditAction.verify|verify} messages.
             * @param message LabelEditAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.SyncActionValue.ILabelEditAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified LabelEditAction message, length delimited. Does not implicitly {@link proto.SyncActionValue.LabelEditAction.verify|verify} messages.
             * @param message LabelEditAction message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.SyncActionValue.ILabelEditAction, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a LabelEditAction message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns LabelEditAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.SyncActionValue.LabelEditAction;

            /**
             * Decodes a LabelEditAction message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns LabelEditAction
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.SyncActionValue.LabelEditAction;

            /**
             * Verifies a LabelEditAction message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a LabelEditAction message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns LabelEditAction
             */
            public static fromObject(object: { [k: string]: any }): proto.SyncActionValue.LabelEditAction;

            /**
             * Creates a plain object from a LabelEditAction message. Also converts values to other types if specified.
             * @param message LabelEditAction
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.SyncActionValue.LabelEditAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this LabelEditAction to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a LocaleSetting. */
        interface ILocaleSetting {

            /** LocaleSetting locale */
            locale?: (string|null);
        }

        /** Represents a LocaleSetting. */
        class LocaleSetting implements ILocaleSetting {

            /**
             * Constructs a new LocaleSetting.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.SyncActionValue.ILocaleSetting);

            /** LocaleSetting locale. */
            public locale: string;

            /**
             * Creates a new LocaleSetting instance using the specified prope